/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.util.VarException;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.MathOperationAbstractBlock;
import plugins.ylemontag.mathoperations.MathOperationPlugin;
import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.operations.Operation2;

public class MathOperationBinaryBlock
extends MathOperationAbstractBlock {
    private VarEnum<Operation2> _operation = new VarEnum("op", (Enum)Operation2.ADD);
    private String _name1 = "a";
    private String _name2 = "b";

    public MathOperationBinaryBlock() {
        super("result");
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Operation", this._operation);
        this.addInputVariant(inputMap, this._name1, "In 1");
        this.addInputVariant(inputMap, this._name2, "In 2");
    }

    public String getMainPluginClassName() {
        return MathOperationPlugin.class.getName();
    }

    public String getName() {
        return "Math operation (2)";
    }

    public void run() {
        Operation2 op = (Operation2)this._operation.getValue();
        if (op == null) {
            throw new VarException("No operation selected");
        }
        Variant in1 = this.retrieveInputValue(this._name1);
        Variant in2 = this.retrieveInputValue(this._name2);
        String description = op.getFunctor().describeOperation(in1.getRepresentation(true), in2.getRepresentation(true));
        try {
            Variant out = op.getFunctor().apply(in1, in2);
            this.defineOutputValue(out);
        }
        catch (Functor.InconsistentArguments err) {
            MathOperationBinaryBlock.reportError(err, description);
        }
    }
}

