/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.type.collection.CollectionUtil;
import icy.type.collection.array.Array1DUtil;
import icy.type.rectangle.Rectangle3D;
import icy.util.XMLUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.activecontours.ActiveContour;
import plugins.adufour.activecontours.ActiveContours;
import plugins.adufour.activecontours.SlidingWindow;
import plugins.adufour.activecontours.TopologyException;
import plugins.adufour.morphology.FillHolesInROI;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Polygon2D
extends ActiveContour {
    private final FillHolesInROI holeFiller = new FillHolesInROI();
    final ArrayList<Point3d> points = new ArrayList();
    Path2D.Double path = new Path2D.Double();
    double cout = 0.0;
    private Vector3d[] modelForces;
    private Vector3d[] contourNormals;
    private Vector3d[] feedbackForces;
    private Vector3d[] volumeConstraintForces;
    AnnounceFrame f = null;
    int cpt = 0;

    public Polygon2D() {
    }

    protected Polygon2D(Var<Double> sampling, SlidingWindow convergenceWindow) {
        super(sampling, convergenceWindow);
        this.setColor(Color.getHSBColor((float)Math.random(), 0.8f, 0.9f));
    }

    public Polygon2D(Polygon2D contour) {
        this((Var<Double>)contour.sampling, new SlidingWindow(contour.convergence.getSize()));
        this.setColor(contour.getColor());
        this.setZ(contour.getZ());
        this.setName(contour.getName());
        int n = contour.points.size();
        this.points.ensureCapacity(n);
        this.contourNormals = new Vector3d[n];
        this.modelForces = new Vector3d[n];
        this.feedbackForces = new Vector3d[n];
        this.volumeConstraintForces = new Vector3d[n];
        for (int i = 0; i < n; ++i) {
            this.contourNormals[i] = new Vector3d();
            this.modelForces[i] = new Vector3d();
            this.feedbackForces[i] = new Vector3d();
            this.volumeConstraintForces[i] = new Vector3d();
            this.addPoint(new Point3d(contour.points.get(i)));
        }
        this.updateMetaData();
    }

    public Polygon2D(Var<Double> sampling, SlidingWindow convergenceWindow, ROI2D roi) throws TopologyException {
        this(sampling, convergenceWindow);
        if (!(roi instanceof ROI2DEllipse || roi instanceof ROI2DRectangle || roi instanceof ROI2DPolygon || roi instanceof ROI2DArea)) {
            throw new IcyHandledException("Active contours: invalid ROI. Only Rectangle, Ellipse, Polygon and Area are supported");
        }
        this.setZ(roi.getZ());
        this.setName(roi.getName());
        if (roi.getNumberOfPoints() < (Double)sampling.getValue() * 3.0) {
            throw new TopologyException(this, null);
        }
        if (roi instanceof ROI2DArea) {
            roi = Polygon2D.dilateROI(roi, 1, 1);
            BooleanMask2D mask = roi.getBooleanMask(true);
            if (FillHolesInROI.fillHoles((BooleanMask2D)mask)) {
                ((ROI2DArea)roi).setAsBooleanMask(mask);
            }
            try {
                this.triangulate((ROI2DArea)roi, (Double)sampling.getValue());
                this.reSample(0.8, 1.4);
                return;
            }
            catch (TopologyException e) {
                int theZ = roi.getZ();
                int theT = roi.getT();
                roi = new ROI2DEllipse(roi.getBounds2D());
                roi.setZ(theZ);
                roi.setT(theT);
            }
        }
        if (roi instanceof ROI2DShape) {
            double[] segment = new double[6];
            PathIterator pathIterator = ((ROI2DShape)roi).getPathIterator(null, 0.1);
            pathIterator.currentSegment(segment);
            this.addPoint(new Point3d(segment[0], segment[1], this.z));
            while (!pathIterator.isDone()) {
                if (pathIterator.currentSegment(segment) == 1) {
                    this.addPoint(new Point3d(segment[0], segment[1], this.z));
                }
                pathIterator.next();
            }
        }
        if (this.getAlgebraicInterior() > 0.0) {
            Collections.reverse(this.points);
        }
        this.reSample(0.8, 1.4);
    }

    @Override
    protected void addPoint(Point3d p) {
        this.points.add(p);
    }

    protected Polygon2D[] checkSelfIntersection(double minDistance) {
        double divSensitivity = this.divisionSensitivity == null ? 0.0 : (Double)this.divisionSensitivity.getValue();
        double divisionDistQ = this.boundingSphere.getRadius() * 2.0 * divSensitivity;
        divisionDistQ *= divisionDistQ;
        double minDistanceQ = minDistance;
        minDistanceQ *= minDistanceQ;
        ArrayList contourNormalList = CollectionUtil.asArrayList((Object[])this.contourNormals);
        while (true) {
            Vector3d i_j;
            int i = 0;
            int j = 0;
            int n = this.points.size();
            Point3d p_i = null;
            Point3d p_j = null;
            boolean selfIntersection = false;
            block1: for (i = 0; i < n; ++i) {
                p_i = this.points.get(i);
                Vector3d n_i = (Vector3d)contourNormalList.get(i);
                for (j = i + 2; j < n - 1; ++j) {
                    p_j = this.points.get(j);
                    double distQ = p_i.distanceSquared(p_j);
                    if (distQ < minDistanceQ) {
                        if (i == 0 && j == n - 2) {
                            this.points.remove(--n);
                            contourNormalList.remove(n);
                            continue;
                        }
                        if (i == 1 && j == n - 1) {
                            this.points.remove(0);
                            contourNormalList.remove(0);
                            --n;
                            continue;
                        }
                        if (j == i + 2) {
                            this.points.remove(i + 1);
                            contourNormalList.remove(i + 1);
                            --n;
                            continue;
                        }
                        selfIntersection = true;
                        break block1;
                    }
                    if (n_i.dot((Vector3d)contourNormalList.get(j)) > -0.5 || !(distQ < divisionDistQ) || j - i <= 2 * n / 5 || j - i >= 3 * n / 5) continue;
                    Vector3d vi1 = new Vector3d((Tuple3d)this.points.get((i + n - 4) % n));
                    Vector3d vi2 = new Vector3d((Tuple3d)this.points.get((i + 4) % n));
                    vi1.sub((Tuple3d)p_i);
                    vi2.sub((Tuple3d)p_i);
                    vi1.normalize();
                    vi2.normalize();
                    vi1.cross(vi1, vi2);
                    if (vi1.z < 0.05) continue;
                    double vi_lQ = vi1.lengthSquared();
                    Vector3d vj1 = new Vector3d((Tuple3d)this.points.get((j + n - 4) % n));
                    Vector3d vj2 = new Vector3d((Tuple3d)this.points.get((j + 4) % n));
                    vj1.sub((Tuple3d)p_j);
                    vj2.sub((Tuple3d)p_j);
                    vj1.normalize();
                    vj2.normalize();
                    vj1.cross(vj1, vj2);
                    if (vj1.z < 0.05) continue;
                    double vj_lQ = vj1.lengthSquared();
                    if (vi_lQ < 0.5 && vj_lQ < 0.5) continue;
                    selfIntersection = true;
                    break block1;
                }
            }
            if (!selfIntersection) {
                return null;
            }
            Point3d center = new Point3d();
            int nPoints = j - i;
            Polygon2D child1 = new Polygon2D((Var<Double>)this.sampling, new SlidingWindow(this.convergence.getSize()));
            for (int p = 0; p < nPoints; ++p) {
                Point3d pp = this.points.get((p + i) % n);
                center.add((Tuple3d)pp);
                child1.addPoint(pp);
            }
            center.scale(1.0 / (double)nPoints);
            child1.setName(this.getName());
            child1.setX(center.x);
            child1.setY(center.y);
            child1.setZ(center.z);
            child1.setT(this.getT());
            center.set(0.0, 0.0, 0.0);
            nPoints = i + n - j;
            Polygon2D child2 = new Polygon2D((Var<Double>)this.sampling, new SlidingWindow(this.convergence.getSize()));
            int p = 0;
            int pj = p + j;
            while (p < nPoints) {
                Point3d pp = this.points.get(pj % n);
                center.add((Tuple3d)pp);
                child2.addPoint(pp);
                ++p;
                ++pj;
            }
            center.scale(1.0 / (double)nPoints);
            child2.setName(this.getName());
            child2.setX(center.x);
            child2.setY(center.y);
            child2.setZ(center.z);
            child2.setT(this.getT());
            double c1area = child1.getDimension(2);
            double c2area = child2.getDimension(2);
            if (child1.points.size() < 10 || c1area < c2area / 8.0) {
                this.points.clear();
                this.points.addAll(child2.points);
                continue;
            }
            if (child2.points.size() < 10 || c2area < c1area / 8.0) {
                this.points.clear();
                this.points.addAll(child1.points);
                continue;
            }
            Vector3d n_i = (Vector3d)contourNormalList.get(i);
            if (n_i.dot(i_j = new Vector3d(p_j.x - p_i.x, p_j.y - p_i.y, 0.0)) < 0.0) {
                return new Polygon2D[]{child1, child2};
            }
            this.points.clear();
            if (child1.getAlgebraicInterior() < 0.0) {
                this.points.addAll(child1.points);
                continue;
            }
            if (!(child2.getAlgebraicInterior() < 0.0)) continue;
            this.points.addAll(child2.points);
        }
    }

    @Override
    protected void clean() {
    }

    @Override
    public Polygon2D clone() {
        return new Polygon2D(this);
    }

    @Override
    void computeAxisForces(double weight) {
        Vector3d axis = new Vector3d();
        int s = (int)this.getDimension(0);
        double maxDistSq = 0.0;
        Vector3d vec = new Vector3d();
        for (int i = 0; i < s; ++i) {
            Point3d vi = this.points.get(i);
            for (int j = i + 1; j < s; ++j) {
                Point3d vj = this.points.get(j);
                vec.sub((Tuple3d)vi, (Tuple3d)vj);
                double dSq = vec.lengthSquared();
                if (!(dSq > maxDistSq)) continue;
                maxDistSq = dSq;
                axis.set((Tuple3d)vec);
            }
        }
        axis.normalize();
        for (int i = 0; i < s; ++i) {
            Vector3d normal = this.contourNormals[i];
            double colinearity = Math.abs(normal.dot(axis));
            double threshold = Math.max(colinearity, 1.0 - weight);
            if (normal == null) continue;
            this.modelForces[i].scale(threshold);
        }
    }

    @Override
    void computeBalloonForces(double weight) {
        int n = this.points.size();
        for (int i = 0; i < n; ++i) {
            Vector3d force = this.modelForces[i];
            force.x += weight * this.contourNormals[i].x;
            force.y += weight * this.contourNormals[i].y;
        }
    }

    @Override
    void computeEdgeForces(Sequence edgeData, int channel, double weight) {
        IcyBufferedImage image = edgeData.getImage(0, (int)Math.round(this.getZ()));
        if (image == null) {
            return;
        }
        Vector3d grad = new Vector3d();
        for (int i = 0; i < this.points.size(); ++i) {
            Point3d p = this.points.get(i);
            Vector3d force = this.modelForces[i];
            double nextX = Polygon2D.getPixelValue(image, p.x + 0.5, p.y, channel);
            double prevX = Polygon2D.getPixelValue(image, p.x - 0.5, p.y, channel);
            double nextY = Polygon2D.getPixelValue(image, p.x, p.y + 0.5, channel);
            double prevY = Polygon2D.getPixelValue(image, p.x, p.y - 0.5, channel);
            if (nextX == 0.0 || prevX == 0.0 || nextY == 0.0 || prevY == 0.0) continue;
            grad.set(nextX - prevX, nextY - prevY, 0.0);
            grad.scale(weight);
            force.add((Tuple3d)grad);
        }
    }

    @Override
    void computeRegionForces(Sequence imageData, int channel, double weight, double sensitivity, double inAvg, double outAvg) {
        Vector3d cvms = new Vector3d();
        int n = this.points.size();
        weight *= this.sampling.getValue().doubleValue();
        int myZ = (int)Math.round(this.getZ());
        IcyBufferedImage image = imageData.getImage(0, myZ);
        if (image == null) {
            throw new IllegalArgumentException("Contour.getZ() = " + this.getZ() + "; Stack size = " + imageData.getSizeZ());
        }
        for (int i = 0; i < n; ++i) {
            Point3d p = this.points.get(i);
            Vector3d force = this.modelForces[i];
            Vector3d norm = this.contourNormals[i];
            double val = Polygon2D.getPixelValue(image, p.x, p.y, channel);
            double inDiff = val - inAvg;
            inDiff *= inDiff;
            double outDiff = val - outAvg;
            outDiff *= outDiff;
            double forceFactor = weight * (sensitivity * outDiff) - inDiff / sensitivity;
            cvms.scale(forceFactor, (Tuple3d)norm);
            force.add((Tuple3d)cvms);
        }
    }

    @Override
    void computeInternalForces(double weight) {
        if (this.feedbackForces == null) {
            return;
        }
        int n = this.points.size();
        if (n < 3) {
            return;
        }
        weight /= this.sampling.getValue().doubleValue();
        Point3d prev = this.points.get(n - 2);
        Point3d curr = this.points.get(n - 1);
        Point3d next = this.points.get(0);
        for (int i = 0; i < n; ++i) {
            prev = curr;
            curr = next;
            next = this.points.get((i + 1) % n);
            Vector3d force = this.feedbackForces[i];
            force.x += weight * (prev.x - 2.0 * curr.x + next.x);
            force.y += weight * (prev.y - 2.0 * curr.y + next.y);
        }
    }

    @Override
    void computeVolumeConstraint(double targetVolume, double weight) {
        double volumeDiff = targetVolume - this.getDimension(2);
        int n = this.points.size();
        Vector3d totalForce = new Vector3d();
        for (int i = 0; i < n; ++i) {
            totalForce.add((Tuple3d)this.feedbackForces[i], (Tuple3d)this.modelForces[i]);
            double forceNorm = totalForce.dot(this.contourNormals[i]);
            if (!(forceNorm * volumeDiff < 0.0)) continue;
            totalForce.set((Tuple3d)this.contourNormals[i]);
            totalForce.scale(volumeDiff * weight / targetVolume);
            this.volumeConstraintForces[i].set((Tuple3d)totalForce);
        }
    }

    @Override
    int computeFeedbackForces(ActiveContour target) {
        Point3d targetCenter = new Point3d();
        target.boundingSphere.getCenter(targetCenter);
        double targetRadiusSq = target.boundingSphere.getRadius();
        targetRadiusSq *= targetRadiusSq;
        int tests = 0;
        int index = 0;
        for (Point3d p : this.points) {
            double distanceSq = p.distanceSquared(targetCenter);
            if (distanceSq < targetRadiusSq) {
                double penetration = target.getDistanceToEdge(p);
                if (penetration > 0.0) {
                    Vector3d feedbackForce = this.feedbackForces[index];
                    feedbackForce.scaleAdd(-penetration * 0.2, (Tuple3d)this.contourNormals[index], (Tuple3d)feedbackForce);
                    this.modelForces[index].scale(0.1);
                }
                ++tests;
            }
            ++index;
        }
        return tests;
    }

    private static void createEdge(ArrayList<Segment> segments, double xStart, double yStart, double xEnd, double yEnd) {
        double EPSILON = 1.0E-5;
        Point3d head = new Point3d(xStart, yStart, 0.0);
        Point3d tail = new Point3d(xEnd, yEnd, 0.0);
        if (segments.size() == 0) {
            segments.add(new Segment(head, tail));
            return;
        }
        int insertAtTailOf = -1;
        int insertAtHeadOf = -1;
        for (int i = 0; i < segments.size(); ++i) {
            if (tail.distance(segments.get(i).getHead()) <= 1.0E-5) {
                insertAtHeadOf = i;
                continue;
            }
            if (!(head.distance(segments.get(i).getTail()) <= 1.0E-5)) continue;
            insertAtTailOf = i;
        }
        if (insertAtTailOf >= 0) {
            if (insertAtHeadOf >= 0) {
                segments.get(insertAtHeadOf).addHead(segments.get(insertAtTailOf));
                segments.remove(insertAtTailOf);
            } else {
                segments.get(insertAtTailOf).addTail(tail);
            }
        } else if (insertAtHeadOf >= 0) {
            segments.get(insertAtHeadOf).addHead(head);
        } else {
            segments.add(new Segment(head, tail));
        }
    }

    private static ROI2D dilateROI(ROI2D roi, int xRadius, int yRadius) {
        int rx = xRadius;
        int rrx = rx * rx;
        int ry = yRadius;
        int rry = ry * ry;
        BooleanMask2D m2 = roi.getBooleanMask(true);
        ROI2DArea r2 = new ROI2DArea(m2);
        r2.setT(roi.getT());
        r2.setZ(roi.getZ());
        r2.setC(roi.getC());
        r2.beginUpdate();
        for (Point p : m2.getContourPoints()) {
            for (int y = -ry; y <= ry; ++y) {
                for (int x = -rx; x <= rx; ++x) {
                    if (!((double)(x * x / rrx + y * y / rry) <= 1.0) || m2.contains(p.x + x, p.y + y)) continue;
                    r2.addPoint(p.x + x, p.y + y);
                }
            }
        }
        r2.endUpdate();
        return r2;
    }

    private static double getPixelValue(IcyBufferedImage image, double x, double y, int c) {
        return image.getDataInterpolated(x, y, c);
    }

    protected double getAlgebraicInterior() {
        int nm1 = this.points.size() - 1;
        double area = 0.0;
        for (int i = 0; i < nm1; ++i) {
            Point3d p1 = this.points.get(i);
            Point3d p2 = this.points.get(i + 1);
            area += (p2.x * p1.y - p1.x * p2.y) * 0.5;
        }
        Point3d p1 = this.points.get(nm1);
        Point3d p2 = this.points.get(0);
        return area += (p2.x * p1.y - p1.x * p2.y) * 0.5;
    }

    @Override
    public double getDimension(int order) {
        if (this.points.size() <= 1) {
            return 0.0;
        }
        switch (order) {
            case 0: {
                return this.points.size();
            }
            case 1: {
                int size = this.points.size();
                Point3d p1 = this.points.get(size - 1);
                Point3d p2 = this.points.get(0);
                double perimeter = p1.distance(p2);
                for (int i = 0; i < size - 1; ++i) {
                    p1 = p2;
                    p2 = this.points.get(i + 1);
                    perimeter += p1.distance(p2);
                }
                return perimeter;
            }
            case 2: {
                return Math.abs(this.getAlgebraicInterior());
            }
        }
        throw new UnsupportedOperationException("Dimension " + order + " not implemented");
    }

    @Override
    public double getDistanceToEdge(Point3d p) {
        Point3d q = new Point3d(p.x + 10000.0 * (p.x - this.x), p.y + 10000.0 * (p.y - this.y), 0.0);
        int nb = 0;
        int nbPtsM1 = this.points.size() - 1;
        double dist = 0.0;
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < nbPtsM1; ++i) {
            Point3d p1 = this.points.get(i);
            Point3d p2 = this.points.get(i + 1);
            if (!Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, p.x, p.y, q.x, q.y)) continue;
            ++nb;
            dist = Line2D.ptLineDist(p1.x, p1.y, p2.x, p2.y, p.x, p.y);
            if (!(dist < minDist)) continue;
            minDist = dist;
        }
        Point3d p1 = this.points.get(nbPtsM1);
        Point3d p2 = this.points.get(0);
        if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, p.x, p.y, q.x, q.y)) {
            ++nb;
            dist = Line2D.ptLineDist(p1.x, p1.y, p2.x, p2.y, p.x, p.y);
            if (dist < minDist) {
                minDist = dist;
            }
        }
        return nb % 2 == 1 ? minDist : 0.0;
    }

    @Override
    public Iterator<Point3d> iterator() {
        return this.points.iterator();
    }

    @Override
    void move(ROI boundField, double timeStep) {
        Rectangle2D nearBounds;
        int n = this.points.size();
        if (this.modelForces == null || this.modelForces.length != n) {
            return;
        }
        Vector3d force = new Vector3d();
        double maxDisp = this.sampling.getValue() * timeStep;
        if (boundField != null) {
            nearBounds = boundField.getBounds5D().toRectangle2D();
            nearBounds.setRect(nearBounds.getX() + 2.0, nearBounds.getY() + 2.0, nearBounds.getWidth() - 4.0, nearBounds.getHeight() - 4.0);
        } else {
            nearBounds = null;
        }
        for (int index = 0; index < n; ++index) {
            Point3d p = this.points.get(index);
            if (this.volumeConstraintForces[index].length() > 0.0) {
                p.add((Tuple3d)this.volumeConstraintForces[index]);
            }
            if (boundField == null || boundField.contains(p.x, p.y, 0.0, 0.0, 0.0)) {
                if (this.modelForces[index] != null && nearBounds != null) {
                    if (p.x < nearBounds.getMinX() || p.x > nearBounds.getMaxX()) {
                        this.modelForces[index].scale(0.5);
                    }
                    if (p.y < nearBounds.getMinY() || p.y > nearBounds.getMaxY()) {
                        this.modelForces[index].scale(0.5);
                    }
                }
            } else {
                if (this.modelForces[index] != null) {
                    this.modelForces[index].scale(0.0);
                }
                this.feedbackForces[index].scale(0.0);
            }
            if (this.modelForces[index] != null) {
                force.set((Tuple3d)this.modelForces[index]);
            } else {
                force.set(0.0, 0.0, 0.0);
            }
            force.add((Tuple3d)this.feedbackForces[index]);
            force.scale(timeStep);
            double disp = force.length();
            if (disp > maxDisp) {
                force.scale(maxDisp / disp);
            }
            p.add((Tuple3d)force);
            this.modelForces[index].set(0.0, 0.0, 0.0);
            this.feedbackForces[index].set(0.0, 0.0, 0.0);
            this.volumeConstraintForces[index].set(0.0, 0.0, 0.0);
        }
        this.updateMetaData();
        if (this.convergence != null) {
            this.convergence.push(this.getDimension(2));
        }
    }

    @Override
    public boolean hasConverged(SlidingWindow.Operation operation, double epsilon) {
        Double value = this.convergence.computeCriterion(operation);
        return value != null && value <= epsilon / 100.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (this.getT() != canvas.getPositionT()) {
            return;
        }
        if (g != null) {
            Rectangle2D.Double viewBounds = ((IcyCanvas2D)canvas).canvasToImage(canvas.getBounds());
            g.clip(viewBounds);
            float fontSize = (float)canvas.canvasToImageLogDeltaX(30);
            g.setFont(new Font("Trebuchet MS", 1, 10).deriveFont(fontSize));
            double stroke = Math.max(canvas.canvasToImageLogDeltaX(3), canvas.canvasToImageLogDeltaY(3));
            g.setColor(this.getColor());
            g.setStroke(new BasicStroke((float)stroke, 1, 1));
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            Path2D.Double double_ = this.path;
            synchronized (double_) {
                g.draw(this.path);
            }
        }
    }

    @Override
    public void reSample(double minFactor, double maxFactor) throws TopologyException {
        if (this.getDimension(1) < 10.0) {
            throw new TopologyException(this, new Polygon2D[0]);
        }
        double minLength = this.sampling.getValue() * minFactor;
        double maxLength = this.sampling.getValue() * maxFactor;
        int n = this.points.size();
        if (this.contourNormals == null) {
            this.contourNormals = new Vector3d[n];
            for (int i = 0; i < n; ++i) {
                this.contourNormals[i] = new Vector3d();
            }
            this.updateNormals();
        }
        ActiveContour[] children = this.cpt % 2 == 0 ? null : this.checkSelfIntersection(this.sampling.getValue());
        ++this.cpt;
        if (children != null) {
            throw new TopologyException(this, children);
        }
        n = this.points.size();
        boolean noChange = false;
        int iterCount = 0;
        int maxIter = n * 10;
        while (!noChange) {
            Point3d pt2;
            if (++iterCount > maxIter) {
                System.err.println("[Active Contours] Warning: hitting safeguard (preventing infinite resampling)");
                break;
            }
            noChange = true;
            for (int i = 0; i < n - 1; ++i) {
                Point3d pt22;
                if (n < 4) {
                    throw new TopologyException(this, new Polygon2D[0]);
                }
                Point3d pt1 = this.points.get(i);
                double distance = pt1.distance(pt22 = this.points.get(i + 1));
                if (distance < minLength) {
                    noChange = false;
                    pt22.set((pt1.x + pt22.x) * 0.5, (pt1.y + pt22.y) * 0.5, (pt1.z + pt22.z) * 0.5);
                    this.points.remove(i);
                    --i;
                    --n;
                    continue;
                }
                if (!(distance > maxLength)) continue;
                noChange = false;
                this.points.add(i + 1, new Point3d((pt1.x + pt22.x) * 0.5, (pt1.y + pt22.y) * 0.5, (pt1.z + pt22.z) * 0.5));
                ++i;
                ++n;
            }
            Point3d pt1 = this.points.get(n - 1);
            if (pt1.distance(pt2 = this.points.get(0)) < minLength) {
                noChange = false;
                pt2.set((pt1.x + pt2.x) * 0.5, (pt1.y + pt2.y) * 0.5, (pt1.z + pt2.z) * 0.5);
                this.points.remove(n - 1);
                --n;
                continue;
            }
            if (!(pt1.distance(pt2) > maxLength)) continue;
            noChange = false;
            this.points.add(new Point3d((pt1.x + pt2.x) * 0.5, (pt1.y + pt2.y) * 0.5, (pt1.z + pt2.z) * 0.5));
            ++n;
        }
        int nbPoints = n;
        if (this.modelForces == null || this.modelForces.length != nbPoints) {
            this.modelForces = new Vector3d[nbPoints];
            this.contourNormals = new Vector3d[nbPoints];
            this.feedbackForces = new Vector3d[nbPoints];
            this.volumeConstraintForces = new Vector3d[nbPoints];
            for (int i = 0; i < nbPoints; ++i) {
                this.modelForces[i] = new Vector3d();
                this.contourNormals[i] = new Vector3d();
                this.feedbackForces[i] = new Vector3d();
                this.volumeConstraintForces[i] = new Vector3d();
            }
        }
        this.updateMetaData();
    }

    private void triangulate(ROI2DArea roi, double resolution) throws TopologyException {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        Rectangle bounds = roi.getBounds();
        boolean grid = true;
        double halfgrid = 0.5;
        boolean cubeWidth = true;
        int cubeHeight = 1 * bounds.width;
        int cubeDiag = 1 + cubeHeight;
        boolean[] mask = roi.getBooleanMask(roi.getBounds(), true);
        Arrays.fill(mask, 0, bounds.width - 1, false);
        for (int o = 0; o < mask.length; o += bounds.width) {
            mask[o] = false;
        }
        for (int j = 0; j < bounds.height; ++j) {
            int i = 0;
            int index = j * bounds.width;
            while (i < bounds.width) {
                boolean d;
                boolean a = mask[index];
                boolean b = i + 1 < bounds.width && mask[index + 1];
                boolean c = j + 1 < bounds.height && mask[index + cubeHeight];
                boolean bl = d = i + 1 < bounds.width && j + 1 < bounds.height && mask[index + cubeDiag];
                if (a != b) {
                    if (b == c) {
                        if (!a) {
                            Polygon2D.createEdge(segments, i, (double)j + 0.5, (double)i + 0.5, j);
                        } else {
                            Polygon2D.createEdge(segments, (double)i + 0.5, j, i, (double)j + 0.5);
                        }
                    } else if (!a) {
                        Polygon2D.createEdge(segments, (double)i + 0.5, (double)j + 0.5, (double)i + 0.5, j);
                    } else {
                        Polygon2D.createEdge(segments, (double)i + 0.5, j, (double)i + 0.5, (double)j + 0.5);
                    }
                } else if (a != c) {
                    if (!a) {
                        Polygon2D.createEdge(segments, i, (double)j + 0.5, (double)i + 0.5, (double)j + 0.5);
                    } else {
                        Polygon2D.createEdge(segments, (double)i + 0.5, (double)j + 0.5, i, (double)j + 0.5);
                    }
                }
                if (c != d) {
                    if (b == c) {
                        if (!c) {
                            Polygon2D.createEdge(segments, (double)i + 0.5, j + 1, i + 1, (double)j + 0.5);
                        } else {
                            Polygon2D.createEdge(segments, i + 1, (double)j + 0.5, (double)i + 0.5, j + 1);
                        }
                    } else if (!c) {
                        Polygon2D.createEdge(segments, (double)i + 0.5, j + 1, (double)i + 0.5, (double)j + 0.5);
                    } else {
                        Polygon2D.createEdge(segments, (double)i + 0.5, (double)j + 0.5, (double)i + 0.5, j + 1);
                    }
                } else if (b != c) {
                    if (!b) {
                        Polygon2D.createEdge(segments, (double)i + 0.5, (double)j + 0.5, i + 1, (double)j + 0.5);
                    } else {
                        Polygon2D.createEdge(segments, i + 1, (double)j + 0.5, (double)i + 0.5, (double)j + 0.5);
                    }
                }
                ++i;
                ++index;
            }
        }
        if (segments.size() == 0) {
            return;
        }
        for (Point3d p : (Segment)segments.get(0)) {
            p.x += (double)bounds.x;
            p.y += (double)bounds.y;
            p.z = roi.getZ();
            this.addPoint(p);
        }
        for (double current_resolution_doubled = 1.0; current_resolution_doubled < resolution * 0.7; current_resolution_doubled *= 2.0) {
            for (int i = 0; i < this.points.size(); ++i) {
                this.points.remove(i);
            }
        }
    }

    @Override
    protected void updateNormals() {
        int n = this.points.size();
        Point3d p1 = this.points.get(n - 2);
        Point3d p = this.points.get(n - 1);
        Point3d p2 = this.points.get(0);
        for (int i = 0; i < n; ++i) {
            p1 = p;
            p = p2;
            p2 = this.points.get((i + 1) % n);
            this.contourNormals[i].normalize(new Vector3d(p2.y - p1.y, p1.x - p2.x, 0.0));
        }
    }

    @Override
    protected void updateMetaData() {
        super.updateMetaData();
        this.updatePath();
    }

    private void updatePath() {
        Path2D.Double newPath = new Path2D.Double();
        int nbPoints = this.points.size();
        if (nbPoints > 0) {
            Point3d p = this.points.get(0);
            newPath.moveTo(p.x, p.y);
            for (int i = 1; i < nbPoints; ++i) {
                p = this.points.get(i);
                newPath.lineTo(p.x, p.y);
            }
        }
        newPath.closePath();
        this.path = newPath;
    }

    @Deprecated
    public ROI2D toROI() {
        return this.toROI(ActiveContours.ROIType.AREA, null);
    }

    public ROI2D toROI(ActiveContours.ROIType type, Sequence sequence) {
        ROI2DPolygon roi;
        switch (type) {
            case AREA: {
                ArrayList<Point2D.Double> p2d = new ArrayList<Point2D.Double>(this.points.size());
                for (Point3d p : this) {
                    p2d.add(new Point2D.Double(p.x, p.y));
                }
                roi = (ROI2D)ROIUtil.convertToMask((ROI)new ROI2DPolygon(p2d));
                break;
            }
            case POLYGON: {
                ArrayList<Point2D.Double> p2d = new ArrayList<Point2D.Double>(this.points.size());
                for (Point3d p : this) {
                    p2d.add(new Point2D.Double(p.x, p.y));
                }
                roi = new ROI2DPolygon(p2d);
                break;
            }
            default: {
                throw new IllegalArgumentException("ROI of type " + (Object)((Object)type) + " cannot be exported yet");
            }
        }
        roi.setT(this.t);
        roi.setName(this.name);
        return roi;
    }

    @Override
    public double computeAverageIntensity(Sequence summedImageData, BooleanMask3D mask) {
        IcyBufferedImage image;
        int myZ = (int)this.z;
        if (myZ == -1 && summedImageData.getSizeZ() == 1) {
            myZ = 0;
        }
        if ((image = summedImageData.getImage(0, myZ)) == null) {
            throw new IllegalArgumentException("Contour.getZ() = " + this.getZ() + "; Stack size = " + summedImageData.getSizeZ());
        }
        boolean[] _mask = mask == null ? null : ((BooleanMask2D)mask.mask.get((Object)Integer.valueOf((int)myZ))).mask;
        int w = summedImageData.getSizeX();
        int h = summedImageData.getSizeY();
        double sum = 0.0;
        double count = 0.0;
        Point3d minBounds = new Point3d();
        Point3d maxBounds = new Point3d();
        this.boundingBox.getLower(minBounds);
        this.boundingBox.getUpper(maxBounds);
        int minY = Math.max((int)minBounds.y - 1, 0);
        int maxY = Math.min((int)maxBounds.y + 1, h);
        int n = this.points.size();
        ArrayList<Integer> crosses = new ArrayList<Integer>(10);
        Point3d p1 = null;
        Point3d p2 = null;
        for (int j = minY; j < maxY; ++j) {
            crosses.clear();
            p1 = this.points.get(n - 1);
            for (int p = 0; p < n; ++p) {
                p2 = this.points.get(p);
                if ((double)j > Math.min(p1.y, p2.y) && (double)j < Math.max(p1.y, p2.y)) {
                    int cross = (int)Math.round((p1.x + p2.x) * 0.5);
                    if (cross < 0) {
                        cross = 0;
                    } else if (cross >= w) {
                        cross = w - 1;
                    }
                    crosses.add(cross);
                }
                p1 = p2;
            }
            if (crosses.size() == 0 || crosses.size() % 2 == 1) continue;
            Collections.sort(crosses);
            int lineOffset = j * w;
            for (int c = 0; c < crosses.size(); c += 2) {
                int crossIN = (Integer)crosses.get(c);
                int crossOUT = (Integer)crosses.get(c + 1);
                sum -= Polygon2D.getPixelValue(image, crossIN, j, 0);
                sum += Polygon2D.getPixelValue(image, crossOUT, j, 0);
                count += (double)(crossOUT - crossIN);
                if (mask == null) continue;
                try {
                    Arrays.fill(_mask, lineOffset + crossIN, lineOffset + crossOUT, true);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    String message = "Image size: " + w + " x " + h + "\n";
                    message = message + "Line offset: " + lineOffset + "\n";
                    message = message + "Cross IN: " + crossIN + "\n";
                    message = message + "Cross OUT: " + crossOUT + "\n";
                    message = message + "\n" + e.getMessage();
                    throw new RuntimeException(message, e);
                }
            }
        }
        return count == 0.0 ? 0.0 : sum / count;
    }

    @Override
    public double computeBackgroundIntensity(Sequence imageData, BooleanMask3D mask) {
        Rectangle3D.Integer b3 = mask.bounds;
        Point3d min = new Point3d();
        Point3d max = new Point3d();
        this.boundingBox.getLower(min);
        this.boundingBox.getUpper(max);
        double yExtent = max.y - min.y;
        int minY = Math.max(0, (int)Math.round(min.y - yExtent));
        int maxY = Math.min(b3.sizeY, (int)Math.round(max.y + yExtent));
        double xExtent = max.x - min.x;
        int minX = Math.max(0, (int)Math.round(min.x - xExtent));
        int maxX = Math.min(b3.sizeX, (int)Math.round(max.x + xExtent));
        double outSum = 0.0;
        double outCpt = 0.0;
        boolean[] _mask = ((BooleanMask2D)mask.mask.get((Object)Integer.valueOf((int)((int)this.z)))).mask;
        float[] _data = imageData.getDataXYAsFloat(0, (int)this.z, 0);
        for (int j = minY; j < maxY; ++j) {
            int offset = minX + j * b3.sizeX;
            int i = minX;
            while (i < maxX) {
                if (!_mask[offset]) {
                    outSum += (double)_data[i];
                    outCpt += 1.0;
                }
                ++i;
                ++offset;
            }
        }
        return outSum / outCpt;
    }

    @Override
    public void toSequence(Sequence output, double value) {
        int myZ = (int)Math.round(this.getZ());
        int myT = Math.round(this.getT());
        Object _mask = output.getDataXY(myT, myZ, 0);
        int sizeX = output.getWidth();
        int sizeY = output.getHeight();
        Point3d minBounds = new Point3d();
        Point3d maxBounds = new Point3d();
        this.boundingBox.getLower(minBounds);
        this.boundingBox.getUpper(maxBounds);
        int minX = Math.max((int)minBounds.x - 2, -10);
        int maxX = Math.min((int)maxBounds.x + 2, sizeX + 10);
        int minY = Math.max((int)minBounds.y - 1, 0);
        int maxY = Math.min((int)maxBounds.y + 1, sizeY);
        int n = this.points.size();
        Point3d p1 = null;
        Point3d p2 = null;
        TreeSet<Integer> crosses = new TreeSet<Integer>();
        for (int j = minY; j < maxY; ++j) {
            int lineOffset = j * sizeX;
            int offset = lineOffset + (minX < 0 ? 0 : minX);
            crosses.clear();
            crosses.add(minX);
            for (int p = 0; p < n - 1; ++p) {
                p1 = this.points.get(p);
                p2 = this.points.get(p + 1);
                if (!((double)j >= Math.min(p1.y, p2.y)) || !((double)j <= Math.max(p1.y, p2.y))) continue;
                int cross = (int)Math.round(p1.x + ((double)j - p1.y) * (p2.x - p1.x) / (p2.y - p1.y));
                if (crosses.contains(cross)) {
                    crosses.remove(cross);
                    Array1DUtil.setValue((Object)_mask, (int)(lineOffset + cross), (double)value);
                    continue;
                }
                crosses.add(cross);
            }
            p1 = this.points.get(0);
            if ((double)j >= Math.min(p1.y, p2.y) && (double)j <= Math.max(p1.y, p2.y)) {
                int cross = (int)Math.round(p1.x + ((double)j - p1.y) * (p2.x - p1.x) / (p2.y - p1.y));
                if (crosses.contains(cross)) {
                    crosses.remove(cross);
                    Array1DUtil.setValue((Object)_mask, (int)(lineOffset + cross), (double)value);
                } else {
                    crosses.add(cross);
                }
            }
            crosses.add(maxX);
            int nC = crosses.size();
            if (nC <= 2) continue;
            boolean in = false;
            Iterator it = crosses.iterator();
            int start = (Integer)it.next();
            if (start < 0) {
                start = 0;
            }
            while (it.hasNext()) {
                int end = (Integer)it.next();
                if (end > sizeX) {
                    end = sizeX;
                }
                if (in) {
                    int i = start;
                    while (i < end) {
                        Array1DUtil.setValue((Object)_mask, (int)offset, (double)value);
                        ++i;
                        ++offset;
                    }
                } else {
                    offset += end - start;
                }
                start = end;
                in = !in;
            }
        }
    }

    public void rasterScan(boolean updateLocalMask, Sequence imageData, VarDouble averageIntensity, BooleanMask3D imageMask) {
    }

    public boolean loadFromXML(Node node) {
        if (!super.loadFromXML(node)) {
            return false;
        }
        Element xmlElement = XMLUtil.getElement((Node)node, (String)"Contour");
        if (xmlElement == null) {
            return false;
        }
        for (Element ptElem : XMLUtil.getElements((Node)xmlElement)) {
            double xPt = XMLUtil.getAttributeDoubleValue((Element)ptElem, (String)"x", (double)Double.NaN);
            double yPt = XMLUtil.getAttributeDoubleValue((Element)ptElem, (String)"y", (double)Double.NaN);
            if (Double.isNaN(xPt) || Double.isNaN(yPt)) {
                return false;
            }
            this.points.add(new Point3d(xPt, yPt, 0.0));
        }
        this.updatePath();
        return true;
    }

    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        Element xmlElement = XMLUtil.addElement((Node)node, (String)"Contour");
        for (Point3d pt : this.points) {
            Element xmlPt = XMLUtil.addElement((Node)xmlElement, (String)"Point");
            XMLUtil.setAttributeDoubleValue((Element)xmlPt, (String)"x", (double)pt.x);
            XMLUtil.setAttributeDoubleValue((Element)xmlPt, (String)"y", (double)pt.y);
        }
        return true;
    }

    private static final class Segment
    implements Iterable<Point3d> {
        final ArrayList<Point3d> points = new ArrayList(2);

        Segment(Point3d head, Point3d tail) {
            this.points.add(head);
            this.points.add(tail);
        }

        final Point3d getHead() {
            return this.points.get(0);
        }

        final Point3d getTail() {
            return this.points.get(this.points.size() - 1);
        }

        final void addHead(Point3d p) {
            this.points.add(0, p);
        }

        final void addHead(Segment s) {
            for (int i = 0; i < s.points.size(); ++i) {
                this.points.add(i, s.points.get(i));
            }
        }

        final void addTail(Point3d p) {
            this.points.add(p);
        }

        @Override
        public Iterator<Point3d> iterator() {
            return this.points.iterator();
        }
    }
}

