/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.PropertySetting;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.acquisition.AcquisitionWrapperEngine;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.ChannelCellEditor;
import org.micromanager.dialogs.ChannelCellRenderer;
import org.micromanager.dialogs.ChannelTableModel;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.ColorEditor;
import org.micromanager.utils.ColorRenderer;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;

public class ChannelTable
extends JTable {
    private static final long serialVersionUID = 8574853674441794225L;
    protected final ChannelTableModel model;

    public ChannelTable() {
        MMMainFrame mmframe = MicroManager.getInstance();
        AcquisitionWrapperEngine eng = MicroManager.getAcquisitionEngine();
        this.model = new ChannelTableModel((ScriptInterface)MicroManager.getMMStudio(), (AcquisitionEngine)eng, mmframe.exposurePrefs, mmframe.colorPrefs, mmframe.options);
        this.model.setChannels(eng.getChannels());
        this.model.addTableModelListener((TableModelListener)this.model);
        this.setAutoCreateColumnsFromModel(false);
        this.setModel((TableModel)this.model);
        this.setSelectionMode(0);
        ChannelCellEditor cellEditor = new ChannelCellEditor((AcquisitionEngine)eng, mmframe.exposurePrefs, mmframe.colorPrefs);
        ChannelCellRenderer cellRenderer = new ChannelCellRenderer((AcquisitionEngine)eng);
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            if (k == this.model.getColumnCount() - 1) {
                ColorRenderer cr = new ColorRenderer(true);
                ColorEditor ce = new ColorEditor((AbstractTableModel)this.model, this.model.getColumnCount() - 1);
                TableColumn column = new TableColumn(this.model.getColumnCount() - 1, 200, (TableCellRenderer)cr, (TableCellEditor)ce);
                column.setPreferredWidth(60);
                this.addColumn(column);
                continue;
            }
            TableColumn column = new TableColumn(k, 200, (TableCellRenderer)cellRenderer, (TableCellEditor)cellEditor);
            column.setPreferredWidth(80);
            this.addColumn(column);
        }
        this.setPreferredSize(new Dimension(400, 140));
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = -3646841366871833973L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return ChannelTable.this.model.getToolTipText(realIndex);
            }
        };
    }

    public void setGroup(String group) {
        if (ChannelTable.setChannelGroup(group)) {
            this.model.cleanUpConfigurationList();
        }
    }

    public List<ChannelSpec> getChannels() {
        return this.model.getChannels();
    }

    public void setChannels(ArrayList<ChannelSpec> values) {
        this.model.setChannels(values);
    }

    protected static boolean setChannelGroup(String group) {
        if (ChannelTable.groupIsEligibleChannel(group)) {
            try {
                MicroManager.setChannelGroup(group);
                return true;
            }
            catch (Throwable t) {
                System.err.println("Cannot set channel group in Micro-Manager.");
                System.err.println("Cause: " + t);
            }
        }
        return false;
    }

    protected static boolean groupIsEligibleChannel(String group) {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return false;
        }
        List<String> cfgs = MicroManager.getConfigs(group);
        if (!cfgs.isEmpty()) {
            try {
                String propName;
                PropertySetting setting;
                String devLabel;
                Configuration presetData = core.getConfigData(group, cfgs.get(0));
                if (presetData.size() >= 1L && core.hasPropertyLimits(devLabel = (setting = presetData.getSetting(0L)).getDeviceLabel(), propName = setting.getPropertyName())) {
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println("Error with Micro-Manager:");
                System.err.println(e);
                return false;
            }
        }
        return true;
    }

    protected static boolean isConfigAvailable(String config) {
        return MicroManager.getChannelConfigs().contains(config);
    }
}

