/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.preferences.XMLPreferences;
import icy.util.XMLUtil;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class RecentFiles {
    private ArrayList<String> previousFiles = new ArrayList();
    private final int MAX_RECENT_FILES = 20;
    XMLPreferences recentFilesPref;

    RecentFiles(XMLPreferences prefs) {
        this.recentFilesPref = prefs.node("recentFiles");
    }

    void add(File file) {
        this.add(file.getAbsolutePath());
    }

    void add(String fileName) {
        this.previousFiles.remove(fileName);
        this.previousFiles.add(0, fileName);
        if (this.previousFiles.size() > 20) {
            this.previousFiles.remove(this.previousFiles.size() - 1);
        }
    }

    void save() {
        XMLUtil.removeAllChildren((Node)this.recentFilesPref.getXMLNode());
        int i = 0;
        for (String fileName : this.previousFiles) {
            XMLPreferences key = this.recentFilesPref.node("entry" + i);
            key.put("file0", fileName);
            ++i;
        }
    }

    void load() {
        this.previousFiles.clear();
        for (XMLPreferences key : this.recentFilesPref.getChildren()) {
            String fileName = key.get("file0", "");
            this.previousFiles.add(fileName);
        }
    }

    public ArrayList<String> getFiles() {
        return this.previousFiles;
    }
}

