/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.javasource;

import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.VariableDeclarator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plugins.tprovoost.scripteditor.javasource.ClassOrInterfaceVisitor;
import plugins.tprovoost.scripteditor.javasource.ConstructorVisitor;
import plugins.tprovoost.scripteditor.javasource.EnumVisitor;
import plugins.tprovoost.scripteditor.javasource.FieldVisitor;
import plugins.tprovoost.scripteditor.javasource.JarAccess;
import plugins.tprovoost.scripteditor.javasource.MethodVisitor;

public class ClassSource {
    static final Pattern DOC_COMMENT_LINE_HEADER = Pattern.compile("\\s*\\n\\s*\\*");
    public static final String PARAM_PATTERN = "<p><b>Parameters:</b><p class='indented'>";
    static final Pattern LINK_TAG_MEMBER_PATTERN = Pattern.compile("(?:\\w+\\.)*\\w+(?:#\\w+(?:\\([^\\)]*\\))?)?|#\\w+(?:\\([^\\)]*\\))?");
    private static HashMap<Class<?>, ClassSource> allClassSources = new HashMap();
    private Class<?> clazz;
    private CompilationUnit cu;
    private HashMap<String, ConstructorDeclaration> constructors = new HashMap();
    private HashMap<String, MethodDeclaration> methods = new HashMap();
    private HashMap<String, VariableDeclarator> fields = new HashMap();
    private HashMap<String, ClassOrInterfaceDeclaration> classOrInterfaces = new HashMap();
    private HashMap<String, EnumDeclaration> enums = new HashMap();
    private boolean constructorsSet = false;
    private boolean methodsSet = false;
    private boolean enumSet = false;
    private boolean fieldsSet = false;
    private boolean classOrInterfacesSet = false;
    private boolean working = false;
    private boolean DEBUG = false;

    public static synchronized ClassSource getClassSource(Class<?> clazz) {
        ClassSource cm = allClassSources.get(clazz);
        if (cm == null) {
            ClassSource cmFinal = cm = new ClassSource(clazz);
            allClassSources.put(clazz, cmFinal);
            InputStream is = JarAccess.getJavaSourceInputStream(clazz);
            if (is != null) {
                try {
                    cmFinal.cu = JavaParser.parse((InputStream)is);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return cm;
    }

    private ClassSource(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getSourceClass() {
        return this.clazz;
    }

    public HashMap<String, ClassOrInterfaceDeclaration> getClassOrInterfaces() {
        return this.classOrInterfaces;
    }

    public HashMap<String, ConstructorDeclaration> getConstructors() {
        return this.constructors;
    }

    public HashMap<String, VariableDeclarator> getFields() {
        return this.fields;
    }

    public HashMap<String, MethodDeclaration> getMethods() {
        return this.methods;
    }

    public HashMap<String, EnumDeclaration> getEnums() {
        return this.enums;
    }

    public synchronized boolean isFieldsSet() {
        return this.fieldsSet;
    }

    public synchronized boolean isEnumSet() {
        return this.enumSet;
    }

    public synchronized boolean isClassOrInterfacesSet() {
        return this.classOrInterfacesSet;
    }

    public synchronized boolean isConstructorsSet() {
        return this.constructorsSet;
    }

    public synchronized boolean isMethodsSet() {
        return this.methodsSet;
    }

    public boolean isAllSet() {
        return this.fieldsSet && this.classOrInterfacesSet && this.constructorsSet && this.methodsSet && this.enumSet;
    }

    public void waitForAllSet() {
        if (!this.isAllSet()) {
            ThreadUtil.sleep((int)100);
            return;
        }
    }

    public synchronized boolean isWorking() {
        return this.working;
    }

    public synchronized void setWorking(boolean working) {
        this.working = working;
    }

    public void populateAll() {
        if (this.working) {
            this.waitForAllSet();
            return;
        }
        this.working = true;
        if (!this.classOrInterfacesSet) {
            this.populateClassesOrInterfaces();
        }
        if (!this.fieldsSet) {
            this.populateFields();
        }
        if (!this.constructorsSet) {
            this.populateConstructors();
        }
        if (!this.methodsSet) {
            this.populateMethods();
        }
        if (!this.enumSet) {
            this.populateEnums();
        }
    }

    public void populateClassesOrInterfaces() {
        if (this.working) {
            return;
        }
        if (this.cu != null) {
            ClassOrInterfaceVisitor coi = new ClassOrInterfaceVisitor();
            coi.visit(this.cu, null);
            ArrayList<BodyDeclaration> list = coi.getList();
            if (list.isEmpty()) {
                System.out.println("Empty Class/Interface Declaration in " + this.clazz.getName());
            } else {
                this.classOrInterfaces.put(this.clazz.getName(), (ClassOrInterfaceDeclaration)list.get(0));
            }
        }
        this.classOrInterfacesSet = true;
        this.startPopulating();
    }

    public void populateFields() {
        if (this.working) {
            return;
        }
        if (this.cu != null) {
            FieldVisitor coi = new FieldVisitor();
            coi.visit(this.cu, null);
            for (BodyDeclaration bd : coi.getList()) {
                FieldDeclaration fd = (FieldDeclaration)bd;
                for (VariableDeclarator vd : fd.getVariables()) {
                    this.fields.put(vd.getId().getName(), vd);
                }
            }
        }
        this.startPopulating();
        this.fieldsSet = true;
    }

    public void populateEnums() {
        if (this.working) {
            return;
        }
        if (this.cu != null) {
            EnumVisitor ev = new EnumVisitor();
            ev.visit(this.cu, null);
            for (BodyDeclaration bd : ev.getList()) {
                EnumDeclaration ed = (EnumDeclaration)bd;
                this.enums.put(ed.getName(), ed);
            }
        }
        this.startPopulating();
        this.fieldsSet = true;
    }

    public void populateConstructors() {
        if (this.working) {
            return;
        }
        if (this.cu != null) {
            ConstructorVisitor cv = new ConstructorVisitor();
            cv.visit(this.cu, null);
            Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> c = constructorArray[n2];
                block1: for (BodyDeclaration bd : cv.getList()) {
                    ConstructorDeclaration cd = (ConstructorDeclaration)bd;
                    if (!cd.getName().contentEquals(this.clazz.getSimpleName())) continue;
                    List paramsSource = cd.getParameters();
                    Class<?>[] paramsReflect = c.getParameterTypes();
                    if (paramsSource == null || paramsSource.size() != paramsReflect.length) continue;
                    int i = 0;
                    while (i < paramsSource.size()) {
                        Parameter paramSource = (Parameter)paramsSource.get(i);
                        Class<?> paramReflect = paramsReflect[i];
                        String className = paramReflect.isArray() ? paramReflect.getCanonicalName() : paramReflect.getName();
                        String paramSourceType = paramSource.getType().toString();
                        int idx = paramSourceType.indexOf(60);
                        if (idx != -1) {
                            paramSourceType = paramSourceType.substring(0, idx);
                        }
                        if (!className.contains(paramSourceType)) continue block1;
                        ++i;
                    }
                    this.constructors.put(c.toGenericString(), cd);
                }
                if (this.constructors.get(c.toGenericString()) == null && this.DEBUG) {
                    System.out.println("No matching constructor in java: " + c.toGenericString());
                }
                ++n2;
            }
        }
        this.startPopulating();
        this.constructorsSet = true;
    }

    public void populateMethods() {
        if (this.working) {
            this.waitForAllSet();
        }
        if (this.cu != null) {
            MethodVisitor mv = new MethodVisitor();
            mv.visit(this.cu, null);
            Method[] methodArray = this.clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                block1: for (BodyDeclaration cd : mv.getList()) {
                    MethodDeclaration md = (MethodDeclaration)cd;
                    if (!md.getName().contentEquals(method.getName())) continue;
                    List paramsSource = md.getParameters();
                    Class<?>[] paramsReflect = method.getParameterTypes();
                    if (paramsSource != null && paramsSource.size() != paramsReflect.length) continue;
                    if (paramsSource != null) {
                        int i = 0;
                        while (i < paramsSource.size()) {
                            Parameter paramSource = (Parameter)paramsSource.get(i);
                            Class<?> paramReflect = paramsReflect[i];
                            String className = paramReflect.isArray() ? paramReflect.getCanonicalName() : paramReflect.getName();
                            String paramSourceType = paramSource.getType().toString();
                            int idx = paramSourceType.indexOf(60);
                            if (idx != -1) {
                                paramSourceType = paramSourceType.substring(0, idx);
                            }
                            if (!className.contains(paramSourceType)) continue block1;
                            ++i;
                        }
                    }
                    this.methods.put(method.toGenericString(), (MethodDeclaration)cd);
                }
                if (this.methods.get(method.toGenericString()) == null && this.DEBUG) {
                    System.out.println("No matching method in java: " + method.toGenericString());
                }
                ++n2;
            }
        }
        this.startPopulating();
        this.methodsSet = true;
    }

    private void startPopulating() {
        ThreadUtil.bgRun((Runnable)new Runnable(){

            @Override
            public void run() {
                ClassSource.this.populateAll();
            }
        });
    }

    private static final void appendDocCommentTail(StringBuffer sb, StringBuffer tail) {
        String temp;
        StringBuffer params = null;
        StringBuffer returns = null;
        StringBuffer throwsItems = null;
        StringBuffer see = null;
        StringBuffer seeTemp = null;
        StringBuffer since = null;
        StringBuffer author = null;
        StringBuffer version = null;
        StringBuffer unknowns = null;
        boolean inParams = false;
        boolean inThrows = false;
        boolean inReturns = false;
        boolean inSeeAlso = false;
        boolean inSince = false;
        boolean inAuthor = false;
        boolean inVersion = false;
        boolean inUnknowns = false;
        String[] st = tail.toString().split("[ \t\r\n\f]+");
        String token = null;
        int i = 0;
        while (i < st.length && (token = st[i++]) != null) {
            if ("@param".equals(token) && i < st.length) {
                token = st[i++];
                if (params == null) {
                    params = new StringBuffer("<b>Parameters:</b><p class='indented'>");
                } else {
                    params.append("<br>");
                }
                params.append("<b>").append(token).append("</b> ");
                inSeeAlso = false;
                inParams = true;
                inReturns = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inVersion = false;
                inUnknowns = false;
                continue;
            }
            if ("@return".equals(token) && i < st.length) {
                if (returns == null) {
                    returns = new StringBuffer("<b>Returns:</b><p class='indented'>");
                }
                inSeeAlso = false;
                inReturns = true;
                inParams = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inVersion = false;
                inUnknowns = false;
                continue;
            }
            if ("@see".equals(token) && i < st.length) {
                if (see == null) {
                    see = new StringBuffer("<b>See Also:</b><p class='indented'>");
                    seeTemp = new StringBuffer();
                } else {
                    if (seeTemp.length() > 0) {
                        temp = seeTemp.substring(0, seeTemp.length() - 1);
                        ClassSource.appendLinkTagText(see, temp);
                    }
                    see.append("<br>");
                    seeTemp.setLength(0);
                }
                inSeeAlso = true;
                inReturns = false;
                inParams = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inVersion = false;
                inUnknowns = false;
                continue;
            }
            if ("@throws".equals(token) || "@exception".equals(token) && i < st.length) {
                token = st[i++];
                if (throwsItems == null) {
                    throwsItems = new StringBuffer("<b>Throws:</b><p class='indented'>");
                } else {
                    throwsItems.append("<br>");
                }
                throwsItems.append("<b>").append(token).append("</b> ");
                inSeeAlso = false;
                inParams = false;
                inReturns = false;
                inThrows = true;
                inSince = false;
                inAuthor = false;
                inVersion = false;
                inUnknowns = false;
                continue;
            }
            if ("@since".equals(token) && i < st.length) {
                if (since == null) {
                    since = new StringBuffer("<b>Since:</b><p class='indented'>");
                }
                inSeeAlso = false;
                inReturns = false;
                inParams = false;
                inThrows = false;
                inSince = true;
                inAuthor = false;
                inVersion = false;
                inUnknowns = false;
                continue;
            }
            if ("@author".equals(token) && i < st.length) {
                if (author == null) {
                    author = new StringBuffer("<b>Author:</b><p class='indented'>");
                } else {
                    author.append("<br>");
                }
                inSeeAlso = false;
                inReturns = false;
                inParams = false;
                inThrows = false;
                inSince = false;
                inAuthor = true;
                inVersion = false;
                inUnknowns = false;
                continue;
            }
            if ("@version".equals(token) && i < st.length) {
                if (version == null) {
                    version = new StringBuffer("<b>Version:</b><p class='indented'>");
                } else {
                    version.append("<br>");
                }
                inSeeAlso = false;
                inReturns = false;
                inParams = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inVersion = true;
                inUnknowns = false;
                continue;
            }
            if (token.startsWith("@") && token.length() > 1) {
                if (unknowns == null) {
                    unknowns = new StringBuffer();
                } else {
                    unknowns.append("</p>");
                }
                unknowns.append("<b>").append(token).append("</b><p class='indented'>");
                inSeeAlso = false;
                inParams = false;
                inReturns = false;
                inThrows = false;
                inSince = false;
                inAuthor = false;
                inVersion = false;
                inUnknowns = true;
                continue;
            }
            if (inParams) {
                params.append(token).append(' ');
                continue;
            }
            if (inReturns) {
                returns.append(token).append(' ');
                continue;
            }
            if (inSeeAlso) {
                seeTemp.append(token).append(' ');
                continue;
            }
            if (inThrows) {
                throwsItems.append(token).append(' ');
                continue;
            }
            if (inSince) {
                since.append(token).append(' ');
                continue;
            }
            if (inAuthor) {
                author.append(token).append(' ');
                continue;
            }
            if (inVersion) {
                version.append(token).append(' ');
                continue;
            }
            if (!inUnknowns) continue;
            unknowns.append(token).append(' ');
        }
        sb.append("<p>");
        if (params != null) {
            sb.append(params).append("</p>");
        }
        if (returns != null) {
            sb.append(returns).append("</p>");
        }
        if (throwsItems != null) {
            sb.append(throwsItems).append("</p>");
        }
        if (see != null) {
            if (seeTemp.length() > 0) {
                temp = seeTemp.substring(0, seeTemp.length() - 1);
                ClassSource.appendLinkTagText(see, temp);
            }
            see.append("<br>");
            sb.append(see).append("</p>");
        }
        if (author != null) {
            sb.append(author).append("</p>");
        }
        if (version != null) {
            sb.append(version).append("</p>");
        }
        if (since != null) {
            sb.append(since).append("</p>");
        }
        if (unknowns != null) {
            sb.append(unknowns).append("</p>");
        }
    }

    private static final void appendLinkTagText(StringBuffer appendTo, String linkContent) {
        appendTo.append("<a href='");
        linkContent = linkContent.trim();
        Matcher m = LINK_TAG_MEMBER_PATTERN.matcher(linkContent);
        if (m.find() && m.start() == 0) {
            String match;
            String link = match = m.group(0);
            String text = null;
            if (match.length() == linkContent.length()) {
                int pound = match.indexOf(35);
                if (pound == 0) {
                    text = match.substring(1);
                } else if (pound > 0) {
                    String prefix = match.substring(0, pound);
                    if ("java.lang.Object".equals(prefix)) {
                        text = match.substring(pound + 1);
                    }
                } else {
                    text = match;
                }
            } else {
                int offs = match.length();
                while (offs < linkContent.length() && Character.isWhitespace(linkContent.charAt(offs))) {
                    ++offs;
                }
                if (offs < linkContent.length()) {
                    text = linkContent.substring(offs);
                }
            }
            if (text == null) {
                text = linkContent;
            }
            text = ClassSource.fixLinkText(text);
            appendTo.append(link).append("'>").append(text);
        } else {
            System.out.println("Unmatched linkContent: " + linkContent);
            appendTo.append("'>").append(linkContent);
        }
        appendTo.append("</a>");
    }

    public static final String docCommentToHtml(String dc) {
        if (dc == null) {
            return null;
        }
        if (dc.endsWith("*/")) {
            dc = dc.substring(0, dc.length() - 2);
        }
        Matcher m = DOC_COMMENT_LINE_HEADER.matcher(dc);
        dc = m.replaceAll("\n");
        StringBuffer html = new StringBuffer();
        StringBuffer tailBuf = null;
        BufferedReader r = new BufferedReader(new StringReader(dc));
        try {
            boolean inPreBlock;
            String line = r.readLine().substring(3);
            line = ClassSource.possiblyStripDocCommentTail(line);
            int offs = 0;
            while (offs < line.length() && Character.isWhitespace(line.charAt(offs))) {
                ++offs;
            }
            if (offs < line.length()) {
                html.append(line.substring(offs));
            }
            html.append((inPreBlock = ClassSource.isInPreBlock(line, false)) ? (char)'\n' : ' ');
            while ((line = r.readLine()) != null) {
                line = ClassSource.possiblyStripDocCommentTail(line);
                if (tailBuf != null) {
                    tailBuf.append(line).append(' ');
                    continue;
                }
                if (line.trim().startsWith("@")) {
                    tailBuf = new StringBuffer();
                    tailBuf.append(line).append(' ');
                    continue;
                }
                html.append(line);
                inPreBlock = ClassSource.isInPreBlock(line, inPreBlock);
                html.append(inPreBlock ? (char)'\n' : ' ');
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        html = ClassSource.fixDocComment(html);
        if (tailBuf != null) {
            ClassSource.appendDocCommentTail(html, ClassSource.fixDocComment(tailBuf));
        }
        return html.toString();
    }

    public static String forXML(String aText) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    private static final StringBuffer fixDocComment(StringBuffer text) {
        int closingBrace;
        int index = text.indexOf("{@");
        if (index == -1) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        int textOffs = 0;
        while ((closingBrace = ClassSource.indexOf('}', text, index + 2)) > -1) {
            sb.append(text.substring(textOffs, index));
            String content = text.substring(index + 2, closingBrace);
            index = textOffs = closingBrace + 1;
            if (content.startsWith("code ")) {
                sb.append("<code>").append(ClassSource.forXML(content.substring(5))).append("</code>");
            } else if (content.startsWith("link ")) {
                sb.append("<code>");
                ClassSource.appendLinkTagText(sb, content.substring(5));
                sb.append("</code>");
            } else if (content.startsWith("linkplain ")) {
                ClassSource.appendLinkTagText(sb, content.substring(10));
            } else if (content.startsWith("literal ")) {
                sb.append(content.substring(8));
            } else {
                sb.append("<code>").append(content).append("</code>");
            }
            if ((index = text.indexOf("{@", index)) > -1) continue;
        }
        if (textOffs < text.length()) {
            sb.append(text.substring(textOffs));
        }
        return sb;
    }

    private static final String fixLinkText(String text) {
        if (text.startsWith("#")) {
            return text.substring(1);
        }
        return text.replace('#', '.');
    }

    private static final int indexOf(char ch, CharSequence sb, int offs) {
        while (offs < sb.length()) {
            if (ch == sb.charAt(offs)) {
                return offs;
            }
            ++offs;
        }
        return -1;
    }

    private static final boolean isInPreBlock(String line, boolean prevValue) {
        int lastPre = line.lastIndexOf("pre>");
        if (lastPre <= 0) {
            return prevValue;
        }
        char prevChar = line.charAt(lastPre - 1);
        if (prevChar == '<') {
            return true;
        }
        if (prevChar == '/' && lastPre >= 2 && line.charAt(lastPre - 2) == '<') {
            return false;
        }
        return prevValue;
    }

    private static final String possiblyStripDocCommentTail(String str) {
        if (str.endsWith("*/")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }

    public static HashMap<String, String> getParameters(String doc) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        if (doc != null && doc.contains("<b>Parameters:</b>")) {
            int idx = doc.indexOf(PARAM_PATTERN) + PARAM_PATTERN.length();
            doc = doc.substring(idx, doc.indexOf("</p>", idx));
            int end = doc.indexOf("<br>");
            while (!StringUtil.isEmpty((String)doc)) {
                Pattern p;
                Matcher m;
                String parameterDoc = doc;
                if (end != -1) {
                    parameterDoc = doc.substring(0, end);
                }
                if ((m = (p = Pattern.compile("<b>(.*)</b>(.*)")).matcher(parameterDoc)).find()) {
                    toReturn.put(m.group(1), m.group(2));
                }
                if (end != -1) {
                    doc = doc.substring(end + "<br>".length());
                    end = doc.indexOf("<br>");
                    continue;
                }
                doc = "";
            }
        }
        return toReturn;
    }
}

