/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.main;

import icy.file.FileUtil;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import plugins.tprovoost.scripteditor.gui.ScriptingEditor;
import plugins.tprovoost.scripteditor.gui.ScriptingPanel;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;

public class ScriptEditorPlugin
extends PluginActionable {
    static List<ScriptingEditor> editors = new ArrayList<ScriptingEditor>();

    public void run() {
        if (ScriptEngineHandler.getEngineManager().getEngineFactories().isEmpty()) {
            new FailedAnnounceFrame("No interpreter found. Impossible to compile/run a script.");
            System.out.println("No interpreter found. Impossible to compile/run a script.");
            return;
        }
        final ScriptingEditor frame = new ScriptingEditor();
        frame.setSize(500, 500);
        frame.addToDesktopPane();
        frame.setVisible(true);
        frame.requestFocus();
        editors.add(frame);
        frame.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

            public void icyFrameClosed(IcyFrameEvent e) {
                frame.removeFrameListener((IcyFrameListener)this);
                editors.remove(frame);
            }
        });
        String[] args = Icy.getCommandLinePluginArgs();
        if (args.length > 0 && args[0] != null) {
            try {
                if (FileUtil.exists((String)args[0])) {
                    frame.openFile(new File(args[0]));
                    ScriptingPanel pane = (ScriptingPanel)frame.getTabbedPane().getSelectedComponent();
                    ScriptingHandler handler = pane.getScriptHandler();
                    if (handler != null) {
                        handler.setNewEngine(true);
                        handler.setForceRun(false);
                        handler.setStrict(true);
                        handler.setVarInterpretation(true);
                        handler.interpret(true);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Script Editor: cannot execute specified '" + args[0] + "' script file");
                IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
            }
            args[0] = null;
        }
    }

    public static void openInScriptEditor(File f) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String text = "";
        while ((line = reader.readLine()) != null) {
            text = String.valueOf(text) + line + "\n";
        }
        reader.close();
        ScriptEditorPlugin.openInScriptEditor(text, f.getName());
    }

    public static void openInScriptEditor(String text) {
        ScriptEditorPlugin.openInScriptEditor(text, "Untitled*");
    }

    public static void openInScriptEditor(final String text, final String title) {
        if (!editors.isEmpty()) {
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScriptingPanel panel = editors.get(0).createNewPane(title);
                    panel.getTextArea().setText(text);
                }
            });
        } else {
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    new ScriptEditorPlugin().run();
                    ScriptingPanel panel = editors.get(0).createNewPane(title);
                    panel.getTextArea().setText(text);
                }
            });
        }
    }
}

