/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptblock;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import java.io.File;
import java.util.HashMap;
import javax.script.ScriptException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.blocks.util.VarListListener;
import plugins.adufour.vars.gui.model.TypeSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarTrigger;
import plugins.adufour.vars.util.TypeChangeListener;
import plugins.adufour.vars.util.VarReferencingPolicy;
import plugins.tprovoost.scripteditor.scriptblock.PythonScriptBlock;
import plugins.tprovoost.scripteditor.scriptblock.VarMutableScript;
import plugins.tprovoost.scripteditor.scriptblock.VarScriptPython;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptVariable;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;
import plugins.tprovoost.scripteditor.scriptinghandlers.py.PyScriptEngine;

public class OldPythonscript
extends Plugin
implements Block,
VarListListener {
    private VarScriptPython inputScript = new VarScriptPython("Script", "# Click on the button\n# to edit in a frame.\n\noutput0 = input0 * 2");
    private VarList inputMap;
    private VarList outputMap;
    private int inputIdx = 0;
    private int outputIdx = 0;
    private VarTrigger triggerInput;
    private VarTrigger triggerOutput;

    public void run() {
        ScriptingHandler handler = this.inputScript.getEditor().getPanelIn().getScriptHandler();
        PyScriptEngine engine = (PyScriptEngine)handler.createNewEngine();
        for (Var var : this.inputMap) {
            Object value = var.getValue();
            String name = var.getName();
            if (!name.contains("input")) continue;
            value = PythonScriptBlock.transformInputForScript(value);
            engine.put(name, value);
        }
        try {
            this.inputScript.evaluate();
        }
        catch (ScriptException e) {
            throw new IcyHandledException(e.getMessage());
        }
        for (Var output : this.outputMap) {
            Object resObject = engine.get(output.getName());
            output.setValue(PythonScriptBlock.transformScriptOutput(resObject));
        }
    }

    public void declareInput(VarList inputMap) {
        if (this.inputMap == null) {
            this.inputMap = inputMap;
        }
        inputMap.addVarListListener((VarListListener)this);
        this.triggerInput = new VarTrigger("Add Input", new VarTrigger.TriggerListener[]{new VarTrigger.TriggerListener(){

            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue) {
                OldPythonscript.this.registerVariables();
            }

            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference) {
                OldPythonscript.this.registerVariables();
            }

            public void triggered(VarTrigger source) {
                String name = "input" + OldPythonscript.this.inputIdx;
                VarMutableScript myVariable = new VarMutableScript(name, Object.class);
                myVariable.setDefaultEditorModel((VarEditorModel)new TypeSelectionModel(new Class[]{Object.class, Object[].class, Sequence.class, ROI[].class, Integer.class, Double.class, int[].class, double[].class, String.class, File.class, File[].class}));
                myVariable.addTypeChangeListener(new TypeChangeListener(){

                    public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
                        OldPythonscript.this.registerVariables();
                    }
                });
                OldPythonscript.this.inputMap.addRuntimeVariable("" + ((Object)((Object)myVariable)).hashCode(), (VarMutable)myVariable);
                OldPythonscript.this.registerVariables();
            }
        }});
        this.triggerInput.setReferencingPolicy(VarReferencingPolicy.NONE);
        this.triggerOutput = new VarTrigger("Add output", new VarTrigger.TriggerListener[]{new VarTrigger.TriggerListener(){

            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue) {
                OldPythonscript.this.registerVariables();
            }

            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference) {
                OldPythonscript.this.registerVariables();
            }

            public void triggered(VarTrigger source) {
                String name = "output" + OldPythonscript.this.outputIdx;
                VarMutableScript myVariable = new VarMutableScript(name, Object.class);
                myVariable.setDefaultEditorModel((VarEditorModel)new TypeSelectionModel(new Class[]{Object.class, Object[].class, Sequence.class, ROI[].class, Integer.class, Double.class, int[].class, double[].class, String.class, File.class, File[].class}));
                myVariable.addTypeChangeListener(new TypeChangeListener(){

                    public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
                        OldPythonscript.this.registerVariables();
                    }
                });
                OldPythonscript.this.outputMap.addRuntimeVariable("" + ((Object)((Object)myVariable)).hashCode(), (VarMutable)myVariable);
                OldPythonscript.this.registerVariables();
            }
        }});
        this.triggerOutput.setReferencingPolicy(VarReferencingPolicy.NONE);
        this.inputScript.setReferencingPolicy(VarReferencingPolicy.NONE);
        inputMap.add(this.inputScript.getName(), (Var)this.inputScript);
        inputMap.add(this.triggerInput.getName(), (Var)this.triggerInput);
        inputMap.add(this.triggerOutput.getName(), (Var)this.triggerOutput);
        String name = "input" + this.inputIdx;
        VarMutableScript myVariable = new VarMutableScript(name, Object.class);
        myVariable.setDefaultEditorModel((VarEditorModel)new TypeSelectionModel(new Class[]{Object.class, Object[].class, Sequence.class, ROI[].class, Boolean.class, Integer.class, Double.class, int[].class, double[].class, String.class, File.class, File[].class}));
        myVariable.addTypeChangeListener(new TypeChangeListener(){

            public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
                OldPythonscript.this.registerVariables();
            }
        });
        inputMap.add(name, (Var)myVariable);
    }

    public void declareOutput(VarList outputMap) {
        this.outputMap = outputMap;
        outputMap.addVarListListener((VarListListener)this);
        String name = "output" + this.outputIdx;
        VarMutableScript myVariable = new VarMutableScript(name, Object.class);
        myVariable.setDefaultEditorModel((VarEditorModel)new TypeSelectionModel(new Class[]{Object.class, Object[].class, Sequence.class, ROI[].class, Boolean.class, Integer.class, Double.class, int[].class, double[].class, String.class, File.class, File[].class}));
        myVariable.addTypeChangeListener(new TypeChangeListener(){

            public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
                OldPythonscript.this.registerVariables();
            }
        });
        outputMap.add(name, (Var)myVariable);
        this.registerVariables();
    }

    private void registerVariables() {
        final ScriptingHandler handlerIn = this.inputScript.getEditor().getPanelIn().getScriptHandler();
        final ScriptingHandler handlerOut = this.inputScript.getEditor().getPanelOut().getScriptHandler();
        HashMap<String, ScriptVariable> variablesInt = handlerIn.getExternalVariables();
        HashMap<String, ScriptVariable> variablesExt = handlerOut.getExternalVariables();
        variablesInt.clear();
        variablesExt.clear();
        for (Var v : this.inputMap) {
            if (!(v instanceof VarMutableScript)) continue;
            variablesInt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
            variablesExt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
        }
        for (Var v : this.outputMap) {
            if (!(v instanceof VarMutableScript)) continue;
            variablesInt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
            variablesExt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                handlerIn.interpret(false);
                handlerOut.interpret(false);
            }
        });
    }

    public void variableAdded(VarList list, Var<?> variable) {
        if (list == this.inputMap && variable != this.triggerInput && variable != this.inputScript && variable != this.triggerOutput) {
            ++this.inputIdx;
        } else if (list == this.outputMap) {
            ++this.outputIdx;
        }
    }

    public void variableRemoved(VarList list, Var<?> variable) {
    }
}

