/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMemoryView$PyExposer;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.buffer.BaseBuffer;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="memoryview", doc="memoryview(object)\n\nCreate a new memoryview object which references the given object.", base=PyObject.class, isBaseType=false)
public class PyMemoryView
extends PySequence
implements BufferProtocol {
    public static final PyType TYPE;
    private PyBuffer backing;
    private boolean released;
    private PyObject shape;
    private PyObject strides;
    private PyObject suboffsets;
    private int hashCache;
    private boolean hashCacheValid = false;
    private static final String cast_doc = "M.cast(format[, shape]) -> memoryview\n\nCast a memoryview to a new format or shape.";
    private static final String release_doc = "M.release() -> None\n\nRelease the underlying buffer exposed by the memoryview object.";
    private static final String tobytes_doc = "M.tobytes() -> bytes\n\nReturn the data in the buffer as a bytestring (an object of class str).";
    private static final String tolist_doc = "M.tolist() -> list\n\nReturn the data in the buffer as a list of elements.";
    private static final String c_contiguous_doc = "c_contiguous\nA bool indicating whether the memory is C contiguous.";
    private static final String contiguous_doc = "contiguous\nA bool indicating whether the memory is contiguous.";
    private static final String f_contiguous_doc = "c_contiguous\nA bool indicating whether the memory is Fortran contiguous.";
    private static final String format_doc = "format\nA string containing the format (in struct module style)\n for each element in the view.";
    private static final String itemsize_doc = "itemsize\nThe size in bytes of each element of the memoryview.";
    private static final String nbytes_doc = "nbytes\nThe amount of space in bytes that the array would use in\na contiguous representation.";
    private static final String ndim_doc = "ndim\nAn integer indicating how many dimensions of a multi-dimensional\narray the memory represents.";
    private static final String obj_doc = "obj\nThe underlying object of the memoryview.";
    private static final String readonly_doc = "readonly\nA bool indicating whether the memory is read only.";
    private static final String shape_doc = "shape\nA tuple of ndim integers giving the shape of the memory\nas an N-dimensional array.";
    private static final String strides_doc = "strides\nA tuple of ndim integers giving the size in bytes to access\neach element for each dimension of the array.";
    private static final String suboffsets_doc = "suboffsets\nA tuple of ndim integers used internally for PIL-style arrays\nor None.";

    public PyMemoryView(BufferProtocol pybuf) {
        super(TYPE);
        this.backing = pybuf.getBuffer(284);
    }

    @ExposedNew
    static PyObject memoryview_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args.length != 1) {
            throw Py.TypeError("memoryview() takes exactly one argument");
        }
        ArgParser ap = new ArgParser("memoryview", args, keywords, "object");
        PyObject obj = ap.getPyObject(0);
        if (obj instanceof BufferProtocol) {
            return new PyMemoryView((BufferProtocol)((Object)obj));
        }
        throw Py.TypeError("cannot make memory view because object does not have the buffer interface");
    }

    public String format() {
        this.checkNotReleased();
        return this.backing.getFormat();
    }

    public int itemsize() {
        this.checkNotReleased();
        return this.backing.getItemsize();
    }

    public PyObject shape() {
        this.checkNotReleased();
        if (this.shape == null) {
            this.shape = this.tupleOf(this.backing.getShape());
        }
        return this.shape;
    }

    public int ndim() {
        this.checkNotReleased();
        return this.backing.getNdim();
    }

    public PyObject strides() {
        this.checkNotReleased();
        if (this.strides == null) {
            this.strides = this.tupleOf(this.backing.getStrides());
        }
        return this.strides;
    }

    public PyObject suboffsets() {
        this.checkNotReleased();
        if (this.suboffsets == null) {
            this.suboffsets = this.tupleOf(this.backing.getSuboffsets());
        }
        return this.suboffsets;
    }

    public boolean readonly() {
        this.checkNotReleased();
        return this.backing.isReadonly();
    }

    public PyString tobytes() {
        return this.memoryview_tobytes();
    }

    final PyString memoryview_tobytes() {
        this.checkNotReleased();
        if (this.backing instanceof BaseBuffer) {
            return new PyString(((Object)this.backing).toString());
        }
        String s = StringUtil.fromBytes(this.backing);
        return new PyString(s);
    }

    public PyList tolist() {
        return this.memoryview_tolist();
    }

    final PyList memoryview_tolist() {
        this.checkNotReleased();
        int n = this.backing.getLen();
        PyList list = new PyList();
        for (int i = 0; i < n; ++i) {
            list.add(new PyInteger(this.backing.intAt(i)));
        }
        return list;
    }

    private PyObject tupleOf(int[] x) {
        if (x != null) {
            PyObject[] pyx = new PyLong[x.length];
            for (int k = 0; k < x.length; ++k) {
                pyx[k] = new PyLong(x[k]);
            }
            return new PyTuple(pyx, false);
        }
        return Py.None;
    }

    @Override
    public int __len__() {
        this.checkNotReleased();
        return this.backing.getLen();
    }

    @Override
    public int hashCode() {
        return this.memoryview___hash__();
    }

    final int memoryview___hash__() {
        if (!this.hashCacheValid) {
            this.checkNotReleased();
            if (this.backing.isReadonly()) {
                this.hashCache = ((Object)this.backing).toString().hashCode();
                this.hashCacheValid = true;
            } else {
                throw Py.ValueError("cannot hash writable memoryview object");
            }
        }
        return this.hashCache;
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.memoryview___eq__(other);
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.memoryview___ne__(other);
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.memoryview___lt__(other);
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.memoryview___le__(other);
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.memoryview___ge__(other);
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.memoryview___gt__(other);
    }

    private static int compare(PyBuffer a, PyBuffer b) {
        int ap = 0;
        int aEnd = ap + a.getLen();
        int bp = 0;
        int bEnd = b.getLen();
        while (ap < aEnd) {
            int bVal;
            int aVal;
            int diff;
            if (bp >= bEnd) {
                return 1;
            }
            if ((diff = (aVal = a.intAt(ap++)) - (bVal = b.intAt(bp++))) == 0) continue;
            return diff < 0 ? -1 : 1;
        }
        if (bp < bEnd) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int memoryview_cmp(PyObject b) {
        this.checkNotReleased();
        PyBuffer bv = BaseBytes.getView(b);
        if (bv == null) {
            return -2;
        }
        try {
            if (bv == this.backing) {
                int n = 0;
                return n;
            }
            int n = PyMemoryView.compare(this.backing, bv);
            return n;
        }
        finally {
            bv.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int memoryview_cmpeq(PyObject b) {
        if (this == b) {
            return 0;
        }
        if (this.released) {
            return -1;
        }
        if (b instanceof PyMemoryView && ((PyMemoryView)b).released) {
            return 1;
        }
        PyBuffer bv = BaseBytes.getView(b);
        if (bv == null) {
            return -2;
        }
        try {
            if (bv == this.backing) {
                int n = 0;
                return n;
            }
            if (bv.getLen() != this.backing.getLen()) {
                int n = 1;
                return n;
            }
            int n = PyMemoryView.compare(this.backing, bv);
            return n;
        }
        finally {
            bv.release();
        }
    }

    final PyObject memoryview___eq__(PyObject other) {
        int cmp = this.memoryview_cmpeq(other);
        if (cmp == 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    final PyObject memoryview___ne__(PyObject other) {
        int cmp = this.memoryview_cmpeq(other);
        if (cmp == 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject memoryview___lt__(PyObject other) {
        int cmp = this.memoryview_cmp(other);
        if (cmp >= 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject memoryview___le__(PyObject other) {
        int cmp = this.memoryview_cmp(other);
        if (cmp > 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject memoryview___ge__(PyObject other) {
        int cmp = this.memoryview_cmp(other);
        if (cmp >= 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    final PyObject memoryview___gt__(PyObject other) {
        int cmp = this.memoryview_cmp(other);
        if (cmp > 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    public PyObject __enter__() {
        return this.memoryview___enter__();
    }

    final PyObject memoryview___enter__() {
        this.checkNotReleased();
        return this;
    }

    public boolean __exit__(PyObject type, PyObject value, PyObject traceback) {
        return this.memoryview___exit__(type, value, traceback);
    }

    final boolean memoryview___exit__(PyObject type, PyObject value, PyObject traceback) {
        this.memoryview_release();
        return false;
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        this.checkNotReleased();
        return this.backing.getBuffer(flags);
    }

    public synchronized void release() {
        this.memoryview_release();
    }

    public final synchronized void memoryview_release() {
        if (!this.released) {
            this.backing.release();
            this.released = true;
        }
    }

    protected void checkNotReleased() {
        if (this.released) {
            throw Py.ValueError("operation forbidden on released memoryview object");
        }
        assert (!this.backing.isReleased());
    }

    @Override
    protected PyString pyget(int index) {
        this.checkNotReleased();
        return new PyString(String.valueOf((char)this.backing.intAt(index)));
    }

    @Override
    protected synchronized PyMemoryView getslice(int start, int stop, int step) {
        this.checkNotReleased();
        int n = PyMemoryView.sliceLength(start, stop, step);
        PyBuffer view = this.backing.getBufferSlice(284, start, n, step);
        PyMemoryView ret = new PyMemoryView(view);
        view.release();
        return ret;
    }

    @Override
    protected synchronized PyMemoryView repeat(int count2) throws PyException {
        throw Py.NotImplementedError("memoryview.repeat()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pyset(int index, PyObject value) throws PyException {
        this.checkNotReleased();
        PyBuffer valueBuf = BaseBytes.getViewOrError(value);
        try {
            if (valueBuf.getLen() != 1) {
                throw Py.ValueError("cannot modify size of memoryview object");
            }
            this.backing.storeAt(valueBuf.byteAt(0), index);
        }
        finally {
            valueBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void setslice(int start, int stop, int step, PyObject value) {
        this.checkNotReleased();
        if (step == 1 && stop < start) {
            stop = start;
        }
        PyBuffer valueBuf = BaseBytes.getViewOrError(value);
        PyBuffer backingSlice = null;
        try {
            int n = PyMemoryView.sliceLength(start, stop, step);
            if (n != valueBuf.getLen()) {
                throw Py.ValueError("cannot modify size of memoryview object");
            }
            backingSlice = this.backing.getBufferSlice(284, start, n, step);
            backingSlice.copyFrom(valueBuf);
        }
        finally {
            if (backingSlice != null) {
                backingSlice.release();
            }
            valueBuf.release();
        }
    }

    static {
        PyType.addBuilder(PyMemoryView.class, new PyMemoryView$PyExposer());
        TYPE = PyType.fromClass(PyMemoryView.class);
    }
}

