/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.TraceFunction;

public class ThreadState {
    public PySystemState systemState;
    public PyFrame frame;
    public PyException exception;
    public Thread thread;
    public boolean tracing;
    public PyList reprStack;
    public int compareStateNesting;
    public int recursion_depth;
    public TraceFunction tracefunc;
    public TraceFunction profilefunc;
    private PyDictionary compareStateDict;

    public ThreadState(Thread t, PySystemState systemState) {
        this.systemState = systemState;
        this.thread = t;
    }

    public boolean enterRepr(PyObject obj) {
        if (this.reprStack == null) {
            this.reprStack = new PyList(new PyObject[]{obj});
            return true;
        }
        int i = this.reprStack.size() - 1;
        while (i >= 0) {
            if (obj == this.reprStack.pyget(i)) {
                return false;
            }
            --i;
        }
        this.reprStack.append(obj);
        return true;
    }

    public void exitRepr(PyObject obj) {
        if (this.reprStack == null) {
            return;
        }
        int i = this.reprStack.size() - 1;
        while (i >= 0) {
            if (this.reprStack.pyget(i) == obj) {
                this.reprStack.delRange(i, this.reprStack.size());
            }
            --i;
        }
    }

    public PyDictionary getCompareStateDict() {
        if (this.compareStateDict == null) {
            this.compareStateDict = new PyDictionary();
        }
        return this.compareStateDict;
    }

    public void enterRecursiveCall(String where) {
        if (this.recursion_depth++ > this.systemState.getrecursionlimit()) {
            throw Py.RuntimeError("maximum recursion depth exceeded" + where);
        }
    }

    public void leaveRecursiveCall() {
        --this.recursion_depth;
    }
}

