/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.unix;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.base.utilities.NativeLibraryUtilities;
import java.io.File;
import java.io.IOException;

public final class Unix {
    private static final boolean operational;
    private static final ProcessDetection processDetection;
    private static volatile boolean useUnixRealtimeTimer;
    public static final short S_ISUID = 2048;
    public static final short S_ISGID = 1024;
    public static final short S_ISVTX = 512;
    public static final short S_IRUSR = 256;
    public static final short S_IWUSR = 128;
    public static final short S_IXUSR = 64;
    public static final short S_IRGRP = 32;
    public static final short S_IWGRP = 16;
    public static final short S_IXGRP = 8;
    public static final short S_IROTH = 4;
    public static final short S_IWOTH = 2;
    public static final short S_IXOTH = 1;

    static {
        useUnixRealtimeTimer = false;
        operational = NativeLibraryUtilities.loadNativeLibrary("unix");
        if (operational) {
            Unix.init();
            int myPid = Unix.getPid();
            processDetection = Unix.isProcessRunningProcFS(myPid) ? ProcessDetection.PROCFS : (Unix.isProcessRunningPS(myPid) ? ProcessDetection.PS : ProcessDetection.NONE);
        } else {
            processDetection = ProcessDetection.NONE;
        }
        useUnixRealtimeTimer = Boolean.getBoolean("unix.realtime.timer");
    }

    private static void throwLinkCreationException(String type, String source2, String target, String errorMessage) {
        throw new IOExceptionUnchecked(new IOException(String.format("Creating %s link '%s' -> '%s': %s", type, target, source2, errorMessage)));
    }

    private static void throwStatException(String filename, String errorMessage) {
        throw new IOExceptionUnchecked(new IOException(String.format("Cannot obtain inode info for file '%s': %s", filename, errorMessage)));
    }

    private static void throwFileException(String operation, String filename, String errorMessage) {
        throw new IOExceptionUnchecked(new IOException(String.format("Cannot %s of file '%s': %s", operation, filename, errorMessage)));
    }

    private static void throwRuntimeException(String operation, String errorMessage) {
        throw new RuntimeException(String.format("Error on %s: %s", operation, errorMessage));
    }

    private static native int init();

    public static boolean isUseUnixRealtimeTimer() {
        return useUnixRealtimeTimer;
    }

    public static void setUseUnixRealtimeTimer(boolean useUnixRealTimeTimer) {
        useUnixRealtimeTimer = useUnixRealTimeTimer;
    }

    private static native int getpid();

    private static native int getuid();

    private static native int geteuid();

    private static native int getgid();

    private static native int getegid();

    private static native int link(String var0, String var1);

    private static native int symlink(String var0, String var1);

    private static native Stat stat(String var0);

    private static native Stat lstat(String var0);

    private static native String readlink(String var0, int var1);

    private static native int chmod(String var0, short var1);

    private static native int chown(String var0, int var1, int var2);

    private static native int lchown(String var0, int var1, int var2);

    private static native int clock_gettime(long[] var0);

    private static native int clock_gettime2(long[] var0);

    private static native int lutimes(String var0, long var1, long var3, long var5, long var7);

    private static native int utimes(String var0, long var1, long var3, long var5, long var7);

    private static native String getuser(int var0);

    private static native String getgroup(int var0);

    private static native int getuid(String var0);

    private static native Password getpwnam(String var0);

    private static native Password getpwuid(int var0);

    private static native int getgid(String var0);

    private static native Group getgrnam(String var0);

    private static native Group getgrgid(int var0);

    private static native String strerror(int var0);

    private static native String strerror();

    @Private
    static boolean isProcessRunningProcFS(int pid) {
        return new File("/proc/" + pid).isDirectory();
    }

    @Private
    static boolean isProcessRunningPS(int pid) {
        try {
            return Runtime.getRuntime().exec(new String[]{"ps", "-p", Integer.toString(pid)}).waitFor() == 0;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (InterruptedException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public static final boolean isOperational() {
        return operational;
    }

    public static boolean canDetectProcesses() {
        return processDetection != ProcessDetection.NONE;
    }

    public static String getLastError() {
        return Unix.strerror();
    }

    public static int getPid() {
        return Unix.getpid();
    }

    public static boolean isProcessRunning(int pid) {
        switch (processDetection) {
            case PROCFS: {
                return Unix.isProcessRunningProcFS(pid);
            }
            case PS: {
                return Unix.isProcessRunningPS(pid);
            }
        }
        return false;
    }

    public static final int getUid() {
        return Unix.getuid();
    }

    public static final int getEuid() {
        return Unix.geteuid();
    }

    public static final int getGid() {
        return Unix.getgid();
    }

    public static final int getEgid() {
        return Unix.getegid();
    }

    public static final Time getSystemTime() {
        int result;
        long[] time = new long[2];
        int n = result = useUnixRealtimeTimer ? Unix.clock_gettime(time) : Unix.clock_gettime2(time);
        if (result < 0) {
            Unix.throwRuntimeException("get system time", Unix.strerror(result));
        }
        return new Time(time[0], time[1]);
    }

    public static final long getSystemTimeMillis() {
        return Unix.getSystemTime().getMillis();
    }

    public static final void createHardLink(String fileName, String linkName) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (linkName == null) {
            throw new NullPointerException("linkName");
        }
        int result = Unix.link(fileName, linkName);
        if (result < 0) {
            Unix.throwLinkCreationException("hard", fileName, linkName, Unix.strerror(result));
        }
    }

    public static final void createSymbolicLink(String fileName, String linkName) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (linkName == null) {
            throw new NullPointerException("linkName");
        }
        int result = Unix.symlink(fileName, linkName);
        if (result < 0) {
            Unix.throwLinkCreationException("symbolic", fileName, linkName, Unix.strerror(result));
        }
    }

    private static Stat tryGetStat(String fileName) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        return Unix.stat(fileName);
    }

    private static Stat getStat(String fileName) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        Stat result = Unix.stat(fileName);
        if (result == null) {
            Unix.throwStatException(fileName, Unix.strerror());
        }
        return result;
    }

    private static Stat tryGetLStat(String linkName) throws IOExceptionUnchecked {
        if (linkName == null) {
            throw new NullPointerException("linkName");
        }
        return Unix.lstat(linkName);
    }

    private static Stat getLStat(String linkName) throws IOExceptionUnchecked {
        if (linkName == null) {
            throw new NullPointerException("linkName");
        }
        Stat result = Unix.lstat(linkName);
        if (result == null) {
            Unix.throwStatException(linkName, Unix.strerror());
        }
        return result;
    }

    @Deprecated
    public static final long getInode(String linkName) throws IOExceptionUnchecked {
        return Unix.getLStat(linkName).getInode();
    }

    @Deprecated
    public static final int getNumberOfHardLinks(String linkName) throws IOExceptionUnchecked {
        return Unix.getLStat(linkName).getNumberOfHardLinks();
    }

    public static final boolean isSymbolicLink(String linkName) throws IOExceptionUnchecked {
        return Unix.getLStat(linkName).isSymbolicLink();
    }

    public static final String tryReadSymbolicLink(String linkName) throws IOExceptionUnchecked {
        Stat stat = Unix.getLStat(linkName);
        return stat.isSymbolicLink() ? Unix.readlink(linkName, (int)stat.getSize()) : null;
    }

    public static final Stat getFileInfo(String fileName) throws IOExceptionUnchecked {
        return Unix.getStat(fileName);
    }

    public static final Stat tryGetFileInfo(String fileName) throws IOExceptionUnchecked {
        return Unix.tryGetStat(fileName);
    }

    public static final Stat getLinkInfo(String linkName) throws IOExceptionUnchecked {
        return Unix.getLinkInfo(linkName, true);
    }

    public static final Stat getLinkInfo(String linkName, boolean readSymbolicLinkTarget) throws IOExceptionUnchecked {
        Stat stat = Unix.getLStat(linkName);
        String symbolicLinkOrNull = readSymbolicLinkTarget && stat.isSymbolicLink() ? Unix.readlink(linkName, (int)stat.getSize()) : null;
        stat.setSymbolicLinkOrNull(symbolicLinkOrNull);
        return stat;
    }

    public static final Stat tryGetLinkInfo(String linkName) throws IOExceptionUnchecked {
        return Unix.tryGetLinkInfo(linkName, true);
    }

    public static final Stat tryGetLinkInfo(String linkName, boolean readSymbolicLinkTarget) throws IOExceptionUnchecked {
        Stat stat = Unix.tryGetLStat(linkName);
        if (stat == null) {
            return null;
        }
        String symbolicLinkOrNull = readSymbolicLinkTarget && stat.isSymbolicLink() ? Unix.readlink(linkName, (int)stat.getSize()) : null;
        stat.setSymbolicLinkOrNull(symbolicLinkOrNull);
        return stat;
    }

    public static final void setAccessMode(String fileName, short mode) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        int result = Unix.chmod(fileName, mode);
        if (result < 0) {
            Unix.throwFileException("set mode", fileName, Unix.strerror(result));
        }
    }

    public static final void setOwner(String fileName, int uid, int gid) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        int result = Unix.chown(fileName, uid, gid);
        if (result < 0) {
            Unix.throwFileException("set owner", fileName, Unix.strerror(result));
        }
    }

    public static final void setOwner(String fileName, Password user) throws IOExceptionUnchecked {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        int result = Unix.chown(fileName, user.getUid(), user.getGid());
        if (result < 0) {
            Unix.throwFileException("set owner", fileName, Unix.strerror(result));
        }
    }

    public static final void setLinkOwner(String linkName, int uid, int gid) throws IOExceptionUnchecked {
        if (linkName == null) {
            throw new NullPointerException("linkName");
        }
        int result = Unix.lchown(linkName, uid, gid);
        if (result < 0) {
            Unix.throwFileException("set link owner", linkName, Unix.strerror(result));
        }
    }

    public static final void setLinkOwner(String linkName, Password user) throws IOExceptionUnchecked {
        if (linkName == null) {
            throw new NullPointerException("linkName");
        }
        int result = Unix.lchown(linkName, user.getUid(), user.getGid());
        if (result < 0) {
            Unix.throwFileException("set owner", linkName, Unix.strerror(result));
        }
    }

    public static void setLinkTimestamps(String fileName, long accessTimeSecs, long accessTimeMicroSecs, long modificationTimeSecs, long modificationTimeMicroSecs) throws IOExceptionUnchecked {
        int result = Unix.lutimes(fileName, accessTimeSecs, accessTimeMicroSecs, modificationTimeSecs, modificationTimeMicroSecs);
        if (result < 0) {
            Unix.throwFileException("set file timestamps", fileName, Unix.strerror(result));
        }
    }

    public static void setLinkTimestamps(String fileName, long accessTimeSecs, long modificationTimeSecs) throws IOExceptionUnchecked {
        Unix.setLinkTimestamps(fileName, accessTimeSecs, 0L, modificationTimeSecs, 0L);
    }

    public static void setLinkTimestamps(String fileName, Time accessTime, Time modificationTime) throws IOExceptionUnchecked {
        Unix.setLinkTimestamps(fileName, accessTime.getSecs(), accessTime.getMicroSecPart(), modificationTime.getSecs(), modificationTime.getMicroSecPart());
    }

    public static void setLinkTimestamps(String fileName) throws IOExceptionUnchecked {
        Time now = Unix.getSystemTime();
        int result = Unix.lutimes(fileName, now.getSecs(), now.getMicroSecPart(), now.getSecs(), now.getMicroSecPart());
        if (result < 0) {
            Unix.throwFileException("set file timestamps", fileName, Unix.strerror(result));
        }
    }

    public static void setFileTimestamps(String fileName, long accessTimeSecs, long accessTimeMicroSecs, long modificationTimeSecs, long modificationTimeMicroSecs) throws IOExceptionUnchecked {
        int result = Unix.utimes(fileName, accessTimeSecs, accessTimeMicroSecs, modificationTimeSecs, modificationTimeMicroSecs);
        if (result < 0) {
            Unix.throwFileException("set file timestamps", fileName, Unix.strerror(result));
        }
    }

    public static void setFileTimestamps(String fileName, long accessTimeSecs, long modificationTimeSecs) throws IOExceptionUnchecked {
        Unix.setFileTimestamps(fileName, accessTimeSecs, 0L, modificationTimeSecs, 0L);
    }

    public static void setFileTimestamps(String fileName, Time accessTime, Time modificationTime) throws IOExceptionUnchecked {
        Unix.setFileTimestamps(fileName, accessTime.getSecs(), accessTime.getMicroSecPart(), modificationTime.getSecs(), modificationTime.getMicroSecPart());
    }

    public static void setFileTimestamps(String fileName) throws IOExceptionUnchecked {
        Time now = Unix.getSystemTime();
        int result = Unix.utimes(fileName, now.getSecs(), now.getMicroSecPart(), now.getSecs(), now.getMicroSecPart());
        if (result < 0) {
            Unix.throwFileException("set file timestamps", fileName, Unix.strerror(result));
        }
    }

    public static final String tryGetUserNameForUid(int uid) {
        return Unix.getuser(uid);
    }

    public static final int getUidForUserName(String userName) {
        if (userName == null) {
            throw new NullPointerException("userName");
        }
        return Unix.getuid(userName);
    }

    public static final Password tryGetUserByName(String userName) {
        if (userName == null) {
            throw new NullPointerException("userName");
        }
        return Unix.getpwnam(userName);
    }

    public static final Password tryGetUserByUid(int uid) {
        return Unix.getpwuid(uid);
    }

    public static final String tryGetGroupNameForGid(int gid) {
        return Unix.getgroup(gid);
    }

    public static final int getGidForGroupName(String groupName) {
        if (groupName == null) {
            throw new NullPointerException("groupName");
        }
        return Unix.getgid(groupName);
    }

    public static final Group tryGetGroupByName(String groupName) {
        if (groupName == null) {
            throw new NullPointerException("groupName");
        }
        return Unix.getgrnam(groupName);
    }

    public static final Group tryGetGroupByGid(int gid) {
        return Unix.getgrgid(gid);
    }

    public static final String getErrorString(int errnum) {
        return Unix.strerror(errnum);
    }

    public static final class Group {
        private final String groupName;
        private final String groupPasswordHash;
        private final int gid;
        private final String[] groupMembers;

        Group(String groupName, String groupPasswordHash, int gid, String[] groupMembers) {
            this.groupName = groupName;
            this.groupPasswordHash = groupPasswordHash;
            this.gid = gid;
            this.groupMembers = groupMembers;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getGroupPasswordHash() {
            return this.groupPasswordHash;
        }

        public int getGid() {
            return this.gid;
        }

        public String[] getGroupMembers() {
            return this.groupMembers;
        }
    }

    public static final class Password {
        private final String userName;
        private final String passwordHash;
        private final int uid;
        private final int gid;
        private final String userFullName;
        private final String homeDirectory;
        private final String shell;

        Password(String userName, String passwordHash, int uid, int gid, String userFullName, String homeDirectory, String shell) {
            this.userName = userName;
            this.passwordHash = passwordHash;
            this.uid = uid;
            this.gid = gid;
            this.userFullName = userFullName;
            this.homeDirectory = homeDirectory;
            this.shell = shell;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPasswordHash() {
            return this.passwordHash;
        }

        public int getUid() {
            return this.uid;
        }

        public int getGid() {
            return this.gid;
        }

        public String getUserFullName() {
            return this.userFullName;
        }

        public String getHomeDirectory() {
            return this.homeDirectory;
        }

        public String getShell() {
            return this.shell;
        }
    }

    private static enum ProcessDetection {
        PROCFS,
        PS,
        NONE;

    }

    public static final class Stat {
        private final long deviceId;
        private final long inode;
        private final short permissions;
        private final FileLinkType linkType;
        private String symbolicLinkOrNull;
        private final int numberOfHardLinks;
        private final int uid;
        private final int gid;
        private final Time lastAccess;
        private final Time lastModified;
        private final Time lastStatusChange;
        private final long size;
        private final long numberOfBlocks;
        private final int blockSize;

        Stat(long deviceId, long inode, short permissions, byte linkType, int numberOfHardLinks, int uid, int gid, long lastAccess, long lastModified, long lastStatusChange, long size, long numberOfBlocks, int blockSize) {
            this(deviceId, inode, permissions, linkType, numberOfHardLinks, uid, gid, lastAccess, 0L, lastModified, 0L, lastStatusChange, 0L, size, numberOfBlocks, blockSize);
        }

        Stat(long deviceId, long inode, short permissions, byte linkType, int numberOfHardLinks, int uid, int gid, long lastAccess, long lastAccessNanos, long lastModified, long lastModifiedNanos, long lastStatusChange, long lastStatusChangeNanos, long size, long numberOfBlocks, int blockSize) {
            this.deviceId = deviceId;
            this.inode = inode;
            this.permissions = permissions;
            this.linkType = FileLinkType.values()[linkType];
            this.numberOfHardLinks = numberOfHardLinks;
            this.uid = uid;
            this.gid = gid;
            this.lastAccess = new Time(lastAccess, lastAccessNanos);
            this.lastModified = new Time(lastModified, lastModifiedNanos);
            this.lastStatusChange = new Time(lastStatusChange, lastStatusChangeNanos);
            this.size = size;
            this.numberOfBlocks = numberOfBlocks;
            this.blockSize = blockSize;
        }

        void setSymbolicLinkOrNull(String symbolicLinkOrNull) {
            this.symbolicLinkOrNull = symbolicLinkOrNull;
        }

        public String tryGetSymbolicLink() {
            return this.symbolicLinkOrNull;
        }

        public long getDeviceId() {
            return this.deviceId;
        }

        public long getInode() {
            return this.inode;
        }

        public short getPermissions() {
            return this.permissions;
        }

        public FileLinkType getLinkType() {
            return this.linkType;
        }

        public final boolean isSymbolicLink() {
            return FileLinkType.SYMLINK == this.linkType;
        }

        public int getNumberOfHardLinks() {
            return this.numberOfHardLinks;
        }

        public int getUid() {
            return this.uid;
        }

        public int getGid() {
            return this.gid;
        }

        public Time getLastAccessTime() {
            return this.lastAccess;
        }

        public long getLastAccess() {
            return this.lastAccess.getSecs();
        }

        public Time getLastModifiedTime() {
            return this.lastModified;
        }

        public long getLastModified() {
            return this.lastModified.getSecs();
        }

        public Time getLastStatusChangeTime() {
            return this.lastStatusChange;
        }

        public long getLastStatusChange() {
            return this.lastStatusChange.getSecs();
        }

        public long getSize() {
            return this.size;
        }

        public long getNumberOfBlocks() {
            return this.numberOfBlocks;
        }

        public int getBlockSize() {
            return this.blockSize;
        }
    }

    public static final class Time {
        private final long secs;
        private final long nanos;

        private Time(long secs, long nanos) {
            this.secs = secs;
            this.nanos = nanos;
        }

        public long getSecs() {
            return this.secs;
        }

        public long getNanoSecPart() {
            return this.nanos;
        }

        public long getMicroSecPart() {
            if (this.nanos % 1000L >= 500L) {
                return this.nanos / 1000L + 1L;
            }
            return this.nanos / 1000L;
        }

        public long getMilliSecPart() {
            if (this.nanos % 1000000L >= 500000L) {
                return this.nanos / 1000000L + 1L;
            }
            return this.nanos / 1000000L;
        }

        public long getMillis() {
            return this.secs * 1000L + this.getMilliSecPart();
        }

        public String toString() {
            return "Time [secs=" + this.secs + ", nanos=" + this.nanos + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (int)(this.nanos ^ this.nanos >>> 32);
            result = 31 * result + (int)(this.secs ^ this.secs >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Time other = (Time)obj;
            if (this.nanos != other.nanos) {
                return false;
            }
            return this.secs == other.secs;
        }
    }
}

