/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import hdf.hdf5lib.HDFNativeData;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.lang.reflect.Array;
import java.util.Iterator;

public class HDF5EnumerationValueArray
implements Iterable<String> {
    private final HDF5EnumerationType type;
    private final int length;
    private HDF5EnumerationType.EnumStorageForm storageForm;
    private byte[] bArrayOrNull;
    private short[] sArrayOrNull;
    private int[] iArrayOrNull;

    HDF5EnumerationValueArray(HDF5EnumerationType type, Object array) throws IllegalArgumentException {
        this.type = type;
        if (array instanceof byte[]) {
            byte[] bArray = (byte[])array;
            this.length = bArray.length;
            this.setOrdinalArray(bArray);
        } else if (array instanceof short[]) {
            short[] sArray = (short[])array;
            this.length = sArray.length;
            this.setOrdinalArray(sArray);
        } else if (array instanceof int[]) {
            int[] iArray = (int[])array;
            this.length = iArray.length;
            this.setOrdinalArray(iArray);
        } else {
            throw new IllegalArgumentException("array is of illegal type " + array.getClass().getCanonicalName());
        }
    }

    public HDF5EnumerationValueArray(HDF5EnumerationType type, byte[] ordinalArray) throws IllegalArgumentException {
        this.type = type;
        this.length = ordinalArray.length;
        this.setOrdinalArray(ordinalArray);
    }

    public HDF5EnumerationValueArray(HDF5EnumerationType type, short[] ordinalArray) throws IllegalArgumentException {
        this.type = type;
        this.length = ordinalArray.length;
        this.setOrdinalArray(ordinalArray);
    }

    public HDF5EnumerationValueArray(HDF5EnumerationType type, int[] ordinalArray) throws IllegalArgumentException {
        this.type = type;
        this.length = ordinalArray.length;
        this.setOrdinalArray(ordinalArray);
    }

    public HDF5EnumerationValueArray(HDF5EnumerationType type, Enum<?>[] valueArray) throws IllegalArgumentException {
        this(type, HDF5EnumerationValueArray.toString(valueArray));
    }

    private static String[] toString(Enum<?>[] valueArray) {
        String[] result = new String[valueArray.length];
        int i = 0;
        while (i < valueArray.length) {
            result[i] = valueArray[i].name();
            ++i;
        }
        return result;
    }

    public HDF5EnumerationValueArray(HDF5EnumerationType type, String[] valueArray) throws IllegalArgumentException {
        this.type = type;
        this.length = valueArray.length;
        this.map(valueArray);
    }

    private void map(String[] array) throws IllegalArgumentException {
        if (this.type.getEnumType().getValueArray().length < 127) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.BYTE;
            this.bArrayOrNull = new byte[array.length];
            int i = 0;
            while (i < array.length) {
                Integer indexOrNull = this.type.tryGetIndexForValue(array[i]);
                if (indexOrNull == null) {
                    throw new IllegalArgumentException("Value '" + array[i] + "' is not allowed for type '" + this.type.getName() + "'.");
                }
                this.bArrayOrNull[i] = indexOrNull.byteValue();
                ++i;
            }
            this.sArrayOrNull = null;
            this.iArrayOrNull = null;
        } else if (this.type.getEnumType().getValueArray().length < Short.MAX_VALUE) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.SHORT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = new short[array.length];
            int i = 0;
            while (i < array.length) {
                Integer indexOrNull = this.type.tryGetIndexForValue(array[i]);
                if (indexOrNull == null) {
                    throw new IllegalArgumentException("Value '" + array[i] + "' is not allowed for type '" + this.type.getName() + "'.");
                }
                this.sArrayOrNull[i] = indexOrNull.shortValue();
                ++i;
            }
            this.iArrayOrNull = null;
        } else {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.INT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = null;
            this.iArrayOrNull = new int[array.length];
            int i = 0;
            while (i < array.length) {
                Integer indexOrNull = this.type.tryGetIndexForValue(array[i]);
                if (indexOrNull == null) {
                    throw new IllegalArgumentException("Value '" + array[i] + "' is not allowed for type '" + this.type.getName() + "'.");
                }
                this.iArrayOrNull[i] = indexOrNull;
                ++i;
            }
        }
    }

    private void setOrdinalArray(byte[] array) {
        if (this.type.getEnumType().getValueArray().length < 127) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.BYTE;
            this.bArrayOrNull = array;
            this.checkOrdinalArray(this.bArrayOrNull);
            this.sArrayOrNull = null;
            this.iArrayOrNull = null;
        } else if (this.type.getEnumType().getValueArray().length < Short.MAX_VALUE) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.SHORT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = this.toShortArray(array);
            this.checkOrdinalArray(this.sArrayOrNull);
            this.iArrayOrNull = null;
        } else {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.INT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = null;
            this.iArrayOrNull = this.toIntArray(array);
            this.checkOrdinalArray(this.iArrayOrNull);
        }
    }

    private void setOrdinalArray(short[] array) throws IllegalArgumentException {
        if (this.type.getEnumType().getValueArray().length < 127) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.BYTE;
            this.bArrayOrNull = this.toByteArray(array);
            this.checkOrdinalArray(this.bArrayOrNull);
            this.sArrayOrNull = null;
            this.iArrayOrNull = null;
        } else if (this.type.getEnumType().getValueArray().length < Short.MAX_VALUE) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.SHORT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = array;
            this.checkOrdinalArray(this.sArrayOrNull);
            this.iArrayOrNull = null;
        } else {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.INT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = null;
            this.iArrayOrNull = this.toIntArray(array);
            this.checkOrdinalArray(this.iArrayOrNull);
        }
    }

    private void setOrdinalArray(int[] array) throws IllegalArgumentException {
        if (this.type.getEnumType().getValueArray().length < 127) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.BYTE;
            this.bArrayOrNull = this.toByteArray(array);
            this.checkOrdinalArray(this.bArrayOrNull);
            this.sArrayOrNull = null;
            this.iArrayOrNull = null;
        } else if (this.type.getEnumType().getValueArray().length < Short.MAX_VALUE) {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.SHORT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = this.toShortArray(array);
            this.checkOrdinalArray(this.sArrayOrNull);
            this.iArrayOrNull = null;
        } else {
            this.storageForm = HDF5EnumerationType.EnumStorageForm.INT;
            this.bArrayOrNull = null;
            this.sArrayOrNull = null;
            this.iArrayOrNull = array;
            this.checkOrdinalArray(this.iArrayOrNull);
        }
    }

    private byte[] toByteArray(short[] array) throws IllegalArgumentException {
        byte[] bArray = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            bArray[i] = (byte)array[i];
            if (bArray[i] != array[i]) {
                throw new IllegalArgumentException("Value " + array[i] + " cannot be stored in byte array");
            }
            ++i;
        }
        return bArray;
    }

    private byte[] toByteArray(int[] array) throws IllegalArgumentException {
        byte[] bArray = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            bArray[i] = (byte)array[i];
            if (bArray[i] != array[i]) {
                throw new IllegalArgumentException("Value " + array[i] + " cannot be stored in byte array");
            }
            ++i;
        }
        return bArray;
    }

    private short[] toShortArray(byte[] array) {
        short[] sArray = new short[array.length];
        int i = 0;
        while (i < array.length) {
            sArray[i] = array[i];
            ++i;
        }
        return sArray;
    }

    private short[] toShortArray(int[] array) throws IllegalArgumentException {
        short[] sArray = new short[array.length];
        int i = 0;
        while (i < array.length) {
            sArray[i] = (short)array[i];
            if (sArray[i] != array[i]) {
                throw new IllegalArgumentException("Value " + array[i] + " cannot be stored in short array");
            }
            ++i;
        }
        return sArray;
    }

    private int[] toIntArray(byte[] array) {
        int[] iArray = new int[array.length];
        int i = 0;
        while (i < array.length) {
            iArray[i] = array[i];
            ++i;
        }
        return iArray;
    }

    private int[] toIntArray(short[] array) {
        int[] iArray = new int[array.length];
        int i = 0;
        while (i < array.length) {
            iArray[i] = array[i];
            ++i;
        }
        return iArray;
    }

    private void checkOrdinalArray(byte[] array) throws IllegalArgumentException {
        int i = 0;
        while (i < array.length) {
            if (array[i] < 0 || array[i] >= this.type.getEnumType().getValueArray().length) {
                throw new IllegalArgumentException("valueIndex " + array[i] + " out of allowed range [0.." + (this.type.getEnumType().getValueArray().length - 1) + "] of type '" + this.type.getName() + "'.");
            }
            ++i;
        }
    }

    private void checkOrdinalArray(short[] array) throws IllegalArgumentException {
        int i = 0;
        while (i < array.length) {
            if (array[i] < 0 || array[i] >= this.type.getEnumType().getValueArray().length) {
                throw new IllegalArgumentException("valueIndex " + array[i] + " out of allowed range [0.." + (this.type.getEnumType().getValueArray().length - 1) + "] of type '" + this.type.getName() + "'.");
            }
            ++i;
        }
    }

    private void checkOrdinalArray(int[] array) throws IllegalArgumentException {
        int i = 0;
        while (i < array.length) {
            if (array[i] < 0 || array[i] >= this.type.getEnumType().getValueArray().length) {
                throw new IllegalArgumentException("valueIndex " + array[i] + " out of allowed range [0.." + (this.type.getEnumType().getValueArray().length - 1) + "] of type '" + this.type.getName() + "'.");
            }
            ++i;
        }
    }

    HDF5EnumerationType.EnumStorageForm getStorageForm() {
        return this.storageForm;
    }

    byte[] getStorageFormBArray() {
        return this.bArrayOrNull;
    }

    short[] getStorageFormSArray() {
        return this.sArrayOrNull;
    }

    int[] getStorageFormIArray() {
        return this.iArrayOrNull;
    }

    public HDF5EnumerationType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getOrdinal(int arrayIndex) {
        if (this.bArrayOrNull != null) {
            return this.bArrayOrNull[arrayIndex];
        }
        if (this.sArrayOrNull != null) {
            return this.sArrayOrNull[arrayIndex];
        }
        return this.iArrayOrNull[arrayIndex];
    }

    public String getValue(int arrayIndex) {
        return this.type.getValues().get(this.getOrdinal(arrayIndex));
    }

    public <T extends Enum<T>> T getValue(Class<T> enumClass, int arrayIndex) {
        return Enum.valueOf(enumClass, this.getValue(arrayIndex));
    }

    public String[] toStringArray() {
        int len = this.getLength();
        String[] values2 = new String[len];
        int i = 0;
        while (i < len) {
            values2[i] = this.getValue(i);
            ++i;
        }
        return values2;
    }

    public <T extends Enum<T>> T[] toEnumArray(Class<T> enumClass) {
        int len = this.getLength();
        Enum[] result = (Enum[])Array.newInstance(enumClass, len);
        int i = 0;
        while (i < len) {
            try {
                result[i] = Enum.valueOf(enumClass, this.getValue(i));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HDF5JavaException("The Java enum class " + enumClass.getCanonicalName() + " has no value '" + this.getValue(i) + "'.");
            }
            ++i;
        }
        return result;
    }

    byte[] toStorageForm() {
        switch (this.getStorageForm()) {
            case BYTE: {
                return this.getStorageFormBArray();
            }
            case SHORT: {
                return NativeData.shortToByte(this.getStorageFormSArray(), NativeData.ByteOrder.NATIVE);
            }
            case INT: {
                return NativeData.intToByte(this.getStorageFormIArray(), NativeData.ByteOrder.NATIVE);
            }
        }
        throw new Error("Illegal storage form (" + (Object)((Object)this.getStorageForm()) + ".)");
    }

    static HDF5EnumerationValueArray fromStorageForm(HDF5EnumerationType enumType, byte[] data, int offset, int len) {
        switch (enumType.getStorageForm()) {
            case BYTE: {
                byte[] subArray = new byte[len];
                System.arraycopy(data, offset, subArray, 0, len);
                return new HDF5EnumerationValueArray(enumType, subArray);
            }
            case SHORT: {
                return new HDF5EnumerationValueArray(enumType, HDFNativeData.byteToShort(offset, len, data));
            }
            case INT: {
                return new HDF5EnumerationValueArray(enumType, HDFNativeData.byteToInt(offset, len, data));
            }
        }
        throw new Error("Illegal storage form (" + (Object)((Object)enumType.getStorageForm()) + ".)");
    }

    static String[] fromStorageFormToStringArray(HDF5EnumerationType enumType, byte[] data, int offset, int len) {
        String[] valueArray = new String[len];
        int i = 0;
        while (i < len) {
            valueArray[i] = enumType.createStringFromStorageForm(data, offset + i);
            ++i;
        }
        return valueArray;
    }

    static int[] fromStorageFormToIntArray(HDF5EnumerationType enumType, byte[] data, int offset, int len) {
        int[] valueArray = new int[len];
        int i = 0;
        while (i < len) {
            valueArray[i] = enumType.getOrdinalFromStorageForm(data, offset + i);
            ++i;
        }
        return valueArray;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < HDF5EnumerationValueArray.this.length;
            }

            @Override
            public String next() {
                return HDF5EnumerationValueArray.this.getValue(this.index++);
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.type.getName());
        b.append(" [");
        for (String value : this) {
            b.append(value);
            b.append(",");
        }
        b.setLength(b.length() - 1);
        b.append("]");
        return b.toString();
    }
}

