/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;

final class HDF5Utils {
    static final String STRING_LENGTH_ATTRIBUTE_NAME = "STRING_LENGTH";
    static final String TYPE_VARIANT_ATTRIBUTE_NAME = "TYPE_VARIANT";
    static final int MIN_CHUNK_SIZE = 1;
    private static final long MIN_TOTAL_SIZE_FOR_CHUNKING = 128L;
    static final long[] SCALAR_DIMENSIONS = new long[]{1L};
    static final String OPAQUE_PREFIX = "Opaque_";
    static final String ENUM_PREFIX = "Enum_";
    static final String COMPOUND_PREFIX = "Compound_";
    static final String HOUSEKEEPING_NAME_SUFFIX_ATTRIBUTE_NAME = "__HOUSEKEEPING_SUFFIX__";
    static final String HOUSEKEEPING_NAME_SUFFIX_STRINGLENGTH_ATTRIBUTE_NAME = "__STRING_LENGTH____HOUSEKEEPING_SUFFIX____";
    static final String DATASET_IS_EMPTY_LEGACY_ATTRIBUTE = "__EMPTY__";
    static Class<?>[] allIntegerTypes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class};
    static Class<?>[] allFloatTypes = new Class[]{Float.TYPE, Float.class, Double.TYPE, Double.class};
    static Class<?>[] allTimeDurationTypes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, HDF5TimeDuration.class};

    HDF5Utils() {
    }

    static String getBooleanDataTypePath(String houseKeepingNameSuffix) {
        return String.valueOf(HDF5Utils.getDataTypeGroup(houseKeepingNameSuffix)) + "/" + ENUM_PREFIX + "Boolean";
    }

    static String getTypeVariantDataTypePath(String houseKeepingNameSuffix) {
        return String.valueOf(HDF5Utils.getDataTypeGroup(houseKeepingNameSuffix)) + "/" + ENUM_PREFIX + "TypeVariant";
    }

    static String getVariableLengthStringDataTypePath(String houseKeepingNameSuffix) {
        return String.valueOf(HDF5Utils.getDataTypeGroup(houseKeepingNameSuffix)) + "/String_VariableLength";
    }

    static String getTypeVariantMembersAttributeName(String houseKeepingNameSuffix) {
        return "".equals(houseKeepingNameSuffix) ? "__TYPE_VARIANT_MEMBERS__" : "TYPE_VARIANT_MEMBERS" + houseKeepingNameSuffix;
    }

    static String getEnumTypeNameAttributeName(String houseKeepingNameSuffix) {
        return "".equals(houseKeepingNameSuffix) ? "__ENUM_TYPE_NAME__" : "ENUM_TYPE_NAME" + houseKeepingNameSuffix;
    }

    static String getDataTypeGroup(String houseKeepingNameSuffix) {
        return "".equals(houseKeepingNameSuffix) ? "/__DATA_TYPES__" : "/DATA_TYPES" + houseKeepingNameSuffix;
    }

    static Class<?> unwrapClass(Class<?> clazz) {
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        return clazz;
    }

    static String getSuperGroup(String path) {
        assert (path != null);
        int lastIndexSlash = path.lastIndexOf(47);
        if (lastIndexSlash <= 0) {
            return "/";
        }
        return path.substring(0, lastIndexSlash);
    }

    static boolean isEmpty(long[] dimensions) {
        long[] lArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            if (d == 0L) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static boolean isNonPositive(long[] dimensions) {
        long[] lArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            if (d <= 0L) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static long[] tryGetChunkSizeForString(int len, boolean tryChunkedDS) {
        if (tryChunkedDS) {
            return (long)len < 128L ? null : SCALAR_DIMENSIONS;
        }
        return null;
    }

    static long[] tryGetChunkSize(long[] dimensions, int elementLength, boolean tryChunkedDS, boolean enforceChunkedDS) {
        assert (dimensions != null);
        if (!enforceChunkedDS && !tryChunkedDS) {
            return null;
        }
        long[] chunkSize = new long[dimensions.length];
        long totalSize = elementLength;
        int i = 0;
        while (i < dimensions.length) {
            totalSize *= dimensions[i];
            chunkSize[i] = Math.max(1L, dimensions[i]);
            ++i;
        }
        if (!enforceChunkedDS && totalSize < 128L) {
            return null;
        }
        return chunkSize;
    }

    static String createDataTypePath(String name, String houseKeepingSuffix, String ... appendices) {
        if (appendices.length == 1 && appendices[0].startsWith("/")) {
            return appendices[0];
        }
        StringBuilder builder = new StringBuilder();
        builder.append(HDF5Utils.getDataTypeGroup(houseKeepingSuffix));
        builder.append('/');
        builder.append(name);
        String[] stringArray = appendices;
        int n = appendices.length;
        int n2 = 0;
        while (n2 < n) {
            String app = stringArray[n2];
            builder.append(app);
            ++n2;
        }
        return builder.toString();
    }

    static String getDataTypeNameFromPath(String pathOrNull, String houseKeepingNameSuffix, HDF5DataClass dataClass) {
        return pathOrNull == null ? "UNKNOWN" : HDF5Utils.tryGetDataTypeNameFromPath(pathOrNull, houseKeepingNameSuffix, dataClass);
    }

    static String tryGetDataTypeNameFromPath(String pathOrNull, String houseKeepingNameSuffix, HDF5DataClass dataClass) {
        if (pathOrNull == null) {
            return null;
        }
        String prefix = HDF5Utils.getPrefixForDataClass(dataClass);
        String pathPrefix = HDF5Utils.createDataTypePath(prefix, houseKeepingNameSuffix, new String[0]);
        if (pathOrNull.startsWith(pathPrefix)) {
            return pathOrNull.substring(pathPrefix.length());
        }
        int lastPathSepIdx = pathOrNull.lastIndexOf(47);
        if (lastPathSepIdx >= 0) {
            return pathOrNull.substring(lastPathSepIdx + 1);
        }
        return pathOrNull;
    }

    static String getPrefixForDataClass(HDF5DataClass dataClass) {
        switch (dataClass) {
            case COMPOUND: {
                return COMPOUND_PREFIX;
            }
            case ENUM: {
                return ENUM_PREFIX;
            }
            case OPAQUE: {
                return OPAQUE_PREFIX;
            }
        }
        return "";
    }

    static int getOneDimensionalArraySize(int[] dimensions) {
        assert (dimensions != null);
        if (dimensions.length == 0) {
            return 1;
        }
        if (dimensions.length != 1) {
            throw new HDF5JavaException("Data Set is expected to be of rank 1 (rank=" + dimensions.length + ")");
        }
        return dimensions[0];
    }

    static int getOneDimensionalArraySize(long[] dimensions) {
        assert (dimensions != null);
        if (dimensions.length == 0) {
            return 1;
        }
        if (dimensions.length != 1) {
            throw new HDF5JavaException("Data Set is expected to be of rank 1 (rank=" + dimensions.length + ")");
        }
        int length = (int)dimensions[0];
        if ((long)length != dimensions[0]) {
            throw new HDF5JavaException("Length is too large (" + dimensions[0] + ")");
        }
        return length;
    }

    static String createObjectTypeVariantAttributeName(String houseKeepingNameSuffix) {
        return "".equals(houseKeepingNameSuffix) ? "__TYPE_VARIANT__" : TYPE_VARIANT_ATTRIBUTE_NAME + houseKeepingNameSuffix;
    }

    static String createAttributeTypeVariantAttributeName(String attributeName, String suffix) {
        boolean noSuffix = "".equals(suffix);
        return String.valueOf(noSuffix ? "__" : "") + TYPE_VARIANT_ATTRIBUTE_NAME + "__" + attributeName + (noSuffix ? "__" : suffix);
    }

    private static boolean isInternalName(String name) {
        return name.startsWith("__") && name.endsWith("__");
    }

    static boolean isInternalName(String name, String houseKeepingNameSuffix) {
        return "".equals(houseKeepingNameSuffix) ? HDF5Utils.isInternalName(name) : name.endsWith(houseKeepingNameSuffix);
    }

    static boolean isInternalName(String name, String houseKeepingNameSuffix, boolean filterRootAttributes) {
        if (filterRootAttributes) {
            return HDF5Utils.isInternalName(name, houseKeepingNameSuffix) || HOUSEKEEPING_NAME_SUFFIX_ATTRIBUTE_NAME.equals(name) || HOUSEKEEPING_NAME_SUFFIX_STRINGLENGTH_ATTRIBUTE_NAME.equals(name);
        }
        return HDF5Utils.isInternalName(name, houseKeepingNameSuffix);
    }

    static String toHouseKeepingName(String name, String houseKeepingNameSuffix) {
        return "".equals(houseKeepingNameSuffix) ? "__" + name + "__" : String.valueOf(name) + houseKeepingNameSuffix;
    }

    static String toHouseKeepingPath(String objectPath, String houseKeepingNameSuffix) {
        int lastPathSeparator = objectPath.lastIndexOf(47) + 1;
        return lastPathSeparator > 0 ? String.valueOf(objectPath.substring(0, lastPathSeparator)) + HDF5Utils.toHouseKeepingName(objectPath.substring(lastPathSeparator), houseKeepingNameSuffix) : HDF5Utils.toHouseKeepingName(objectPath, houseKeepingNameSuffix);
    }

    static List<String> removeInternalNames(List<String> names, String houseKeepingNameSuffix, boolean filterRootAttributes) {
        Iterator<String> iterator2 = names.iterator();
        while (iterator2.hasNext()) {
            String memberName = iterator2.next();
            if (!HDF5Utils.isInternalName(memberName, houseKeepingNameSuffix, filterRootAttributes)) continue;
            iterator2.remove();
        }
        return names;
    }

    static <T> T[] createArray(Class<T> componentClass, int vectorLength) {
        Object[] value = (Object[])Array.newInstance(componentClass, vectorLength);
        return value;
    }

    static boolean mightBeEmptyInStorage(long[] dimensions) {
        long[] lArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            if (d != 1L) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static boolean areMatrixDimensionsConsistent(Object a) {
        if (!a.getClass().isArray()) {
            return false;
        }
        int length = Array.getLength(a);
        if (length == 0) {
            return true;
        }
        Object element = Array.get(a, 0);
        if (element.getClass().isArray()) {
            int elementLength = Array.getLength(element);
            int i = 0;
            while (i < length) {
                Object o = Array.get(a, i);
                if (!HDF5Utils.areMatrixDimensionsConsistent(o)) {
                    return false;
                }
                if (elementLength != Array.getLength(o)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    static boolean isInBounds(long[] dimensions, long[] subDimensions) {
        assert (dimensions.length == subDimensions.length);
        int i = 0;
        while (i < dimensions.length) {
            if (subDimensions[i] > dimensions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

