/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xmp.impl;

import com.adobe.internal.xmp.XMPConst;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.impl.ParameterAsserts;
import com.adobe.internal.xmp.impl.Utils;
import com.adobe.internal.xmp.impl.XMPMetaImpl;
import com.adobe.internal.xmp.impl.XMPNode;
import com.adobe.internal.xmp.impl.XMPNodeUtils;
import com.adobe.internal.xmp.impl.xpath.XMPPath;
import com.adobe.internal.xmp.impl.xpath.XMPPathParser;
import com.adobe.internal.xmp.options.PropertyOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import com.adobe.internal.xmp.options.TemplateOptions;
import com.adobe.internal.xmp.properties.XMPAliasInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class XMPUtilsImpl
implements XMPConst {
    private static final int UCK_NORMAL = 0;
    private static final int UCK_SPACE = 1;
    private static final int UCK_COMMA = 2;
    private static final int UCK_SEMICOLON = 3;
    private static final int UCK_QUOTE = 4;
    private static final int UCK_CONTROL = 5;
    private static final String SPACES = " \u3000\u303f";
    private static final String COMMAS = ",\uff0c\uff64\ufe50\ufe51\u3001\u060c\u055d";
    private static final String SEMICOLA = ";\uff1b\ufe54\u061b\u037e";
    private static final String QUOTES = "\"\u00ab\u00bb\u301d\u301e\u301f\u2015\u2039\u203a";
    private static final String CONTROLS = "\u2028\u2029";

    private XMPUtilsImpl() {
    }

    public static String catenateArrayItems(XMPMeta xmp, String schemaNS, String arrayName, String separator, String quotes, boolean allowCommas) throws XMPException {
        ParameterAsserts.assertSchemaNS(schemaNS);
        ParameterAsserts.assertArrayName(arrayName);
        ParameterAsserts.assertImplementation(xmp);
        if (separator == null || separator.length() == 0) {
            separator = "; ";
        }
        if (quotes == null || quotes.length() == 0) {
            quotes = "\"";
        }
        XMPMetaImpl xmpImpl = (XMPMetaImpl)xmp;
        XMPNode arrayNode = null;
        XMPNode currItem = null;
        XMPPath arrayPath = XMPPathParser.expandXPath(schemaNS, arrayName);
        arrayNode = XMPNodeUtils.findNode(xmpImpl.getRoot(), arrayPath, false, null);
        if (arrayNode == null) {
            return "";
        }
        if (!arrayNode.getOptions().isArray() || arrayNode.getOptions().isArrayAlternate()) {
            throw new XMPException("Named property must be non-alternate array", 4);
        }
        XMPUtilsImpl.checkSeparator(separator);
        char openQuote = quotes.charAt(0);
        char closeQuote = XMPUtilsImpl.checkQuotes(quotes, openQuote);
        StringBuffer catinatedString = new StringBuffer();
        Iterator it = arrayNode.iterateChildren();
        while (it.hasNext()) {
            currItem = (XMPNode)it.next();
            if (currItem.getOptions().isCompositeProperty()) {
                throw new XMPException("Array items must be simple", 4);
            }
            String str = XMPUtilsImpl.applyQuotes(currItem.getValue(), openQuote, closeQuote, allowCommas);
            catinatedString.append(str);
            if (!it.hasNext()) continue;
            catinatedString.append(separator);
        }
        return catinatedString.toString();
    }

    public static void separateArrayItems(XMPMeta xmp, String schemaNS, String arrayName, String catedStr, PropertyOptions arrayOptions, boolean preserveCommas) throws XMPException {
        ParameterAsserts.assertSchemaNS(schemaNS);
        ParameterAsserts.assertArrayName(arrayName);
        if (catedStr == null) {
            throw new XMPException("Parameter must not be null", 4);
        }
        ParameterAsserts.assertImplementation(xmp);
        XMPMetaImpl xmpImpl = (XMPMetaImpl)xmp;
        XMPNode arrayNode = XMPUtilsImpl.separateFindCreateArray(schemaNS, arrayName, arrayOptions, xmpImpl);
        int arrayElementLimit = Integer.MAX_VALUE;
        if (arrayNode != null && arrayOptions != null && (arrayElementLimit = arrayOptions.getArrayElementsLimit()) == -1) {
            arrayElementLimit = Integer.MAX_VALUE;
        }
        StringBuilder itemValue = new StringBuilder("");
        int nextKind = 0;
        int charKind = 0;
        char ch = '\u0000';
        char nextChar = '\u0000';
        int itemEnd = 0;
        int endPos = catedStr.length();
        while (itemEnd < endPos && arrayNode.getChildrenLength() < arrayElementLimit) {
            int itemStart;
            for (itemStart = itemEnd; itemStart < endPos && (charKind = XMPUtilsImpl.classifyCharacter(ch = catedStr.charAt(itemStart))) != 0 && charKind != 4; ++itemStart) {
            }
            if (itemStart >= endPos) break;
            if (charKind != 4) {
                for (itemEnd = itemStart; itemEnd < endPos && ((charKind = XMPUtilsImpl.classifyCharacter(ch = catedStr.charAt(itemEnd))) == 0 || charKind == 4 || charKind == 2 && preserveCommas || charKind == 1 && itemEnd + 1 < endPos && ((nextKind = XMPUtilsImpl.classifyCharacter(ch = catedStr.charAt(itemEnd + 1))) == 0 || nextKind == 4 || nextKind == 2 && preserveCommas)); ++itemEnd) {
                }
                itemValue = new StringBuilder(catedStr.substring(itemStart, itemEnd));
            } else {
                char openQuote = ch;
                char closeQuote = XMPUtilsImpl.getClosingQuote(openQuote);
                itemValue = new StringBuilder("");
                for (itemEnd = ++itemStart; itemEnd < endPos; ++itemEnd) {
                    ch = catedStr.charAt(itemEnd);
                    charKind = XMPUtilsImpl.classifyCharacter(ch);
                    if (charKind != 4 || !XMPUtilsImpl.isSurroundingQuote(ch, openQuote, closeQuote)) {
                        itemValue.append(ch);
                        continue;
                    }
                    if (itemEnd + 1 < endPos) {
                        nextChar = catedStr.charAt(itemEnd + 1);
                        nextKind = XMPUtilsImpl.classifyCharacter(nextChar);
                    } else {
                        nextKind = 3;
                        nextChar = ';';
                    }
                    if (ch == nextChar) {
                        itemValue.append(ch);
                        ++itemEnd;
                        continue;
                    }
                    if (!XMPUtilsImpl.isClosingingQuote(ch, openQuote, closeQuote)) {
                        itemValue.append(ch);
                        continue;
                    }
                    ++itemEnd;
                    break;
                }
            }
            int foundIndex = -1;
            for (int oldChild = 1; oldChild <= arrayNode.getChildrenLength(); ++oldChild) {
                if (!itemValue.toString().equals(arrayNode.getChild(oldChild).getValue())) continue;
                foundIndex = oldChild;
                break;
            }
            XMPNode newItem = null;
            if (foundIndex >= 0) continue;
            newItem = new XMPNode("[]", itemValue.toString(), null);
            arrayNode.addChild(newItem);
        }
    }

    private static XMPNode separateFindCreateArray(String schemaNS, String arrayName, PropertyOptions arrayOptions, XMPMetaImpl xmp) throws XMPException {
        if (!(arrayOptions = XMPNodeUtils.verifySetOptions(arrayOptions, null)).isOnlyArrayOptions()) {
            throw new XMPException("Options can only provide array form", 103);
        }
        XMPPath arrayPath = XMPPathParser.expandXPath(schemaNS, arrayName);
        XMPNode arrayNode = XMPNodeUtils.findNode(xmp.getRoot(), arrayPath, false, null);
        if (arrayNode != null) {
            PropertyOptions arrayForm = arrayNode.getOptions();
            if (!arrayForm.isArray() || arrayForm.isArrayAlternate()) {
                throw new XMPException("Named property must be non-alternate array", 102);
            }
            if (arrayOptions.equalArrayTypes(arrayForm)) {
                throw new XMPException("Mismatch of specified and existing array form", 102);
            }
        } else {
            arrayNode = XMPNodeUtils.findNode(xmp.getRoot(), arrayPath, true, arrayOptions.setArray(true));
            if (arrayNode == null) {
                throw new XMPException("Failed to create named array", 102);
            }
        }
        return arrayNode;
    }

    public static void removeProperties(XMPMeta xmp, String schemaNS, String propName, boolean doAllProperties, boolean includeAliases) throws XMPException {
        block5: {
            XMPMetaImpl xmpImpl;
            block6: {
                block4: {
                    ParameterAsserts.assertImplementation(xmp);
                    xmpImpl = (XMPMetaImpl)xmp;
                    if (propName == null || propName.length() <= 0) break block4;
                    if (schemaNS == null || schemaNS.length() == 0) {
                        throw new XMPException("Property name requires schema namespace", 4);
                    }
                    XMPPath expPath = XMPPathParser.expandXPath(schemaNS, propName);
                    XMPNode propNode = XMPNodeUtils.findNode(xmpImpl.getRoot(), expPath, false, null);
                    if (propNode == null || !doAllProperties && Utils.isInternalProperty(expPath.getSegment(0).getName(), expPath.getSegment(1).getName())) break block5;
                    XMPNode parent = propNode.getParent();
                    parent.removeChild(propNode);
                    if (!parent.getOptions().isSchemaNode() || parent.hasChildren()) break block5;
                    parent.getParent().removeChild(parent);
                    break block5;
                }
                if (schemaNS == null || schemaNS.length() <= 0) break block6;
                XMPNode schemaNode = XMPNodeUtils.findSchemaNode(xmpImpl.getRoot(), schemaNS, false);
                if (schemaNode != null && XMPUtilsImpl.removeSchemaChildren(schemaNode, doAllProperties)) {
                    xmpImpl.getRoot().removeChild(schemaNode);
                }
                if (!includeAliases) break block5;
                XMPAliasInfo[] aliases = XMPMetaFactory.getSchemaRegistry().findAliases(schemaNS);
                for (int i = 0; i < aliases.length; ++i) {
                    XMPAliasInfo info = aliases[i];
                    XMPPath path = XMPPathParser.expandXPath(info.getNamespace(), info.getPropName());
                    XMPNode actualProp = XMPNodeUtils.findNode(xmpImpl.getRoot(), path, false, null);
                    if (actualProp == null) continue;
                    XMPNode parent = actualProp.getParent();
                    parent.removeChild(actualProp);
                }
                break block5;
            }
            Iterator it = xmpImpl.getRoot().iterateChildren();
            while (it.hasNext()) {
                XMPNode schema = (XMPNode)it.next();
                if (!XMPUtilsImpl.removeSchemaChildren(schema, doAllProperties)) continue;
                it.remove();
            }
        }
    }

    public static void appendProperties(XMPMeta source2, XMPMeta destination, boolean doAllProperties, boolean replaceOldValues, boolean deleteEmptyValues) throws XMPException {
        ParameterAsserts.assertImplementation(source2);
        ParameterAsserts.assertImplementation(destination);
        XMPMetaImpl src = (XMPMetaImpl)source2;
        XMPMetaImpl dest = (XMPMetaImpl)destination;
        Iterator it = src.getRoot().iterateChildren();
        while (it.hasNext()) {
            XMPNode sourceSchema = (XMPNode)it.next();
            XMPNode destSchema = XMPNodeUtils.findSchemaNode(dest.getRoot(), sourceSchema.getName(), false);
            boolean createdSchema = false;
            if (destSchema == null) {
                destSchema = new XMPNode(sourceSchema.getName(), sourceSchema.getValue(), new PropertyOptions().setSchemaNode(true));
                dest.getRoot().addChild(destSchema);
                createdSchema = true;
            }
            Iterator ic = sourceSchema.iterateChildren();
            while (ic.hasNext()) {
                XMPNode sourceProp = (XMPNode)ic.next();
                if (!doAllProperties && Utils.isInternalProperty(sourceSchema.getName(), sourceProp.getName())) continue;
                XMPUtilsImpl.appendSubtree(dest, sourceProp, destSchema, false, replaceOldValues, deleteEmptyValues);
            }
            if (destSchema.hasChildren() || !createdSchema && !deleteEmptyValues) continue;
            dest.getRoot().removeChild(destSchema);
        }
    }

    private static boolean removeSchemaChildren(XMPNode schemaNode, boolean doAllProperties) {
        Iterator it = schemaNode.iterateChildren();
        while (it.hasNext()) {
            XMPNode currProp = (XMPNode)it.next();
            if (!doAllProperties && Utils.isInternalProperty(schemaNode.getName(), currProp.getName())) continue;
            it.remove();
        }
        return !schemaNode.hasChildren();
    }

    private static void appendSubtree(XMPMetaImpl destXMP, XMPNode sourceNode, XMPNode destParent, boolean mergeCompound, boolean replaceOldValues, boolean deleteEmptyValues) throws XMPException {
        block16: {
            PropertyOptions sourceForm;
            XMPNode destNode;
            block17: {
                block15: {
                    destNode = XMPNodeUtils.findChildNode(destParent, sourceNode.getName(), false);
                    boolean valueIsEmpty = false;
                    boolean bl = sourceNode.getOptions().isSimple() ? sourceNode.getValue() == null || sourceNode.getValue().length() == 0 : (valueIsEmpty = !sourceNode.hasChildren());
                    if (valueIsEmpty) {
                        if (deleteEmptyValues && destNode != null) {
                            destParent.removeChild(destNode);
                        }
                        return;
                    }
                    if (destNode == null) {
                        XMPNode tempNode = (XMPNode)sourceNode.clone(true);
                        if (tempNode != null) {
                            destParent.addChild(tempNode);
                        }
                        return;
                    }
                    sourceForm = sourceNode.getOptions();
                    boolean replaceThis = replaceOldValues;
                    if (mergeCompound && !sourceForm.isSimple()) {
                        replaceThis = false;
                    }
                    if (replaceThis) {
                        destParent.removeChild(destNode);
                        XMPNode tempNode = (XMPNode)sourceNode.clone(true);
                        if (tempNode != null) {
                            destParent.addChild(tempNode);
                        }
                        return;
                    }
                    PropertyOptions destForm = destNode.getOptions();
                    if (sourceForm.getOptions() != destForm.getOptions() || sourceForm.isSimple()) {
                        return;
                    }
                    if (!sourceForm.isStruct()) break block15;
                    Iterator it = sourceNode.iterateChildren();
                    while (it.hasNext()) {
                        XMPNode sourceField = (XMPNode)it.next();
                        XMPUtilsImpl.appendSubtree(destXMP, sourceField, destNode, mergeCompound, replaceOldValues, deleteEmptyValues);
                        if (!deleteEmptyValues || destNode.hasChildren()) continue;
                        destParent.removeChild(destNode);
                    }
                    break block16;
                }
                if (!sourceForm.isArrayAltText()) break block17;
                Iterator it = sourceNode.iterateChildren();
                while (it.hasNext()) {
                    XMPNode sourceItem = (XMPNode)it.next();
                    if (!sourceItem.hasQualifier() || !"xml:lang".equals(sourceItem.getQualifier(1).getName())) continue;
                    int destIndex = XMPNodeUtils.lookupLanguageItem(destNode, sourceItem.getQualifier(1).getValue());
                    if (sourceItem.getValue() == null || sourceItem.getValue().length() == 0) {
                        if (!deleteEmptyValues || destIndex == -1) continue;
                        destNode.removeChild(destIndex);
                        if (destNode.hasChildren()) continue;
                        destParent.removeChild(destNode);
                        continue;
                    }
                    if (destIndex == -1) {
                        if (!"x-default".equals(sourceItem.getQualifier(1).getValue()) || !destNode.hasChildren()) {
                            XMPNode tempNode = (XMPNode)sourceItem.clone(true);
                            if (tempNode == null) continue;
                            destNode.addChild(tempNode);
                            continue;
                        }
                        XMPNode destItem = new XMPNode(sourceItem.getName(), sourceItem.getValue(), sourceItem.getOptions());
                        sourceItem.cloneSubtree(destItem, true);
                        destNode.addChild(1, destItem);
                        continue;
                    }
                    if (!replaceOldValues) continue;
                    destNode.getChild(destIndex).setValue(sourceItem.getValue());
                }
                break block16;
            }
            if (!sourceForm.isArray()) break block16;
            Iterator is = sourceNode.iterateChildren();
            while (is.hasNext()) {
                XMPNode tempNode;
                XMPNode sourceItem = (XMPNode)is.next();
                boolean match = false;
                Iterator id = destNode.iterateChildren();
                while (id.hasNext()) {
                    XMPNode destItem = (XMPNode)id.next();
                    if (!XMPUtilsImpl.itemValuesMatch(sourceItem, destItem)) continue;
                    match = true;
                    break;
                }
                if (match || (tempNode = (XMPNode)sourceItem.clone(true)) == null) continue;
                destNode.addChild(tempNode);
            }
        }
    }

    private static boolean itemValuesMatch(XMPNode leftNode, XMPNode rightNode) throws XMPException {
        PropertyOptions rightForm;
        PropertyOptions leftForm = leftNode.getOptions();
        if (!leftForm.equals(rightForm = rightNode.getOptions())) {
            return false;
        }
        if (leftForm.isSimple()) {
            if (!leftNode.getValue().equals(rightNode.getValue())) {
                return false;
            }
            if (leftNode.getOptions().getHasLanguage() != rightNode.getOptions().getHasLanguage()) {
                return false;
            }
            if (leftNode.getOptions().getHasLanguage() && !leftNode.getQualifier(1).getValue().equals(rightNode.getQualifier(1).getValue())) {
                return false;
            }
        } else if (leftForm.isStruct()) {
            if (leftNode.getChildrenLength() != rightNode.getChildrenLength()) {
                return false;
            }
            Iterator it = leftNode.iterateChildren();
            while (it.hasNext()) {
                XMPNode leftField = (XMPNode)it.next();
                XMPNode rightField = XMPNodeUtils.findChildNode(rightNode, leftField.getName(), false);
                if (rightField != null && XMPUtilsImpl.itemValuesMatch(leftField, rightField)) continue;
                return false;
            }
        } else {
            assert (leftForm.isArray());
            Iterator il = leftNode.iterateChildren();
            while (il.hasNext()) {
                XMPNode leftItem = (XMPNode)il.next();
                boolean match = false;
                Iterator ir = rightNode.iterateChildren();
                while (ir.hasNext()) {
                    XMPNode rightItem = (XMPNode)ir.next();
                    if (!XMPUtilsImpl.itemValuesMatch(leftItem, rightItem)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public static void duplicateSubtree(XMPMeta source2, XMPMeta dest, String sourceNS, String sourceRoot, String destNS, String destRoot, PropertyOptions options) throws XMPException {
        boolean fullSourceTree = false;
        boolean fullDestTree = false;
        XMPNode sourceNode = null;
        XMPNode destNode = null;
        ParameterAsserts.assertNotNull(source2);
        ParameterAsserts.assertSchemaNS(sourceNS);
        ParameterAsserts.assertSchemaNS(sourceRoot);
        ParameterAsserts.assertNotNull(dest);
        ParameterAsserts.assertNotNull(destNS);
        ParameterAsserts.assertNotNull(destRoot);
        if (destNS.length() == 0) {
            destNS = sourceNS;
        }
        if (destRoot.length() == 0) {
            destRoot = sourceRoot;
        }
        if (sourceNS.equals("*")) {
            fullSourceTree = true;
        }
        if (destNS.equals("*")) {
            fullDestTree = true;
        }
        if (source2 == dest && fullSourceTree | fullDestTree) {
            throw new XMPException("Can't duplicate tree onto itself", 4);
        }
        if (fullSourceTree & fullDestTree) {
            throw new XMPException("Use Clone for full tree to full tree", 4);
        }
        if (fullSourceTree) {
            XMPPath destPath = XMPPathParser.expandXPath(destNS, destRoot);
            XMPMetaImpl destImpl = (XMPMetaImpl)dest;
            destNode = XMPNodeUtils.findNode(destImpl.getRoot(), destPath, false, null);
            if (destNode == null || !destNode.getOptions().isStruct()) {
                throw new XMPException("Destination must be an existing struct", 102);
            }
            if (destNode.hasChildren()) {
                if (options != null && (options.getOptions() & 0x20000000) != 0) {
                    destNode.removeChildren();
                } else {
                    throw new XMPException("Destination must be an empty struct", 102);
                }
            }
            XMPMetaImpl sourceImpl = (XMPMetaImpl)source2;
            int schemaLim = sourceImpl.getRoot().getChildrenLength();
            for (int schemaNum = 1; schemaNum <= schemaLim; ++schemaNum) {
                XMPNode currSchema = sourceImpl.getRoot().getChild(schemaNum);
                int propLim = currSchema.getChildrenLength();
                for (int propNum = 1; propNum <= propLim; ++propNum) {
                    sourceNode = currSchema.getChild(propNum);
                    destNode.addChild((XMPNode)sourceNode.clone(false));
                }
            }
        } else if (fullDestTree) {
            XMPMetaImpl srcImpl = (XMPMetaImpl)source2;
            XMPMetaImpl dstImpl = (XMPMetaImpl)dest;
            XMPPath sourcePath = XMPPathParser.expandXPath(sourceNS, sourceRoot);
            sourceNode = XMPNodeUtils.findNode(srcImpl.getRoot(), sourcePath, false, null);
            if (sourceNode == null || !sourceNode.getOptions().isStruct()) {
                throw new XMPException("Source must be an existing struct", 102);
            }
            destNode = dstImpl.getRoot();
            if (destNode.hasChildren()) {
                if (options != null && (options.getOptions() & 0x20000000) != 0) {
                    destNode.removeChildren();
                } else {
                    throw new XMPException("Source must be an existing struct", 102);
                }
            }
            int fieldLim = sourceNode.getChildrenLength();
            for (int fieldNum = 1; fieldNum <= fieldLim; ++fieldNum) {
                XMPNode currField = sourceNode.getChild(fieldNum);
                int colonPos = currField.getName().indexOf(58);
                if (colonPos == -1) continue;
                String nsPrefix = new String(currField.getName().substring(0, colonPos + 1));
                XMPSchemaRegistry nsRegister = XMPMetaFactory.getSchemaRegistry();
                String nsURI = nsRegister.getNamespaceURI(nsPrefix);
                if (nsURI == null) {
                    throw new XMPException("Source field namespace is not global", 101);
                }
                XMPNode destSchema = XMPNodeUtils.findSchemaNode(dstImpl.getRoot(), nsURI, true);
                if (destSchema == null) {
                    throw new XMPException("Failed to find destination schema", 101);
                }
                destSchema.addChild((XMPNode)currField.clone(false));
            }
        } else {
            XMPPath sourcePath = XMPPathParser.expandXPath(sourceNS, sourceRoot);
            XMPPath destPath = XMPPathParser.expandXPath(destNS, destRoot);
            XMPMetaImpl sourceImpl = (XMPMetaImpl)source2;
            XMPMetaImpl destImpl = (XMPMetaImpl)dest;
            sourceNode = XMPNodeUtils.findNode(sourceImpl.getRoot(), sourcePath, false, null);
            if (sourceNode == null) {
                throw new XMPException("Can't find source subtree", 102);
            }
            destNode = XMPNodeUtils.findNode(destImpl.getRoot(), destPath, false, null);
            if (destNode != null) {
                throw new XMPException("Destination subtree must not exist", 102);
            }
            destNode = XMPNodeUtils.findNode(destImpl.getRoot(), destPath, true, null);
            if (destNode == null) {
                throw new XMPException("Can't create destination root node", 102);
            }
            if (source2 == dest) {
                for (XMPNode testNode = destNode; testNode != null; testNode = testNode.getParent()) {
                    if (testNode != sourceNode) continue;
                    throw new XMPException("Destination subtree is within the source subtree", 102);
                }
            }
            destNode.setValue(sourceNode.getValue());
            destNode.setOptions(sourceNode.getOptions());
            sourceNode.cloneSubtree(destNode, false);
        }
    }

    private static void checkSeparator(String separator) throws XMPException {
        boolean haveSemicolon = false;
        for (int i = 0; i < separator.length(); ++i) {
            int charKind = XMPUtilsImpl.classifyCharacter(separator.charAt(i));
            if (charKind == 3) {
                if (haveSemicolon) {
                    throw new XMPException("Separator can have only one semicolon", 4);
                }
                haveSemicolon = true;
                continue;
            }
            if (charKind == 1) continue;
            throw new XMPException("Separator can have only spaces and one semicolon", 4);
        }
        if (!haveSemicolon) {
            throw new XMPException("Separator must have one semicolon", 4);
        }
    }

    private static char checkQuotes(String quotes, char openQuote) throws XMPException {
        char closeQuote;
        int charKind = XMPUtilsImpl.classifyCharacter(openQuote);
        if (charKind != 4) {
            throw new XMPException("Invalid quoting character", 4);
        }
        if (quotes.length() == 1) {
            closeQuote = openQuote;
        } else {
            closeQuote = quotes.charAt(1);
            charKind = XMPUtilsImpl.classifyCharacter(closeQuote);
            if (charKind != 4) {
                throw new XMPException("Invalid quoting character", 4);
            }
        }
        if (closeQuote != XMPUtilsImpl.getClosingQuote(openQuote)) {
            throw new XMPException("Mismatched quote pair", 4);
        }
        return closeQuote;
    }

    private static int classifyCharacter(char ch) {
        if (SPACES.indexOf(ch) >= 0 || '\u2000' <= ch && ch <= '\u200b') {
            return 1;
        }
        if (COMMAS.indexOf(ch) >= 0) {
            return 2;
        }
        if (SEMICOLA.indexOf(ch) >= 0) {
            return 3;
        }
        if (QUOTES.indexOf(ch) >= 0 || '\u3008' <= ch && ch <= '\u300f' || '\u2018' <= ch && ch <= '\u201f') {
            return 4;
        }
        if (ch < ' ' || CONTROLS.indexOf(ch) >= 0) {
            return 5;
        }
        return 0;
    }

    private static char getClosingQuote(char openQuote) {
        switch (openQuote) {
            case '\"': {
                return '\"';
            }
            case '\u00ab': {
                return '\u00bb';
            }
            case '\u00bb': {
                return '\u00ab';
            }
            case '\u2015': {
                return '\u2015';
            }
            case '\u2018': {
                return '\u2019';
            }
            case '\u201a': {
                return '\u201b';
            }
            case '\u201c': {
                return '\u201d';
            }
            case '\u201e': {
                return '\u201f';
            }
            case '\u2039': {
                return '\u203a';
            }
            case '\u203a': {
                return '\u2039';
            }
            case '\u3008': {
                return '\u3009';
            }
            case '\u300a': {
                return '\u300b';
            }
            case '\u300c': {
                return '\u300d';
            }
            case '\u300e': {
                return '\u300f';
            }
            case '\u301d': {
                return '\u301f';
            }
        }
        return '\u0000';
    }

    private static String applyQuotes(String item, char openQuote, char closeQuote, boolean allowCommas) {
        int i;
        if (item == null) {
            item = "";
        }
        boolean prevSpace = false;
        for (i = 0; i < item.length(); ++i) {
            char ch = item.charAt(i);
            int charKind = XMPUtilsImpl.classifyCharacter(ch);
            if (i == 0 && charKind == 4) break;
            if (charKind == 1) {
                if (prevSpace) break;
                prevSpace = true;
                continue;
            }
            prevSpace = false;
            if (charKind == 3 || charKind == 5 || charKind == 2 && !allowCommas) break;
        }
        if (i < item.length()) {
            int splitPoint;
            StringBuffer newItem = new StringBuffer(item.length() + 2);
            for (splitPoint = 0; splitPoint <= i && XMPUtilsImpl.classifyCharacter(item.charAt(i)) != 4; ++splitPoint) {
            }
            newItem.append(openQuote).append(item.substring(0, splitPoint));
            for (int charOffset = splitPoint; charOffset < item.length(); ++charOffset) {
                newItem.append(item.charAt(charOffset));
                if (XMPUtilsImpl.classifyCharacter(item.charAt(charOffset)) != 4 || !XMPUtilsImpl.isSurroundingQuote(item.charAt(charOffset), openQuote, closeQuote)) continue;
                newItem.append(item.charAt(charOffset));
            }
            newItem.append(closeQuote);
            item = newItem.toString();
        }
        return item;
    }

    private static boolean isSurroundingQuote(char ch, char openQuote, char closeQuote) {
        return ch == openQuote || XMPUtilsImpl.isClosingingQuote(ch, openQuote, closeQuote);
    }

    private static boolean isClosingingQuote(char ch, char openQuote, char closeQuote) {
        return ch == closeQuote || openQuote == '\u301d' && ch == '\u301e' || ch == '\u301f';
    }

    static boolean moveOneProperty(XMPMetaImpl stdXMP, XMPMetaImpl extXMP, String schemaURI, String propName) throws XMPException {
        XMPNode propNode = null;
        XMPNode stdSchema = XMPNodeUtils.findSchemaNode(stdXMP.getRoot(), schemaURI, false);
        if (stdSchema != null) {
            propNode = XMPNodeUtils.findChildNode(stdSchema, propName, false);
        }
        if (propNode == null) {
            return false;
        }
        XMPNode extSchema = XMPNodeUtils.findSchemaNode(extXMP.getRoot(), schemaURI, true);
        propNode.setParent(extSchema);
        extSchema.setImplicit(false);
        extSchema.addChild(propNode);
        stdSchema.removeChild(propNode);
        if (!stdSchema.hasChildren()) {
            XMPNode xmpTree = stdSchema.getParent();
            xmpTree.removeChild(stdSchema);
        }
        return true;
    }

    static int estimateSizeForJPEG(XMPNode xmpNode) {
        boolean includeName;
        int estSize = 0;
        int nameSize = xmpNode.getName().length();
        boolean bl = includeName = !xmpNode.getOptions().isArray();
        if (xmpNode.getOptions().isSimple()) {
            if (includeName) {
                estSize += nameSize + 3;
            }
            estSize += xmpNode.getValue().length();
        } else if (xmpNode.getOptions().isArray()) {
            if (includeName) {
                estSize += 2 * nameSize + 5;
            }
            int arraySize = xmpNode.getChildrenLength();
            estSize += 19;
            estSize += arraySize * 17;
            for (int i = 1; i <= arraySize; ++i) {
                estSize += XMPUtilsImpl.estimateSizeForJPEG(xmpNode.getChild(i));
            }
        } else {
            if (includeName) {
                estSize += 2 * nameSize + 5;
            }
            estSize += 25;
            int fieldCount = xmpNode.getChildrenLength();
            for (int i = 1; i <= fieldCount; ++i) {
                estSize += XMPUtilsImpl.estimateSizeForJPEG(xmpNode.getChild(i));
            }
        }
        return estSize;
    }

    private static void putObjectsInMultiMap(Map<Integer, List<List<String>>> multiMap, Integer key, List<String> stringPair) {
        if (multiMap == null) {
            return;
        }
        List<List<String>> tempList = multiMap.get(key);
        if (tempList == null) {
            tempList = new ArrayList<List<String>>();
            multiMap.put(key, tempList);
        }
        tempList.add(stringPair);
    }

    private static List<String> getBiggestEntryInMultiMap(Map<Integer, List<List<String>>> multiMap) {
        if (multiMap == null || multiMap.isEmpty()) {
            return null;
        }
        List<List<String>> myList = multiMap.get(((TreeMap)multiMap).lastKey());
        List<String> myList1 = myList.get(0);
        myList.remove(0);
        if (myList.isEmpty()) {
            multiMap.remove(((TreeMap)multiMap).lastKey());
        }
        return myList1;
    }

    static void createEstimatedSizeMap(XMPMetaImpl stdXMP, Map<Integer, List<List<String>>> propSizes) {
        for (int s2 = stdXMP.getRoot().getChildrenLength(); s2 > 0; --s2) {
            XMPNode stdSchema = stdXMP.getRoot().getChild(s2);
            for (int p = stdSchema.getChildrenLength(); p > 0; --p) {
                XMPNode stdProp = stdSchema.getChild(p);
                if (stdSchema.getName().equals("http://ns.adobe.com/xmp/note/") && stdProp.getName().equals("xmpNote:HasExtendedXMP")) continue;
                int propSize = XMPUtilsImpl.estimateSizeForJPEG(stdProp);
                ArrayList<String> namePair = new ArrayList<String>();
                namePair.add(stdSchema.getName());
                namePair.add(stdProp.getName());
                XMPUtilsImpl.putObjectsInMultiMap(propSizes, propSize, namePair);
            }
        }
    }

    static int moveLargestProperty(XMPMetaImpl stdXMP, XMPMetaImpl extXMP, Map<Integer, List<List<String>>> propSizes) throws XMPException {
        assert (!propSizes.isEmpty());
        int propSize = (Integer)((TreeMap)propSizes).lastKey();
        List<String> tempList = XMPUtilsImpl.getBiggestEntryInMultiMap(propSizes);
        String schemaURI = tempList.get(0);
        String propName = tempList.get(1);
        boolean moved = XMPUtilsImpl.moveOneProperty(stdXMP, extXMP, schemaURI, propName);
        assert (moved);
        return propSize;
    }

    public static void packageForJPEG(XMPMeta origXMPImpl, StringBuilder stdStr, StringBuilder extStr, StringBuilder digestStr) throws XMPException, NoSuchAlgorithmException {
        boolean moved;
        XMPMetaImpl origXMP = (XMPMetaImpl)origXMPImpl;
        assert (stdStr != null && extStr != null && digestStr != null);
        int kStdXMPLimit = 65000;
        String kPacketTrailer = "<?xpacket end=\"w\"?>";
        int kTrailerLen = "<?xpacket end=\"w\"?>".length();
        String tempStr = null;
        XMPMetaImpl stdXMP = new XMPMetaImpl();
        XMPMetaImpl extXMP = new XMPMetaImpl();
        SerializeOptions keepItSmall = new SerializeOptions(64);
        keepItSmall.setPadding(0);
        keepItSmall.setIndent("");
        keepItSmall.setBaseIndent(0);
        keepItSmall.setNewline(" ");
        tempStr = XMPMetaFactory.serializeToString(origXMP, keepItSmall);
        if (tempStr.length() > 65000) {
            stdXMP.getRoot().setOptions(origXMP.getRoot().getOptions());
            stdXMP.getRoot().setName(origXMP.getRoot().getName());
            stdXMP.getRoot().setValue(origXMP.getRoot().getValue());
            origXMP.getRoot().cloneSubtree(stdXMP.getRoot(), false);
            if (stdXMP.doesPropertyExist("http://ns.adobe.com/xap/1.0/", "Thumbnails")) {
                stdXMP.deleteProperty("http://ns.adobe.com/xap/1.0/", "Thumbnails");
                tempStr = XMPMetaFactory.serializeToString(stdXMP, keepItSmall);
            }
        }
        if (tempStr.length() > 65000) {
            stdXMP.setProperty("http://ns.adobe.com/xmp/note/", "HasExtendedXMP", "123456789-123456789-123456789-12", new PropertyOptions(0));
            XMPNode crSchema = XMPNodeUtils.findSchemaNode(stdXMP.getRoot(), "http://ns.adobe.com/camera-raw-settings/1.0/", false);
            if (crSchema != null) {
                crSchema.setParent(extXMP.getRoot());
                extXMP.getRoot().addChild(crSchema);
                stdXMP.getRoot().removeChild(crSchema);
                tempStr = XMPMetaFactory.serializeToString(stdXMP, keepItSmall);
            }
        }
        if (tempStr.length() > 65000 && (moved = XMPUtilsImpl.moveOneProperty(stdXMP, extXMP, "http://ns.adobe.com/photoshop/1.0/", "photoshop:History"))) {
            tempStr = XMPMetaFactory.serializeToString(stdXMP, keepItSmall);
        }
        if (tempStr.length() > 65000) {
            TreeMap<Integer, List<List<String>>> propSizes = new TreeMap<Integer, List<List<String>>>();
            XMPUtilsImpl.createEstimatedSizeMap(stdXMP, propSizes);
            while (tempStr.length() > 65000 && !propSizes.isEmpty()) {
                int propSize;
                for (int tempLen = tempStr.length(); tempLen > 65000 && !propSizes.isEmpty(); tempLen -= propSize) {
                    propSize = XMPUtilsImpl.moveLargestProperty(stdXMP, extXMP, propSizes);
                    assert (propSize > 0);
                    if (propSize <= tempLen) continue;
                    propSize = tempLen;
                }
                tempStr = XMPMetaFactory.serializeToString(stdXMP, keepItSmall);
            }
        }
        if (tempStr.length() > 65000) {
            throw new XMPException("Can't reduce XMP enough for JPEG file", 9);
        }
        if (extXMP.getRoot().getChildrenLength() == 0) {
            stdStr.append(tempStr);
        } else {
            tempStr = XMPMetaFactory.serializeToString(extXMP, new SerializeOptions(80));
            extStr.append(tempStr);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(tempStr.getBytes());
            byte[] byteData = md.digest();
            for (int i = 0; i < byteData.length; ++i) {
                digestStr.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            stdXMP.setProperty("http://ns.adobe.com/xmp/note/", "HasExtendedXMP", digestStr.toString(), new PropertyOptions(0));
            tempStr = XMPMetaFactory.serializeToString(stdXMP, keepItSmall);
            stdStr.append(tempStr);
        }
        assert (stdStr.length() > kTrailerLen && stdStr.length() <= 65000);
        int extraPadding = 65000 - stdStr.length();
        if (extraPadding > 2047) {
            extraPadding = 2047;
        }
        stdStr.delete(stdStr.toString().indexOf("<?xpacket end=\"w\"?>"), stdStr.length());
        for (int i = 0; i < extraPadding; ++i) {
            stdStr.append(' ');
        }
        stdStr.append("<?xpacket end=\"w\"?>").toString();
    }

    public static void mergeFromJPEG(XMPMeta fullXMP, XMPMeta extendedXMP) throws XMPException {
        TemplateOptions flags = new TemplateOptions(48);
        XMPUtilsImpl.applyTemplate((XMPMetaImpl)fullXMP, (XMPMetaImpl)extendedXMP, flags);
        fullXMP.deleteProperty("http://ns.adobe.com/xmp/note/", "HasExtendedXMP");
    }

    public static void applyTemplate(XMPMeta OrigXMP, XMPMeta tempXMP, TemplateOptions actions2) throws XMPException {
        XMPNode templateSchema;
        boolean doAll;
        XMPMetaImpl workingXMP = (XMPMetaImpl)OrigXMP;
        XMPMetaImpl templateXMP = (XMPMetaImpl)tempXMP;
        boolean doClear = (actions2.getOptions() & 2) != 0;
        boolean doAdd = (actions2.getOptions() & 0x40) != 0;
        boolean doReplace = (actions2.getOptions() & 0x10) != 0;
        boolean deleteEmpty = (actions2.getOptions() & 0x80) != 0;
        doReplace |= deleteEmpty;
        deleteEmpty &= !doClear;
        boolean bl = doAll = (actions2.getOptions() & 0x20) != 0;
        if (doClear) {
            for (int schemaOrdinal = workingXMP.getRoot().getChildrenLength(); schemaOrdinal > 0; --schemaOrdinal) {
                XMPNode workingProp;
                int propOrdinal;
                XMPNode workingSchema = workingXMP.getRoot().getChild(schemaOrdinal);
                templateSchema = XMPNodeUtils.findSchemaNode(templateXMP.getRoot(), workingSchema.getName(), false);
                if (templateSchema == null) {
                    if (doAll) {
                        workingSchema.removeChildren();
                    } else {
                        for (propOrdinal = workingSchema.getChildrenLength(); propOrdinal > 0; --propOrdinal) {
                            workingProp = workingSchema.getChild(propOrdinal);
                            if (Utils.isInternalProperty(workingSchema.getName(), workingProp.getName())) continue;
                            workingSchema.removeChild(propOrdinal);
                        }
                    }
                } else {
                    for (propOrdinal = workingSchema.getChildrenLength(); propOrdinal > 0; --propOrdinal) {
                        workingProp = workingSchema.getChild(propOrdinal);
                        if (!doAll && Utils.isInternalProperty(workingSchema.getName(), workingProp.getName()) || XMPNodeUtils.findChildNode(templateSchema, workingProp.getName(), false) != null) continue;
                        workingSchema.removeChild(propOrdinal);
                    }
                }
                if (workingSchema.hasChildren()) continue;
                workingXMP.getRoot().removeChild(schemaOrdinal);
            }
        }
        if (doAdd | doReplace) {
            int schemaLim = templateXMP.getRoot().getChildrenLength();
            for (int schemaNum = 0; schemaNum < schemaLim; ++schemaNum) {
                templateSchema = templateXMP.getRoot().getChild(schemaNum + 1);
                XMPNode workingSchema = XMPNodeUtils.findSchemaNode(workingXMP.getRoot(), templateSchema.getName(), false);
                if (workingSchema == null) {
                    workingSchema = new XMPNode(templateSchema.getName(), templateSchema.getValue(), new PropertyOptions(Integer.MIN_VALUE));
                    workingXMP.getRoot().addChild(workingSchema);
                    workingSchema.setParent(workingXMP.getRoot());
                }
                int propLim = templateSchema.getChildrenLength();
                for (int propNum = 1; propNum <= propLim; ++propNum) {
                    XMPNode templateProp = templateSchema.getChild(propNum);
                    if (!doAll && Utils.isInternalProperty(templateSchema.getName(), templateProp.getName())) continue;
                    XMPUtilsImpl.appendSubtree(workingXMP, templateProp, workingSchema, doAdd, doReplace, deleteEmpty);
                }
                if (workingSchema.hasChildren()) continue;
                workingXMP.getRoot().removeChild(workingSchema);
            }
        }
    }
}

