/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.imaging.png.PngChromaticities;
import com.drew.imaging.png.PngChunk;
import com.drew.imaging.png.PngChunkReader;
import com.drew.imaging.png.PngChunkType;
import com.drew.imaging.png.PngHeader;
import com.drew.imaging.png.PngProcessingException;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.ByteConvert;
import com.drew.lang.Charsets;
import com.drew.lang.DateUtil;
import com.drew.lang.KeyValuePair;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.StreamUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.ErrorDirectory;
import com.drew.metadata.Metadata;
import com.drew.metadata.StringValue;
import com.drew.metadata.exif.ExifTiffHandler;
import com.drew.metadata.file.FileSystemMetadataReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.png.PngChromaticitiesDirectory;
import com.drew.metadata.png.PngDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class PngMetadataReader {
    private static Set<PngChunkType> _desiredChunkTypes;
    private static Charset _latin1Encoding;

    @NotNull
    public static Metadata readMetadata(@NotNull File file2) throws PngProcessingException, IOException {
        Metadata metadata;
        FileInputStream inputStream2 = new FileInputStream(file2);
        try {
            metadata = PngMetadataReader.readMetadata(inputStream2);
        }
        finally {
            ((InputStream)inputStream2).close();
        }
        new FileSystemMetadataReader().read(file2, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream2) throws PngProcessingException, IOException {
        Iterable<PngChunk> chunks = new PngChunkReader().extract(new StreamReader(inputStream2), _desiredChunkTypes);
        Metadata metadata = new Metadata();
        for (PngChunk chunk : chunks) {
            try {
                PngMetadataReader.processChunk(metadata, chunk);
            }
            catch (Exception e) {
                metadata.addDirectory(new ErrorDirectory("Exception reading PNG chunk: " + e.getMessage()));
            }
        }
        return metadata;
    }

    private static void processChunk(@NotNull Metadata metadata, @NotNull PngChunk chunk) throws PngProcessingException, IOException {
        PngChunkType chunkType = chunk.getType();
        byte[] bytes = chunk.getBytes();
        if (chunkType.equals(PngChunkType.IHDR)) {
            PngHeader header = new PngHeader(bytes);
            PngDirectory directory = new PngDirectory(PngChunkType.IHDR);
            directory.setInt(1, header.getImageWidth());
            directory.setInt(2, header.getImageHeight());
            directory.setInt(3, header.getBitsPerSample());
            directory.setInt(4, header.getColorType().getNumericValue());
            directory.setInt(5, header.getCompressionType() & 0xFF);
            directory.setInt(6, header.getFilterMethod());
            directory.setInt(7, header.getInterlaceMethod());
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.PLTE)) {
            PngDirectory directory = new PngDirectory(PngChunkType.PLTE);
            directory.setInt(8, bytes.length / 3);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.tRNS)) {
            PngDirectory directory = new PngDirectory(PngChunkType.tRNS);
            directory.setInt(9, 1);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.sRGB)) {
            byte srgbRenderingIntent = bytes[0];
            PngDirectory directory = new PngDirectory(PngChunkType.sRGB);
            directory.setInt(10, srgbRenderingIntent);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.cHRM)) {
            PngChromaticities chromaticities = new PngChromaticities(bytes);
            PngChromaticitiesDirectory directory = new PngChromaticitiesDirectory();
            directory.setInt(1, chromaticities.getWhitePointX());
            directory.setInt(2, chromaticities.getWhitePointY());
            directory.setInt(3, chromaticities.getRedX());
            directory.setInt(4, chromaticities.getRedY());
            directory.setInt(5, chromaticities.getGreenX());
            directory.setInt(6, chromaticities.getGreenY());
            directory.setInt(7, chromaticities.getBlueX());
            directory.setInt(8, chromaticities.getBlueY());
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.gAMA)) {
            int gammaInt = ByteConvert.toInt32BigEndian(bytes);
            new SequentialByteArrayReader(bytes).getInt32();
            PngDirectory directory = new PngDirectory(PngChunkType.gAMA);
            directory.setDouble(11, (double)gammaInt / 100000.0);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.iCCP)) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            byte[] profileNameBytes = reader.getNullTerminatedBytes(80);
            PngDirectory directory = new PngDirectory(PngChunkType.iCCP);
            directory.setStringValue(12, new StringValue(profileNameBytes, _latin1Encoding));
            byte compressionMethod = reader.getInt8();
            if (compressionMethod == 0) {
                int bytesLeft = bytes.length - (profileNameBytes.length + 1 + 1);
                byte[] compressedProfile = ((SequentialReader)reader).getBytes(bytesLeft);
                try {
                    InflaterInputStream inflateStream = new InflaterInputStream(new ByteArrayInputStream(compressedProfile));
                    new IccReader().extract(new RandomAccessStreamReader(inflateStream), metadata, directory);
                    inflateStream.close();
                }
                catch (ZipException zex) {
                    directory.addError(String.format("Exception decompressing PNG iCCP chunk : %s", zex.getMessage()));
                    metadata.addDirectory(directory);
                }
            } else {
                directory.addError("Invalid compression method value");
            }
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.bKGD)) {
            PngDirectory directory = new PngDirectory(PngChunkType.bKGD);
            directory.setByteArray(15, bytes);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.tEXt)) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            StringValue keywordsv = reader.getNullTerminatedStringValue(80, _latin1Encoding);
            String keyword = keywordsv.toString();
            int bytesLeft = bytes.length - (keywordsv.getBytes().length + 1);
            StringValue value = reader.getNullTerminatedStringValue(bytesLeft, _latin1Encoding);
            ArrayList<KeyValuePair> textPairs = new ArrayList<KeyValuePair>();
            textPairs.add(new KeyValuePair(keyword, value));
            PngDirectory directory = new PngDirectory(PngChunkType.tEXt);
            directory.setObject(13, textPairs);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.zTXt)) {
            PngDirectory directory;
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            StringValue keywordsv = reader.getNullTerminatedStringValue(80, _latin1Encoding);
            String keyword = keywordsv.toString();
            byte compressionMethod = reader.getInt8();
            int bytesLeft = bytes.length - (keywordsv.getBytes().length + 1 + 1);
            byte[] textBytes = null;
            if (compressionMethod == 0) {
                try {
                    textBytes = StreamUtil.readAllBytes(new InflaterInputStream(new ByteArrayInputStream(bytes, bytes.length - bytesLeft, bytesLeft)));
                }
                catch (ZipException zex) {
                    directory = new PngDirectory(PngChunkType.zTXt);
                    directory.addError(String.format("Exception decompressing PNG zTXt chunk with keyword \"%s\": %s", keyword, zex.getMessage()));
                    metadata.addDirectory(directory);
                }
            } else {
                PngDirectory directory2 = new PngDirectory(PngChunkType.zTXt);
                directory2.addError("Invalid compression method value");
                metadata.addDirectory(directory2);
            }
            if (textBytes != null) {
                if (keyword.equals("XML:com.adobe.xmp")) {
                    new XmpReader().extract(textBytes, metadata);
                } else {
                    ArrayList<KeyValuePair> textPairs = new ArrayList<KeyValuePair>();
                    textPairs.add(new KeyValuePair(keyword, new StringValue(textBytes, _latin1Encoding)));
                    directory = new PngDirectory(PngChunkType.zTXt);
                    directory.setObject(13, textPairs);
                    metadata.addDirectory(directory);
                }
            }
        } else if (chunkType.equals(PngChunkType.iTXt)) {
            PngDirectory directory;
            PngDirectory directory3;
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            StringValue keywordsv = reader.getNullTerminatedStringValue(80, _latin1Encoding);
            String keyword = keywordsv.toString();
            byte compressionFlag = reader.getInt8();
            byte compressionMethod = reader.getInt8();
            byte[] languageTagBytes = reader.getNullTerminatedBytes(bytes.length);
            byte[] translatedKeywordBytes = reader.getNullTerminatedBytes(bytes.length);
            int bytesLeft = bytes.length - (keywordsv.getBytes().length + 1 + 1 + 1 + languageTagBytes.length + 1 + translatedKeywordBytes.length + 1);
            byte[] textBytes = null;
            if (compressionFlag == 0) {
                textBytes = reader.getNullTerminatedBytes(bytesLeft);
            } else if (compressionFlag == 1) {
                if (compressionMethod == 0) {
                    try {
                        textBytes = StreamUtil.readAllBytes(new InflaterInputStream(new ByteArrayInputStream(bytes, bytes.length - bytesLeft, bytesLeft)));
                    }
                    catch (ZipException zex) {
                        directory3 = new PngDirectory(PngChunkType.iTXt);
                        directory3.addError(String.format("Exception decompressing PNG iTXt chunk with keyword \"%s\": %s", keyword, zex.getMessage()));
                        metadata.addDirectory(directory3);
                    }
                } else {
                    directory = new PngDirectory(PngChunkType.iTXt);
                    directory.addError("Invalid compression method value");
                    metadata.addDirectory(directory);
                }
            } else {
                directory = new PngDirectory(PngChunkType.iTXt);
                directory.addError("Invalid compression flag value");
                metadata.addDirectory(directory);
            }
            if (textBytes != null) {
                if (keyword.equals("XML:com.adobe.xmp")) {
                    new XmpReader().extract(textBytes, metadata);
                } else {
                    ArrayList<KeyValuePair> textPairs = new ArrayList<KeyValuePair>();
                    textPairs.add(new KeyValuePair(keyword, new StringValue(textBytes, _latin1Encoding)));
                    directory3 = new PngDirectory(PngChunkType.iTXt);
                    directory3.setObject(13, textPairs);
                    metadata.addDirectory(directory3);
                }
            }
        } else if (chunkType.equals(PngChunkType.tIME)) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            int year = reader.getUInt16();
            short month = reader.getUInt8();
            short day = reader.getUInt8();
            short hour = reader.getUInt8();
            short minute = reader.getUInt8();
            short second = reader.getUInt8();
            PngDirectory directory = new PngDirectory(PngChunkType.tIME);
            if (DateUtil.isValidDate(year, month - 1, day) && DateUtil.isValidTime(hour, minute, second)) {
                String dateString = String.format("%04d:%02d:%02d %02d:%02d:%02d", year, (int)month, (int)day, (int)hour, (int)minute, (int)second);
                directory.setString(14, dateString);
            } else {
                directory.addError(String.format("PNG tIME data describes an invalid date/time: year=%d month=%d day=%d hour=%d minute=%d second=%d", year, (int)month, (int)day, (int)hour, (int)minute, (int)second));
            }
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.pHYs)) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            int pixelsPerUnitX = reader.getInt32();
            int pixelsPerUnitY = reader.getInt32();
            byte unitSpecifier = reader.getInt8();
            PngDirectory directory = new PngDirectory(PngChunkType.pHYs);
            directory.setInt(16, pixelsPerUnitX);
            directory.setInt(17, pixelsPerUnitY);
            directory.setInt(18, unitSpecifier);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.sBIT)) {
            PngDirectory directory = new PngDirectory(PngChunkType.sBIT);
            directory.setByteArray(19, bytes);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.eXIf)) {
            try {
                ExifTiffHandler handler = new ExifTiffHandler(metadata, null);
                new TiffReader().processTiff(new ByteArrayReader(bytes), handler, 0);
            }
            catch (TiffProcessingException ex) {
                PngDirectory directory = new PngDirectory(PngChunkType.eXIf);
                directory.addError(ex.getMessage());
                metadata.addDirectory(directory);
            }
            catch (IOException ex) {
                PngDirectory directory = new PngDirectory(PngChunkType.eXIf);
                directory.addError(ex.getMessage());
                metadata.addDirectory(directory);
            }
        }
    }

    static {
        _latin1Encoding = Charsets.ISO_8859_1;
        HashSet<PngChunkType> desiredChunkTypes = new HashSet<PngChunkType>();
        desiredChunkTypes.add(PngChunkType.IHDR);
        desiredChunkTypes.add(PngChunkType.PLTE);
        desiredChunkTypes.add(PngChunkType.tRNS);
        desiredChunkTypes.add(PngChunkType.cHRM);
        desiredChunkTypes.add(PngChunkType.sRGB);
        desiredChunkTypes.add(PngChunkType.gAMA);
        desiredChunkTypes.add(PngChunkType.iCCP);
        desiredChunkTypes.add(PngChunkType.bKGD);
        desiredChunkTypes.add(PngChunkType.tEXt);
        desiredChunkTypes.add(PngChunkType.zTXt);
        desiredChunkTypes.add(PngChunkType.iTXt);
        desiredChunkTypes.add(PngChunkType.tIME);
        desiredChunkTypes.add(PngChunkType.pHYs);
        desiredChunkTypes.add(PngChunkType.sBIT);
        desiredChunkTypes.add(PngChunkType.eXIf);
        _desiredChunkTypes = Collections.unmodifiableSet(desiredChunkTypes);
    }
}

