/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.StringValue;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.ReconyxHyperFireMakernoteDirectory;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class ReconyxHyperFireMakernoteDescriptor
extends TagDescriptor<ReconyxHyperFireMakernoteDirectory> {
    public ReconyxHyperFireMakernoteDescriptor(@NotNull ReconyxHyperFireMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 0: {
                return String.format("%d", ((ReconyxHyperFireMakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 2: {
                return ((ReconyxHyperFireMakernoteDirectory)this._directory).getString(tagType);
            }
            case 12: {
                return ((ReconyxHyperFireMakernoteDirectory)this._directory).getString(tagType);
            }
            case 14: {
                int[] sequence2 = ((ReconyxHyperFireMakernoteDirectory)this._directory).getIntArray(tagType);
                if (sequence2 == null) {
                    return null;
                }
                return String.format("%d/%d", sequence2[0], sequence2[1]);
            }
            case 18: {
                return String.format("%d", ((ReconyxHyperFireMakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 82: {
                return String.format("%d", ((ReconyxHyperFireMakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 84: {
                Double value = ((ReconyxHyperFireMakernoteDirectory)this._directory).getDoubleObject(tagType);
                DecimalFormat formatter = new DecimalFormat("0.000");
                return value == null ? null : formatter.format(value);
            }
            case 22: {
                String date = ((ReconyxHyperFireMakernoteDirectory)this._directory).getString(tagType);
                try {
                    SimpleDateFormat parser = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                    return parser.format(parser.parse(date));
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case 36: {
                return this.getIndexedDescription(tagType, "New", "Waxing Crescent", "First Quarter", "Waxing Gibbous", "Full", "Waning Gibbous", "Last Quarter", "Waning Crescent");
            }
            case 38: 
            case 40: {
                return String.format("%d", ((ReconyxHyperFireMakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 42: {
                StringValue svalue = ((ReconyxHyperFireMakernoteDirectory)this._directory).getStringValue(tagType);
                if (svalue == null) {
                    return null;
                }
                return svalue.toString();
            }
            case 72: 
            case 74: 
            case 76: 
            case 78: {
                return String.format("%d", ((ReconyxHyperFireMakernoteDirectory)this._directory).getInteger(tagType));
            }
            case 80: {
                return this.getIndexedDescription(tagType, "Off", "On");
            }
            case 86: {
                return ((ReconyxHyperFireMakernoteDirectory)this._directory).getString(tagType);
            }
        }
        return super.getDescription(tagType);
    }
}

