/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp3;

import com.drew.imaging.ImageProcessingException;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.mp3.Mp3Directory;
import java.io.IOException;
import java.io.InputStream;

public class Mp3Reader {
    public void extract(@NotNull InputStream inputStream2, @NotNull Metadata metadata) {
        Mp3Directory directory = new Mp3Directory();
        metadata.addDirectory(directory);
        try {
            StreamReader reader = new StreamReader(inputStream2);
            int header = reader.getInt32();
            int id = 0;
            switch ((header & 0x180000) >> 19) {
                case 0: {
                    throw new ImageProcessingException("MPEG-2.5 not supported.");
                }
                case 2: {
                    directory.setString(1, "MPEG-2");
                    id = 2;
                    break;
                }
                case 3: {
                    directory.setString(1, "MPEG-1");
                    id = 1;
                }
            }
            int layer = (header & 0x60000) >> 17;
            switch (layer) {
                case 0: {
                    directory.setString(2, "Not defined");
                    break;
                }
                case 1: {
                    directory.setString(2, "Layer III");
                    break;
                }
                case 2: {
                    directory.setString(2, "Layer II");
                    break;
                }
                case 3: {
                    directory.setString(2, "Layer I");
                }
            }
            int protectionBit = (header & 0x10000) >> 16;
            int bitrate = (header & 0xF000) >> 12;
            if (bitrate != 0 && bitrate != 15) {
                directory.setInt(3, Mp3Reader.setBitrate(bitrate, layer, id));
            }
            int frequency = (header & 0xC00) >> 10;
            int[][] frequencyMapping = new int[2][3];
            frequencyMapping[0] = new int[]{44100, 48000, 32000};
            frequencyMapping[1] = new int[]{22050, 24000, 16000};
            if (frequency <= 2) {
                if (id == 2) {
                    directory.setInt(4, frequencyMapping[1][frequency]);
                    frequency = frequencyMapping[1][frequency];
                } else if (id == 1) {
                    directory.setInt(4, frequencyMapping[0][frequency]);
                    frequency = frequencyMapping[0][frequency];
                }
            } else {
                directory.addError("Invalid frequency index.");
                frequency = -1;
            }
            int paddingBit = (header & 0x200) >> 9;
            int mode = (header & 0xC0) >> 6;
            switch (mode) {
                case 0: {
                    directory.setString(5, "Stereo");
                    break;
                }
                case 1: {
                    directory.setString(5, "Joint stereo");
                    break;
                }
                case 2: {
                    directory.setString(5, "Dual channel");
                    break;
                }
                case 3: {
                    directory.setString(5, "Mono");
                }
            }
            int copyright = (header & 8) >> 3;
            switch (copyright) {
                case 0: {
                    directory.setString(7, "False");
                    break;
                }
                case 1: {
                    directory.setString(7, "True");
                }
            }
            int emphasis = header & 3;
            switch (emphasis) {
                case 0: {
                    directory.setString(6, "none");
                    break;
                }
                case 1: {
                    directory.setString(6, "50/15ms");
                    break;
                }
                case 3: {
                    directory.setString(6, "CCITT j.17");
                }
            }
            if (frequency != -1 && bitrate != 0 && bitrate != 15) {
                int frameSize = Mp3Reader.setBitrate(bitrate, layer, id) * 1000 * 144 / frequency;
                directory.setString(8, frameSize + " bytes");
            }
        }
        catch (IOException e) {
            directory.addError(e.getMessage());
        }
        catch (ImageProcessingException e) {
            directory.addError(e.getMessage());
        }
    }

    private static int setBitrate(int bitrate, int layer, int id) {
        int[][] bitrateMapping = new int[14][6];
        bitrateMapping[0] = new int[]{32, 32, 32, 32, 32, 8};
        bitrateMapping[1] = new int[]{64, 48, 40, 64, 48, 16};
        bitrateMapping[2] = new int[]{96, 56, 48, 96, 56, 24};
        bitrateMapping[3] = new int[]{128, 64, 56, 128, 64, 32};
        bitrateMapping[4] = new int[]{160, 80, 64, 160, 80, 64};
        bitrateMapping[5] = new int[]{192, 96, 80, 192, 96, 80};
        bitrateMapping[6] = new int[]{224, 112, 96, 224, 112, 56};
        bitrateMapping[7] = new int[]{256, 128, 112, 256, 128, 64};
        bitrateMapping[8] = new int[]{288, 160, 128, 28, 160, 128};
        bitrateMapping[9] = new int[]{320, 192, 160, 320, 192, 160};
        bitrateMapping[10] = new int[]{352, 224, 192, 352, 224, 112};
        bitrateMapping[11] = new int[]{384, 256, 224, 384, 256, 128};
        bitrateMapping[12] = new int[]{416, 320, 256, 416, 320, 256};
        bitrateMapping[13] = new int[]{448, 384, 320, 448, 384, 320};
        int xPos = 0;
        int yPos = bitrate - 1;
        if (id == 2) {
            switch (layer) {
                case 1: {
                    xPos = 5;
                    break;
                }
                case 2: {
                    xPos = 4;
                    break;
                }
                case 3: {
                    xPos = 3;
                }
            }
        } else if (id == 1) {
            switch (layer) {
                case 1: {
                    xPos = 2;
                    break;
                }
                case 2: {
                    xPos = 1;
                    break;
                }
                case 3: {
                    xPos = 0;
                }
            }
        }
        return bitrateMapping[yPos][xPos];
    }
}

