/*
 * Decompiled with CFR 0.152.
 */
package com.drew.tools;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.Iterables;
import com.drew.lang.annotations.NotNull;
import com.drew.tools.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

public class ExtractJpegSegmentTool {
    public static void main(String[] args2) throws IOException, JpegProcessingException {
        String filePath;
        if (args2.length < 1) {
            ExtractJpegSegmentTool.printUsage();
            System.exit(1);
        }
        if (!new File(filePath = args2[0]).exists()) {
            System.err.println("File does not exist");
            ExtractJpegSegmentTool.printUsage();
            System.exit(1);
        }
        HashSet<JpegSegmentType> segmentTypes = new HashSet<JpegSegmentType>();
        for (int i = 1; i < args2.length; ++i) {
            JpegSegmentType segmentType = JpegSegmentType.valueOf(args2[i].toUpperCase());
            if (!segmentType.canContainMetadata) {
                System.err.printf("WARNING: Segment type %s cannot contain metadata so it may not be necessary to extract it%n", new Object[]{segmentType});
            }
            segmentTypes.add(segmentType);
        }
        if (segmentTypes.size() == 0) {
            segmentTypes.addAll(JpegSegmentType.canContainMetadataTypes);
        }
        System.out.println("Reading: " + filePath);
        JpegSegmentData segmentData = JpegSegmentReader.readSegments(new File(filePath), segmentTypes);
        ExtractJpegSegmentTool.saveSegmentFiles(filePath, segmentData);
    }

    public static void saveSegmentFiles(@NotNull String jpegFilePath, @NotNull JpegSegmentData segmentData) throws IOException {
        for (JpegSegmentType segmentType : segmentData.getSegmentTypes()) {
            List<byte[]> segments = Iterables.toList(segmentData.getSegments(segmentType));
            if (segments.size() == 0) continue;
            if (segments.size() > 1) {
                for (int i = 0; i < segments.size(); ++i) {
                    String outputFilePath = String.format("%s.%s.%d", jpegFilePath, segmentType.toString().toLowerCase(), i);
                    System.out.println("Writing: " + outputFilePath);
                    FileUtil.saveBytes(new File(outputFilePath), segments.get(i));
                }
                continue;
            }
            String outputFilePath = String.format("%s.%s", jpegFilePath, segmentType.toString().toLowerCase());
            System.out.println("Writing: " + outputFilePath);
            FileUtil.saveBytes(new File(outputFilePath), segments.get(0));
        }
    }

    private static void printUsage() {
        System.out.println("USAGE:\n");
        System.out.println("\tjava com.drew.tools.ExtractJpegSegmentTool <filename> [<segment> ...]\n");
        System.out.print("Where <segment> is zero or more of:");
        for (JpegSegmentType segmentType : (JpegSegmentType[])JpegSegmentType.class.getEnumConstants()) {
            if (!segmentType.canContainMetadata) continue;
            System.out.print(" " + segmentType.toString());
        }
        System.out.println();
    }
}

