/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.xml.atom;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import com.google.api.client.xml.Xml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import com.google.api.client.xml.atom.AbstractAtomFeedParser;
import com.google.api.client.xml.atom.Atom;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class AtomFeedParser<T, E>
extends AbstractAtomFeedParser<T> {
    private final Class<E> entryClass;

    public AtomFeedParser(XmlNamespaceDictionary namespaceDictionary, XmlPullParser parser, InputStream inputStream2, Class<T> feedClass, Class<E> entryClass) {
        super(namespaceDictionary, parser, inputStream2, feedClass);
        this.entryClass = Preconditions.checkNotNull(entryClass);
    }

    @Override
    public E parseNextEntry() throws IOException, XmlPullParserException {
        return (E)super.parseNextEntry();
    }

    @Override
    protected Object parseEntryInternal() throws IOException, XmlPullParserException {
        E result = Types.newInstance(this.entryClass);
        Xml.parseElement(this.getParser(), result, this.getNamespaceDictionary(), null);
        return result;
    }

    public final Class<E> getEntryClass() {
        return this.entryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E> AtomFeedParser<T, E> create(HttpResponse response, XmlNamespaceDictionary namespaceDictionary, Class<T> feedClass, Class<E> entryClass) throws IOException, XmlPullParserException {
        InputStream content = response.getContent();
        try {
            Atom.checkContentType(response.getContentType());
            XmlPullParser parser = Xml.createParser();
            parser.setInput(content, null);
            AtomFeedParser<T, E> result = new AtomFeedParser<T, E>(namespaceDictionary, parser, content, feedClass, entryClass);
            content = null;
            AtomFeedParser<T, E> atomFeedParser = result;
            return atomFeedParser;
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }
}

