/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.io.Opener;
import ij.plugin.FolderOpener;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.ColorModel;
import java.io.File;
import java.util.Properties;

public class VirtualStack
extends ImageStack {
    private static final int INITIAL_SIZE = 100;
    private String path;
    private int nSlices;
    private String[] names;
    private String[] labels;
    private int bitDepth;
    private int delay;
    private Properties properties;
    private boolean generateData;
    private int[] indexes;

    public VirtualStack() {
    }

    public VirtualStack(int width, int height) {
        super(width, height);
    }

    public VirtualStack(int width, int height, ColorModel cm, String path) {
        super(width, height, cm);
        this.path = path = IJ.addSeparator(path);
        this.names = new String[100];
        this.labels = new String[100];
    }

    public VirtualStack(int width, int height, int slices) {
        this(width, height, slices, "8-bit");
    }

    public VirtualStack(int width, int height, int slices, String options) {
        super(width, height, null);
        this.nSlices = slices;
        int depth = 8;
        if (options.contains("16-bit")) {
            depth = 16;
        }
        if (options.contains("RGB")) {
            depth = 24;
        }
        if (options.contains("32-bit")) {
            depth = 32;
        }
        if (options.contains("delay")) {
            this.delay = 250;
        }
        this.generateData = options.contains("fill");
        this.bitDepth = depth;
    }

    public void addSlice(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("'fileName' is null!");
        }
        if (fileName.startsWith(".")) {
            return;
        }
        if (this.names == null) {
            throw new IllegalArgumentException("VirtualStack(w,h,cm,path) constructor not used");
        }
        ++this.nSlices;
        if (this.nSlices == this.names.length) {
            String[] tmp = new String[this.nSlices * 2];
            System.arraycopy(this.names, 0, tmp, 0, this.nSlices);
            this.names = tmp;
            tmp = new String[this.nSlices * 2];
            System.arraycopy(this.labels, 0, tmp, 0, this.nSlices);
            this.labels = tmp;
        }
        this.names[this.nSlices - 1] = fileName;
    }

    @Override
    public void addSlice(String sliceLabel, Object pixels) {
    }

    @Override
    public void addSlice(String sliceLabel, ImageProcessor ip) {
    }

    @Override
    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
    }

    @Override
    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        for (int i = n; i < this.nSlices; ++i) {
            this.names[i - 1] = this.names[i];
        }
        this.names[this.nSlices - 1] = null;
        --this.nSlices;
    }

    @Override
    public void deleteLastSlice() {
        int n = this.size();
        if (n > 0) {
            this.deleteSlice(n);
        }
    }

    @Override
    public Object getPixels(int n) {
        ImageProcessor ip = this.getProcessor(n);
        if (ip != null) {
            return ip.getPixels();
        }
        return null;
    }

    @Override
    public void setPixels(Object pixels, int n) {
    }

    @Override
    public ImageProcessor getProcessor(int n) {
        if (this.path == null) {
            ImageProcessor ip = null;
            int w = this.getWidth();
            int h2 = this.getHeight();
            switch (this.bitDepth) {
                case 8: {
                    ip = new ByteProcessor(w, h2);
                    break;
                }
                case 16: {
                    ip = new ShortProcessor(w, h2);
                    break;
                }
                case 24: {
                    ip = new ColorProcessor(w, h2);
                    break;
                }
                case 32: {
                    ip = new FloatProcessor(w, h2);
                }
            }
            String hlabel = null;
            if (this.generateData) {
                int value = 0;
                ImagePlus img = WindowManager.getCurrentImage();
                if (img != null && img.getStackSize() == this.nSlices) {
                    value = img.getCurrentSlice() - 1;
                }
                if (this.bitDepth == 16) {
                    value *= 256;
                }
                if (this.bitDepth != 32) {
                    for (int i = 0; i < ip.getPixelCount(); ++i) {
                        ip.set(i, value++);
                    }
                }
                if (img != null && img.isHyperStack()) {
                    int[] pos = img.convertIndexToPosition(n);
                    hlabel = pos[0] + " " + pos[1] + " " + pos[2] + " " + n;
                }
            }
            this.label(ip, hlabel != null ? hlabel : "" + n, Color.white);
            if (this.delay > 0) {
                IJ.wait(this.delay);
            }
            return ip;
        }
        n = this.translate(n);
        Opener opener = new Opener();
        opener.setSilentMode(true);
        IJ.redirectErrorMessages(true);
        ImagePlus imp = opener.openTempImage(this.path, this.names[n - 1]);
        IJ.redirectErrorMessages(false);
        ImageProcessor ip = null;
        int depthThisImage = 0;
        if (imp != null) {
            int w = imp.getWidth();
            int h3 = imp.getHeight();
            int type = imp.getType();
            ColorModel cm = imp.getProcessor().getColorModel();
            String info = (String)imp.getProperty("Info");
            if (info != null) {
                if (FolderOpener.useInfo(info)) {
                    this.labels[n - 1] = info;
                }
            } else {
                String sliceLabel = imp.getStack().getSliceLabel(1);
                if (FolderOpener.useInfo(sliceLabel)) {
                    this.labels[n - 1] = "Label: " + sliceLabel;
                }
            }
            depthThisImage = imp.getBitDepth();
            ip = imp.getProcessor();
            ip.setOverlay(imp.getOverlay());
            this.properties = imp.getProperty("FHT") != null ? imp.getProperties() : null;
        } else {
            File f = new File(this.path, this.names[n - 1]);
            String msg = f.exists() ? "Error opening " : "File not found: ";
            ip = new ByteProcessor(this.getWidth(), this.getHeight());
            ip.invert();
            this.label(ip, msg + this.names[n - 1], Color.black);
            depthThisImage = 8;
        }
        if (depthThisImage != this.bitDepth) {
            switch (this.bitDepth) {
                case 8: {
                    ip = ip.convertToByte(true);
                    break;
                }
                case 16: {
                    ip = ip.convertToShort(true);
                    break;
                }
                case 24: {
                    ip = ip.convertToRGB();
                    break;
                }
                case 32: {
                    ip = ip.convertToFloat();
                }
            }
        }
        if (ip.getWidth() != this.getWidth() || ip.getHeight() != this.getHeight()) {
            ImageProcessor ip2 = ip.createProcessor(this.getWidth(), this.getHeight());
            ip2.insert(ip, 0, 0);
            ip = ip2;
        }
        if (this.cTable != null) {
            ip.setCalibrationTable(this.cTable);
        }
        return ip;
    }

    private void label(ImageProcessor ip, String msg, Color color) {
        int size = this.getHeight() / 20;
        if (size < 9) {
            size = 9;
        }
        Font font = new Font("Helvetica", 0, size);
        ip.setFont(font);
        ip.setAntialiasedText(true);
        ip.setColor(color);
        ip.drawString(msg, size, size * 2);
    }

    public int saveChanges(int n) {
        return -1;
    }

    @Override
    public int size() {
        return this.getSize();
    }

    @Override
    public int getSize() {
        return this.nSlices;
    }

    @Override
    public String getSliceLabel(int n) {
        if (this.labels == null) {
            return null;
        }
        String label = this.labels[n - 1];
        if (label == null) {
            return this.names[n - 1];
        }
        if (label.startsWith("Label: ")) {
            return label.substring(7, label.length());
        }
        return this.names[n - 1] + "\n" + label;
    }

    @Override
    public Object[] getImageArray() {
        return null;
    }

    @Override
    public void setSliceLabel(String label, int n) {
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public void trim() {
    }

    public String getDirectory() {
        return IJ.addSeparator(this.path);
    }

    public String getFileName(int n) {
        return this.names[n - 1];
    }

    @Override
    public void setBitDepth(int bitDepth) {
        this.bitDepth = bitDepth;
    }

    @Override
    public int getBitDepth() {
        return this.bitDepth;
    }

    public ImageStack sortDicom(String[] strings, String[] info, int maxDigits) {
        int i;
        int n = this.size();
        String[] names2 = new String[n];
        for (i = 0; i < n; ++i) {
            names2[i] = this.names[i];
        }
        for (i = 0; i < n; ++i) {
            int slice = (int)Tools.parseDouble(strings[i].substring(strings[i].length() - maxDigits), 0.0);
            if (slice == 0) {
                return null;
            }
            this.names[i] = names2[slice - 1];
            this.labels[i] = info[slice - 1];
        }
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setIndexes(int[] indexes) {
        this.indexes = indexes;
    }

    public int translate(int n) {
        int n2 = this.indexes != null && this.indexes.length == this.getSize() ? this.indexes[n - 1] + 1 : n;
        return n2;
    }
}

