/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.RoiRotator;
import ij.plugin.RoiScaler;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class Overlay
implements Iterable<Roi> {
    private Vector<Roi> list = new Vector();
    private boolean label;
    private boolean drawNames;
    private boolean drawBackgrounds;
    private Color labelColor;
    private Font labelFont;
    private boolean scalableLabels;
    private boolean isCalibrationBar;
    private boolean selectable = true;
    private boolean draggable = true;

    public Overlay() {
    }

    public Overlay(Roi roi) {
        if (roi != null) {
            this.list.add(roi);
        }
    }

    public void add(Roi roi) {
        if (roi != null) {
            this.list.add(roi);
        }
    }

    public void add(Roi roi, String name) {
        roi.setName(name);
        this.add(roi);
    }

    public void addElement(Roi roi) {
        if (roi != null) {
            this.list.add(roi);
        }
    }

    public void set(Roi roi, int index) {
        if (index < 0 || index >= this.list.size()) {
            throw new IllegalArgumentException("set: index out of range");
        }
        if (roi != null) {
            this.list.set(index, roi);
        }
    }

    public void remove(int index) {
        if (index >= 0) {
            this.list.remove(index);
        }
    }

    public void remove(Roi roi) {
        this.list.remove(roi);
    }

    public void remove(String name) {
        if (name == null) {
            return;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!name.equals(this.get(i).getName())) continue;
            this.remove(i);
        }
    }

    public void clear() {
        this.list.clear();
    }

    public Roi get(int index) {
        try {
            return this.list.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Roi get(String name) {
        int index = this.getIndex(name);
        if (index == -1) {
            return null;
        }
        return this.get(index);
    }

    public int getIndex(String name) {
        if (name == null) {
            return -1;
        }
        Roi[] rois = this.toArray();
        for (int i = rois.length - 1; i >= 0; --i) {
            if (!name.equals(rois[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public int indexAt(int x, int y) {
        Roi[] rois = this.toArray();
        for (int i = rois.length - 1; i >= 0; --i) {
            if (!this.contains(rois[i], x, y)) continue;
            return i;
        }
        return -1;
    }

    private boolean contains(Roi roi, int x, int y) {
        if (roi == null) {
            return false;
        }
        if (roi instanceof Line) {
            return ((Line)roi).getFloatPolygon(10.0).contains(x, y);
        }
        return roi.contains(x, y);
    }

    public boolean contains(Roi roi) {
        return this.list.contains(roi);
    }

    public int size() {
        return this.list.size();
    }

    public Roi[] toArray() {
        Roi[] array = new Roi[this.list.size()];
        return this.list.toArray(array);
    }

    public Roi[] toArray(int[] indexes) {
        ArrayList<Roi> rois = new ArrayList<Roi>();
        for (int i = 0; i < this.size(); ++i) {
            if (indexes[i] < 0 || indexes[i] >= this.size()) continue;
            rois.add(this.get(indexes[i]));
        }
        return rois.toArray(new Roi[rois.size()]);
    }

    public void setStrokeColor(Color color) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setStrokeColor(color);
        }
    }

    public void setStrokeWidth(Double width) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setStrokeWidth(width);
        }
    }

    public void setFillColor(Color color) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setFillColor(color);
        }
    }

    public void translate(int dx, int dy) {
        for (int i = 0; i < this.size(); ++i) {
            Rectangle2D r;
            Roi roi = this.get(i);
            if (roi.subPixelResolution()) {
                r = roi.getFloatBounds();
                roi.setLocation(r.getX() + (double)dx, r.getY() + (double)dy);
                continue;
            }
            r = roi.getBounds();
            roi.setLocation(((Rectangle)r).x + dx, ((Rectangle)r).y + dy);
        }
    }

    public void translate(double dx, double dy) {
        boolean intArgs = (double)((int)dx) == dx && (double)((int)dy) == dy;
        for (int i = 0; i < this.size(); ++i) {
            Rectangle2D r;
            Roi roi = this.get(i);
            if (roi.subPixelResolution() || !intArgs) {
                r = roi.getFloatBounds();
                roi.setLocation(r.getX() + dx, r.getY() + dy);
                continue;
            }
            r = roi.getBounds();
            roi.setLocation(((Rectangle)r).x + (int)dx, ((Rectangle)r).y + (int)dy);
        }
    }

    public ResultsTable measure(ImagePlus imp) {
        ResultsTable rt = new ResultsTable();
        rt.showRowNumbers(true);
        Analyzer analyzer = new Analyzer(imp, rt);
        for (int i = 0; i < this.size(); ++i) {
            Roi roi = this.get(i);
            imp.setRoi(roi);
            analyzer.measure();
        }
        imp.deleteRoi();
        return rt;
    }

    public Overlay crop(Rectangle bounds) {
        int dy;
        Roi[] allRois;
        if (bounds == null) {
            return this.duplicate();
        }
        Overlay overlay2 = this.create();
        for (Roi roi : allRois = this.toArray()) {
            Rectangle roiBounds = roi.getBounds();
            if (roiBounds.width == 0) {
                roiBounds.width = 1;
            }
            if (roiBounds.height == 0) {
                roiBounds.height = 1;
            }
            if (!bounds.intersects(roiBounds)) continue;
            overlay2.add((Roi)roi.clone());
        }
        int dx = bounds.x > 0 ? bounds.x : 0;
        int n = dy = bounds.y > 0 ? bounds.y : 0;
        if (dx > 0 || dy > 0) {
            overlay2.translate(-dx, -dy);
        }
        return overlay2;
    }

    public void crop(int firstSlice, int lastSlice) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Roi roi = this.get(i);
            int position = roi.getPosition();
            if (position <= 0) continue;
            if (position < firstSlice || position > lastSlice) {
                this.remove(i);
                continue;
            }
            roi.setPosition(position - firstSlice + 1);
        }
    }

    public void crop(int firstC, int lastC, int firstZ, int lastZ, int firstT, int lastT) {
        int nc = lastC - firstC + 1;
        int nz = lastZ - firstZ + 1;
        int nt = lastT - firstT + 1;
        boolean toCStack = nz == 1 && nt == 1;
        boolean toZStack = nt == 1 && nc == 1;
        boolean toTStack = nc == 1 && nz == 1;
        for (int i = this.size() - 1; i >= 0; --i) {
            Roi roi = this.get(i);
            int c = roi.getCPosition();
            int z = roi.getZPosition();
            int t2 = roi.getTPosition();
            int c2 = c - firstC + 1;
            int z2 = z - firstZ + 1;
            int t22 = t2 - firstT + 1;
            if (toCStack) {
                roi.setPosition(c2);
            } else if (toZStack) {
                roi.setPosition(z2);
            } else if (toTStack) {
                roi.setPosition(t22);
            } else {
                roi.setPosition(c2, z2, t22);
            }
            if ((c2 >= 1 && c2 <= nc || c <= 0) && (z2 >= 1 && z2 <= nz || z <= 0) && (t22 >= 1 && t22 <= nt || t2 <= 0)) continue;
            this.remove(i);
        }
    }

    public Roi xor(int[] indexes) {
        return Roi.xor(this.toArray(indexes));
    }

    public Overlay create() {
        Overlay overlay2 = new Overlay();
        overlay2.drawLabels(this.label);
        overlay2.drawNames(this.drawNames);
        overlay2.drawBackgrounds(this.drawBackgrounds);
        overlay2.setLabelColor(this.labelColor);
        overlay2.setLabelFont(this.labelFont, this.scalableLabels);
        overlay2.setIsCalibrationBar(this.isCalibrationBar);
        overlay2.selectable(this.selectable);
        overlay2.setDraggable(this.draggable);
        return overlay2;
    }

    public Overlay duplicate() {
        Roi[] rois = this.toArray();
        Overlay overlay2 = this.create();
        for (int i = 0; i < rois.length; ++i) {
            overlay2.add((Roi)rois[i].clone());
        }
        return overlay2;
    }

    public Overlay scale(double xscale, double yscale) {
        Overlay overlay2 = this.create();
        for (int i = 0; i < this.size(); ++i) {
            Roi roi = this.get(i);
            int position = roi.getPosition();
            roi = RoiScaler.scale(roi, xscale, yscale, false);
            roi.setPosition(position);
            overlay2.add(roi);
        }
        return overlay2;
    }

    public Overlay rotate(double angle, double xcenter, double ycenter) {
        Overlay overlay2 = this.create();
        for (int i = 0; i < this.size(); ++i) {
            Roi roi = this.get(i);
            int position = roi.getPosition();
            if (!"|GRID|".equals(roi.getName())) {
                roi = RoiRotator.rotate(roi, angle, xcenter, ycenter);
            }
            roi.setPosition(position);
            overlay2.add(roi);
        }
        return overlay2;
    }

    public void drawLabels(boolean b) {
        this.label = b;
    }

    public boolean getDrawLabels() {
        return this.label;
    }

    public void drawNames(boolean b) {
        this.drawNames = b;
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].setIgnoreClipRect(this.drawNames);
        }
    }

    public boolean getDrawNames() {
        return this.drawNames;
    }

    public void drawBackgrounds(boolean b) {
        this.drawBackgrounds = b;
    }

    public boolean getDrawBackgrounds() {
        return this.drawBackgrounds;
    }

    public void setLabelColor(Color c) {
        this.labelColor = c;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font font) {
        this.setLabelFont(font, false);
    }

    public void setLabelFont(Font font, boolean scalable) {
        this.labelFont = font;
        this.scalableLabels = scalable;
    }

    public void setLabelFontSize(int size, String options) {
        int style = 0;
        if (options != null) {
            this.scalableLabels = options.contains("scale");
            if (options.contains("bold")) {
                style = 1;
            }
            this.drawBackgrounds = options.contains("back");
        }
        this.labelFont = new Font("SansSerif", style, size);
        this.drawLabels(true);
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setIsCalibrationBar(boolean b) {
        this.isCalibrationBar = b;
    }

    public boolean isCalibrationBar() {
        return this.isCalibrationBar;
    }

    public void fill(ImagePlus imp, Color foreground, Color background) {
        ImageProcessor ip = imp.getProcessor();
        if (background != null) {
            ip.resetRoi();
            ip.setColor(background);
            ip.fillRect(0, 0, ip.getWidth(), ip.getHeight());
        }
        if (foreground != null) {
            ip.setColor(foreground);
            for (int i = 0; i < this.size(); ++i) {
                ip.fill(this.get(i));
            }
            ip.resetRoi();
        }
        imp.updateAndDraw();
    }

    void setVector(Vector<Roi> v) {
        this.list = v;
    }

    Vector<Roi> getVector() {
        return this.list;
    }

    public void selectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public boolean scalableLabels() {
        return this.scalableLabels;
    }

    public String toString() {
        return "Overlay[size=" + this.size() + " " + (this.scalableLabels ? "scale" : "") + " " + Colors.colorToString(this.getLabelColor()) + "]";
    }

    public static void updateTableOverlay(ImagePlus imp, int first, int last, int tableSize) {
        int i;
        if (imp == null) {
            return;
        }
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            return;
        }
        if (overlay.size() != tableSize) {
            return;
        }
        if (first < 0) {
            first = 0;
        }
        if (last > tableSize - 1) {
            last = tableSize - 1;
        }
        if (first > last) {
            return;
        }
        String name1 = overlay.get(0).getName();
        String name2 = overlay.get(overlay.size() - 1).getName();
        if (!"1".equals(name1) || !("" + tableSize).equals(name2)) {
            return;
        }
        int count = last - first + 1;
        if (overlay.size() == count && !IJ.isMacro()) {
            if (count == 1 || IJ.showMessageWithCancel("ImageJ", "Delete " + overlay.size() + " element overlay?  ")) {
                imp.setOverlay(null);
            }
            return;
        }
        for (i = 0; i < count; ++i) {
            overlay.remove(first);
        }
        for (i = first; i < overlay.size(); ++i) {
            overlay.get(i).setName("" + (i + 1));
        }
        imp.draw();
    }

    public static Overlay createStackOverlay(Roi[] rois) {
        Overlay overlay = new Overlay();
        for (int i = 0; i < rois.length; ++i) {
            Roi roi = (Roi)rois[i].clone();
            roi.setLocation(0, 0);
            roi.setPosition(i + 1);
            overlay.add(roi);
        }
        return overlay;
    }

    @Override
    public Iterator<Roi> iterator() {
        final Overlay overlay = this;
        Iterator<Roi> it = new Iterator<Roi>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index + 1 < overlay.size();
            }

            @Override
            public Roi next() {
                if (this.index + 1 < overlay.size()) {
                    return overlay.get(++this.index);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return it;
    }
}

