/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.HyperStackConverter;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.image.ColorModel;

public class Binner
implements PlugIn {
    public static int AVERAGE = 0;
    public static int MEDIAN = 1;
    public static int MIN = 2;
    public static int MAX = 3;
    public static int SUM = 4;
    private static String[] methods = new String[]{"Average", "Median", "Min", "Max", "Sum"};
    private int xshrink = 2;
    private int yshrink = 2;
    private int zshrink = 1;
    private int method = AVERAGE;
    private float maxValue;

    @Override
    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (!this.showDialog(imp)) {
            return;
        }
        if (imp.getStackSize() == 1) {
            Undo.setup(2, imp);
        }
        imp.startTiming();
        ImagePlus imp2 = this.shrink(imp, this.xshrink, this.yshrink, this.zshrink, this.method);
        IJ.showTime(imp, imp.getStartTime(), "", imp.getStackSize());
        imp.setStack(imp2.getStack());
        imp.setCalibration(imp2.getCalibration());
        if (this.zshrink > 1) {
            imp.setSlice(1);
        }
    }

    public ImagePlus shrink(ImagePlus imp, int xshrink, int yshrink, int zshrink, int method) {
        this.xshrink = xshrink;
        this.yshrink = yshrink;
        int w = imp.getWidth() / xshrink;
        int h2 = imp.getHeight() / yshrink;
        ColorModel cm = imp.createLut().getColorModel();
        ImageStack stack = imp.getStack();
        ImageStack stack2 = new ImageStack(w, h2, cm);
        int d = stack.size();
        if (method == SUM) {
            int bitDepth = imp.getBitDepth();
            this.maxValue = bitDepth == 8 ? 255.0f : (bitDepth == 16 ? 65535.0f : 0.0f);
        }
        for (int z = 1; z <= d; ++z) {
            IJ.showProgress(z, d);
            ImageProcessor ip = stack.getProcessor(z);
            if (ip.isInvertedLut()) {
                ip.invert();
            }
            ImageProcessor ip2 = this.shrink(ip, method);
            if (ip.isInvertedLut()) {
                ip2.invert();
            }
            stack2.addSlice(stack.getSliceLabel(z), ip2);
        }
        if (zshrink > 1 && !imp.isHyperStack()) {
            stack2 = this.shrinkZ(stack2, zshrink);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("Reduced " + imp.getShortTitle(), stack2);
        Calibration cal2 = imp2.getCalibration();
        if (cal2.scaled()) {
            cal2.pixelWidth *= (double)xshrink;
            cal2.pixelHeight *= (double)yshrink;
            cal2.pixelDepth *= (double)zshrink;
        }
        imp2.setOpenAsHyperStack(imp.isHyperStack());
        if (method == SUM && imp2.getBitDepth() > 8) {
            ImageProcessor ip = imp2.getProcessor();
            ip.setMinAndMax(ip.getMin(), ip.getMax() * (double)xshrink * (double)yshrink * (double)zshrink);
        }
        return imp2;
    }

    private ImageStack shrinkZ(ImageStack stack, int zshrink) {
        int w = stack.getWidth();
        int h2 = stack.getHeight();
        int d = stack.size();
        int d2 = d / zshrink;
        ImageStack stack2 = new ImageStack(w, h2, stack.getColorModel());
        for (int z = 1; z <= d2; ++z) {
            stack2.addSlice(stack.getProcessor(z).duplicate());
        }
        boolean rgb = stack.getBitDepth() == 24;
        ImageProcessor ip = rgb ? new ColorProcessor(d, h2) : new FloatProcessor(d, h2);
        for (int x = 0; x < w; ++x) {
            IJ.showProgress(x + 1, w);
            for (int y = 0; y < h2; ++y) {
                for (int z = 0; z < d; ++z) {
                    float value = (float)stack.getVoxel(x, y, z);
                    ip.setf(z, y, value);
                }
            }
            ImageProcessor ip2 = this.shrink(ip, zshrink, 1, this.method);
            for (int x2 = 0; x2 < d2; ++x2) {
                for (int y2 = 0; y2 < h2; ++y2) {
                    stack2.setVoxel(x, y2, x2, ip2.getf(x2, y2));
                }
            }
        }
        return stack2;
    }

    public ImagePlus shrinkHyperstackZ(ImagePlus imp, int zshrink) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        ImageStack stack = imp.getStack();
        int slices2 = slices / zshrink;
        ImageStack stack2 = new ImageStack(width, height);
        for (int c = 1; c <= channels; ++c) {
            for (int t2 = 1; t2 <= frames; ++t2) {
                ImageStack tstack = new ImageStack(width, height);
                for (int z = 1; z <= slices; ++z) {
                    int i = imp.getStackIndex(c, z, t2);
                    ImageProcessor ip = stack.getProcessor(imp.getStackIndex(c, z, t2));
                    tstack.addSlice(stack.getSliceLabel(i), ip);
                }
                tstack = this.shrinkZ(tstack, zshrink);
                for (int i = 1; i <= tstack.size(); ++i) {
                    stack2.addSlice(tstack.getSliceLabel(i), tstack.getProcessor(i));
                }
            }
        }
        imp.setStack(stack2, channels, slices2, frames);
        new HyperStackConverter().shuffle(imp, 3);
        IJ.showProgress(1.0);
        return imp;
    }

    public ImageProcessor shrink(ImageProcessor ip, int xshrink, int yshrink, int method) {
        this.xshrink = xshrink;
        this.yshrink = yshrink;
        return this.shrink(ip, method);
    }

    private ImageProcessor shrink(ImageProcessor ip, int method) {
        if (method < 0 || method > methods.length) {
            method = AVERAGE;
        }
        int w = ip.getWidth() / this.xshrink;
        int h2 = ip.getHeight() / this.yshrink;
        ImageProcessor ip2 = ip.createProcessor(w, h2);
        if (ip instanceof ColorProcessor) {
            return this.shrinkRGB((ColorProcessor)ip, (ColorProcessor)ip2, method);
        }
        for (int y = 0; y < h2; ++y) {
            for (int x = 0; x < w; ++x) {
                if (method == AVERAGE) {
                    ip2.setf(x, y, this.getAverage(ip, x, y));
                    continue;
                }
                if (method == MEDIAN) {
                    ip2.setf(x, y, this.getMedian(ip, x, y));
                    continue;
                }
                if (method == MIN) {
                    ip2.setf(x, y, this.getMin(ip, x, y));
                    continue;
                }
                if (method == MAX) {
                    ip2.setf(x, y, this.getMax(ip, x, y));
                    continue;
                }
                if (method != SUM) continue;
                ip2.setf(x, y, this.getSum(ip, x, y));
            }
        }
        return ip2;
    }

    private ImageProcessor shrinkRGB(ColorProcessor cp, ColorProcessor cp2, int method) {
        ByteProcessor bp = cp.getChannel(1, null);
        cp2.setChannel(1, (ByteProcessor)this.shrink(bp, method));
        cp2.setChannel(2, (ByteProcessor)this.shrink(cp.getChannel(2, bp), method));
        cp2.setChannel(3, (ByteProcessor)this.shrink(cp.getChannel(3, bp), method));
        return cp2;
    }

    private float getAverage(ImageProcessor ip, int x, int y) {
        float sum = 0.0f;
        for (int y2 = 0; y2 < this.yshrink; ++y2) {
            for (int x2 = 0; x2 < this.xshrink; ++x2) {
                sum += ip.getf(x * this.xshrink + x2, y * this.yshrink + y2);
            }
        }
        return sum / (float)(this.xshrink * this.yshrink);
    }

    private float getMedian(ImageProcessor ip, int x, int y) {
        int shrinksize = this.xshrink * this.yshrink;
        float[] pixels = new float[shrinksize];
        int p = 0;
        for (int y2 = 0; y2 < this.yshrink; ++y2) {
            for (int x2 = 0; x2 < this.xshrink; ++x2) {
                pixels[p++] = ip.getf(x * this.xshrink + x2, y * this.yshrink + y2);
            }
        }
        int halfsize = shrinksize / 2;
        for (int i = 0; i <= halfsize; ++i) {
            float max = 0.0f;
            int mj = 0;
            for (int j = 0; j < shrinksize; ++j) {
                if (!(pixels[j] > max)) continue;
                max = pixels[j];
                mj = j;
            }
            pixels[mj] = 0.0f;
        }
        float max = -3.4028235E38f;
        for (int j = 0; j < shrinksize; ++j) {
            if (!(pixels[j] > max)) continue;
            max = pixels[j];
        }
        return max;
    }

    private float getMin(ImageProcessor ip, int x, int y) {
        float min2 = Float.MAX_VALUE;
        for (int y2 = 0; y2 < this.yshrink; ++y2) {
            for (int x2 = 0; x2 < this.xshrink; ++x2) {
                float pixel = ip.getf(x * this.xshrink + x2, y * this.yshrink + y2);
                if (!(pixel < min2)) continue;
                min2 = pixel;
            }
        }
        return min2;
    }

    private float getMax(ImageProcessor ip, int x, int y) {
        float max = -3.4028235E38f;
        for (int y2 = 0; y2 < this.yshrink; ++y2) {
            for (int x2 = 0; x2 < this.xshrink; ++x2) {
                float pixel = ip.getf(x * this.xshrink + x2, y * this.yshrink + y2);
                if (!(pixel > max)) continue;
                max = pixel;
            }
        }
        return max;
    }

    private float getSum(ImageProcessor ip, int x, int y) {
        float sum = 0.0f;
        for (int y2 = 0; y2 < this.yshrink; ++y2) {
            for (int x2 = 0; x2 < this.xshrink; ++x2) {
                sum += ip.getf(x * this.xshrink + x2, y * this.yshrink + y2);
            }
        }
        if (this.maxValue > 0.0f && sum > this.maxValue) {
            sum = this.maxValue;
        }
        return sum;
    }

    private boolean showDialog(ImagePlus imp) {
        boolean stack;
        boolean bl = stack = imp.getStackSize() > 1;
        if (imp.isComposite() && imp.getNChannels() == imp.getStackSize()) {
            stack = false;
        }
        GenericDialog gd = new GenericDialog("Image Shrink");
        gd.addNumericField("X shrink factor:", this.xshrink, 0);
        gd.addNumericField("Y shrink factor:", this.yshrink, 0);
        if (stack) {
            gd.addNumericField("Z shrink factor:", this.zshrink, 0);
        }
        if (this.method > methods.length) {
            this.method = 0;
        }
        gd.addChoice("Bin Method: ", methods, methods[this.method]);
        if (imp.getStackSize() == 1) {
            gd.setInsets(5, 0, 0);
            gd.addMessage("This command supports Undo", null, Color.darkGray);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.xshrink = (int)gd.getNextNumber();
        this.yshrink = (int)gd.getNextNumber();
        if (stack) {
            this.zshrink = (int)gd.getNextNumber();
        }
        this.method = gd.getNextChoiceIndex();
        return true;
    }
}

