/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.CompilerTool;
import ij.plugin.Macro_Runner;
import ij.plugin.PlugIn;
import ij.plugin.PlugInExecuter;
import ij.plugin.frame.Editor;
import java.awt.Font;
import java.io.File;
import java.io.FilenameFilter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Vector;

public class Compiler
implements PlugIn,
FilenameFilter {
    private static final String info = "Library JAR files (e.g., imagescience.jar) should\nbe located in either plugins/jars or plugins/lib.\n \nThe javac command line will be displayed in\nthe Log window if ImageJ is in debug mode.";
    private static final int TARGET14 = 0;
    private static final int TARGET15 = 1;
    private static final int TARGET16 = 2;
    private static final int TARGET17 = 3;
    private static final int TARGET18 = 4;
    private static final int TARGET19 = 5;
    private static final String[] targets = new String[]{"1.4", "1.5", "1.6", "1.7", "1.8", "1.9"};
    private static final String TARGET_KEY = "javac.target";
    private static CompilerTool compilerTool;
    private static String dir;
    private static String name;
    private static Editor errors;
    private static boolean generateDebuggingInfo;
    private static int target;
    private static boolean checkForUpdateDone;

    @Override
    public void run(String arg) {
        if (arg.equals("edit")) {
            this.edit();
        } else if (arg.equals("options")) {
            this.showDialog();
        } else if (arg != null && arg.length() > 0 && !arg.endsWith(".java")) {
            IJ.error("Compiler", "File name must end with \".java\"");
        } else {
            this.compileAndRun(arg);
        }
    }

    void edit() {
        Editor ed;
        if (this.open("", "Open macro or plugin") && (ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "")) != null) {
            ed.open(dir, name);
        }
    }

    void compileAndRun(String path) {
        if (!this.open(path, "Compile and Run Plugin...")) {
            return;
        }
        if (name.endsWith(".class")) {
            this.runPlugin(name.substring(0, name.length() - 1));
            return;
        }
        if (!this.isJavac()) {
            boolean ok;
            Object compiler;
            if (IJ.debugMode) {
                IJ.log("Compiler: javac not found");
            }
            if (!checkForUpdateDone) {
                this.checkForUpdate("/plugins/compiler/Compiler.jar", "1.48c");
                checkForUpdateDone = true;
            }
            if ((compiler = IJ.runPlugIn("Compiler", dir + name)) == null && (ok = Macro_Runner.downloadJar("/plugins/compiler/Compiler.jar"))) {
                IJ.runPlugIn("Compiler", dir + name);
            }
            return;
        }
        if (this.compile(dir + name)) {
            this.runPlugin(name);
        }
    }

    private void checkForUpdate(String plugin, String currentVersion) {
        int slashIndex = plugin.lastIndexOf("/");
        if (slashIndex == -1 || !plugin.endsWith(".jar")) {
            return;
        }
        String className = plugin.substring(slashIndex + 1, plugin.length() - 4);
        File f = new File(Prefs.getImageJDir() + "plugins" + File.separator + "jars" + File.separator + className + ".jar");
        if (!f.exists() || !f.canWrite()) {
            if (IJ.debugMode) {
                IJ.log("checkForUpdate: jar not found (" + plugin + ")");
            }
            return;
        }
        String version = null;
        try {
            Class<?> c = IJ.getClassLoader().loadClass("Compiler");
            version = "0.00a";
            Method m4 = c.getDeclaredMethod("getVersion", new Class[0]);
            version = (String)m4.invoke(null, new Object[0]);
        }
        catch (Exception c) {
            // empty catch block
        }
        if (version == null) {
            if (IJ.debugMode) {
                IJ.log("checkForUpdate: class not found (" + className + ")");
            }
            return;
        }
        if (version.compareTo(currentVersion) >= 0) {
            if (IJ.debugMode) {
                IJ.log("checkForUpdate: up to date (" + className + "  " + version + ")");
            }
            return;
        }
        boolean ok = Macro_Runner.downloadJar(plugin);
        if (IJ.debugMode) {
            IJ.log("checkForUpdate: " + className + " " + version + " " + ok);
        }
    }

    boolean isJavac() {
        if (compilerTool == null) {
            compilerTool = CompilerTool.getDefault();
        }
        return compilerTool != null;
    }

    boolean compile(String path) {
        IJ.showStatus("compiling " + path);
        String classpath = this.getClassPath(path);
        Vector<String> options = new Vector<String>();
        if (generateDebuggingInfo) {
            options.addElement("-g");
        }
        this.validateTarget();
        options.addElement("-source");
        options.addElement(targets[target]);
        options.addElement("-target");
        options.addElement(targets[target]);
        options.addElement("-Xlint:unchecked");
        options.addElement("-deprecation");
        options.addElement("-classpath");
        options.addElement(classpath);
        Vector<String> sources = new Vector<String>();
        sources.add(path);
        if (IJ.debugMode) {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append("javac");
            for (i = 0; i < options.size(); ++i) {
                builder.append(" ");
                builder.append(options.get(i));
            }
            for (i = 0; i < sources.size(); ++i) {
                builder.append(" ");
                builder.append(sources.get(i));
            }
            IJ.log(builder.toString());
        }
        boolean errors = true;
        String s2 = "not compiled";
        if (compilerTool != null) {
            StringWriter outputWriter = new StringWriter();
            errors = !compilerTool.compile(sources, options, outputWriter);
            s2 = outputWriter.toString();
        } else {
            errors = true;
        }
        if (errors) {
            this.showErrors(s2);
        } else {
            IJ.showStatus("done");
        }
        return !errors;
    }

    String getClassPath(String path) {
        String pluginsDir;
        long start = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append(System.getProperty("java.class.path"));
        File f = new File(path);
        if (f != null) {
            sb.append(File.pathSeparator + f.getParent());
        }
        if ((pluginsDir = Menus.getPlugInsPath()) != null) {
            this.addJars(pluginsDir, sb);
        }
        return sb.toString();
    }

    void addJars(String path, StringBuffer sb) {
        String[] list = null;
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            list = f.list();
        }
        if (list == null) {
            return;
        }
        boolean isJarsFolder = path.endsWith("jars") || path.endsWith("lib");
        path = IJ.addSeparator(path);
        for (int i = 0; i < list.length; ++i) {
            File f2 = new File(path + list[i]);
            if (f2.isDirectory()) {
                this.addJars(path + list[i], sb);
                continue;
            }
            if (!list[i].endsWith(".jar") || list[i].contains("_") && !isJarsFolder) continue;
            sb.append(File.pathSeparator + path + list[i]);
        }
    }

    void showErrors(String s2) {
        if (errors == null || !errors.isVisible()) {
            errors = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
            errors.setFont(new Font("Monospaced", 0, errors.getFontSize()));
        }
        if (errors != null) {
            ImageJ ij = IJ.getInstance();
            if (ij != null) {
                s2 = ij.getInfo() + "\n \n" + s2;
            }
            errors.display("Errors", s2);
        }
        IJ.showStatus("done (errors)");
    }

    boolean open(String path, String msg) {
        boolean okay;
        String fileName;
        String directory;
        if (path.equals("")) {
            String lcName;
            if (dir == null) {
                dir = IJ.getDirectory("plugins");
            }
            OpenDialog od = new OpenDialog(msg, dir, name);
            directory = od.getDirectory();
            fileName = od.getFileName();
            okay = fileName != null;
            String string = lcName = okay ? fileName.toLowerCase(Locale.US) : null;
            if (okay) {
                if (msg.startsWith("Compile")) {
                    if (!lcName.endsWith(".java") && !lcName.endsWith(".class")) {
                        IJ.error("File name must end with \".java\" or \".class\".");
                        okay = false;
                    }
                } else if (!(lcName.endsWith(".java") || lcName.endsWith(".txt") || lcName.endsWith(".ijm") || lcName.endsWith(".js") || lcName.endsWith(".py") || lcName.endsWith(".bsh"))) {
                    IJ.error("File name must end with \".java\", \".txt\", \".ijm\", \".js\" or \".py\"");
                    okay = false;
                }
            }
        } else {
            int i = path.lastIndexOf(47);
            if (i == -1) {
                i = path.lastIndexOf(92);
            }
            if (i > 0) {
                directory = path.substring(0, i + 1);
                fileName = path.substring(i + 1);
            } else {
                directory = "";
                fileName = path;
            }
            okay = true;
        }
        if (okay) {
            name = fileName;
            dir = directory;
            Editor.setDefaultDirectory(dir);
        }
        return okay;
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.endsWith(".java") || name.endsWith(".macro") || name.endsWith(".txt");
    }

    void runPlugin(String name) {
        name = name.substring(0, name.length() - 5);
        new PlugInExecuter(name);
    }

    public void showDialog() {
        this.validateTarget();
        GenericDialog gd = new GenericDialog("Compile and Run");
        gd.addChoice("Target: ", targets, targets[target]);
        gd.setInsets(15, 5, 0);
        gd.addCheckbox("Generate debugging info (javac -g)", generateDebuggingInfo);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#compiler");
        Font font = IJ.font10;
        gd.addMessage(info, font);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        target = gd.getNextChoiceIndex();
        generateDebuggingInfo = gd.getNextBoolean();
        this.validateTarget();
    }

    void validateTarget() {
        if (target > 5) {
            target = 5;
        }
        if (target < 2) {
            target = 2;
        }
        if (target > 2 && IJ.javaVersion() < 7) {
            target = 2;
        }
        if (target > 3 && IJ.javaVersion() < 8) {
            target = 3;
        }
        if (target > 4 && IJ.javaVersion() < 9) {
            target = 4;
        }
        Prefs.set(TARGET_KEY, target);
    }

    static {
        target = (int)Prefs.get(TARGET_KEY, 4.0);
    }
}

