/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;

public class ContrastEnhancer
implements PlugIn,
Measurements {
    static final double defaultSaturated = 0.35;
    static double gSaturated = 0.35;
    static boolean gEqualize;
    double saturated = 0.35;
    int max;
    int range;
    boolean classicEqualization;
    int stackSize;
    boolean updateSelectionOnly;
    boolean equalize;
    boolean normalize;
    boolean processStack;
    boolean useStackHistogram;
    boolean entireImage;

    @Override
    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        this.stackSize = imp.getStackSize();
        imp.trimProcessor();
        if (!this.showDialog(imp)) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi != null) {
            roi.endPaste();
        }
        if (this.stackSize == 1) {
            Undo.setup(6, imp);
        } else {
            Undo.reset();
        }
        if (this.equalize) {
            this.equalize(imp);
        } else {
            this.stretchHistogram(imp, this.saturated);
        }
        if (this.normalize) {
            ImageProcessor ip;
            ip.setMinAndMax(0.0, (ip = imp.getProcessor()).getBitDepth() == 32 ? 1.0 : ip.maxValue());
        }
        imp.updateAndDraw();
    }

    boolean showDialog(ImagePlus imp) {
        Roi roi;
        boolean isMacro;
        String options;
        String string = options = IJ.isMacro() ? Macro.getOptions() : null;
        if (options != null && options.contains("normalize_all")) {
            Macro.setOptions(options.replaceAll("normalize_all", "process_all"));
        }
        boolean bl = isMacro = options != null;
        if (!isMacro) {
            this.equalize = gEqualize;
            this.saturated = gSaturated;
        }
        int bitDepth = imp.getBitDepth();
        boolean composite = imp.isComposite();
        if (composite) {
            this.stackSize = 1;
        }
        boolean areaRoi = (roi = imp.getRoi()) != null && roi.isArea() && !composite;
        GenericDialog gd = new GenericDialog("Enhance Contrast");
        gd.addNumericField("Saturated pixels:", this.saturated, 2, 5, "%");
        if (bitDepth != 24 && !composite) {
            gd.addCheckbox("Normalize", this.normalize);
        }
        if (areaRoi) {
            String label = bitDepth == 24 ? "Update entire image" : "Update all when normalizing";
            gd.addCheckbox(label, this.entireImage);
        }
        gd.addCheckbox("Equalize histogram", this.equalize);
        if (this.stackSize > 1) {
            if (!composite) {
                gd.addCheckbox("Process_all " + this.stackSize + " slices", this.processStack);
            }
            gd.addCheckbox("Use stack histogram", this.useStackHistogram);
        }
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#enhance");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.saturated = gd.getNextNumber();
        this.normalize = bitDepth != 24 && !composite ? gd.getNextBoolean() : false;
        if (areaRoi) {
            this.entireImage = gd.getNextBoolean();
            boolean bl2 = this.updateSelectionOnly = !this.entireImage;
            if (!this.normalize && bitDepth != 24) {
                this.updateSelectionOnly = false;
            }
        }
        this.equalize = gd.getNextBoolean();
        this.processStack = this.stackSize > 1 ? gd.getNextBoolean() : false;
        boolean bl3 = this.useStackHistogram = this.stackSize > 1 ? gd.getNextBoolean() : false;
        if (this.saturated < 0.0) {
            this.saturated = 0.0;
        }
        if (this.saturated > 100.0) {
            this.saturated = 100.0;
        }
        if (this.processStack && !this.equalize) {
            this.normalize = true;
        }
        if (!isMacro) {
            gEqualize = this.equalize;
            gSaturated = this.saturated;
        }
        return true;
    }

    public void stretchHistogram(ImagePlus imp, double saturated) {
        ImageStatistics stats = null;
        if (this.useStackHistogram) {
            stats = new StackStatistics(imp);
        }
        if (this.processStack) {
            ImageStack stack = imp.getStack();
            int size = this.stackSize == 0 ? stack.size() : this.stackSize;
            for (int i = 1; i <= size; ++i) {
                IJ.showProgress(i, size);
                ImageProcessor ip = stack.getProcessor(i);
                ip.setRoi(imp.getRoi());
                if (!this.useStackHistogram) {
                    stats = ImageStatistics.getStatistics(ip, 16, null);
                }
                this.stretchHistogram(ip, saturated, stats);
            }
        } else {
            ImageProcessor ip = imp.getProcessor();
            ip.setRoi(imp.getRoi());
            if (stats == null) {
                stats = ImageStatistics.getStatistics(ip, 16, null);
            }
            if (imp.isComposite()) {
                this.stretchCompositeImageHistogram((CompositeImage)imp, saturated, stats);
            } else {
                this.stretchHistogram(ip, saturated, stats);
            }
        }
    }

    public void stretchHistogram(ImageProcessor ip, double saturated) {
        this.useStackHistogram = false;
        this.stretchHistogram(new ImagePlus("", ip), saturated);
    }

    public void stretchHistogram(ImageProcessor ip, double saturated, ImageStatistics stats) {
        int hmin;
        int[] a = this.getMinAndMax(ip, saturated, stats);
        int hmax = a[1];
        if (hmax > (hmin = a[0])) {
            double min2 = stats.histMin + (double)hmin * stats.binSize;
            double max = stats.histMin + (double)hmax * stats.binSize;
            if (stats.histogram16 != null && ip instanceof ShortProcessor) {
                min2 = hmin;
                max = hmax;
            }
            if (!this.updateSelectionOnly) {
                ip.resetRoi();
            }
            if (this.normalize) {
                this.normalize(ip, min2, max);
            } else if (this.updateSelectionOnly) {
                ImageProcessor mask = ip.getMask();
                if (mask != null) {
                    ip.snapshot();
                }
                ip.setMinAndMax(min2, max);
                if (mask != null) {
                    ip.reset(mask);
                }
            } else {
                ip.setMinAndMax(min2, max);
            }
        }
    }

    void stretchCompositeImageHistogram(CompositeImage imp, double saturated, ImageStatistics stats) {
        int hmin;
        ImageProcessor ip = imp.getProcessor();
        int[] a = this.getMinAndMax(ip, saturated, stats);
        int hmax = a[1];
        if (hmax > (hmin = a[0])) {
            double min2 = stats.histMin + (double)hmin * stats.binSize;
            double max = stats.histMin + (double)hmax * stats.binSize;
            if (stats.histogram16 != null && imp.getBitDepth() == 16) {
                min2 = hmin;
                max = hmax;
            }
            imp.setDisplayRange(min2, max);
        }
    }

    int[] getMinAndMax(ImageProcessor ip, double saturated, ImageStatistics stats) {
        int[] histogram = stats.histogram;
        if (stats.histogram16 != null && ip instanceof ShortProcessor) {
            histogram = stats.histogram16;
        }
        int hsize = histogram.length;
        int threshold = saturated > 0.0 ? (int)((double)stats.pixelCount * saturated / 200.0) : 0;
        int i = -1;
        boolean found = false;
        int count = 0;
        int maxindex = hsize - 1;
        do {
            boolean bl = found = (count += histogram[++i]) > threshold;
        } while (!found && i < maxindex);
        int hmin = i;
        i = hsize;
        count = 0;
        do {
            boolean bl = found = (count += histogram[--i]) > threshold;
        } while (!found && i > 0);
        int hmax = i;
        int[] a = new int[]{hmin, hmax};
        return a;
    }

    void normalize(ImageProcessor ip, double min2, double max) {
        boolean min22 = false;
        int max2 = 255;
        int range = 256;
        if (ip instanceof ShortProcessor) {
            max2 = 65535;
            range = 65536;
        } else if (ip instanceof FloatProcessor) {
            this.normalizeFloat(ip, min2, max);
        }
        int[] lut = new int[range];
        for (int i = 0; i < range; ++i) {
            lut[i] = (double)i <= min2 ? 0 : ((double)i >= max ? max2 : (int)(((double)i - min2) / (max - min2) * (double)max2));
        }
        this.applyTable(ip, lut);
    }

    void applyTable(ImageProcessor ip, int[] lut) {
        if (this.updateSelectionOnly) {
            ImageProcessor mask = ip.getMask();
            if (mask != null) {
                ip.snapshot();
            }
            ip.applyTable(lut);
            if (mask != null) {
                ip.reset(mask);
            }
        } else {
            ip.applyTable(lut);
        }
    }

    void normalizeFloat(ImageProcessor ip, double min2, double max) {
        double scale = max > min2 ? 1.0 / (max - min2) : 1.0;
        int size = ip.getWidth() * ip.getHeight();
        float[] pixels = (float[])ip.getPixels();
        for (int i = 0; i < size; ++i) {
            double v = (double)pixels[i] - min2;
            if (v < 0.0) {
                v = 0.0;
            }
            if ((v *= scale) > 1.0) {
                v = 1.0;
            }
            pixels[i] = (float)v;
        }
    }

    public void equalize(ImagePlus imp) {
        ImageStack stack;
        if (imp.getBitDepth() == 32) {
            IJ.showMessage("Contrast Enhancer", "Equalization of 32-bit images not supported.");
            return;
        }
        this.classicEqualization = IJ.altKeyDown();
        int[] histogram = null;
        if (this.useStackHistogram) {
            StackStatistics stats = new StackStatistics(imp);
            histogram = stats.histogram;
            if (stats.histogram16 != null && imp.getBitDepth() == 16) {
                histogram = stats.histogram16;
            }
        }
        if (this.processStack) {
            stack = imp.getStack();
            int size = this.stackSize == 0 ? stack.size() : this.stackSize;
            for (int i = 1; i <= size; ++i) {
                IJ.showProgress(i, size);
                ImageProcessor ip = stack.getProcessor(i);
                if (histogram == null) {
                    histogram = ip.getHistogram();
                }
                this.equalize(ip, histogram);
            }
        } else {
            ImageProcessor ip = imp.getProcessor();
            if (histogram == null) {
                histogram = ip.getHistogram();
            }
            this.equalize(ip, histogram);
        }
        if (imp.getBitDepth() == 16 && this.processStack && imp.getStackSize() > 1) {
            stack = imp.getStack();
            ImageProcessor ip = stack.getProcessor(stack.size() / 2);
            ImageStatistics stats = ip.getStats();
            imp.getProcessor().setMinAndMax(stats.min, stats.max);
        } else {
            imp.getProcessor().resetMinAndMax();
        }
    }

    public void equalize(ImageProcessor ip) {
        this.equalize(ip, ip.getHistogram());
    }

    private void equalize(ImageProcessor ip, int[] histogram) {
        ip.resetRoi();
        if (ip instanceof ShortProcessor) {
            this.max = 65535;
            this.range = 65535;
        } else {
            this.max = 255;
            this.range = 255;
        }
        double sum = this.getWeightedValue(histogram, 0);
        for (int i = 1; i < this.max; ++i) {
            sum += 2.0 * this.getWeightedValue(histogram, i);
        }
        double scale = (double)this.range / (sum += this.getWeightedValue(histogram, this.max));
        int[] lut = new int[this.range + 1];
        lut[0] = 0;
        sum = this.getWeightedValue(histogram, 0);
        for (int i = 1; i < this.max; ++i) {
            double delta = this.getWeightedValue(histogram, i);
            lut[i] = (int)Math.round((sum += delta) * scale);
            sum += delta;
        }
        lut[this.max] = this.max;
        this.applyTable(ip, lut);
    }

    private double getWeightedValue(int[] histogram, int i) {
        int h2 = histogram[i];
        if (h2 < 2 || this.classicEqualization) {
            return h2;
        }
        return Math.sqrt(h2);
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setProcessStack(boolean processStack) {
        this.processStack = processStack;
        this.normalize = true;
    }

    public void setUseStackHistogram(boolean useStackHistogram) {
        this.useStackHistogram = useStackHistogram;
    }
}

