/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.Toolbar;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.FolderOpener;
import ij.plugin.PlugIn;
import ij.plugin.TextReader;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DragAndDrop
implements PlugIn,
DropTargetListener,
Runnable {
    private Iterator iterator;
    private static boolean convertToRGB;
    private static boolean virtualStack;
    private boolean openAsVirtualStack;

    @Override
    public void run(String arg) {
        ImageJ ij = IJ.getInstance();
        ij.setDropTarget(null);
        new DropTarget(ij, this);
        new DropTarget(Toolbar.getInstance(), this);
        new DropTarget(ij.getStatusBar(), this);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(1);
        DataFlavor[] flavors = null;
        try {
            Transferable t2 = dtde.getTransferable();
            this.iterator = null;
            flavors = t2.getTransferDataFlavors();
            if (IJ.debugMode) {
                IJ.log("DragAndDrop.drop: " + flavors.length + " flavors");
            }
            for (int i = 0; i < flavors.length; ++i) {
                String tmp;
                Object ob;
                if (IJ.debugMode) {
                    IJ.log("  flavor[" + i + "]: " + flavors[i].getMimeType());
                }
                if (flavors[i].isFlavorJavaFileListType()) {
                    Object data = t2.getTransferData(DataFlavor.javaFileListFlavor);
                    this.iterator = ((List)data).iterator();
                    break;
                }
                if (!flavors[i].isFlavorTextType() || !((ob = t2.getTransferData(flavors[i])) instanceof String)) continue;
                String s2 = ob.toString().trim();
                if (IJ.isLinux() && s2.length() > 1 && s2.charAt(1) == '\u0000') {
                    s2 = this.fixLinuxString(s2);
                }
                ArrayList<Object> list = new ArrayList<Object>();
                if (s2.indexOf("href=\"") != -1 || s2.indexOf("src=\"") != -1) {
                    s2 = this.parseHTML(s2);
                    if (IJ.debugMode) {
                        IJ.log("  url: " + s2);
                    }
                    list.add(s2);
                    this.iterator = list.iterator();
                    break;
                }
                BufferedReader br = new BufferedReader(new StringReader(s2));
                while (null != (tmp = br.readLine())) {
                    if ((tmp = URLDecoder.decode(tmp.replaceAll("\\+", "%2b"), "UTF-8")).startsWith("file://")) {
                        tmp = tmp.substring(7);
                    }
                    if (IJ.debugMode) {
                        IJ.log("  content: " + tmp);
                    }
                    if (tmp.startsWith("http://")) {
                        list.add(s2);
                        continue;
                    }
                    list.add(new File(tmp));
                }
                this.iterator = list.iterator();
                break;
            }
            if (this.iterator != null) {
                Thread thread2 = new Thread((Runnable)this, "DrawAndDrop");
                thread2.setPriority(Math.max(thread2.getPriority() - 1, 1));
                thread2.start();
            }
        }
        catch (Exception e) {
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
        if (flavors == null || flavors.length == 0) {
            if (IJ.isMacOSX()) {
                IJ.error("First drag and drop ignored. Please try again. You can avoid this\nproblem by dragging to the toolbar instead of the status bar.");
            } else {
                IJ.error("Drag and drop failed");
            }
        }
    }

    private String fixLinuxString(String s2) {
        StringBuffer sb = new StringBuffer(200);
        for (int i = 0; i < s2.length(); i += 2) {
            sb.append(s2.charAt(i));
        }
        return new String(sb);
    }

    private String parseHTML(String s2) {
        int index2;
        int index1;
        if (IJ.debugMode) {
            IJ.log("parseHTML:\n" + s2);
        }
        if ((index1 = s2.indexOf("src=\"")) >= 0 && (index2 = s2.indexOf("\"", index1 + 5)) > 0) {
            return s2.substring(index1 + 5, index2);
        }
        index1 = s2.indexOf("href=\"");
        if (index1 >= 0 && (index2 = s2.indexOf("\"", index1 + 6)) > 0) {
            return s2.substring(index1 + 6, index2);
        }
        return s2;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        IJ.showStatus("<<Drag and Drop>>");
        if (IJ.debugMode) {
            IJ.log("DragEnter: " + e.getLocation());
        }
        e.acceptDrag(1);
        this.openAsVirtualStack = false;
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (IJ.debugMode) {
            IJ.log("DragOver: " + e.getLocation());
        }
        Point loc = e.getLocation();
        int width = IJ.getInstance().getSize().width;
        int buttonSize = Toolbar.getButtonSize();
        boolean bl = this.openAsVirtualStack = width - loc.x <= buttonSize + buttonSize / 3;
        if (this.openAsVirtualStack) {
            IJ.showStatus("<<Open as virtual stack or text image>>");
        } else {
            IJ.showStatus("<<Drag and Drop>>");
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        IJ.showStatus("");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void run() {
        Iterator iterator2 = this.iterator;
        while (iterator2.hasNext()) {
            Object obj = iterator2.next();
            String str = "" + obj;
            if (str != null && str.startsWith("https:/")) {
                if (!str.startsWith("https://")) {
                    str = str.replace("https:/", "https://");
                }
                obj = str;
            }
            if (obj != null && obj instanceof String) {
                this.openURL((String)obj);
                continue;
            }
            this.openFile((File)obj);
        }
    }

    private void openURL(String url) {
        if (IJ.debugMode) {
            IJ.log("DragAndDrop.openURL: " + url);
        }
        if (url != null) {
            IJ.open(url);
        }
    }

    public void openFile(File f) {
        block17: {
            if (IJ.debugMode) {
                IJ.log("DragAndDrop.openFile: " + f);
            }
            try {
                if (null == f) {
                    return;
                }
                String path = f.getCanonicalPath();
                if (f.exists()) {
                    if (f.isDirectory()) {
                        if (this.openAsVirtualStack) {
                            IJ.run("Image Sequence...", "open=[" + path + "] sort use");
                        } else {
                            this.openDirectory(f, path);
                        }
                    } else {
                        if (this.openAsVirtualStack && (path.endsWith(".tif") || path.endsWith(".TIF"))) {
                            new FileInfoVirtualStack().run(path);
                        } else if (this.openAsVirtualStack && (path.endsWith(".avi") || path.endsWith(".AVI"))) {
                            IJ.run("AVI...", "open=[" + path + "] use");
                        } else if (this.openAsVirtualStack && path.endsWith(".txt")) {
                            ImageProcessor ip = new TextReader().open(path);
                            if (ip != null) {
                                new ImagePlus(f.getName(), ip).show();
                            }
                        } else {
                            Recorder.recordOpen(path);
                            new Opener().openAndAddToRecent(path);
                        }
                        OpenDialog.setLastDirectory(f.getParent() + File.separator);
                        OpenDialog.setLastName(f.getName());
                        OpenDialog.setDefaultDirectory(f.getParent());
                    }
                } else {
                    IJ.log("File not found: " + path);
                }
            }
            catch (Throwable e) {
                if ("Macro canceled".equals(e.getMessage())) break block17;
                IJ.handleException(e);
            }
        }
    }

    private void openDirectory(File f, String path) {
        if (path == null) {
            return;
        }
        path = IJ.addSeparator(path);
        String[] names = f.list();
        if ((names = new FolderOpener().trimFileList(names)) == null) {
            return;
        }
        FolderOpener fo = new FolderOpener();
        fo.setDirectory(path);
        fo.run("");
    }
}

