/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.CanvasResizer;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Duplicator
implements PlugIn,
TextListener,
ItemListener {
    private static boolean staticDuplicateStack;
    private static boolean staticIgnoreSelection;
    private static boolean ignoreNextSelection;
    private boolean duplicateStack;
    private boolean ignoreSelection;
    private int first;
    private int last;
    private Checkbox stackCheckbox;
    private TextField titleField;
    private TextField rangeField;
    private TextField[] rangeFields;
    private int firstC;
    private int lastC;
    private int firstZ;
    private int lastZ;
    private int firstT;
    private int lastT;
    private String defaultTitle;
    private String sliceLabel;
    private ImagePlus imp;
    private boolean legacyMacro;
    private boolean titleChanged;
    private GenericDialog gd;

    @Override
    public void run(String arg) {
        ImagePlus imp2;
        String newTitle;
        boolean isRotatedRect;
        this.imp = IJ.getImage();
        Roi roiA = this.imp.getRoi();
        ImagePlus impA = this.imp;
        boolean bl = isRotatedRect = roiA != null && roiA instanceof RotatedRectRoi;
        if (isRotatedRect) {
            Rectangle bounds = this.imp.getRoi().getBounds();
            this.imp.setRoi(bounds);
        }
        if (roiA != null) {
            Rectangle r = roiA.getBounds();
            if (r.x >= this.imp.getWidth() || r.y >= this.imp.getHeight() || r.x + r.width <= 0 || r.y + r.height <= 0) {
                IJ.error("Roi is outside image");
                return;
            }
        }
        int stackSize = this.imp.getStackSize();
        String title = this.imp.getTitle();
        this.defaultTitle = newTitle = WindowManager.getUniqueName(this.imp, title);
        this.duplicateStack = staticDuplicateStack && !IJ.isMacro();
        boolean bl2 = this.ignoreSelection = (staticIgnoreSelection || ignoreNextSelection) && Macro.getOptions() == null;
        if (!IJ.altKeyDown() || stackSize > 1) {
            if (this.imp.isHyperStack() || this.imp.isComposite()) {
                this.duplicateHyperstack(this.imp, newTitle);
                if (isRotatedRect) {
                    this.straightenRotatedRect(impA, roiA, IJ.getImage());
                }
                return;
            }
            newTitle = this.showDialog(this.imp, "Duplicate...", "Title: ");
        }
        if (newTitle == null) {
            if (isRotatedRect) {
                this.imp.setRoi(roiA);
            }
            return;
        }
        Roi roi = this.imp.getRoi();
        if (this.ignoreSelection && roi != null) {
            this.imp.deleteRoi();
        }
        if (this.duplicateStack && (this.first > 1 || this.last < stackSize)) {
            imp2 = this.run(this.imp, this.first, this.last);
        } else if (this.duplicateStack || this.imp.getStackSize() == 1) {
            imp2 = this.run(this.imp);
            if (this.imp.getStackSize() == 1) {
                this.recordCrop(this.imp);
            }
        } else {
            imp2 = this.crop(this.imp);
            this.recordCrop(this.imp);
        }
        if (this.ignoreSelection && roi != null) {
            this.imp.setRoi(roi);
        }
        Calibration cal = imp2.getCalibration();
        if (roi != null && (cal.xOrigin != 0.0 || cal.yOrigin != 0.0)) {
            cal.xOrigin -= (double)roi.getBounds().x;
            cal.yOrigin -= (double)roi.getBounds().y;
        }
        imp2.setTitle(newTitle);
        imp2.setProp("UniqueName", "true");
        if (roi != null && roi.isArea() && roi.getType() != 0) {
            Roi roi2 = (Roi)this.cropRoi(this.imp, roi).clone();
            roi2.setLocation(0, 0);
            imp2.setRoi(roi2);
        }
        imp2.show();
        if (stackSize > 1 && imp2.getStackSize() == stackSize) {
            imp2.setSlice(this.imp.getCurrentSlice());
        }
        if (isRotatedRect) {
            this.straightenRotatedRect(impA, roiA, imp2);
        }
    }

    private void recordCrop(ImagePlus imp) {
        if (!Recorder.record) {
            return;
        }
        if (imp.getStackSize() == 1) {
            if (imp.getRoi() == null || this.ignoreSelection) {
                Recorder.recordCall("imp = imp.duplicate();");
            } else {
                Recorder.recordCall("imp = imp.crop();");
            }
        } else if (imp.getRoi() == null || this.ignoreSelection) {
            if (this.duplicateStack) {
                Recorder.recordCall("imp = imp.duplicate();");
            } else {
                Recorder.recordCall("imp = imp.crop(\"whole-slice\");");
            }
        } else if (this.duplicateStack) {
            Recorder.recordCall("imp = imp.crop();");
        } else {
            Recorder.recordCall("imp = imp.crop(\"slice\");");
        }
    }

    private void straightenRotatedRect(ImagePlus impA, Roi roiA, ImagePlus impB) {
        impB.deleteRoi();
        Color colorBack = Toolbar.getBackgroundColor();
        IJ.setBackgroundColor(0, 0, 0);
        String title = impB.getTitle();
        if (impB.getOverlay() != null) {
            impB.getOverlay().clear();
        }
        int boundLeft = roiA.getBounds().x;
        int boundTop = roiA.getBounds().y;
        int boundWidth = roiA.getBounds().width;
        int boundHeight = roiA.getBounds().height;
        float[] xx = roiA.getFloatPolygon().xpoints;
        float[] yy = roiA.getFloatPolygon().ypoints;
        double dx1 = xx[1] - xx[0];
        double dy1 = yy[1] - yy[0];
        double dx2 = xx[2] - xx[1];
        double dy2 = yy[2] - yy[1];
        double rrWidth = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double rrHeight = Math.sqrt(dx2 * dx2 + dy2 * dy2);
        double rrDia = Math.sqrt(rrWidth * rrWidth + rrHeight * rrHeight);
        double phi1 = -Math.atan2(dy1, dx1);
        double phi0 = phi1 * 180.0 / Math.PI;
        double usedL = Math.max(boundLeft, 0);
        double usedR = Math.min(boundLeft + boundWidth, impA.getWidth());
        double usedT = Math.max(boundTop, 0);
        double usedB = Math.min(boundTop + boundHeight, impA.getHeight());
        double usedCX = (usedL + usedR) / 2.0;
        double usedCY = (usedT + usedB) / 2.0;
        double boundsCX = boundLeft + boundWidth / 2;
        double boundsCY = boundTop + boundHeight / 2;
        double dx3 = boundsCX - usedCX;
        double dy3 = boundsCY - usedCY;
        double rad3 = Math.sqrt(dx3 * dx3 + dy3 * dy3);
        double phi3 = Math.atan2(dy3, dx3);
        double phi4 = phi3 + phi1;
        double dx4 = -rad3 * Math.cos(phi4);
        double dy4 = -rad3 * Math.sin(phi4);
        ImageStack stackOld = impB.getStack();
        int currentSlice = impB.getCurrentSlice();
        double xOff = (rrDia - (usedR - usedL)) / 2.0;
        double yOff = (rrDia - (usedB - usedT)) / 2.0;
        ImageStack stackNew = new CanvasResizer().expandStack(stackOld, (int)rrDia, (int)rrDia, (int)xOff, (int)yOff);
        impB.setStack(stackNew);
        ImageProcessor ip = impB.getProcessor();
        ip.setInterpolationMethod(1);
        ip.setBackgroundValue(0.0);
        for (int slc = 0; slc < stackNew.size(); ++slc) {
            impB.setSlice(slc + 1);
            ip.rotate(phi0);
            ip.translate(dx4, dy4);
        }
        int x = (impB.getWidth() - (int)rrWidth) / 2;
        int y = (impB.getHeight() - (int)rrHeight) / 2;
        impB.setStack(impB.getStack().crop(x, y, 0, (int)rrWidth, (int)rrHeight, impB.getStack().getSize()));
        impB.setSlice(currentSlice);
        impB.setTitle(title);
        impB.show();
        impB.updateAndDraw();
        impA.setRoi(roiA);
        Toolbar.setBackgroundColor(colorBack);
    }

    public ImagePlus run(ImagePlus imp) {
        Overlay overlay;
        if (imp.getStackSize() == 1) {
            return this.crop(imp);
        }
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        Roi roi2 = this.cropRoi(imp, roi);
        if (roi2 != null && roi2.isArea()) {
            rect = roi2.getBounds();
        }
        ImageStack stack = imp.getStack();
        boolean virtualStack = stack.isVirtual();
        double min2 = imp.getDisplayRangeMin();
        double max = imp.getDisplayRangeMax();
        ImageStack stack2 = null;
        int n = stack.size();
        boolean showProgress = virtualStack || (double)n * (double)stack.getWidth() * (double)stack.getHeight() >= 2.097152E8;
        for (int i = 1; i <= n; ++i) {
            if (showProgress) {
                IJ.showStatus("Duplicating: " + i + "/" + n);
                IJ.showProgress(i, n);
            }
            ImageProcessor ip2 = stack.getProcessor(i);
            ip2.setRoi(rect);
            ip2 = ip2.crop();
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight(), imp.getProcessor().getColorModel());
            }
            stack2.addSlice(stack.getSliceLabel(i), ip2);
        }
        IJ.showProgress(1.0);
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        String info = (String)imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        imp2.setProperties(imp.getPropertiesAsArray());
        imp2.setCalibration(imp.getCalibration());
        int[] dim = imp.getDimensions();
        imp2.setDimensions(dim[2], dim[3], dim[4]);
        if (imp.isComposite()) {
            imp2 = new CompositeImage(imp2, 0);
            ((CompositeImage)imp2).copyLuts(imp);
        }
        if (virtualStack) {
            imp2.setDisplayRange(min2, max);
        }
        if (imp.isHyperStack()) {
            imp2.setOpenAsHyperStack(true);
        }
        if ((overlay = imp.getOverlay()) != null && !imp.getHideOverlay()) {
            imp2.setOverlay(overlay.crop(rect));
        }
        if (Recorder.record) {
            if (imp.getRoi() == null || this.ignoreSelection) {
                Recorder.recordCall("imp = imp.duplicate();");
            } else {
                Recorder.recordCall("imp = imp.crop(\"stack\");");
            }
        }
        return imp2;
    }

    public ImagePlus crop(ImagePlus imp) {
        if (imp.getNChannels() > 1 && imp.getCompositeMode() == 1) {
            int z = imp.getSlice();
            int t2 = imp.getFrame();
            return this.run(imp, 1, imp.getNChannels(), z, z, t2, t2);
        }
        boolean hyperstack = imp.isHyperStack();
        int displayMode = imp.isComposite() ? imp.getDisplayMode() : 0;
        ImageProcessor ip = imp.getProcessor();
        ImageProcessor ip2 = ip.crop();
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setProcessor("DUP_" + imp.getTitle(), ip2);
        String info = (String)imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        imp2.setProperties(imp.getPropertiesAsArray());
        if (imp.isStack()) {
            ImageStack stack = imp.getStack();
            String label = stack.getSliceLabel(imp.getCurrentSlice());
            if (label != null) {
                if (label.length() > 250 && label.indexOf(10) > 0 && label.contains("0002,")) {
                    imp2.setProperty("Info", label);
                } else {
                    imp2.setProp("Slice_Label", label);
                }
            }
            if (imp.isComposite()) {
                LUT lut = ((CompositeImage)imp).getChannelLut();
                if (displayMode == 3) {
                    imp2.getProcessor().setColorModel(null);
                } else {
                    imp2.getProcessor().setColorModel(lut);
                }
            }
        } else {
            String label = imp.getProp("Slice_Label");
            if (label != null) {
                imp2.setProp("Slice_Label", label);
            }
        }
        Overlay overlay = imp.getOverlay();
        if (overlay != null && !imp.getHideOverlay()) {
            Overlay overlay2 = overlay.crop(ip.getRoi());
            if (imp.getStackSize() > 1) {
                if (hyperstack) {
                    int c = imp.getC();
                    int z = imp.getZ();
                    int t3 = imp.getT();
                    overlay2.crop(c, c, z, z, t3, t3);
                } else {
                    overlay2.crop(imp.getCurrentSlice(), imp.getCurrentSlice());
                }
            }
            imp2.setOverlay(overlay2);
        }
        return imp2;
    }

    public ImagePlus run(ImagePlus imp, int firstSlice, int lastSlice) {
        Overlay overlay;
        boolean tseries;
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            rect = roi.getBounds();
        }
        ImageStack stack = imp.getStack();
        boolean virtualStack = stack.isVirtual();
        double min2 = imp.getDisplayRangeMin();
        double max = imp.getDisplayRangeMax();
        ImageStack stack2 = null;
        int n = lastSlice - firstSlice + 1;
        boolean showProgress = virtualStack || (double)n * (double)stack.getWidth() * (double)stack.getHeight() >= 2.097152E8;
        for (int i = firstSlice; i <= lastSlice; ++i) {
            if (showProgress) {
                IJ.showStatus("Duplicating: " + i + "/" + lastSlice);
                IJ.showProgress(i - firstSlice, n);
            }
            ImageProcessor ip2 = stack.getProcessor(i);
            ip2.setRoi(rect);
            ip2 = ip2.crop();
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight(), imp.getProcessor().getColorModel());
            }
            stack2.addSlice(stack.getSliceLabel(i), ip2);
        }
        IJ.showProgress(1.0);
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        String info = (String)imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        imp2.setProperties(imp.getPropertiesAsArray());
        int size = stack2.getSize();
        boolean bl = tseries = imp.getNFrames() == imp.getStackSize();
        if (tseries) {
            imp2.setDimensions(1, 1, size);
        } else {
            imp2.setDimensions(1, size, 1);
        }
        if (virtualStack) {
            imp2.setDisplayRange(min2, max);
        }
        if ((overlay = imp.getOverlay()) != null && !imp.getHideOverlay()) {
            Overlay overlay2 = overlay.crop(rect);
            overlay2.crop(firstSlice, lastSlice);
            imp2.setOverlay(overlay2);
        }
        if (Recorder.record) {
            Recorder.recordCall("imp = imp.crop(\"" + firstSlice + "-" + lastSlice + "\");");
        }
        return imp2;
    }

    public ImagePlus run(ImagePlus imp, int firstC, int lastC, int firstZ, int lastZ, int firstT, int lastT) {
        Overlay overlay;
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        Roi roi2 = this.cropRoi(imp, roi);
        if (roi2 != null && roi2.isArea()) {
            rect = roi2.getBounds();
        }
        ImageStack stack = imp.getStack();
        ImageStack stack2 = null;
        for (int t2 = firstT; t2 <= lastT; ++t2) {
            for (int z = firstZ; z <= lastZ; ++z) {
                for (int c = firstC; c <= lastC; ++c) {
                    int n1 = imp.getStackIndex(c, z, t2);
                    ImageProcessor ip = stack.getProcessor(n1);
                    String label = stack.getSliceLabel(n1);
                    ip.setRoi(rect);
                    ip = ip.crop();
                    if (stack2 == null) {
                        stack2 = new ImageStack(ip.getWidth(), ip.getHeight(), null);
                    }
                    stack2.addSlice(label, ip);
                }
            }
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        imp2.setDimensions(lastC - firstC + 1, lastZ - firstZ + 1, lastT - firstT + 1);
        if (imp.isComposite()) {
            int mode = imp.getDisplayMode();
            if (lastC > firstC) {
                imp2 = new CompositeImage(imp2, mode);
                int i2 = 1;
                for (int i = firstC; i <= lastC; ++i) {
                    LUT lut = ((CompositeImage)imp).getChannelLut(i);
                    ((CompositeImage)imp2).setChannelLut(lut, i2++);
                }
                if (imp.getNChannels() == imp2.getNChannels()) {
                    boolean[] active = ((CompositeImage)imp).getActiveChannels();
                    boolean[] active2 = ((CompositeImage)imp2).getActiveChannels();
                    if (active != null && active2 != null && active.length == active2.length) {
                        for (int i = 0; i < active.length; ++i) {
                            active2[i] = active[i];
                        }
                    }
                }
            } else if (firstC == lastC) {
                LUT lut = ((CompositeImage)imp).getChannelLut(firstC);
                if (mode == 3) {
                    imp2.getProcessor().setColorModel(null);
                } else {
                    imp2.getProcessor().setColorModel(lut);
                }
                imp2.setDisplayRange(lut.min, lut.max);
            }
        }
        imp2.setOpenAsHyperStack(true);
        Calibration cal = imp2.getCalibration();
        if (roi != null && (cal.xOrigin != 0.0 || cal.yOrigin != 0.0)) {
            cal.xOrigin -= (double)roi.getBounds().x;
            cal.yOrigin -= (double)roi.getBounds().y;
        }
        if ((overlay = imp.getOverlay()) != null && !imp.getHideOverlay()) {
            Overlay overlay2 = overlay.crop(roi2 != null ? roi2.getBounds() : null);
            int nChannels = imp.getNChannels();
            int nSlices = imp.getNSlices();
            int nFrames = imp.getNFrames();
            if (firstC != 1 || lastC != nChannels || firstZ != 1 || lastZ != nSlices || firstT != 1 || lastT != nFrames) {
                overlay2.crop(firstC, lastC, firstZ, lastZ, firstT, lastT);
            }
            imp2.setOverlay(overlay2);
        }
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp, " + firstC + ", " + lastC + ", " + firstZ + ", " + lastZ + ", " + firstT + ", " + lastT + ");");
        }
        return imp2;
    }

    String showDialog(ImagePlus imp, String dialogTitle, String prompt) {
        GenericDialog gd;
        int stackSize = imp.getStackSize();
        String options = Macro.getOptions();
        boolean isRoi = imp.getRoi() != null;
        boolean isMacro = options != null;
        this.duplicateStack = stackSize > 1 && this.duplicateStack && !isMacro;
        this.legacyMacro = options != null && (options.contains("duplicate") || !options.contains("use"));
        String title = this.getNewTitle();
        if (title == null) {
            title = this.defaultTitle;
        }
        this.gd = gd = new GenericDialog(dialogTitle);
        gd.addStringField(prompt, title, 15);
        if (isRoi) {
            gd.addCheckbox("Ignore selection", this.ignoreSelection);
        }
        if (stackSize > 1) {
            gd.addCheckbox("Duplicate stack", this.duplicateStack);
            gd.setInsets(2, 30, 3);
            gd.addStringField("Range:", "1-" + stackSize);
            if (!isMacro) {
                this.stackCheckbox = (Checkbox)gd.getCheckboxes().elementAt(gd.getCheckboxes().size() - 1);
                this.stackCheckbox.addItemListener(this);
                Vector v = gd.getStringFields();
                this.titleField = (TextField)v.elementAt(0);
                this.rangeField = (TextField)v.elementAt(1);
                this.titleField.addTextListener(this);
                this.rangeField.addTextListener(this);
            }
        }
        gd.setSmartRecording(true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        title = gd.getNextString();
        if (isRoi) {
            this.ignoreSelection = gd.getNextBoolean();
        }
        if (stackSize > 1) {
            this.duplicateStack = gd.getNextBoolean();
            if (this.duplicateStack) {
                String[] range = Tools.split(gd.getNextString(), " -");
                double d1 = gd.parseDouble(range[0]);
                double d2 = range.length == 2 ? gd.parseDouble(range[1]) : Double.NaN;
                this.first = Double.isNaN(d1) ? 1 : (int)d1;
                int n = this.last = Double.isNaN(d2) ? stackSize : (int)d2;
                if (this.first < 1) {
                    this.first = 1;
                }
                if (this.last > stackSize) {
                    this.last = stackSize;
                }
                if (this.first > this.last) {
                    this.first = 1;
                    this.last = stackSize;
                }
            } else {
                this.first = 1;
                this.last = stackSize;
            }
        }
        if (!isMacro) {
            staticDuplicateStack = this.duplicateStack;
            if (!ignoreNextSelection) {
                staticIgnoreSelection = this.ignoreSelection;
            }
        }
        ignoreNextSelection = false;
        if (Recorder.record && this.titleField != null && this.titleField.getText().equals(this.sliceLabel)) {
            Recorder.recordOption("use");
        }
        return title;
    }

    private String getNewTitle() {
        if (this.titleChanged) {
            return null;
        }
        String title = this.defaultTitle;
        if (!(this.imp.getStackSize() <= 1 || this.duplicateStack || this.legacyMacro || this.stackCheckbox != null && this.stackCheckbox.getState())) {
            ImageStack stack = this.imp.getStack();
            String label = stack.getShortSliceLabel(this.imp.getCurrentSlice());
            if (label != null && label.length() == 0) {
                label = null;
            }
            if (label != null) {
                title = label;
                this.sliceLabel = label;
            }
        }
        return title;
    }

    void duplicateHyperstack(ImagePlus imp, String newTitle) {
        if ((newTitle = this.showHSDialog(imp, newTitle)) == null) {
            return;
        }
        ImagePlus imp2 = null;
        Roi roi = imp.getRoi();
        if (!this.duplicateStack) {
            boolean singleComposite;
            int nChannels = imp.getNChannels();
            boolean bl = singleComposite = imp.isComposite() && nChannels == imp.getStackSize();
            if (!singleComposite && nChannels > 1 && imp.isComposite() && ((CompositeImage)imp).getMode() == 1) {
                this.firstC = 1;
                this.lastC = nChannels;
            } else {
                this.firstC = this.lastC = imp.getChannel();
            }
            this.firstZ = this.lastZ = imp.getSlice();
            this.firstT = this.lastT = imp.getFrame();
        }
        if ((imp2 = this.run(imp, this.firstC, this.lastC, this.firstZ, this.lastZ, this.firstT, this.lastT)) == null) {
            return;
        }
        imp2.setTitle(newTitle);
        if (imp2.getWidth() == 0 || imp2.getHeight() == 0) {
            IJ.error("Duplicator", "Selection is outside the image");
            return;
        }
        if (roi != null && roi.isArea() && roi.getType() != 0) {
            Roi roi2 = (Roi)this.cropRoi(imp, roi).clone();
            roi2.setLocation(0, 0);
            imp2.setRoi(roi2);
        }
        imp2.show();
        imp2.setPosition(imp.getC(), imp.getZ(), imp.getT());
        if (IJ.isMacro() && imp2.getWindow() != null) {
            IJ.wait(50);
        }
    }

    String showHSDialog(ImagePlus imp, String newTitle) {
        String[] range;
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        boolean composite = imp.isComposite() && nChannels == imp.getStackSize();
        String options = Macro.getOptions();
        boolean isMacro = options != null;
        GenericDialog gd = new GenericDialog("Duplicate");
        gd.addStringField("Title:", newTitle, 15);
        gd.setInsets(12, 20, 8);
        gd.addCheckbox("Duplicate hyperstack", this.duplicateStack && !isMacro || composite);
        int nRangeFields = 0;
        if (nChannels > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Channels (c):", "1-" + nChannels);
            ++nRangeFields;
        }
        if (nSlices > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Slices (z):", "1-" + nSlices);
            ++nRangeFields;
        }
        if (nFrames > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Frames (t):", "1-" + nFrames);
            ++nRangeFields;
        }
        if (!isMacro) {
            this.stackCheckbox = (Checkbox)gd.getCheckboxes().elementAt(gd.getCheckboxes().size() - 1);
            this.stackCheckbox.addItemListener(this);
            Vector v = gd.getStringFields();
            this.rangeFields = new TextField[3];
            for (int i = 0; i < nRangeFields; ++i) {
                this.rangeFields[i] = (TextField)v.elementAt(i + 1);
                this.rangeFields[i].addTextListener(this);
            }
        }
        gd.setSmartRecording(true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        newTitle = gd.getNextString();
        this.duplicateStack = gd.getNextBoolean();
        if (nChannels > 1) {
            range = Tools.split(gd.getNextString(), " -");
            double c1 = gd.parseDouble(range[0]);
            double c2 = range.length == 2 ? gd.parseDouble(range[1]) : Double.NaN;
            this.firstC = Double.isNaN(c1) ? 1 : (int)c1;
            int n = this.lastC = Double.isNaN(c2) ? this.firstC : (int)c2;
            if (this.firstC < 1) {
                this.firstC = 1;
            }
            if (this.lastC > nChannels) {
                this.lastC = nChannels;
            }
            if (this.firstC > this.lastC) {
                this.firstC = 1;
                this.lastC = nChannels;
            }
        } else {
            this.lastC = 1;
            this.firstC = 1;
        }
        if (nSlices > 1) {
            range = Tools.split(gd.getNextString(), " -");
            double z1 = gd.parseDouble(range[0]);
            double z2 = range.length == 2 ? gd.parseDouble(range[1]) : Double.NaN;
            this.firstZ = Double.isNaN(z1) ? 1 : (int)z1;
            int n = this.lastZ = Double.isNaN(z2) ? this.firstZ : (int)z2;
            if (this.firstZ < 1) {
                this.firstZ = 1;
            }
            if (this.lastZ > nSlices) {
                this.lastZ = nSlices;
            }
            if (this.firstZ > this.lastZ) {
                this.firstZ = 1;
                this.lastZ = nSlices;
            }
        } else {
            this.lastZ = 1;
            this.firstZ = 1;
        }
        if (nFrames > 1) {
            range = Tools.split(gd.getNextString(), " -");
            double t1 = gd.parseDouble(range[0]);
            double t2 = range.length == 2 ? gd.parseDouble(range[1]) : Double.NaN;
            this.firstT = Double.isNaN(t1) ? 1 : (int)t1;
            int n = this.lastT = Double.isNaN(t2) ? this.firstT : (int)t2;
            if (this.firstT < 1) {
                this.firstT = 1;
            }
            if (this.lastT > nFrames) {
                this.lastT = nFrames;
            }
            if (this.firstT > this.lastT) {
                this.firstT = 1;
                this.lastT = nFrames;
            }
        } else {
            this.lastT = 1;
            this.firstT = 1;
        }
        if (!isMacro) {
            staticDuplicateStack = this.duplicateStack;
        }
        return newTitle;
    }

    Roi cropRoi(ImagePlus imp, Roi roi) {
        if (roi == null) {
            return null;
        }
        if (imp == null) {
            return roi;
        }
        Rectangle b = roi.getBounds();
        int w = imp.getWidth();
        int h2 = imp.getHeight();
        if (b.x < 0 || b.y < 0 || b.x + b.width > w || b.y + b.height > h2) {
            ShapeRoi shape1 = new ShapeRoi(roi);
            ShapeRoi shape2 = new ShapeRoi(new Roi(0, 0, w, h2));
            roi = shape2.and(shape1);
        }
        if (roi.getBounds().width == 0 || roi.getBounds().height == 0) {
            throw new IllegalArgumentException("Selection is outside the image");
        }
        return roi;
    }

    public static Overlay cropOverlay(Overlay overlay, Rectangle bounds) {
        return overlay.crop(bounds);
    }

    @Override
    public void textValueChanged(TextEvent e) {
        if (IJ.debugMode) {
            IJ.log("Duplicator.textValueChanged: " + e);
        }
        if (e.getSource() == this.titleField) {
            if (!this.titleField.getText().equals(this.getNewTitle())) {
                this.titleChanged = true;
            }
        } else {
            this.stackCheckbox.setState(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String title;
        this.duplicateStack = this.stackCheckbox.getState();
        if (this.titleField != null && (title = this.getNewTitle()) != null && !title.equals(this.titleField.getText())) {
            this.titleField.setText(title);
            if (this.gd != null) {
                this.gd.setDefaultString(0, title);
            }
        }
    }

    public static void ignoreNextSelection() {
        ignoreNextSelection = true;
    }
}

