/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.EllipseRoi;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.io.FileInfo;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.AVI_Reader;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.ListVirtualStack;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;

public class ImageInfo
implements PlugIn {
    @Override
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.showInfo();
        } else {
            String info = this.getImageInfo(imp);
            if (info.contains("----")) {
                this.showInfo(imp, info, 450, 600);
            } else {
                int inc = info.contains("No selection") ? 0 : 130;
                this.showInfo(imp, info, 400, 500 + inc);
            }
        }
    }

    private void showInfo() {
        String s2 = new String("");
        if (IJ.getInstance() != null) {
            s2 = s2 + IJ.getInstance().getInfo() + "\n \n";
        }
        s2 = s2 + "No images are open\n";
        Dimension screen = IJ.getScreenSize();
        s2 = s2 + "ImageJ home: " + IJ.getDir("imagej") + "\n";
        s2 = s2 + "Java home: " + System.getProperty("java.home") + "\n";
        s2 = s2 + "Java version: " + IJ.javaVersion() + "\n";
        s2 = s2 + "Screen size: " + screen.width + "x" + screen.height + "\n";
        s2 = s2 + "GUI scale: " + IJ.d2s(Prefs.getGuiScale(), 2) + "\n";
        String path = Prefs.getCustomPropsPath();
        if (path != null) {
            s2 = s2 + "*Custom properties*: " + path + "\n";
        }
        if ((path = Prefs.getCustomPrefsPath()) != null) {
            s2 = s2 + "*Custom preferences*: " + path + "\n";
        }
        new TextWindow("Info", s2, 600, 300);
    }

    public String getImageInfo(ImagePlus imp) {
        String properties;
        ImageStack stack;
        String label;
        ImageProcessor ip = imp.getProcessor();
        String infoProperty = null;
        if ((imp.getStackSize() > 1 || imp.isStack()) && (label = (stack = imp.getStack()).getSliceLabel(imp.getCurrentSlice())) != null && label.indexOf(10) > 0) {
            infoProperty = label;
        }
        if (infoProperty == null && (infoProperty = (String)imp.getProperty("Info")) == null) {
            infoProperty = this.getExifData(imp);
        }
        if (imp.getProp("HideInfo") == null && (properties = this.getImageProperties(imp)) != null) {
            infoProperty = infoProperty != null ? properties + "\n" + infoProperty : properties;
        }
        String info = this.getInfo(imp, ip);
        if (infoProperty != null) {
            return infoProperty + "--------------------------------------------\n" + info;
        }
        return info;
    }

    public String getExifData(ImagePlus imp) {
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi == null) {
            return null;
        }
        String directory = fi.directory;
        String name = fi.fileName;
        if (directory == null) {
            return null;
        }
        if ((name == null || name.equals("")) && imp.getStack().isVirtual()) {
            name = imp.getStack().getSliceLabel(imp.getCurrentSlice());
        }
        if (name == null || !name.endsWith("jpg") && !name.endsWith("JPG")) {
            return null;
        }
        String path = directory + name;
        String metadata = null;
        try {
            Class<?> c = IJ.getClassLoader().loadClass("Exif_Reader");
            if (c == null) {
                return null;
            }
            String methodName = "getMetadata";
            Class[] argClasses = new Class[]{methodName.getClass()};
            Method m4 = c.getMethod("getMetadata", argClasses);
            Object[] args2 = new Object[]{path};
            Object obj = m4.invoke(null, args2);
            metadata = obj != null ? obj.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
        if (metadata != null && !metadata.startsWith("Error:")) {
            return metadata;
        }
        return null;
    }

    private String getInfo(ImagePlus imp, ImageProcessor ip) {
        double[] p;
        Roi roi;
        String pinfo;
        ImageWindow win;
        double mag;
        String label;
        String s2 = new String("");
        if (IJ.getInstance() != null) {
            s2 = s2 + IJ.getInstance().getInfo() + "\n \n";
        }
        s2 = s2 + "Title: " + imp.getTitle() + "\n";
        Calibration cal = imp.getCalibration();
        int stackSize = imp.getStackSize();
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int digits = imp.getBitDepth() == 32 ? 4 : 0;
        boolean nonUniformUnits = !cal.getXUnit().equals(cal.getYUnit());
        String xunit = cal.getXUnit();
        String yunit = cal.getYUnit();
        String zunit = cal.getZUnit();
        if (cal.scaled()) {
            String xunits;
            String yunits = xunits = cal.getUnits();
            String zunits = xunits;
            if (nonUniformUnits) {
                xunits = xunit;
                yunits = yunit;
                zunits = zunit;
            }
            double pw = (double)imp.getWidth() * cal.pixelWidth;
            double ph = (double)imp.getHeight() * cal.pixelHeight;
            s2 = s2 + "Width:  " + this.d2s(pw) + " " + xunits + " (" + imp.getWidth() + ")\n";
            s2 = s2 + "Height:  " + this.d2s(ph) + " " + yunits + " (" + imp.getHeight() + ")\n";
            if (slices > 1) {
                double pd = (double)slices * cal.pixelDepth;
                s2 = s2 + "Depth:  " + this.d2s(pd) + " " + zunits + " (" + slices + ")\n";
            }
            s2 = s2 + "Size:  " + ImageWindow.getImageSize(imp) + "\n";
            double xResolution = 1.0 / cal.pixelWidth;
            double yResolution = 1.0 / cal.pixelHeight;
            if (xResolution == yResolution) {
                s2 = s2 + "Resolution:  " + this.d2s(xResolution) + " pixels per " + xunit + "\n";
            } else {
                s2 = s2 + "X Resolution:  " + this.d2s(xResolution) + " pixels per " + xunit + "\n";
                s2 = s2 + "Y Resolution:  " + this.d2s(yResolution) + " pixels per " + yunit + "\n";
            }
        } else {
            s2 = s2 + "Width:  " + imp.getWidth() + " pixels\n";
            s2 = s2 + "Height:  " + imp.getHeight() + " pixels\n";
            if (stackSize > 1) {
                s2 = s2 + "Depth:  " + slices + " pixels\n";
            }
            s2 = s2 + "Size:  " + ImageWindow.getImageSize(imp) + "\n";
        }
        if (stackSize > 1) {
            String vunit = cal.getUnit() + "^3";
            if (nonUniformUnits) {
                vunit = "(" + xunit + " x " + yunit + " x " + zunit + ")";
            }
            s2 = s2 + "Voxel size: " + this.d2s(cal.pixelWidth) + "x" + this.d2s(cal.pixelHeight) + "x" + this.d2s(cal.pixelDepth) + " " + vunit + "\n";
        } else {
            String punit = cal.getUnit() + "^2";
            if (nonUniformUnits) {
                punit = "(" + xunit + " x " + yunit + ")";
            }
            int dp = Tools.getDecimalPlaces(cal.pixelWidth, cal.pixelHeight);
            s2 = s2 + "Pixel size: " + this.d2s(cal.pixelWidth) + "x" + this.d2s(cal.pixelHeight) + " " + punit + "\n";
        }
        s2 = s2 + "ID: " + imp.getID() + "\n";
        int type = imp.getType();
        switch (type) {
            case 0: {
                s2 = s2 + "Bits per pixel: 8 ";
                String lut = "LUT";
                lut = imp.getProcessor().isColorLut() ? "color " + lut : "grayscale " + lut;
                if (imp.isInvertedLut()) {
                    lut = "inverting " + lut;
                }
                s2 = s2 + "(" + lut + ")\n";
                if (imp.getNChannels() > 1) {
                    s2 = s2 + this.displayRanges(imp);
                    break;
                }
                s2 = s2 + "Display range: " + (int)ip.getMin() + "-" + (int)ip.getMax() + "\n";
                break;
            }
            case 1: 
            case 2: {
                if (type == 1) {
                    String sign = cal.isSigned16Bit() ? "signed" : "unsigned";
                    s2 = s2 + "Bits per pixel: 16 (" + sign + ")\n";
                } else {
                    s2 = s2 + "Bits per pixel: 32 (float)\n";
                }
                if (imp.getNChannels() > 1) {
                    s2 = s2 + this.displayRanges(imp);
                    break;
                }
                s2 = s2 + "Display range: ";
                double min2 = ip.getMin();
                double max = ip.getMax();
                if (cal.calibrated()) {
                    min2 = cal.getCValue((int)min2);
                    max = cal.getCValue((int)max);
                }
                s2 = s2 + this.d2s(min2) + " - " + this.d2s(max) + "\n";
                break;
            }
            case 3: {
                s2 = s2 + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                s2 = s2 + "Bits per pixel: 32 (RGB)\n";
            }
        }
        String lutName = imp.getProp("CurrentLUT");
        if (lutName != null) {
            s2 = s2 + "LUT name: " + lutName + "\n";
        }
        double interval = cal.frameInterval;
        double fps = cal.fps;
        if (stackSize > 1) {
            ImageStack stack = imp.getStack();
            int slice = imp.getCurrentSlice();
            String number = slice + "/" + stackSize;
            String label2 = stack.getSliceLabel(slice);
            if (label2 != null && label2.contains("\n")) {
                label2 = stack.getShortSliceLabel(slice);
            }
            label2 = label2 != null && label2.length() > 0 ? " (" + label2 + ")" : "";
            if (interval > 0.0 || fps != 0.0) {
                s2 = s2 + "Frame: " + number + label2 + "\n";
                if (fps != 0.0) {
                    String sRate = Math.abs(fps - (double)Math.round(fps)) < 1.0E-5 ? IJ.d2s(fps, 0) : IJ.d2s(fps, 5);
                    s2 = s2 + "Frame rate: " + sRate + " fps\n";
                }
                if (interval != 0.0) {
                    s2 = s2 + "Frame interval: " + ((double)((int)interval) == interval ? IJ.d2s(interval, 0) : IJ.d2s(interval, 5)) + " " + cal.getTimeUnit() + "\n";
                }
            } else {
                s2 = s2 + "Image: " + number + label2 + "\n";
            }
            if (imp.isHyperStack()) {
                if (channels > 1) {
                    s2 = s2 + "  Channel: " + imp.getChannel() + "/" + channels + "\n";
                }
                if (slices > 1) {
                    s2 = s2 + "  Slice: " + imp.getSlice() + "/" + slices + "\n";
                }
                if (frames > 1) {
                    s2 = s2 + "  Frame: " + imp.getFrame() + "/" + frames + "\n";
                }
            }
            if (imp.isComposite()) {
                if (!imp.isHyperStack() && channels > 1) {
                    s2 = s2 + "  Channels: " + channels + "\n";
                }
                String mode = ((CompositeImage)imp).getModeAsString();
                s2 = s2 + "  Composite mode: \"" + mode + "\"\n";
            }
            if (stack.isVirtual()) {
                String stackType = "virtual";
                if (stack instanceof AVI_Reader) {
                    stackType = stackType + " (AVI Reader)";
                }
                if (stack instanceof FileInfoVirtualStack) {
                    stackType = stackType + " (FileInfoVirtualStack)";
                }
                if (stack instanceof ListVirtualStack) {
                    stackType = stackType + " (ListVirtualStack)";
                }
                s2 = s2 + "Stack type: " + stackType + "\n";
            }
        } else if (imp.isStack() && (label = imp.getStack().getShortSliceLabel(1)) != null && label.length() > 0) {
            s2 = s2 + "Image: 1/1 (" + label + ")\n";
        }
        if (imp.isLocked()) {
            s2 = s2 + "**Locked**\n";
        }
        if (ip.getMinThreshold() == -808080.0) {
            s2 = s2 + "No threshold\n";
        } else {
            double lower = ip.getMinThreshold();
            double upper = ip.getMaxThreshold();
            String uncalibrated = "";
            if (cal.calibrated()) {
                uncalibrated = " (" + (int)lower + "-" + (int)upper + ")";
                lower = cal.getCValue((int)lower);
                upper = cal.getCValue((int)upper);
            }
            int lutMode = ip.getLutUpdateMode();
            String mode = "red";
            switch (lutMode) {
                case 1: {
                    mode = "B&W";
                    break;
                }
                case 2: {
                    mode = "invisible";
                    break;
                }
                case 3: {
                    mode = "over/under";
                }
            }
            s2 = s2 + "Threshold: " + this.d2s(lower) + "-" + this.d2s(upper) + uncalibrated + " (" + mode + ")\n";
        }
        ImageCanvas ic = imp.getCanvas();
        double d = mag = ic != null ? ic.getMagnification() : 1.0;
        if (mag != 1.0) {
            s2 = s2 + "Magnification: " + IJ.d2s(mag, 2) + "\n";
        }
        if (ic != null) {
            s2 = s2 + "ScaleToFit: " + ic.getScaleToFit() + "\n";
        }
        String valueUnit = cal.getValueUnit();
        if (cal.calibrated()) {
            s2 = s2 + " \n";
            int curveFit = cal.getFunction();
            s2 = s2 + "Calibration function: ";
            s2 = curveFit == 21 ? s2 + "Uncalibrated OD\n" : (curveFit == 22 ? s2 + "Custom lookup table\n" : s2 + CurveFitter.fList[curveFit] + "\n");
            double[] c = cal.getCoefficients();
            if (c != null) {
                s2 = s2 + "  a: " + IJ.d2s(c[0], 6) + "\n";
                s2 = s2 + "  b: " + IJ.d2s(c[1], 6) + "\n";
                if (c.length >= 3) {
                    s2 = s2 + "  c: " + IJ.d2s(c[2], 6) + "\n";
                }
                if (c.length >= 4) {
                    s2 = s2 + "  c: " + IJ.d2s(c[3], 6) + "\n";
                }
                if (c.length >= 5) {
                    s2 = s2 + "  c: " + IJ.d2s(c[4], 6) + "\n";
                }
            }
            s2 = s2 + "  Unit: \"" + valueUnit + "\"\n";
        } else if (valueUnit != null && !valueUnit.equals("Gray Value")) {
            s2 = s2 + "Calibration function: None\n";
            s2 = s2 + "  Unit: \"" + valueUnit + "\"\n";
        } else {
            s2 = s2 + "Uncalibrated\n";
        }
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            if (fi.url != null && !fi.url.equals("")) {
                s2 = s2 + "URL: " + fi.url + "\n";
            } else {
                String defaultDir;
                String string = defaultDir = fi.directory == null || fi.directory.length() == 0 ? System.getProperty("user.dir") : "";
                if (defaultDir.length() > 0) {
                    defaultDir = defaultDir.replaceAll("\\\\", "/");
                    defaultDir = defaultDir + "/";
                }
                s2 = s2 + "Path: " + defaultDir + fi.getFilePath() + "\n";
            }
        }
        if ((win = imp.getWindow()) != null) {
            Point loc = win.getLocation();
            Rectangle bounds = GUI.getScreenBounds(win);
            s2 = s2 + "Screen location: " + (loc.x - bounds.x) + "," + (loc.y - bounds.y) + " (" + bounds.width + "x" + bounds.height + ")\n";
        }
        if (IJ.isMacOSX()) {
            String time = " (" + ImageWindow.setMenuBarTime + "ms)";
            s2 = s2 + "SetMenuBarCount: " + Menus.setMenuBarCount + time + "\n";
        }
        String zOrigin = stackSize > 1 || cal.zOrigin != 0.0 ? "," + this.d2s(cal.zOrigin) : "";
        String origin = this.d2s(cal.xOrigin) + "," + this.d2s(cal.yOrigin) + zOrigin;
        if (!origin.equals("0,0") || cal.getInvertY()) {
            s2 = s2 + "Coordinate origin:  " + origin + "\n";
        }
        if (cal.getInvertY()) {
            s2 = s2 + "Inverted y coordinates\n";
        }
        s2 = !(pinfo = imp.getPropsInfo()).equals("0") ? s2 + "Properties: " + pinfo + "\n" : s2 + "No properties\n";
        Overlay overlay = imp.getOverlay();
        if (overlay != null) {
            int n = overlay.size();
            String elements = n == 1 ? " element" : " elements";
            String selectable = overlay.isSelectable() ? " selectable " : " non-selectable ";
            String hidden = imp.getHideOverlay() ? " (hidden)" : "";
            s2 = s2 + "Overlay: " + n + selectable + elements + hidden + "\n";
        } else {
            s2 = s2 + "No overlay\n";
        }
        Interpreter interp = Interpreter.getInstance();
        if (interp != null) {
            s2 = s2 + "Macro is running" + (Interpreter.isBatchMode() ? " in batch mode" : "") + "\n";
        }
        if ((roi = imp.getRoi()) == null) {
            if (cal.calibrated()) {
                s2 = s2 + " \n";
            }
            s2 = s2 + "No selection\n";
        } else if (roi instanceof RotatedRectRoi) {
            s2 = s2 + "\nRotated rectangle selection\n";
            p = ((RotatedRectRoi)roi).getParams();
            double dx = p[2] - p[0];
            double dy = p[3] - p[1];
            double major = Math.sqrt(dx * dx + dy * dy);
            s2 = s2 + "  Length: " + IJ.d2s(major, 2) + "\n";
            s2 = s2 + "  Width: " + IJ.d2s(p[4], 2) + "\n";
            s2 = s2 + "  X1: " + IJ.d2s(p[0], 2) + "\n";
            s2 = s2 + "  Y1: " + IJ.d2s(p[1], 2) + "\n";
            s2 = s2 + "  X2: " + IJ.d2s(p[2], 2) + "\n";
            s2 = s2 + "  Y2: " + IJ.d2s(p[3], 2) + "\n";
        } else if (roi instanceof EllipseRoi) {
            s2 = s2 + "\nElliptical selection\n";
            p = ((EllipseRoi)roi).getParams();
            double dx = p[2] - p[0];
            double dy = p[3] - p[1];
            double major = Math.sqrt(dx * dx + dy * dy);
            s2 = s2 + "  Major: " + IJ.d2s(major, 2) + "\n";
            s2 = s2 + "  Minor: " + IJ.d2s(major * p[4], 2) + "\n";
            s2 = s2 + "  X1: " + IJ.d2s(p[0], 2) + "\n";
            s2 = s2 + "  Y1: " + IJ.d2s(p[1], 2) + "\n";
            s2 = s2 + "  X2: " + IJ.d2s(p[2], 2) + "\n";
            s2 = s2 + "  Y2: " + IJ.d2s(p[3], 2) + "\n";
            s2 = s2 + "  Aspect ratio: " + IJ.d2s(p[4], 2) + "\n";
        } else {
            String name;
            s2 = s2 + " \n";
            s2 = s2 + roi.getTypeAsString() + " Selection";
            String points = null;
            if (roi instanceof PointRoi) {
                int npoints = ((PolygonRoi)roi).getNCoordinates();
                String suffix = npoints > 1 ? "s)" : ")";
                points = " (" + npoints + " point" + suffix;
            }
            if ((name = roi.getName()) != null) {
                s2 = s2 + " (\"" + name + "\")";
                if (points != null) {
                    s2 = s2 + "\n " + points;
                }
            } else if (points != null) {
                s2 = s2 + points;
            }
            s2 = s2 + "\n";
            if (roi instanceof Line) {
                Line line = (Line)roi;
                s2 = s2 + "  X1: " + IJ.d2s(cal.getX(line.x1d)) + "\n";
                s2 = s2 + "  Y1: " + IJ.d2s(cal.getY(line.y1d, imp.getHeight())) + "\n";
                s2 = s2 + "  X2: " + IJ.d2s(cal.getX(line.x2d)) + "\n";
                s2 = s2 + "  Y2: " + IJ.d2s(cal.getY(line.y2d, imp.getHeight())) + "\n";
            } else {
                int decimals;
                Rectangle2D.Double r = roi.getFloatBounds();
                int n = decimals = r.x == (double)((int)r.x) && r.y == (double)((int)r.y) && r.width == (double)((int)r.width) && r.height == (double)((int)r.height) ? 0 : 2;
                if (cal.scaled()) {
                    s2 = s2 + "  X: " + IJ.d2s(cal.getX(r.x)) + " (" + IJ.d2s(r.x, decimals) + ")\n";
                    s2 = s2 + "  Y: " + IJ.d2s(cal.getY(r.y, imp.getHeight())) + " (" + IJ.d2s(this.yy(r.y, imp), decimals) + ")\n";
                    s2 = s2 + "  Width: " + IJ.d2s(r.width * cal.pixelWidth) + " (" + IJ.d2s(r.width, decimals) + ")\n";
                    s2 = s2 + "  Height: " + IJ.d2s(r.height * cal.pixelHeight) + " (" + IJ.d2s(r.height, decimals) + ")\n";
                } else {
                    s2 = s2 + "  X: " + IJ.d2s(r.x, decimals) + "\n";
                    s2 = s2 + "  Y: " + IJ.d2s(this.yy(r.y, imp), decimals) + "\n";
                    s2 = s2 + "  Width: " + IJ.d2s(r.width, decimals) + "\n";
                    s2 = s2 + "  Height: " + IJ.d2s(r.height, decimals) + "\n";
                }
            }
        }
        return s2;
    }

    private String displayRanges(ImagePlus imp) {
        LUT[] luts = imp.getLuts();
        if (luts == null) {
            return "";
        }
        String s2 = "Display ranges\n";
        int n = luts.length;
        if (n > 7) {
            n = 7;
        }
        for (int i = 0; i < n; ++i) {
            double min2 = luts[i].min;
            double max = luts[i].max;
            s2 = s2 + "  " + (i + 1) + ": " + this.d2s(min2) + "-" + this.d2s(max) + "\n";
        }
        return s2;
    }

    private int yy(int y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    private double yy(double y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    private void showInfo(ImagePlus imp, String info, int width, int height) {
        new TextWindow("Info for " + imp.getTitle(), info, width, height);
    }

    private String d2s(double n) {
        return IJ.d2s(n, Tools.getDecimalPlaces(n));
    }

    private String getImageProperties(ImagePlus imp) {
        String s2 = "";
        String[] props = imp.getPropertiesAsArray();
        if (props == null) {
            return null;
        }
        for (int i = 0; i < props.length; i += 2) {
            String key = props[i];
            String value = props[i + 1];
            if ("CurrentLUT".equals(key) || "UniqueName".equals(key) || key == null || value == null || key.equals("ShowInfo") || key.equals("Slice_Label")) continue;
            s2 = value.length() < 80 ? s2 + key + ": " + value + "\n" : s2 + key + ": <" + value.length() + " characters>\n";
        }
        return s2.length() > 0 ? s2 : null;
    }
}

