/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GUI;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.applet.Applet;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class JavaProperties
implements PlugIn {
    ArrayList list = new ArrayList();

    @Override
    public void run(String arg) {
        this.show("java.version");
        this.show("java.vendor");
        if (IJ.isMacintosh()) {
            this.show("mrj.version");
        }
        this.show("os.name");
        this.show("os.version");
        this.show("os.arch");
        this.show("file.separator");
        this.show("path.separator");
        String s2 = System.getProperty("line.separator");
        String str2 = "";
        char ch1 = s2.charAt(0);
        String str1 = ch1 == '\r' ? "<cr>" : "<lf>";
        if (s2.length() == 2) {
            char ch2 = s2.charAt(1);
            str2 = ch2 == '\r' ? "<cr>" : "<lf>";
        }
        this.list.add("  line.separator: " + str1 + str2);
        Applet applet = IJ.getApplet();
        if (applet != null) {
            this.list.add("");
            this.list.add("  code base: " + applet.getCodeBase());
            this.list.add("  document base: " + applet.getDocumentBase());
            this.list.add("  sample images dir: " + Prefs.getImagesURL());
            TextWindow tw = new TextWindow("Properties", "", this.list, 400, 400);
            return;
        }
        this.list.add("");
        this.show("user.name");
        this.show("user.home");
        this.show("user.dir");
        this.show("user.country");
        this.show("file.encoding");
        this.show("java.home");
        this.show("java.compiler");
        this.show("java.class.path");
        this.show("java.ext.dirs");
        this.show("java.io.tmpdir");
        this.list.add("");
        String userDir = System.getProperty("user.dir");
        String userHome = System.getProperty("user.home");
        String osName = System.getProperty("os.name");
        String path = Prefs.getCustomPropsPath();
        if (path != null) {
            this.list.add("  *Custom properties*: " + path);
        }
        if ((path = Prefs.getCustomPrefsPath()) != null) {
            this.list.add("  *Custom preferences*: " + path);
        }
        this.list.add("  IJ.getVersion: " + IJ.getVersion());
        this.list.add("  IJ.getFullVersion: " + IJ.getFullVersion());
        this.list.add("  IJ.javaVersion: " + IJ.javaVersion());
        this.list.add("  IJ.isJava18(): " + IJ.isJava18());
        this.list.add("  IJ.isLinux: " + IJ.isLinux());
        this.list.add("  IJ.isMacintosh: " + IJ.isMacintosh());
        this.list.add("  IJ.isMacOSX: " + IJ.isMacOSX());
        this.list.add("  IJ.isWindows: " + IJ.isWindows());
        this.list.add("  IJ.is64Bit: " + IJ.is64Bit());
        this.list.add("");
        this.list.add("  IJ.getDir(\"imagej\"): " + IJ.getDir("imagej"));
        this.list.add("  IJ.getDir(\"home\"): " + IJ.getDir("home"));
        this.list.add("  IJ.getDir(\"plugins\"): " + IJ.getDir("plugins"));
        this.list.add("  IJ.getDir(\"macros\"): " + IJ.getDir("macros"));
        this.list.add("  IJ.getDir(\"luts\"): " + IJ.getDir("luts"));
        this.list.add("  IJ.getDir(\"current\"): " + IJ.getDir("current"));
        this.list.add("  IJ.getDir(\"cwd\"): " + IJ.getDir("cwd"));
        this.list.add("  IJ.getDir(\"temp\"): " + IJ.getDir("temp"));
        this.list.add("  IJ.getDir(\"default\"): " + IJ.getDir("default"));
        this.list.add("  IJ.getDir(\"image\"): " + IJ.getDir("image"));
        this.list.add("  IJ.getDir(\"preferences\"): " + IJ.getDir("preferences"));
        this.list.add("");
        this.list.add("  Menus.getPlugInsPath: " + Menus.getPlugInsPath());
        this.list.add("  Menus.getMacrosPath: " + Menus.getMacrosPath());
        this.list.add("  Prefs.getImageJDir: " + Prefs.getImageJDir());
        this.list.add("  Prefs.getThreads: " + Prefs.getThreads() + this.cores());
        this.list.add("  Prefs.open100Percent: " + Prefs.open100Percent);
        this.list.add("  Prefs.blackBackground: " + Prefs.blackBackground);
        this.list.add("  Prefs.useJFileChooser: " + Prefs.useJFileChooser);
        this.list.add("  Prefs.weightedColor: " + Prefs.weightedColor);
        this.list.add("  Prefs.blackCanvas: " + Prefs.blackCanvas);
        this.list.add("  Prefs.pointAutoMeasure: " + Prefs.pointAutoMeasure);
        this.list.add("  Prefs.pointAutoNextSlice: " + Prefs.pointAutoNextSlice);
        this.list.add("  Prefs.requireControlKey: " + Prefs.requireControlKey);
        this.list.add("  Prefs.useInvertingLut: " + Prefs.useInvertingLut);
        this.list.add("  Prefs.antialiasedTools: " + Prefs.antialiasedTools);
        this.list.add("  Prefs.useInvertingLut: " + Prefs.useInvertingLut);
        this.list.add("  Prefs.intelByteOrder: " + Prefs.intelByteOrder);
        this.list.add("  Prefs.noPointLabels: " + Prefs.noPointLabels);
        this.list.add("  Prefs.disableUndo: " + Prefs.disableUndo);
        this.list.add("  Prefs dir: " + Prefs.getPrefsDir());
        this.list.add("  Current dir: " + OpenDialog.getDefaultDirectory());
        this.list.add("  Sample images dir: " + Prefs.getImagesURL());
        this.list.add("  Memory in use: " + IJ.freeMemory());
        Rectangle s1 = GUI.getScreenBounds();
        Rectangle s22 = GUI.getScreenBounds(IJ.getInstance());
        if (s1.equals(s22)) {
            this.list.add("  Screen size: " + s1.width + "x" + s1.height);
        } else {
            this.list.add("  Size of primary screen: " + s1.width + "x" + s1.height);
            this.list.add("  Size of \"ImageJ\" screen: " + s22.width + "x" + s22.height);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.list.add("  Max window bounds: " + this.toString(GUI.getMaxWindowBounds(IJ.getInstance())));
        this.listMonitors(ge, this.list);
        System.gc();
        this.doFullDump();
        if (IJ.getInstance() == null) {
            for (int i = 0; i < this.list.size(); ++i) {
                IJ.log((String)this.list.get(i));
            }
        } else {
            new TextWindow("Properties", "", this.list, 400, 500);
        }
    }

    private void listMonitors(GraphicsEnvironment ge, ArrayList list) {
        int max = 10;
        String[] str = new String[max];
        int n = 0;
        Rectangle bounds2 = null;
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                Rectangle bounds = gc[i].getBounds();
                if (bounds == null || bounds.equals(bounds2) || n >= max) continue;
                str[n++] = this.toString(bounds);
                bounds2 = bounds;
            }
        }
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                list.add("  Monitor" + (i + 1) + ": " + str[i]);
            }
        }
    }

    private String toString(Rectangle r) {
        if (r == null) {
            return "";
        }
        String s2 = r.toString();
        return s2.substring(19, s2.length() - 1);
    }

    String cores() {
        int cores = Runtime.getRuntime().availableProcessors();
        if (cores == 1) {
            return " (1 core)";
        }
        return " (" + cores + " cores)";
    }

    void show(String property) {
        String p = System.getProperty(property);
        if (p != null) {
            this.list.add("  " + property + ": " + p);
        }
    }

    void doFullDump() {
        this.list.add("");
        this.list.add("All Java Properties");
        Properties props = System.getProperties();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.list.add("  " + key + ": " + (String)props.get(key));
        }
    }
}

