/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PlotWindow;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;

public class WindowOrganizer
implements PlugIn {
    private static final int XSTART = 4;
    private static final int YSTART = 94;
    private static final int XOFFSET = 8;
    private static final int YOFFSET = 24;
    private static final int MAXSTEP = 200;
    private static final int GAP = 2;
    private int titlebarHeight = IJ.isMacintosh() ? 40 : 20;

    @Override
    public void run(String arg) {
        if (arg.equals("imagej")) {
            this.showImageJ();
            return;
        }
        int[] wList = WindowManager.getIDList();
        if (arg.equals("show")) {
            this.showAll(wList);
            return;
        }
        if (wList == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("tile")) {
            this.tileWindows(wList);
        } else {
            this.cascadeWindows(wList);
        }
    }

    void tileWindows(int[] wList) {
        int vloc;
        int hloc;
        boolean theyFit;
        int vspace;
        Rectangle screen = GUI.getMaxWindowBounds(IJ.getInstance());
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        boolean allSameSize = true;
        int width = 0;
        int height = 0;
        double totalWidth = 0.0;
        double totalHeight = 0.0;
        for (int i = 0; i < wList.length; ++i) {
            ImageWindow win = this.getWindow(wList[i]);
            if (win == null) continue;
            if (win instanceof PlotWindow && !((PlotWindow)win).getPlot().isFrozen()) {
                IJ.error("Tile", "Unfrozen plot windows cannot be tiled.");
                return;
            }
            Dimension d = win.getSize();
            int w = d.width;
            int h2 = d.height + this.titlebarHeight;
            if (i == 0) {
                width = w;
                height = h2;
            }
            if (w != width || h2 != height) {
                allSameSize = false;
            }
            if (w < minWidth) {
                minWidth = w;
            }
            if (h2 < minHeight) {
                minHeight = h2;
            }
            totalWidth += (double)w;
            totalHeight += (double)h2;
        }
        int nPics = wList.length;
        double averageWidth = totalWidth / (double)nPics;
        double averageHeight = totalHeight / (double)nPics;
        int tileWidth = (int)averageWidth;
        int tileHeight = (int)averageHeight;
        int hspace = screen.width - 4;
        if (tileWidth > hspace) {
            tileWidth = hspace;
        }
        if (tileHeight > (vspace = screen.height - 94)) {
            tileHeight = vspace;
        }
        do {
            hloc = 4;
            vloc = 94;
            theyFit = true;
            int i = 0;
            do {
                ++i;
                if (hloc + tileWidth > screen.width) {
                    hloc = 4;
                    if ((vloc += tileHeight) + tileHeight > screen.height) {
                        theyFit = false;
                    }
                }
                hloc = hloc + tileWidth + 2;
            } while (theyFit && i < nPics);
            if (theyFit) continue;
            tileWidth = (int)((double)tileWidth * 0.98 + 0.5);
            tileHeight = (int)((double)tileHeight * 0.98 + 0.5);
        } while (!theyFit);
        int nColumns = (screen.width - 4) / (tileWidth + 2);
        int nRows = nPics / nColumns;
        if (nPics % nColumns != 0) {
            ++nRows;
        }
        hloc = 4;
        vloc = 94;
        for (int i = 0; i < nPics; ++i) {
            ImageWindow win;
            if (hloc + tileWidth > screen.width) {
                hloc = 4;
                vloc += tileHeight;
            }
            if ((win = this.getWindow(wList[i])) != null) {
                win.setLocation(hloc + screen.x, vloc + screen.y);
                ImageCanvas canvas = win.getCanvas();
                while ((double)win.getSize().width * 0.85 >= (double)tileWidth && canvas.getMagnification() > 0.03125) {
                    canvas.zoomOut(0, 0);
                }
                win.toFront();
                ImagePlus imp = win.getImagePlus();
                if (imp != null) {
                    imp.setIJMenuBar(i == nPics - 1);
                }
            }
            hloc += tileWidth + 2;
        }
    }

    ImageWindow getWindow(int id) {
        ImageWindow win = null;
        ImagePlus imp = WindowManager.getImage(id);
        if (imp != null) {
            win = imp.getWindow();
        }
        return win;
    }

    void cascadeWindows(int[] wList) {
        Rectangle screen = GUI.getMaxWindowBounds(IJ.getInstance());
        int x = 4;
        int y = 94;
        int xstep = 0;
        int xstart = 4;
        for (int i = 0; i < wList.length; ++i) {
            ImageWindow win = this.getWindow(wList[i]);
            if (win == null) continue;
            Dimension d = win.getSize();
            if (i == 0 && (xstep = (int)((double)d.width * 0.8)) > 200) {
                xstep = 200;
            }
            if ((double)y + (double)d.height * 0.67 > (double)screen.height) {
                if ((double)(xstart += xstep) + (double)d.width * 0.67 > (double)screen.width) {
                    xstart = 12;
                }
                x = xstart;
                y = 94;
            }
            win.setLocation(x + screen.x, y + screen.y);
            win.toFront();
            x += 8;
            y += 24;
            ImagePlus imp = win.getImagePlus();
            if (imp == null) continue;
            imp.setIJMenuBar(i == wList.length - 1);
        }
    }

    void showImageJ() {
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            ij.toFront();
        }
    }

    void showAll(int[] wList) {
        Window[] windows;
        if (wList != null) {
            for (int i = 0; i < wList.length; ++i) {
                ImageWindow win = this.getWindow(wList[i]);
                if (win == null) continue;
                WindowManager.toFront(win);
            }
        }
        if ((windows = WindowManager.getAllNonImageWindows()) != null) {
            for (int i = 0; i < windows.length; ++i) {
                WindowManager.toFront(windows[i]);
            }
        }
        IJ.getInstance().toFront();
    }
}

