/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.Measurements;
import ij.plugin.TextReader;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.Fitter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Calibrator
implements PlugInFilter,
Measurements,
ActionListener {
    private static final String NONE = "None";
    private static final String INVERTER = "Pixel Inverter";
    private static final String UNCALIBRATED_OD = "Uncalibrated OD";
    private static final String CUSTOM = "Custom";
    private static boolean showSettings;
    private boolean global1;
    private boolean global2;
    private ImagePlus imp;
    private int choiceIndex;
    private String[] functions;
    private int nFits = 14;
    private String curveFitError;
    private int spacerIndex = this.nFits + 1;
    private int inverterIndex = this.nFits + 2;
    private int odIndex = this.nFits + 3;
    private int customIndex = this.nFits + 4;
    private static String xText;
    private static String yText;
    private static boolean importedValues;
    private String unit;
    private double lx = 0.02;
    private double ly = 0.1;
    private int oldFunction;
    private String sumResiduals;
    private String fitGoodness;
    private Button open;
    private Button save;
    private GenericDialog gd;
    private static boolean showPlotFlagSaved;
    private boolean showPlotFlag;
    private static String unitSaved;
    private CurveFitter curveFitter;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 143;
    }

    @Override
    public void run(ImageProcessor ip) {
        boolean bl = this.global1 = this.imp.getGlobalCalibration() != null;
        if (!this.showDialog(this.imp)) {
            return;
        }
        if (this.choiceIndex == this.customIndex) {
            this.showPlot(null, null, this.imp.getCalibration(), null);
            return;
        }
        if (this.imp.getType() == 2) {
            if (this.choiceIndex == 0) {
                this.imp.getCalibration().setValueUnit(this.unit);
            } else {
                IJ.error("Calibrate", "Function must be \"None\" for 32-bit images,\nbut you can change the Unit.");
            }
        } else {
            this.calibrate(this.imp);
        }
    }

    public boolean showDialog(ImagePlus imp) {
        int function;
        Calibration cal = imp.getCalibration();
        this.functions = this.getFunctionList(cal.getFunction() == 22);
        this.oldFunction = function = cal.getFunction();
        double[] p = cal.getCoefficients();
        this.unit = cal.getValueUnit();
        if (this.unit == "Gray Value") {
            this.unit = unitSaved;
        }
        String defaultChoice = function == 20 ? NONE : (function < this.nFits && function == 0 && p != null && p[0] == 255.0 && p[1] == -1.0 ? INVERTER : (function < this.nFits ? CurveFitter.fitList[function] : (function == 21 ? UNCALIBRATED_OD : (function == 22 ? CUSTOM : NONE))));
        String tmpText = this.getMeans();
        if (!importedValues && !tmpText.equals("")) {
            xText = tmpText;
        }
        this.gd = new GenericDialog("Calibrate...");
        this.gd.addChoice("Function:", this.functions, defaultChoice);
        this.gd.addStringField("Unit:", this.unit, 16);
        this.gd.addTextAreas(xText, yText, 20, 14);
        this.gd.addPanel(this.makeButtonPanel(this.gd));
        this.gd.addCheckbox("Global calibration", IJ.isMacro() ? false : this.global1);
        this.gd.addCheckbox("Show plot", IJ.isMacro() ? false : showPlotFlagSaved);
        this.gd.addHelp("http://imagej.nih.gov/ij/docs/menus/analyze.html#cal");
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return false;
        }
        this.choiceIndex = this.gd.getNextChoiceIndex();
        this.unit = this.gd.getNextString();
        xText = this.gd.getNextText();
        yText = this.gd.getNextText();
        this.global2 = this.gd.getNextBoolean();
        showPlotFlagSaved = this.showPlotFlag = this.gd.getNextBoolean();
        unitSaved = this.unit;
        return true;
    }

    Panel makeButtonPanel(GenericDialog gd) {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(1, 5, 0));
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        buttons.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        return buttons;
    }

    public void calibrate(ImagePlus imp) {
        int bitDepth;
        double[] y;
        double[] x;
        int function;
        Calibration cal;
        block28: {
            block29: {
                cal = imp.getCalibration();
                Calibration calOrig = cal.copy();
                function = 20;
                boolean is16Bits = imp.getType() == 1;
                double[] parameters = null;
                x = null;
                y = null;
                boolean zeroClip = false;
                this.curveFitter = null;
                if (this.choiceIndex <= 0) {
                    if (this.oldFunction == 20 && !yText.equals("") && !xText.equals("")) {
                        IJ.error("Calibrate", "Please select a function");
                        return;
                    }
                    function = 20;
                } else if (this.choiceIndex <= this.nFits) {
                    int i;
                    function = this.choiceIndex - 1;
                    x = this.getData(xText);
                    y = this.getData(yText);
                    if (cal.isSigned16Bit() || imp.getProperty("WasSigned") != null) {
                        i = 0;
                        while (i < x.length) {
                            int n = i++;
                            x[n] = x[n] + 32768.0;
                        }
                        imp.setProperty("WasSigned", "WasSigned");
                    }
                    if (!this.validateXValues(imp, x)) {
                        return;
                    }
                    if (!(cal.calibrated() && y.length == 0 && function == this.oldFunction || (parameters = this.doCurveFitting(x, y, function)) != null)) {
                        IJ.error(this.curveFitError);
                        function = 20;
                        return;
                    }
                    if (!is16Bits && function != 0) {
                        zeroClip = true;
                        for (i = 0; i < y.length; ++i) {
                            if (!(y[i] < 0.0)) continue;
                            zeroClip = false;
                        }
                    }
                } else if (this.choiceIndex == this.inverterIndex) {
                    function = 0;
                    parameters = new double[]{is16Bits ? 65535.0 : 255.0, -1.0};
                    this.unit = "Inverted Gray Value";
                } else if (this.choiceIndex == this.odIndex) {
                    if (is16Bits) {
                        IJ.error("Calibrate", "Uncalibrated OD is not supported on 16-bit images.");
                        return;
                    }
                    function = 21;
                    this.unit = UNCALIBRATED_OD;
                }
                cal.setFunction(function, parameters, this.unit, zeroClip);
                if (function == 20) {
                    cal.setValueUnit(this.unit);
                }
                if (!cal.equals(calOrig)) {
                    imp.setCalibration(cal);
                }
                bitDepth = imp.getBitDepth();
                imp.setGlobalCalibration(this.global2 ? cal : null);
                if (function == 20 || bitDepth == 8 || imp.getNChannels() != 1) break block28;
                if (bitDepth != 16) break block29;
                if (imp.getDefault16bitRange() > 0) break block28;
            }
            ImageStatistics stats = imp.getProcessor().getStats();
            if (imp.getDisplayRangeMin() < stats.min || imp.getDisplayRangeMax() > stats.max) {
                imp.resetDisplayRange();
                imp.updateAndDraw();
            }
        }
        if (this.global2 || this.global2 != this.global1) {
            WindowManager.repaintImageWindows();
        } else {
            imp.repaintWindow();
        }
        if (this.global2 && this.global2 != this.global1) {
            FileOpener.setShowConflictMessage(true);
        }
        if (function != 20 && this.showPlotFlag) {
            if (this.curveFitter != null) {
                Fitter.plot(this.curveFitter, bitDepth == 8);
            } else {
                this.showPlot(x, y, cal, this.fitGoodness);
            }
        }
    }

    private boolean validateXValues(ImagePlus imp, double[] x) {
        int bitDepth = imp.getBitDepth();
        if (bitDepth == 32 || x == null) {
            return true;
        }
        int max = 255;
        if (bitDepth == 16) {
            max = 65535;
        }
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] < 0.0) && !(x[i] > (double)max)) continue;
            String title = (bitDepth == 8 ? "8-bit" : "16-bit") + " Calibration";
            String msg = "Measured (uncalibrated) values in the left\ncolumn must be in the range 0-";
            IJ.error(title, msg + max + ".");
            return false;
        }
        return true;
    }

    double[] doCurveFitting(double[] x, double[] y, int fitType) {
        if (x.length != y.length || y.length == 0) {
            IJ.error("Calibrate", "To create a calibration curve, the left column must\ncontain a list of measured mean pixel values and the\nright column must contain the same number of calibration\nstandard values. Use the Measure command to add mean\npixel value measurements to the left column.\n \n    Left column: " + x.length + " values\n    Right column: " + y.length + " values\n");
            return null;
        }
        int n = x.length;
        double xmin = 0.0;
        double xmax = this.imp.getType() == 1 ? 65535.0 : 255.0;
        double[] a = Tools.getMinMax(y);
        double ymin = a[0];
        double ymax = a[1];
        CurveFitter cf = new CurveFitter(x, y);
        cf.doFit(fitType, showSettings);
        if (cf.getStatus() == 1) {
            this.curveFitError = cf.getStatusString();
            return null;
        }
        if (IJ.debugMode) {
            IJ.log(cf.getResultString());
        }
        int np = cf.getNumParams();
        double[] p = cf.getParams();
        this.fitGoodness = IJ.d2s(cf.getRSquared(), 6);
        this.curveFitter = cf;
        double[] parameters = new double[np];
        for (int i = 0; i < np; ++i) {
            parameters[i] = p[i];
        }
        return parameters;
    }

    void showPlot(double[] x, double[] y, Calibration cal, String rSquared) {
        int i;
        int xmax;
        boolean xmin;
        if (!this.showPlotFlag || !cal.calibrated()) {
            return;
        }
        float[] ctable = cal.getCTable();
        if (ctable.length == 256) {
            xmin = false;
            xmax = 255;
        } else {
            xmin = false;
            xmax = 65535;
        }
        int range = 256;
        float[] px = new float[range];
        float[] py = new float[range];
        for (i = 0; i < range; ++i) {
            px[i] = (float)((double)i / 255.0 * (double)xmax);
        }
        for (i = 0; i < range; ++i) {
            py[i] = ctable[(int)px[i]];
        }
        double[] a = Tools.getMinMax(py);
        double ymin = a[0];
        double ymax = a[1];
        int fit = cal.getFunction();
        String unit = cal.getValueUnit();
        Plot plot = new Plot("Calibration Function", "pixel value", unit, px, py);
        plot.setLimits((double)xmin, xmax, ymin, ymax);
        if (x != null && y != null && x.length > 0 && y.length > 0) {
            plot.addPoints(x, y, 0);
        }
        double[] p = cal.getCoefficients();
        if (fit <= 9) {
            this.drawLabel(plot, CurveFitter.fList[fit]);
            this.ly += 0.04;
        }
        if (p != null) {
            int np = p.length;
            this.drawLabel(plot, "a=" + IJ.d2s(p[0], 6, 10));
            this.drawLabel(plot, "b=" + IJ.d2s(p[1], 6, 10));
            if (np >= 3) {
                this.drawLabel(plot, "c=" + IJ.d2s(p[2], 6, 10));
            }
            if (np >= 4) {
                this.drawLabel(plot, "d=" + IJ.d2s(p[3], 6, 10));
            }
            if (np >= 5) {
                this.drawLabel(plot, "e=" + IJ.d2s(p[4], 6, 10));
            }
            this.ly += 0.04;
        }
        if (rSquared != null) {
            this.drawLabel(plot, "R^2=" + rSquared);
            rSquared = null;
        }
        plot.show();
    }

    void drawLabel(Plot plot, String label) {
        plot.addLabel(this.lx, this.ly, label);
        this.ly += 0.08;
    }

    double sqr(double x) {
        return x * x;
    }

    String[] getFunctionList(boolean custom) {
        int n = this.nFits + 4;
        if (custom) {
            ++n;
        }
        String[] list = new String[n];
        list[0] = NONE;
        for (int i = 0; i < this.nFits; ++i) {
            list[1 + i] = CurveFitter.fitList[i];
        }
        list[this.spacerIndex] = "-";
        list[this.inverterIndex] = INVERTER;
        list[this.odIndex] = UNCALIBRATED_OD;
        if (custom) {
            list[this.customIndex] = CUSTOM;
        }
        return list;
    }

    String getMeans() {
        float[] umeans = Analyzer.getUMeans();
        int count = Analyzer.getCounter();
        if (umeans == null || count == 0) {
            return "";
        }
        if (count > 20) {
            count = 20;
        }
        String s2 = "";
        for (int i = 0; i < count; ++i) {
            s2 = s2 + IJ.d2s(umeans[i], 2) + "\n";
        }
        importedValues = false;
        return s2;
    }

    double[] getData(String xData) {
        int len = xData.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = xData.charAt(i);
            if ((c < '0' || c > '9') && c != '-' && c != '.' && c != ',' && c != '\n' && c != '\r' && c != ' ') continue;
            sb.append(c);
        }
        xData = sb.toString();
        StringTokenizer st = new StringTokenizer(xData);
        int nTokens = st.countTokens();
        if (nTokens < 1) {
            return new double[0];
        }
        int n = nTokens;
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.getNum(st);
        }
        return data;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = Double.valueOf(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void save() {
        TextArea ta1 = this.gd.getTextArea1();
        TextArea ta2 = this.gd.getTextArea2();
        ta1.selectAll();
        String text1 = ta1.getText();
        ta1.select(0, 0);
        ta2.selectAll();
        String text2 = ta2.getText();
        ta2.select(0, 0);
        double[] x = this.getData(text1);
        double[] y = this.getData(text2);
        SaveDialog sd = new SaveDialog("Save as Text...", "calibration", ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        int n = Math.max(x.length, y.length);
        for (int i = 0; i < n; ++i) {
            String xs;
            String string = x.length == 0 ? "" : (xs = i < x.length ? "" + x[i] : "0");
            String ys = y.length == 0 ? "" : (i < y.length ? "" + y[i] : "0");
            pw.println(xs + "\t" + ys);
        }
        pw.close();
    }

    void open() {
        OpenDialog od = new OpenDialog("Open Calibration...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        TextReader tr = new TextReader();
        String path = directory + name;
        ImageProcessor ip = tr.open(path);
        if (ip == null) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        if (width != 1 && width != 2 || height <= 1) {
            IJ.error("Calibrate", "This appears to not be a one or two column text file");
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < height; ++i) {
            sb.append("" + ip.getPixelValue(0, i));
            sb.append("\n");
        }
        String s1 = null;
        String s2 = null;
        if (width == 2) {
            s1 = new String(sb);
            sb = new StringBuffer();
            for (int i = 0; i < height; ++i) {
                sb.append("" + ip.getPixelValue(1, i));
                sb.append("\n");
            }
            s2 = new String(sb);
        } else {
            s2 = new String(sb);
        }
        if (s1 != null) {
            TextArea ta1 = this.gd.getTextArea1();
            ta1.selectAll();
            ta1.setText(s1);
        }
        TextArea ta2 = this.gd.getTextArea2();
        ta2.selectAll();
        ta2.setText(s2);
        importedValues = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source2 = e.getSource();
        if (source2 == this.save) {
            this.save();
        } else if (source2 == this.open) {
            this.open();
        }
    }

    static {
        xText = "";
        yText = "";
        showPlotFlagSaved = true;
        unitSaved = "Gray Value";
    }
}

