/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.gui.ColorChooser;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.frame.ColorGenerator;
import ij.plugin.frame.ColorPicker;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class ColorCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    private static Cursor defaultCursor = new Cursor(0);
    private static Cursor crosshairCursor = new Cursor(1);
    int ybase = ColorPicker.ybase;
    Rectangle flipperRect = new Rectangle(86, this.ybase + 268, 18, 18);
    Rectangle resetRect = new Rectangle(84, this.ybase + 293, 21, 18);
    Rectangle foreground1Rect = new Rectangle(9, this.ybase + 266, 45, 10);
    Rectangle foreground2Rect = new Rectangle(9, this.ybase + 276, 23, 25);
    Rectangle background1Rect = new Rectangle(33, this.ybase + 302, 45, 10);
    Rectangle background2Rect = new Rectangle(56, this.ybase + 277, 23, 25);
    int width;
    int height;
    Vector colors;
    boolean background;
    long mouseDownTime;
    ColorGenerator ip;
    ColorPicker cp;
    double scale;
    String status = "";

    public ColorCanvas(int width, int height, ColorPicker cp, ColorGenerator ip, double scale) {
        this.width = width;
        this.height = height;
        this.ip = ip;
        this.cp = cp;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(IJ.getInstance());
        this.setSize(width, height);
        this.scale = scale;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void update(Graphics g2) {
        this.paint(g2);
    }

    @Override
    public void paint(Graphics g2) {
        g2.drawImage(this.ip.createImage(), 0, 0, (int)((double)this.ip.getWidth() * this.scale), (int)((double)this.ip.getHeight() * this.scale), null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Color color;
        this.ip.setLineWidth(1);
        if (Toolbar.getToolId() == 13) {
            IJ.setTool(0);
        }
        int x = (int)((double)e.getX() / this.scale);
        int y = (int)((double)e.getY() / this.scale);
        long difference = System.currentTimeMillis() - this.mouseDownTime;
        boolean doubleClick = difference <= 250L;
        this.mouseDownTime = System.currentTimeMillis();
        if (this.flipperRect.contains(x, y)) {
            Color c = Toolbar.getBackgroundColor();
            Toolbar.setBackgroundColor(Toolbar.getForegroundColor());
            Toolbar.setForegroundColor(c);
            Recorder.setForegroundColor(Toolbar.getForegroundColor());
            Recorder.setBackgroundColor(Toolbar.getBackgroundColor());
        } else if (this.resetRect.contains(x, y)) {
            Toolbar.setForegroundColor(Color.white);
            Toolbar.setBackgroundColor(Color.black);
            Recorder.setForegroundColor(Color.white);
            Recorder.setBackgroundColor(Color.black);
        } else if (this.background1Rect.contains(x, y) || this.background2Rect.contains(x, y)) {
            this.background = true;
            if (doubleClick) {
                this.editColor();
            }
            this.ip.refreshForeground(this.background);
            this.ip.refreshBackground(this.background);
        } else if (this.foreground1Rect.contains(x, y) || this.foreground2Rect.contains(x, y)) {
            this.background = false;
            if (doubleClick) {
                this.editColor();
            }
            this.ip.refreshBackground(this.background);
            this.ip.refreshForeground(this.background);
        } else if (doubleClick) {
            this.editColor();
        } else {
            this.setDrawingColor(x, y, this.background);
            this.showStatus(" ", Toolbar.getForegroundColor().getRGB());
        }
        if (this.background) {
            this.ip.refreshForeground(this.background);
            this.ip.refreshBackground(this.background);
            color = Toolbar.getBackgroundColor();
        } else {
            this.ip.refreshBackground(this.background);
            this.ip.refreshForeground(this.background);
            color = Toolbar.getForegroundColor();
        }
        this.cp.colorField.setText(Colors.colorToString(color));
        this.showStatus(" ", color.getRGB());
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y;
        int x = (int)((double)e.getX() / this.scale);
        if (this.flipperRect.contains(x, y = (int)((double)e.getY() / this.scale))) {
            this.showStatus("Click to flip foreground and background colors", 0);
        } else if (this.resetRect.contains(x, y)) {
            this.showStatus("Click to reset foreground to white, background to black", 0);
        } else if (!this.background && (this.background1Rect.contains(x, y) || this.background2Rect.contains(x, y))) {
            this.showStatus("Click to switch to background selection mode ", 0);
        } else if (this.background && (this.foreground1Rect.contains(x, y) || this.foreground2Rect.contains(x, y))) {
            this.showStatus("Click to switch to foreground selection mode", 0);
        } else {
            this.showStatus("", this.ip.getPixel(x, y));
        }
    }

    String pad(int n) {
        String str = "" + n;
        while (str.length() < 3) {
            str = "0" + str;
        }
        return str;
    }

    void setDrawingColor(int x, int y, boolean setBackground) {
        int p = this.ip.getPixel(x, y);
        int r = (p & 0xFF0000) >> 16;
        int g2 = (p & 0xFF00) >> 8;
        int b = p & 0xFF;
        Color c = new Color(r, g2, b);
        if (setBackground) {
            Toolbar.setBackgroundColor(c);
            if (Recorder.record) {
                Recorder.setBackgroundColor(c);
            }
        } else {
            Toolbar.setForegroundColor(c);
            if (Recorder.record) {
                Recorder.setForegroundColor(c);
            }
        }
    }

    void editColor() {
        Color c = this.background ? Toolbar.getBackgroundColor() : Toolbar.getForegroundColor();
        ColorChooser cc = new ColorChooser((this.background ? "Background" : "Foreground") + " Color", c, false);
        c = cc.getColor();
        if (this.background) {
            Toolbar.setBackgroundColor(c);
        } else {
            Toolbar.setForegroundColor(c);
        }
    }

    public void refreshColors() {
        this.ip.refreshBackground(false);
        this.ip.refreshForeground(false);
        this.repaint();
    }

    private void showStatus(String msg, int rgb) {
        if (msg.length() > 1) {
            IJ.showStatus(msg);
        } else {
            int r = (rgb & 0xFF0000) >> 16;
            int g2 = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            String hex = Colors.colorToString(new Color(r, g2, b));
            IJ.showStatus("red=" + this.pad(r) + ", green=" + this.pad(g2) + ", blue=" + this.pad(b) + " (" + hex + ") " + msg);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        IJ.showStatus("");
        this.setCursor(defaultCursor);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(crosshairCursor);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

