/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.io.OpenDialog;
import ij.measure.CurveFitter;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class Fitter
extends PlugInFrame
implements PlugIn,
ItemListener,
ActionListener,
KeyListener,
ClipboardOwner {
    Choice fit;
    Button doIt;
    Button open;
    Button apply;
    Checkbox settings;
    String fitTypeStr = CurveFitter.fitList[0];
    TextArea textArea;
    double[] dx = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    double[] dy = new double[]{0.0, 0.9, 4.5, 8.0, 18.0, 24.0};
    double[] x;
    double[] y;
    static CurveFitter cf;
    static int fitType;
    static String equation;
    static final int USER_DEFINED = -1;

    public Fitter() {
        super("Curve Fitter");
        WindowManager.addWindow(this);
        this.addKeyListener(this);
        Panel panel = new Panel();
        this.fit = new Choice();
        for (int i = 0; i < CurveFitter.fitList.length; ++i) {
            this.fit.addItem(CurveFitter.fitList[CurveFitter.sortedTypes[i]]);
        }
        this.fit.addItem("*User-defined*");
        this.fit.addItemListener(this);
        panel.add(this.fit);
        this.doIt = new Button(" Fit ");
        this.doIt.addActionListener(this);
        this.doIt.addKeyListener(this);
        panel.add(this.doIt);
        this.open = new Button("Open");
        this.open.addActionListener(this);
        panel.add(this.open);
        this.apply = new Button("Apply");
        this.apply.addActionListener(this);
        panel.add(this.apply);
        this.settings = new Checkbox("Show settings", false);
        panel.add(this.settings);
        this.add("North", panel);
        String text = "";
        for (int i = 0; i < this.dx.length; ++i) {
            text = text + IJ.d2s(this.dx[i], 2) + "  " + IJ.d2s(this.dy[i], 2) + "\n";
        }
        this.textArea = new TextArea("", 15, 30, 1);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        if (IJ.isLinux()) {
            this.textArea.setBackground(Color.white);
        }
        this.textArea.append(text);
        this.add("Center", this.textArea);
        GUI.scale(this);
        this.pack();
        GUI.centerOnImageJScreen(this);
        this.show();
        IJ.register(Fitter.class);
    }

    public boolean doFit(int fitType) {
        if (!this.getData()) {
            IJ.beep();
            return false;
        }
        cf = new CurveFitter(this.x, this.y);
        cf.setStatusAndEsc("Optimization: Iteration ", true);
        try {
            if (fitType == -1) {
                String eqn = this.getEquation();
                if (eqn == null) {
                    return false;
                }
                int params = cf.doCustomFit(eqn, null, this.settings.getState());
                if (params == 0) {
                    IJ.beep();
                    IJ.log("Bad formula; should be:\n   y = function(x, a, ...)");
                    return false;
                }
            } else {
                cf.doFit(fitType, this.settings.getState());
            }
            if (cf.getStatus() == 1) {
                IJ.beep();
                IJ.showStatus(cf.getStatusString());
                IJ.log("Curve Fitting Error:\n" + cf.getStatusString());
                return false;
            }
            if (Double.isNaN(cf.getSumResidualsSqr())) {
                IJ.beep();
                IJ.showStatus("Error: fit yields Not-a-Number");
                return false;
            }
        }
        catch (Exception e) {
            IJ.handleException(e);
            return false;
        }
        IJ.log(cf.getResultString());
        Fitter.plot(cf);
        Fitter.fitType = fitType;
        return true;
    }

    String getEquation() {
        GenericDialog gd = new GenericDialog("Formula");
        gd.addStringField("Formula:", equation, 38);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        equation = gd.getNextString();
        return equation;
    }

    public static void plot(CurveFitter cf) {
        Fitter.plot(cf, false);
    }

    public static void plot(CurveFitter cf, boolean eightBitCalibrationPlot) {
        Plot plot = cf.getPlot(eightBitCalibrationPlot ? 256 : 100);
        plot.show();
    }

    double sqr(double x) {
        return x * x;
    }

    boolean getData() {
        this.textArea.selectAll();
        String text = this.textArea.getText();
        text = this.zapGremlins(text);
        this.textArea.select(0, 0);
        StringTokenizer st = new StringTokenizer(text, " \t\n\r,");
        int nTokens = st.countTokens();
        if (nTokens < 4 || nTokens % 2 != 0) {
            IJ.showStatus("Data error: min. two (x,y) pairs needed");
            return false;
        }
        int n = nTokens / 2;
        this.x = new double[n];
        this.y = new double[n];
        for (int i = 0; i < n; ++i) {
            String xString = st.nextToken();
            String yString = st.nextToken();
            this.x[i] = Tools.parseDouble(xString);
            this.y[i] = Tools.parseDouble(yString);
            if (!Double.isNaN(this.x[i]) && !Double.isNaN(this.y[i])) continue;
            IJ.showStatus("Data error:  Bad number at " + i + ": " + xString + " " + yString);
            return false;
        }
        return true;
    }

    void applyFunction() {
        if (cf == null || fitType < 0) {
            IJ.error("No function available");
            return;
        }
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null) {
            IJ.noImage();
            return;
        }
        if (img.getTitle().matches("y\\s=.*")) {
            IJ.error("First select the image to be transformed");
            return;
        }
        double[] p = cf.getParams();
        int width = img.getWidth();
        int height = img.getHeight();
        int size = width * height;
        float[] data = new float[size];
        ImageProcessor ip = img.getProcessor();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float value = ip.getPixelValue(x, y);
                data[y * width + x] = (float)cf.f(p, value);
            }
        }
        FloatProcessor ip2 = new FloatProcessor(width, height, data, ip.getColorModel());
        new ImagePlus(img.getTitle() + "-transformed", ip2).show();
    }

    void open() {
        OpenDialog od = new OpenDialog("Open Text File...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        this.textArea.selectAll();
        this.textArea.setText("");
        try {
            String s2;
            BufferedReader r = new BufferedReader(new FileReader(directory + name));
            while ((s2 = r.readLine()) != null && s2.length() <= 100) {
                this.textArea.append(s2 + "\n");
            }
            r.close();
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fitTypeStr = this.fit.getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            String cmd = e.getActionCommand();
            if (cmd == null) {
                return;
            }
            if (cmd.equals("Cut")) {
                this.cut();
            } else if (cmd.equals("Copy")) {
                this.copy();
            } else if (cmd.equals("Paste")) {
                this.paste();
            }
            return;
        }
        try {
            if (e.getSource() == this.doIt) {
                final int fitType = CurveFitter.getFitCode(this.fit.getSelectedItem());
                Thread thread2 = new Thread(new Runnable(){

                    @Override
                    public final void run() {
                        Fitter.this.doFit(fitType);
                    }
                }, "CurveFitting");
                thread2.setPriority(Thread.currentThread().getPriority());
                thread2.start();
            } else if (e.getSource() == this.apply) {
                this.applyFunction();
            } else {
                this.open();
            }
        }
        catch (Exception ex) {
            IJ.log("" + ex);
        }
    }

    String zapGremlins(String text) {
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\n' || c == '\t' || c >= ' ' && c <= '\u007f') continue;
            ++count;
            chars[i] = 32;
        }
        if (count > 0) {
            return new String(chars);
        }
        return text;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            IJ.getInstance().keyPressed(e);
        }
    }

    private boolean copy() {
        String s2 = this.textArea.getSelectedText();
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip != null) {
            StringSelection cont = new StringSelection(s2);
            clip.setContents(cont, this);
            return true;
        }
        return false;
    }

    private void cut() {
        if (this.copy()) {
            int start = this.textArea.getSelectionStart();
            int end = this.textArea.getSelectionEnd();
            this.textArea.replaceRange("", start, end);
        }
    }

    private void paste() {
        String s2 = this.textArea.getSelectedText();
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(s2);
        try {
            s2 = (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            s2 = e.toString();
        }
        int start = this.textArea.getSelectionStart();
        int end = this.textArea.getSelectionEnd();
        this.textArea.replaceRange(s2, start, end);
        if (IJ.isMacOSX()) {
            this.textArea.setCaretPosition(start + s2.length());
        }
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    static {
        fitType = -1;
        equation = "y = a + b*x + c*x*x";
    }
}

