/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ImageProcessor;
import java.util.Arrays;

public class DownsizeTable {
    public final int kernelSize;
    public final int srcStart;
    public final int srcEnd;
    public final int[] indices;
    public final float[] weights;
    private static final int[] kernelSizes = new int[]{1, 2, 4};
    private final int srcOrigin;
    private final int srcLength;
    private final double scale;
    private final int interpolationMethod;
    private static final int UNUSED = -1;

    DownsizeTable(int srcSize, int srcOrigin, int srcLength, int dstSize, int interpolationMethod) {
        this.srcOrigin = srcOrigin;
        this.srcLength = srcLength;
        this.interpolationMethod = interpolationMethod;
        this.scale = (double)srcLength / (double)dstSize;
        this.kernelSize = kernelSizes[interpolationMethod];
        int srcStartUncorr = (int)Math.ceil(1.0E-8 + this.srcIndex(-0.5 * (double)this.kernelSize));
        this.srcStart = srcStartUncorr < 0 ? 0 : srcStartUncorr;
        int srcEndUncorr = (int)Math.floor(1.0E-8 + this.srcIndex((double)(dstSize - 1) + 0.5 * (double)this.kernelSize));
        this.srcEnd = srcEndUncorr >= srcSize ? srcSize - 1 : srcEndUncorr;
        int arraySize = (this.srcEnd - this.srcStart + 1) * this.kernelSize;
        this.indices = new int[arraySize];
        this.weights = new float[arraySize];
        Arrays.fill(this.indices, -1);
        for (int dst = 0; dst < dstSize; ++dst) {
            int iStop;
            double sum = 0.0;
            int lowestS = (int)Math.ceil(1.0E-8 + this.srcIndex((double)dst - 0.5 * (double)this.kernelSize));
            int highestS = (int)Math.floor(-1.0E-8 + this.srcIndex((double)dst + 0.5 * (double)this.kernelSize));
            for (int src = lowestS; src <= highestS; ++src) {
                int s2 = src < 0 ? 0 : (src >= srcSize ? srcSize - 1 : src);
                int p = (s2 - this.srcStart) * this.kernelSize;
                while (this.indices[p] != -1 && this.indices[p] != dst) {
                    ++p;
                }
                this.indices[p] = dst;
                float weight = this.kernel((double)dst - this.dstIndex(src));
                sum += (double)weight;
                int n = p;
                this.weights[n] = this.weights[n] + weight;
            }
            int iStart = (lowestS - this.srcStart) * this.kernelSize;
            if (iStart < 0) {
                iStart = 0;
            }
            if ((iStop = (highestS - this.srcStart) * this.kernelSize + (this.kernelSize - 1)) >= this.indices.length) {
                iStop = this.indices.length - 1;
            }
            for (int i = iStart; i <= iStop; ++i) {
                if (this.indices[i] != dst) continue;
                this.weights[i] = (float)((double)this.weights[i] / sum);
            }
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] != -1) continue;
            this.indices[i] = 0;
        }
    }

    private double srcIndex(double dstIndex) {
        return (double)this.srcOrigin - 0.5 + (dstIndex + 0.5) * this.scale;
    }

    private double dstIndex(int srcIndex) {
        return ((double)(srcIndex - this.srcOrigin) + 0.5) / this.scale - 0.5;
    }

    protected float kernel(double x) {
        switch (this.interpolationMethod) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                return 1.0f - (float)Math.abs(x);
            }
            case 2: {
                return (float)ImageProcessor.cubic(x);
            }
        }
        return Float.NaN;
    }
}

