/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class FloodFiller {
    int maxStackSize = 500;
    int[] xstack = new int[this.maxStackSize];
    int[] ystack = new int[this.maxStackSize];
    int stackSize;
    ImageProcessor ip;
    int max;
    boolean isFloat;
    int count = 0;

    public FloodFiller(ImageProcessor ip) {
        this.ip = ip;
        this.isFloat = ip instanceof FloatProcessor;
    }

    /*
     * Unable to fully structure code
     */
    public boolean fill(int x, int y) {
        width = this.ip.getWidth();
        height = this.ip.getHeight();
        color = this.ip.getPixel(x, y);
        this.fillLine(this.ip, x, x, y);
        newColor = this.ip.getPixel(x, y);
        this.ip.putPixel(x, y, color);
        if (color == newColor) {
            return false;
        }
        this.stackSize = 0;
        this.push(x, y);
        block0: while (true) {
            if ((x = this.popx()) == -1) {
                return true;
            }
            y = this.popy();
            if (this.ip.getPixel(x, y) != color) continue;
            x2 = x;
            for (x1 = x; this.ip.getPixel(x1, y) == color && x1 >= 0; --x1) {
            }
            ++x1;
            while (this.ip.getPixel(x2, y) == color && x2 < width) {
                ++x2;
            }
            this.fillLine(this.ip, x1, --x2, y);
            inScanLine = false;
            for (i = x1; i <= x2; ++i) {
                if (!inScanLine && y > 0 && this.ip.getPixel(i, y - 1) == color) {
                    this.push(i, y - 1);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || y <= 0 || this.ip.getPixel(i, y - 1) == color) continue;
                inScanLine = false;
            }
            inScanLine = false;
            i = x1;
            while (true) {
                if (i <= x2) ** break;
                continue block0;
                if (!inScanLine && y < height - 1 && this.ip.getPixel(i, y + 1) == color) {
                    this.push(i, y + 1);
                    inScanLine = true;
                } else if (inScanLine && y < height - 1 && this.ip.getPixel(i, y + 1) != color) {
                    inScanLine = false;
                }
                ++i;
            }
            break;
        }
    }

    public boolean fill8(int x, int y) {
        int width = this.ip.getWidth();
        int height = this.ip.getHeight();
        int color = this.ip.getPixel(x, y);
        int wm1 = width - 1;
        int hm1 = height - 1;
        this.fillLine(this.ip, x, x, y);
        int newColor = this.ip.getPixel(x, y);
        this.ip.putPixel(x, y, color);
        if (color == newColor) {
            return false;
        }
        this.stackSize = 0;
        this.push(x, y);
        block0: while ((x = this.popx()) != -1) {
            int i;
            int x1;
            y = this.popy();
            int x2 = x;
            if (this.ip.getPixel(x1, y) == color) {
                for (x1 = x; this.ip.getPixel(x1, y) == color && x1 >= 0; --x1) {
                }
                ++x1;
                while (this.ip.getPixel(x2, y) == color && x2 < width) {
                    ++x2;
                }
                this.fillLine(this.ip, x1, --x2, y);
            }
            if (y > 0) {
                if (x1 > 0 && this.ip.getPixel(x1 - 1, y - 1) == color) {
                    this.push(x1 - 1, y - 1);
                }
                if (x2 < wm1 && this.ip.getPixel(x2 + 1, y - 1) == color) {
                    this.push(x2 + 1, y - 1);
                }
            }
            if (y < hm1) {
                if (x1 > 0 && this.ip.getPixel(x1 - 1, y + 1) == color) {
                    this.push(x1 - 1, y + 1);
                }
                if (x2 < wm1 && this.ip.getPixel(x2 + 1, y + 1) == color) {
                    this.push(x2 + 1, y + 1);
                }
            }
            boolean inScanLine = false;
            for (i = x1; i <= x2; ++i) {
                if (!inScanLine && y > 0 && this.ip.getPixel(i, y - 1) == color) {
                    this.push(i, y - 1);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || y <= 0 || this.ip.getPixel(i, y - 1) == color) continue;
                inScanLine = false;
            }
            inScanLine = false;
            i = x1;
            while (true) {
                if (i > x2) continue block0;
                if (!inScanLine && y < hm1 && this.ip.getPixel(i, y + 1) == color) {
                    this.push(i, y + 1);
                    inScanLine = true;
                } else if (inScanLine && y < hm1 && this.ip.getPixel(i, y + 1) != color) {
                    inScanLine = false;
                }
                ++i;
            }
            break;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void particleAnalyzerFill(int x, int y, double level1, double level2, ImageProcessor mask, Rectangle bounds) {
        width = this.ip.getWidth();
        height = this.ip.getHeight();
        if (x == 0 && y == 0 && level1 == 0.0 && level2 == 255.0 && this.ip.getBitDepth() == 8) {
            this.ip.fill();
            return;
        }
        mask.setColor(0);
        mask.fill();
        mask.setColor(255);
        this.stackSize = 0;
        this.push(x, y);
        block0: while (true) {
            if ((x = this.popx()) == -1) {
                return;
            }
            y = this.popy();
            if (!this.inParticle(x, y, level1, level2)) continue;
            x2 = x;
            for (x1 = x; this.inParticle(x1, y, level1, level2) && x1 >= 0; --x1) {
            }
            ++x1;
            while (this.inParticle(x2, y, level1, level2) && x2 < width) {
                ++x2;
            }
            this.fillLine(mask, x1 - bounds.x, --x2 - bounds.x, y - bounds.y);
            this.fillLine(this.ip, x1, x2, y);
            inScanLine = false;
            if (x1 > 0) {
                --x1;
            }
            if (x2 < width - 1) {
                ++x2;
            }
            for (i = x1; i <= x2; ++i) {
                if (!inScanLine && y > 0 && this.inParticle(i, y - 1, level1, level2)) {
                    this.push(i, y - 1);
                    inScanLine = true;
                    continue;
                }
                if (!inScanLine || y <= 0 || this.inParticle(i, y - 1, level1, level2)) continue;
                inScanLine = false;
            }
            inScanLine = false;
            i = x1;
            while (true) {
                if (i <= x2) ** break;
                continue block0;
                if (!inScanLine && y < height - 1 && this.inParticle(i, y + 1, level1, level2)) {
                    this.push(i, y + 1);
                    inScanLine = true;
                } else if (inScanLine && y < height - 1 && !this.inParticle(i, y + 1, level1, level2)) {
                    inScanLine = false;
                }
                ++i;
            }
            break;
        }
    }

    final boolean inParticle(int x, int y, double level1, double level2) {
        if (this.isFloat) {
            return (double)this.ip.getPixelValue(x, y) >= level1 && (double)this.ip.getPixelValue(x, y) <= level2;
        }
        int v = this.ip.getPixel(x, y);
        return (double)v >= level1 && (double)v <= level2;
    }

    final void push(int x, int y) {
        ++this.stackSize;
        if (this.stackSize == this.maxStackSize) {
            int[] newXStack = new int[this.maxStackSize * 2];
            int[] newYStack = new int[this.maxStackSize * 2];
            System.arraycopy(this.xstack, 0, newXStack, 0, this.maxStackSize);
            System.arraycopy(this.ystack, 0, newYStack, 0, this.maxStackSize);
            this.xstack = newXStack;
            this.ystack = newYStack;
            this.maxStackSize *= 2;
        }
        this.xstack[this.stackSize - 1] = x;
        this.ystack[this.stackSize - 1] = y;
    }

    final int popx() {
        if (this.stackSize == 0) {
            return -1;
        }
        return this.xstack[this.stackSize - 1];
    }

    final int popy() {
        int value = this.ystack[this.stackSize - 1];
        --this.stackSize;
        return value;
    }

    final void fillLine(ImageProcessor ip, int x1, int x2, int y) {
        if (x1 > x2) {
            int t2 = x1;
            x1 = x2;
            x2 = t2;
        }
        for (int x = x1; x <= x2; ++x) {
            ip.drawPixel(x, y);
        }
    }
}

