/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import ij.IJ;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    public static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE, 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public static void startAndJoin(Thread[] threads) {
        int ithread;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].setPriority(5);
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public static Thread[] createThreadArray(int nb) {
        if (nb == 0) {
            nb = ThreadUtil.getNbCpus();
        }
        Thread[] threads = new Thread[nb];
        return threads;
    }

    public static Thread[] createThreadArray() {
        return ThreadUtil.createThreadArray(0);
    }

    public static int getNbCpus() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static Future[] startAndJoin(Callable[] callables) {
        if (callables.length == 1) {
            Object callResult = null;
            try {
                callResult = callables[0].call();
            }
            catch (Exception e) {
                IJ.handleException(e);
            }
            final Object result = callResult;
            Future[] futures = new Future[]{new Future(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                public Object get() {
                    return result;
                }

                public Object get(long timeout2, TimeUnit unit) {
                    return result;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }
            }};
            return futures;
        }
        Future[] futures = ThreadUtil.start(callables);
        ThreadUtil.joinAll(futures);
        return futures;
    }

    public static Future[] start(Callable[] callables) {
        Future[] futures = new Future[callables.length];
        for (int i = 0; i < callables.length; ++i) {
            futures[i] = threadPoolExecutor.submit(callables[i]);
        }
        return futures;
    }

    public static void joinAll(Future[] futures) {
        boolean interrupted = false;
        for (int i = 0; i < futures.length; ++i) {
            Future f = futures[i];
            try {
                f.get();
                continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                for (int j = i; j < futures.length; ++j) {
                    futures[j].cancel(true);
                }
                --i;
                continue;
            }
            catch (CancellationException e) {
                continue;
            }
            catch (Exception eOther) {
                IJ.log("Error in thread called by " + Thread.currentThread().getName() + ":\n" + eOther);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
            threadPoolExecutor.purge();
        }
    }
}

