/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

public class WildcardMatch {
    boolean preceededByMultipleChar = false;
    private char sc = (char)63;
    private char mc = (char)42;
    private char ec = (char)92;
    private boolean caseSensitive = true;
    private boolean isEscaped = false;
    private int escCnt = 0;

    public WildcardMatch() {
    }

    public WildcardMatch(char singleChar, char multipleChars) {
        this.sc = singleChar;
        this.mc = multipleChars;
    }

    public void setWildcardChars(char singleChar, char multipleChars) {
        this.sc = singleChar;
        this.mc = multipleChars;
    }

    public void setEscapeChar(char escapeChar) {
        this.ec = escapeChar;
    }

    public char getSingleWildcardChar() {
        return this.sc;
    }

    public char getMultipleWildcardChar() {
        return this.mc;
    }

    public char getEscapeChar() {
        return this.ec;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean match(String s2, String pattern) {
        this.preceededByMultipleChar = false;
        this.isEscaped = false;
        if (!this.caseSensitive) {
            pattern = pattern.toLowerCase();
            s2 = s2.toLowerCase();
        }
        int offset = 0;
        do {
            String ps = this.getNextSubString(pattern);
            int len = ps.length();
            pattern = pattern.substring(len + this.escCnt);
            if (len > 0 && this.isWildcard(ps.charAt(0)) && this.escCnt == 0) {
                offset = this.getWildcardOffset(ps.charAt(0));
                if (this.isSingleWildcardChar(ps.charAt(0))) {
                    s2 = s2.substring(1);
                }
                if (pattern.length() != 0) continue;
                return s2.length() <= offset || this.preceededByMultipleChar;
            }
            int idx = s2.indexOf(ps);
            if (idx < 0 || idx > offset && !this.preceededByMultipleChar) {
                return false;
            }
            s2 = s2.substring(idx + len);
            this.preceededByMultipleChar = false;
        } while (pattern.length() != 0);
        return s2.length() == 0;
    }

    private String getNextSubString(String pat) {
        this.escCnt = 0;
        if ("".equals(pat)) {
            return "";
        }
        if (this.isWildcard(pat.charAt(0))) {
            if (pat.length() > 1 && !this.isSingleWildcardChar(pat.charAt(0)) && this.isSingleWildcardChar(pat.charAt(1))) {
                this.preceededByMultipleChar = true;
            }
            return pat.substring(0, 1);
        }
        String s2 = "";
        for (int i = 0; i < pat.length() && !this.isWildcard(pat.charAt(i), this.isEscaped); ++i) {
            if (pat.charAt(i) == this.ec) {
                boolean bl = this.isEscaped = !this.isEscaped;
                if (!this.isEscaped) {
                    s2 = s2 + pat.charAt(i);
                }
                ++this.escCnt;
                continue;
            }
            if (this.isWildcard(pat.charAt(i))) {
                this.isEscaped = false;
                s2 = s2 + pat.charAt(i);
                continue;
            }
            s2 = s2 + pat.charAt(i);
        }
        return s2;
    }

    private boolean isWildcard(char c, boolean isEsc) {
        return !isEsc && this.isWildcard(c);
    }

    private boolean isSingleWildcardChar(char c) {
        return c == this.sc;
    }

    private boolean isWildcard(char c) {
        return c == this.mc || c == this.sc;
    }

    private int getWildcardOffset(char c) {
        if (c == this.mc) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

