/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.Digest;
import io.minio.Signer;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.joda.time.DateTime;

class ChunkedInputStream
extends InputStream {
    private static final int CHUNK_SIZE = 65536;
    private static final int FULL_CHUNK_LEN = 65626;
    private static final int CHUNK_SIGNATURE_METADATA_LEN = 85;
    private static final int FINAL_ADDITIONAL_CHUNK_LEN = 86;
    private InputStream inputStream;
    private int streamSize;
    private int length;
    private DateTime date;
    private String region;
    private String secretKey;
    private String prevSignature;
    private int streamBytesRead = 0;
    private byte[] chunkBody = new byte[0];
    private int chunkPos = 0;
    private boolean isEof = false;
    private int bytesRead = 0;

    public ChunkedInputStream(InputStream inputStream2, int streamSize, DateTime date, String region, String secretKey, String seedSignature) throws IOException {
        this.inputStream = inputStream2;
        this.streamSize = streamSize;
        this.date = date;
        this.region = region;
        this.secretKey = secretKey;
        this.prevSignature = seedSignature;
        int fullChunks = this.streamSize / 65536;
        this.length = fullChunks * 65626;
        int lastChunkLen = this.streamSize % 65536;
        if (lastChunkLen > 0) {
            this.length += Integer.toHexString(lastChunkLen).getBytes(StandardCharsets.UTF_8).length;
            this.length += 85;
            this.length += lastChunkLen;
        }
        this.length += 86;
    }

    private int readData(byte[] buf) throws IOException {
        if (this.isEof) {
            return -1;
        }
        int pos = 0;
        int len = buf.length;
        int totalBytesRead = 0;
        int bytesRead = 0;
        while (totalBytesRead < buf.length) {
            bytesRead = this.inputStream.read(buf, pos, len);
            if (bytesRead < 0) {
                this.isEof = true;
                break;
            }
            pos = bytesRead;
            len = buf.length - (totalBytesRead += bytesRead);
        }
        return totalBytesRead;
    }

    private void createChunkBody(byte[] chunk) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InsufficientDataException, InternalException {
        String chunkSha256 = Digest.sha256Hash(chunk, chunk.length);
        String signature = Signer.getChunkSignature(chunkSha256, this.date, this.region, this.secretKey, this.prevSignature);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(Integer.toHexString(chunk.length).getBytes(StandardCharsets.UTF_8));
        os.write(";chunk-signature=".getBytes(StandardCharsets.UTF_8));
        os.write(signature.getBytes(StandardCharsets.UTF_8));
        os.write("\r\n".getBytes(StandardCharsets.UTF_8));
        os.write(chunk, 0, chunk.length);
        os.write("\r\n".getBytes(StandardCharsets.UTF_8));
        this.chunkBody = os.toByteArray();
        this.chunkPos = 0;
        this.prevSignature = signature;
    }

    private int readChunk(int chunkSize) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InsufficientDataException, InternalException {
        byte[] chunk = new byte[chunkSize];
        int len = this.readData(chunk);
        if (len < 0) {
            return -1;
        }
        if (len != chunkSize) {
            throw new InsufficientDataException("Insufficient data.  read = " + len + " expected = " + chunkSize);
        }
        this.createChunkBody(chunk);
        return this.chunkBody.length;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRead == this.length) {
            return -1;
        }
        try {
            if (this.streamBytesRead == 0 || this.chunkPos == this.chunkBody.length) {
                if (this.streamBytesRead != this.streamSize) {
                    int chunkSize = 65536;
                    if (this.streamBytesRead + chunkSize > this.streamSize) {
                        chunkSize = this.streamSize - this.streamBytesRead;
                    }
                    if (this.readChunk(chunkSize) < 0) {
                        return -1;
                    }
                    this.streamBytesRead += chunkSize;
                } else {
                    byte[] chunk = new byte[]{};
                    this.createChunkBody(chunk);
                }
            }
            ++this.bytesRead;
            int value = this.chunkBody[this.chunkPos] & 0xFF;
            ++this.chunkPos;
            return value;
        }
        catch (InsufficientDataException | InternalException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException(e.getCause());
        }
    }

    public int length() {
        return this.length;
    }
}

