/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.dicom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.dicom.DicomAttribute;
import loci.formats.dicom.DicomVR;
import loci.formats.dicom.ResolutionStrategy;

public class DicomTag
implements Comparable<DicomTag> {
    public DicomTag parent = null;
    public List<DicomTag> children = new ArrayList<DicomTag>();
    public int tag;
    public DicomAttribute attribute = null;
    public DicomVR vr = null;
    public String key = null;
    public Object value = null;
    public int elementLength = 0;
    private long start = 0L;
    private boolean bigEndianTransferSyntax = false;
    private boolean oddLocations = false;
    public ResolutionStrategy strategy = null;

    public DicomTag(DicomAttribute attribute) {
        this(attribute, null);
    }

    public DicomTag(DicomAttribute attribute, DicomVR vr) {
        this.attribute = attribute;
        this.vr = vr != null ? vr : attribute.getDefaultVR();
        this.tag = attribute.getTag();
    }

    public DicomTag(int tag, DicomVR vr) {
        this.tag = tag;
        this.attribute = DicomAttribute.get(tag);
        if (vr != null) {
            this.vr = vr;
        } else if (this.attribute != null) {
            this.vr = this.attribute.getDefaultVR();
        }
    }

    public DicomTag(RandomAccessInputStream in, boolean bigEndian, long location, boolean oddLocations) throws FormatException, IOException {
        this(in, bigEndian, location, oddLocations, true);
    }

    public DicomTag(RandomAccessInputStream in, boolean bigEndian, long location, boolean oddLocations, boolean readValue) throws FormatException, IOException {
        this.bigEndianTransferSyntax = bigEndian;
        this.oddLocations = oddLocations;
        this.tag = this.getNextTag(in);
        this.attribute = DicomAttribute.get(this.tag);
        this.start = in.getFilePointer();
        this.key = this.attribute != null ? this.attribute.getDescription() : DicomAttribute.getDescription(this.tag);
        String id = null;
        if (this.attribute != null) {
            DicomVR altVR;
            id = this.attribute.getDescription();
            if (this.vr == DicomVR.IMPLICIT && id != null && (altVR = DicomVR.get((id.charAt(0) << 8) + id.charAt(1))) != null) {
                this.vr = altVR;
            }
            if (id.length() > 2) {
                id = id.substring(2);
            }
            if (this.attribute == DicomAttribute.RED_LUT_DATA || this.attribute == DicomAttribute.GREEN_LUT_DATA || this.attribute == DicomAttribute.BLUE_LUT_DATA || this.attribute == DicomAttribute.SEGMENTED_RED_LUT_DATA || this.attribute == DicomAttribute.SEGMENTED_GREEN_LUT_DATA || this.attribute == DicomAttribute.SEGMENTED_BLUE_LUT_DATA) {
                this.vr = DicomVR.US;
            }
        } else if (this.vr == DicomVR.IMPLICIT) {
            this.vr = DicomAttribute.getDefaultVR(this.tag);
        }
        if (!readValue || this.attribute == DicomAttribute.PIXEL_DATA) {
            long skip = (long)this.elementLength & 0xFFFFFFFFL;
            if (skip > 0L && skip <= in.length() - in.getFilePointer()) {
                in.skipBytes(skip);
            }
            return;
        }
        if (this.attribute == DicomAttribute.ITEM) {
            this.value = id;
        }
        if (this.value == null) {
            boolean skip;
            boolean bl = skip = this.vr == null;
            if ((this.vr == DicomVR.IMPLICIT || this.vr == DicomVR.RESERVED) && this.attribute != null) {
                this.vr = this.attribute.getDefaultVR();
            }
            if (this.vr != null) {
                switch (this.vr) {
                    case AE: 
                    case AS: 
                    case CS: 
                    case DA: 
                    case DS: 
                    case DT: 
                    case IS: 
                    case LO: 
                    case LT: 
                    case PN: 
                    case SH: 
                    case ST: 
                    case TM: 
                    case UC: 
                    case UI: 
                    case UR: 
                    case UT: {
                        this.value = in.readString(this.elementLength);
                        break;
                    }
                    case AT: {
                        short[] pair = new short[]{in.readShort(), in.readShort()};
                        this.value = pair;
                        break;
                    }
                    case FL: {
                        if (this.elementLength % 4 == 0 && this.elementLength > 4) {
                            float[] f = new float[this.elementLength / 4];
                            for (int i = 0; i < f.length; ++i) {
                                f[i] = in.readFloat();
                            }
                            this.value = f;
                            break;
                        }
                        this.value = Float.valueOf(in.readFloat());
                        break;
                    }
                    case FD: {
                        if (this.elementLength % 8 == 0 && this.elementLength > 8) {
                            double[] d = new double[this.elementLength / 8];
                            for (int i = 0; i < d.length; ++i) {
                                d[i] = in.readDouble();
                            }
                            this.value = d;
                            break;
                        }
                        this.value = in.readDouble();
                        break;
                    }
                    case OB: {
                        this.value = new byte[this.elementLength];
                        in.read((byte[])this.value);
                        break;
                    }
                    case SL: {
                        if (this.elementLength % 4 == 0 && this.elementLength > 4) {
                            long[] v = new long[this.elementLength / 4];
                            for (int i = 0; i < v.length; ++i) {
                                v[i] = in.readInt();
                            }
                            this.value = v;
                            break;
                        }
                        this.value = in.readInt();
                        break;
                    }
                    case SS: {
                        if (this.elementLength == 2) {
                            this.value = in.readShort();
                            break;
                        }
                        short[] values2 = new short[this.elementLength / 2];
                        for (int i = 0; i < values2.length; ++i) {
                            values2[i] = in.readShort();
                        }
                        this.value = values2;
                        break;
                    }
                    case SV: {
                        if (this.elementLength % 8 == 0 && this.elementLength > 8) {
                            long[] v = new long[this.elementLength / 8];
                            for (int i = 0; i < v.length; ++i) {
                                v[i] = in.readLong();
                            }
                            this.value = v;
                            break;
                        }
                        this.value = in.readLong();
                        break;
                    }
                    case UL: {
                        if (this.elementLength % 4 == 0 && this.elementLength > 4) {
                            long[] v = new long[this.elementLength / 4];
                            for (int i = 0; i < v.length; ++i) {
                                v[i] = (long)in.readInt() & 0xFFFFFFFFL;
                            }
                            this.value = v;
                            break;
                        }
                        this.value = (long)in.readInt() & 0xFFFFFFFFL;
                        break;
                    }
                    case US: {
                        if (this.elementLength == 2) {
                            this.value = in.readShort();
                            break;
                        }
                        short[] values3 = new short[this.elementLength / 2];
                        for (int i = 0; i < values3.length; ++i) {
                            values3[i] = in.readShort();
                        }
                        this.value = values3;
                        break;
                    }
                    case IMPLICIT: {
                        if (this.elementLength == 2) {
                            this.value = in.readShort();
                            break;
                        }
                        if (this.elementLength <= 44) {
                            this.value = in.readString(this.elementLength);
                            break;
                        }
                        short[] values4 = new short[this.elementLength / 2];
                        for (int i = 0; i < values4.length; ++i) {
                            values4[i] = in.readShort();
                        }
                        this.value = values4;
                        break;
                    }
                    case SQ: {
                        long stop = in.getFilePointer() + (long)this.elementLength;
                        if (this.elementLength == -1) {
                            stop = in.length();
                            this.elementLength = 0;
                        }
                        block24: while (in.getFilePointer() < stop) {
                            long fp = in.getFilePointer();
                            DicomTag child = new DicomTag(in, bigEndian, location, oddLocations);
                            if (child.attribute == DicomAttribute.SEQUENCE_DELIMITATION_ITEM) {
                                stop = in.getFilePointer();
                                break;
                            }
                            if (child.attribute == DicomAttribute.PIXEL_DATA) {
                                child.parent = this;
                                this.children.add(child);
                                if (child.elementLength != -1) continue;
                                long seek = fp - 2L;
                                int nextTag = 0;
                                while (seek < in.length() && nextTag != DicomAttribute.SEQUENCE_DELIMITATION_ITEM.getTag() && nextTag != DicomAttribute.ITEM_DELIMITATION_ITEM.getTag()) {
                                    in.seek(seek += 2L);
                                    try {
                                        nextTag = this.getNextTag(in);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (nextTag != -16785952 && nextTag != -16839410) continue;
                                    in.order(!in.isLittleEndian());
                                    continue block24;
                                }
                                continue;
                            }
                            if (child.attribute == DicomAttribute.ITEM || child.attribute == DicomAttribute.ITEM_DELIMITATION_ITEM) continue;
                            child.parent = this;
                            this.children.add(child);
                        }
                        if (this.elementLength <= 0) {
                            this.elementLength = (int)(stop - this.start);
                        }
                        in.seek(stop);
                        break;
                    }
                    default: {
                        skip = true;
                    }
                }
            }
            if (skip && this.elementLength > 0) {
                long skipCount = this.elementLength;
                if (in.getFilePointer() + skipCount <= in.length()) {
                    in.skipBytes(skipCount);
                }
                location += (long)this.elementLength;
                this.value = "";
            }
        }
    }

    private int getNextTag(RandomAccessInputStream in) throws FormatException, IOException {
        long fp = in.getFilePointer();
        if (fp >= in.length() - 2L) {
            return 0;
        }
        int groupWord = in.readShort() & 0xFFFF;
        if (groupWord == 2048 && this.bigEndianTransferSyntax) {
            groupWord = 8;
            in.order(false);
        }
        short elementWord = in.readShort();
        int tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
        this.elementLength = this.getLength(in);
        if ((long)this.elementLength > in.length()) {
            in.seek(fp);
            in.order(!in.isLittleEndian());
            groupWord = in.readShort() & 0xFFFF;
            elementWord = in.readShort();
            tag = groupWord << 16 & 0xFFFF0000 | elementWord & 0xFFFF;
            this.elementLength = this.getLength(in);
            if ((long)this.elementLength > in.length()) {
                throw new FormatException("Invalid tag length " + this.elementLength);
            }
            return tag;
        }
        if (groupWord == 32736) {
            long length = (long)this.elementLength & 0xFFFFFFFFL;
            if (this.elementLength == -1 || length > 0L && length < in.length()) {
                return tag;
            }
            in.skipBytes(12);
            this.elementLength = in.readInt();
            if (this.elementLength < 0) {
                this.elementLength = in.readInt();
            }
        }
        if (this.elementLength == 0 && (groupWord == 32736 || tag == 2691092)) {
            this.elementLength = this.getLength(in);
        } else if (this.elementLength == 0) {
            in.seek(in.getFilePointer() - 4L);
            DicomVR v = DicomVR.get(in.readShort() & 0xFFFF);
            if (v == DicomVR.UT) {
                in.skipBytes(2);
                this.elementLength = in.readInt();
            } else {
                in.skipBytes(2);
            }
        }
        if (!this.oddLocations && this.elementLength % 2 == 1) {
            ++this.elementLength;
        }
        return tag;
    }

    private int getLength(RandomAccessInputStream in) throws IOException {
        byte[] b = new byte[4];
        in.read(b);
        this.vr = DicomVR.get((b[0] & 0xFF) << 8 | b[1] & 0xFF);
        if (this.vr == null) {
            this.vr = DicomVR.IMPLICIT;
            int len = DataTools.bytesToInt(b, in.isLittleEndian());
            if ((long)len + in.getFilePointer() > in.length() || len < 0) {
                len = DataTools.bytesToInt(b, 2, 2, in.isLittleEndian());
                len &= 0xFFFF;
            }
            return len;
        }
        switch (this.vr) {
            case UC: 
            case UT: 
            case OB: 
            case SQ: 
            case OV: 
            case OW: 
            case UN: {
                if (b[2] == 0 || b[3] == 0) {
                    return in.readInt();
                }
                this.vr = DicomVR.IMPLICIT;
                return DataTools.bytesToInt(b, in.isLittleEndian());
            }
            case AE: 
            case AS: 
            case CS: 
            case DA: 
            case DS: 
            case DT: 
            case IS: 
            case LO: 
            case LT: 
            case PN: 
            case SH: 
            case ST: 
            case TM: 
            case UI: 
            case AT: 
            case FL: 
            case FD: 
            case SL: 
            case SS: 
            case UL: 
            case US: 
            case QQ: {
                if (this.attribute == DicomAttribute.LUT_DATA) {
                    return DataTools.bytesToInt(b, 2, 2, in.isLittleEndian());
                }
                int n1 = DataTools.bytesToShort(b, 2, 2, in.isLittleEndian());
                int n2 = DataTools.bytesToShort(b, 2, 2, !in.isLittleEndian());
                n2 &= 0xFFFF;
                if ((n1 &= 0xFFFF) < 0 || (long)n1 + in.getFilePointer() > in.length()) {
                    return n2;
                }
                if (n2 < 0 || (long)n2 + in.getFilePointer() > in.length()) {
                    return n1;
                }
                return n1;
            }
            case RESERVED: {
                int len = DataTools.bytesToInt(b, 0, 4, in.isLittleEndian());
                if (len == -1) {
                    return len;
                }
                this.vr = DicomVR.IMPLICIT;
                return 8;
            }
        }
        throw new IllegalArgumentException(this.vr.toString());
    }

    public String getStringValue() {
        return this.value == null ? null : this.value.toString().trim();
    }

    public Number getNumberValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        String v = this.value.toString().trim();
        try {
            return new Double(v);
        }
        catch (NumberFormatException e) {
            return DataTools.parseDouble(v);
        }
    }

    public long getValueStartPointer() {
        return this.start;
    }

    public long getEndPointer() {
        if (this.elementLength < 0) {
            return this.start;
        }
        return this.start + (long)this.elementLength;
    }

    public DicomTag lookupChild(DicomAttribute attr) {
        for (DicomTag child : this.children) {
            if (child.attribute != attr) continue;
            return child;
        }
        return null;
    }

    public boolean validate(List<DicomTag> tags) {
        for (DicomTag t2 : tags) {
            if (this.tag != t2.tag) continue;
            return this.strategy != ResolutionStrategy.IGNORE;
        }
        return true;
    }

    public void validateValue() {
        if (this.value == null) {
            return;
        }
        switch (this.vr) {
            case AE: 
            case AS: 
            case CS: 
            case DA: 
            case DS: 
            case DT: 
            case IS: 
            case LO: 
            case LT: 
            case PN: 
            case SH: 
            case ST: 
            case TM: 
            case UC: 
            case UI: 
            case UR: 
            case UT: {
                this.value = this.value.toString();
                break;
            }
            case AT: 
            case SS: 
            case US: {
                if (this.value instanceof Short) {
                    this.value = new short[]{(Short)this.value};
                    break;
                }
                if (this.value instanceof String) {
                    String[] values2 = ((String)this.value).split(",");
                    short[] v = new short[values2.length];
                    for (int i = 0; i < values2.length; ++i) {
                        v[i] = Short.decode(values2[i]);
                    }
                    this.value = v;
                    break;
                }
                if (this.value instanceof short[]) break;
                throw new IllegalArgumentException("Incorrect value type " + this.value.getClass() + " for VR " + (Object)((Object)this.vr));
            }
            case FL: {
                if (this.value instanceof Float) {
                    this.value = new float[]{((Float)this.value).floatValue()};
                    break;
                }
                if (this.value instanceof String) {
                    String[] values3 = ((String)this.value).split(",");
                    float[] v = new float[values3.length];
                    for (int i = 0; i < values3.length; ++i) {
                        v[i] = Float.parseFloat(values3[i]);
                    }
                    this.value = v;
                    break;
                }
                if (this.value instanceof float[]) break;
                throw new IllegalArgumentException("Incorrect value type " + this.value.getClass() + " for VR " + (Object)((Object)this.vr));
            }
            case FD: {
                if (this.value instanceof Double) {
                    this.value = new double[]{(Double)this.value};
                    break;
                }
                if (this.value instanceof String) {
                    String[] values4 = ((String)this.value).split(",");
                    double[] v = new double[values4.length];
                    for (int i = 0; i < values4.length; ++i) {
                        v[i] = Double.parseDouble(values4[i]);
                    }
                    this.value = v;
                    break;
                }
                if (this.value instanceof double[]) break;
                throw new IllegalArgumentException("Incorrect value type " + this.value.getClass() + " for VR " + (Object)((Object)this.vr));
            }
            case OB: 
            case IMPLICIT: {
                if (this.value instanceof Byte) {
                    this.value = new byte[]{(Byte)this.value};
                    break;
                }
                if (this.value instanceof String) {
                    String[] values5 = ((String)this.value).split(",");
                    byte[] v = new byte[values5.length];
                    for (int i = 0; i < values5.length; ++i) {
                        v[i] = Byte.decode(values5[i]);
                    }
                    this.value = v;
                    break;
                }
                if (this.value instanceof byte[]) break;
                throw new IllegalArgumentException("Incorrect value type " + this.value.getClass() + " for VR " + (Object)((Object)this.vr));
            }
            case SL: {
                if (this.value instanceof Integer) {
                    this.value = new int[]{(Integer)this.value};
                    break;
                }
                if (this.value instanceof String) {
                    String[] values6 = ((String)this.value).split(",");
                    int[] v = new int[values6.length];
                    for (int i = 0; i < values6.length; ++i) {
                        v[i] = Integer.decode(values6[i]);
                    }
                    this.value = v;
                    break;
                }
                if (this.value instanceof int[]) break;
                throw new IllegalArgumentException("Incorrect value type " + this.value.getClass() + " for VR " + (Object)((Object)this.vr));
            }
            case SV: 
            case UL: {
                if (this.value instanceof Long) {
                    this.value = new long[]{(Long)this.value};
                    break;
                }
                if (this.value instanceof String) {
                    String[] values7 = ((String)this.value).split(",");
                    long[] v = new long[values7.length];
                    for (int i = 0; i < values7.length; ++i) {
                        v[i] = Long.decode(values7[i]);
                    }
                    this.value = v;
                    break;
                }
                if (this.value instanceof long[]) break;
                throw new IllegalArgumentException("Incorrect value type " + this.value.getClass() + " for VR " + (Object)((Object)this.vr));
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(this.vr.getCode()));
            }
        }
    }

    public boolean isPrivateContentCreator() {
        int highWord = this.tag >> 16 & 0xFFFF;
        int lowWord = this.tag & 0xFFFF;
        return highWord % 2 == 1 && lowWord == 16;
    }

    public String toString() {
        if (this.key == null) {
            this.key = this.attribute != null ? this.attribute.getDescription() : DicomAttribute.getDescription(this.tag);
        }
        return this.key + " = " + this.value;
    }

    @Override
    public int compareTo(DicomTag o) {
        int thisTag = this.attribute == null ? this.tag : this.attribute.getTag();
        int otherTag = o.attribute == null ? o.tag : o.attribute.getTag();
        return thisTag - otherTag;
    }
}

