/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Hashtable;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.gui.Index16ColorModel;
import loci.formats.gui.SignedByteBuffer;
import loci.formats.gui.SignedColorModel;
import loci.formats.gui.SignedShortBuffer;
import loci.formats.gui.TwoChannelColorSpace;
import loci.formats.gui.UnsignedIntBuffer;
import loci.formats.gui.UnsignedIntColorModel;
import loci.formats.meta.MetadataRetrieve;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWTImageTools {
    protected static final Component OBS = new Container();
    private static final Logger LOGGER = LoggerFactory.getLogger(AWTImageTools.class);

    private AWTImageTools() {
    }

    public static BufferedImage makeImage(byte[] data, int w, int h2, boolean signed) {
        return AWTImageTools.makeImage(new byte[][]{data}, w, h2, signed);
    }

    public static BufferedImage makeImage(short[] data, int w, int h2, boolean signed) {
        return AWTImageTools.makeImage(new short[][]{data}, w, h2, signed);
    }

    public static BufferedImage makeImage(int[] data, int w, int h2, boolean signed) {
        return AWTImageTools.makeImage(new int[][]{data}, w, h2, signed);
    }

    public static BufferedImage makeImage(float[] data, int w, int h2) {
        return AWTImageTools.makeImage(new float[][]{data}, w, h2);
    }

    public static BufferedImage makeImage(double[] data, int w, int h2) {
        return AWTImageTools.makeImage(new double[][]{data}, w, h2);
    }

    public static BufferedImage makeImage(byte[] data, int w, int h2, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2, signed);
        }
        if (c > 2) {
            return AWTImageTools.makeRGBImage(data, c, w, h2, interleaved);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, c * w * h2) : new DataBufferByte(data, c * w * h2);
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(short[] data, int w, int h2, int c, boolean interleaved, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2, signed);
        }
        if (signed) {
            dataType = 2;
            buffer = new SignedShortBuffer(data, c * w * h2);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, c * w * h2);
        }
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(int[] data, int w, int h2, int c, boolean interleaved, boolean signed) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2, signed);
        }
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, c * w * h2) : new UnsignedIntBuffer(data, c * w * h2);
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(float[] data, int w, int h2, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2);
        }
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, c * w * h2);
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(double[] data, int w, int h2, int c, boolean interleaved) {
        if (c == 1) {
            return AWTImageTools.makeImage(data, w, h2);
        }
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, c * w * h2);
        return AWTImageTools.constructImage(c, dataType, w, h2, interleaved, false, buffer);
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h2, boolean signed) {
        if (data.length > 2) {
            return AWTImageTools.makeRGBImage(data, w, h2);
        }
        int dataType = 0;
        DataBuffer buffer = signed ? new SignedByteBuffer(data, data[0].length) : new DataBufferByte(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(short[][] data, int w, int h2, boolean signed) {
        DataBuffer buffer;
        int dataType;
        if (signed) {
            dataType = 2;
            buffer = new SignedShortBuffer(data, data[0].length);
        } else {
            dataType = 1;
            buffer = new DataBufferUShort(data, data[0].length);
        }
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(int[][] data, int w, int h2, boolean signed) {
        int dataType = 3;
        DataBuffer buffer = signed ? new DataBufferInt(data, data[0].length) : new UnsignedIntBuffer(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(float[][] data, int w, int h2) {
        int dataType = 4;
        DataBufferFloat buffer = new DataBufferFloat(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(double[][] data, int w, int h2) {
        int dataType = 5;
        DataBufferDouble buffer = new DataBufferDouble(data, data[0].length);
        return AWTImageTools.constructImage(data.length, dataType, w, h2, false, true, buffer);
    }

    public static BufferedImage makeImage(byte[] data, boolean interleaved, MetadataRetrieve meta, int series) throws FormatException {
        MetadataTools.verifyMinimumPopulated(meta, series);
        int width = (Integer)meta.getPixelsSizeX(series).getValue();
        int height = (Integer)meta.getPixelsSizeY(series).getValue();
        String pixelType = meta.getPixelsType(series).toString();
        int type = FormatTools.pixelTypeFromString(pixelType);
        PositiveInteger nChannels = meta.getChannelSamplesPerPixel(series, 0);
        if (nChannels == null) {
            LOGGER.warn("SamplesPerPixel is null; it is assumed to be 1.");
        }
        int channels = nChannels == null ? 1 : (Integer)nChannels.getValue();
        boolean littleEndian = false;
        if (meta.getPixelsBigEndian(series) != null) {
            littleEndian = meta.getPixelsBigEndian(series) == false;
        } else if (meta.getPixelsBinDataCount(series) == 0) {
            littleEndian = meta.getPixelsBinDataBigEndian(series, 0) == false;
        }
        return AWTImageTools.makeImage(data, width, height, channels, interleaved, FormatTools.getBytesPerPixel(type), FormatTools.isFloatingPoint(type), littleEndian, FormatTools.isSigned(type));
    }

    public static BufferedImage makeImage(byte[] data, int w, int h2, int c, boolean interleaved, int bpp, boolean fp, boolean little, boolean signed) {
        Object pixels = DataTools.makeDataArray(data, bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
        if (pixels instanceof byte[]) {
            return AWTImageTools.makeImage((byte[])pixels, w, h2, c, interleaved, signed);
        }
        if (pixels instanceof short[]) {
            return AWTImageTools.makeImage((short[])pixels, w, h2, c, interleaved, signed);
        }
        if (pixels instanceof int[]) {
            return AWTImageTools.makeImage((int[])pixels, w, h2, c, interleaved, signed);
        }
        if (pixels instanceof float[]) {
            return AWTImageTools.makeImage((float[])pixels, w, h2, c, interleaved);
        }
        if (pixels instanceof double[]) {
            return AWTImageTools.makeImage((double[])pixels, w, h2, c, interleaved);
        }
        return null;
    }

    public static BufferedImage makeImage(byte[][] data, int w, int h2, int bpp, boolean fp, boolean little, boolean signed) {
        int c = data.length;
        Object v = null;
        for (int i = 0; i < c; ++i) {
            Object pixels = DataTools.makeDataArray(data[i], bpp % 3 == 0 ? bpp / 3 : bpp, fp, little);
            if (pixels instanceof byte[]) {
                if (v == null) {
                    v = new byte[c][];
                }
                ((byte[][])v)[i] = (byte[])pixels;
                continue;
            }
            if (pixels instanceof short[]) {
                if (v == null) {
                    v = new short[c][];
                }
                ((short[][])v)[i] = (short[])pixels;
                continue;
            }
            if (pixels instanceof int[]) {
                if (v == null) {
                    v = new int[c][];
                }
                ((int[][])v)[i] = (int[])pixels;
                continue;
            }
            if (pixels instanceof float[]) {
                if (v == null) {
                    v = new float[c][];
                }
                ((float[][])v)[i] = (float[])pixels;
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            if (v == null) {
                v = new double[c][];
            }
            ((double[][])v)[i] = (double[])pixels;
        }
        if (v instanceof byte[][]) {
            return AWTImageTools.makeImage(v, w, h2, signed);
        }
        if (v instanceof short[][]) {
            return AWTImageTools.makeImage((short[][])v, w, h2, signed);
        }
        if (v instanceof int[][]) {
            return AWTImageTools.makeImage((int[][])v, w, h2, signed);
        }
        if (v instanceof float[][]) {
            return AWTImageTools.makeImage(v, w, h2);
        }
        if (v instanceof double[][]) {
            return AWTImageTools.makeImage((double[][])v, w, h2);
        }
        return null;
    }

    public static BufferedImage makeRGBImage(byte[] data, int c, int w, int h2, boolean interleaved) {
        int cc = Math.min(c, 4);
        int[] buf = new int[data.length / c];
        int nBits = (cc - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < cc; ++q) {
                if (interleaved) {
                    int n = i;
                    buf[n] = buf[n] | (data[i * c + q] & 0xFF) << nBits - q * 8;
                    continue;
                }
                int n = i;
                buf[n] = buf[n] | (data[q * buf.length + i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImageTools.constructImage(cc, 3, w, h2, false, false, buffer);
    }

    public static BufferedImage makeRGBImage(byte[][] data, int w, int h2) {
        int[] buf = new int[data[0].length];
        int nBits = (data.length - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            for (int q = 0; q < data.length; ++q) {
                int n = i;
                buf[n] = buf[n] | (data[q][i] & 0xFF) << nBits - q * 8;
            }
        }
        DataBufferInt buffer = new DataBufferInt(buf, buf.length);
        return AWTImageTools.constructImage(data.length, 3, w, h2, false, false, buffer);
    }

    public static BufferedImage blankImage(int w, int h2, int c, int type) {
        switch (type) {
            case 0: {
                return AWTImageTools.makeImage(new byte[c][w * h2], w, h2, true);
            }
            case 1: {
                return AWTImageTools.makeImage(new byte[c][w * h2], w, h2, false);
            }
            case 2: {
                return AWTImageTools.makeImage(new short[c][w * h2], w, h2, true);
            }
            case 3: {
                return AWTImageTools.makeImage(new short[c][w * h2], w, h2, false);
            }
            case 4: {
                return AWTImageTools.makeImage(new int[c][w * h2], w, h2, true);
            }
            case 5: {
                return AWTImageTools.makeImage(new int[c][w * h2], w, h2, false);
            }
            case 6: {
                return AWTImageTools.makeImage(new float[c][w * h2], w, h2);
            }
            case 7: {
                return AWTImageTools.makeImage(new double[c][w * h2], w, h2);
            }
        }
        return null;
    }

    public static BufferedImage constructImage(int c, int type, int w, int h2, boolean interleaved, boolean banded, DataBuffer buffer) {
        return AWTImageTools.constructImage(c, type, w, h2, interleaved, banded, buffer, null);
    }

    public static BufferedImage constructImage(int c, int type, int w, int h2, boolean interleaved, boolean banded, DataBuffer buffer, ColorModel colorModel) {
        int[] bandOffsets;
        SampleModel model;
        int i;
        if (c > 4) {
            throw new IllegalArgumentException("Cannot construct image with " + c + " channels");
        }
        if (colorModel == null || colorModel instanceof DirectColorModel) {
            colorModel = AWTImageTools.makeColorModel(c, type);
            if (colorModel == null) {
                return null;
            }
            if (buffer instanceof UnsignedIntBuffer) {
                try {
                    colorModel = new UnsignedIntColorModel(32, type, c);
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        if (c > 2 && type == 3 && buffer.getNumBanks() == 1 && !(buffer instanceof UnsignedIntBuffer)) {
            int[] bitMasks = new int[c];
            for (i = 0; i < c; ++i) {
                bitMasks[i] = 255 << (c - i - 1) * 8;
            }
            model = new SinglePixelPackedSampleModel(3, w, h2, bitMasks);
        } else if (banded) {
            model = new BandedSampleModel(type, w, h2, c);
        } else if (interleaved) {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i;
            }
            model = new PixelInterleavedSampleModel(type, w, h2, c, c * w, bandOffsets);
        } else {
            bandOffsets = new int[c];
            for (i = 0; i < c; ++i) {
                bandOffsets[i] = i * w * h2;
            }
            model = new ComponentSampleModel(type, w, h2, 1, w, bandOffsets);
        }
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        BufferedImage b = null;
        if (c == 1 && type == 0 && !(buffer instanceof SignedByteBuffer)) {
            b = colorModel instanceof IndexColorModel ? new BufferedImage(w, h2, 13) : new BufferedImage(w, h2, 10);
            b.setData(raster);
        } else if (c == 1 && type == 1) {
            if (!(colorModel instanceof IndexColorModel)) {
                b = new BufferedImage(w, h2, 11);
                b.setData(raster);
            }
        } else if (c > 2 && type == 3 && buffer.getNumBanks() == 1 && !(buffer instanceof UnsignedIntBuffer)) {
            if (c == 3) {
                b = new BufferedImage(w, h2, 1);
            } else if (c == 4) {
                b = new BufferedImage(w, h2, 2);
            }
            if (b != null) {
                b.setData(raster);
            }
        }
        if (b == null) {
            b = new BufferedImage(colorModel, raster, false, null);
        }
        return b;
    }

    public static BufferedImage openImage(byte[] buf, IFormatReader r, int w, int h2) throws FormatException, IOException {
        return AWTImageTools.openImage(buf, r, w, h2, r.isNormalized());
    }

    public static BufferedImage openImage(byte[] buf, IFormatReader r, int w, int h2, boolean normal) throws FormatException, IOException {
        int bpp;
        BufferedImage b;
        int pixelType = r.getPixelType();
        boolean little = r.isLittleEndian();
        int rgbChanCount = r.getRGBChannelCount();
        boolean interleaved = r.isInterleaved();
        boolean indexed = r.isIndexed();
        if (pixelType == 6) {
            float[] f = (float[])DataTools.makeDataArray(buf, 4, true, little);
            if (normal) {
                f = DataTools.normalizeFloats(f);
            }
            return AWTImageTools.makeImage(f, w, h2, rgbChanCount, interleaved);
        }
        if (pixelType == 7) {
            double[] d = (double[])DataTools.makeDataArray(buf, 8, true, little);
            if (normal) {
                d = DataTools.normalizeDoubles(d);
            }
            return AWTImageTools.makeImage(d, w, h2, rgbChanCount, interleaved);
        }
        boolean signed = FormatTools.isSigned(pixelType);
        ColorModel model = null;
        if (signed) {
            if (pixelType == 0) {
                model = new SignedColorModel(8, 0, rgbChanCount);
            } else if (pixelType == 2) {
                model = new SignedColorModel(16, 2, rgbChanCount);
            } else if (pixelType == 4) {
                model = new SignedColorModel(32, 3, rgbChanCount);
            }
        }
        if ((b = AWTImageTools.makeImage(buf, w, h2, rgbChanCount, interleaved, bpp = FormatTools.getBytesPerPixel(pixelType), false, little, signed)) == null) {
            throw new FormatException("Could not construct BufferedImage");
        }
        if (indexed && rgbChanCount == 1) {
            Object table;
            if (pixelType == 1 || pixelType == 0) {
                table = r.get8BitLookupTable();
                if (table != null && ((byte[][])table).length > 0 && table[0] != null) {
                    int len = table[0].length;
                    byte[] dummy = ((byte[][])table).length < 3 ? new byte[len] : null;
                    byte[] red = ((byte[][])table).length >= 1 ? table[0] : dummy;
                    byte[] green = ((byte[][])table).length >= 2 ? table[1] : dummy;
                    byte[] blue = ((byte[][])table).length >= 3 ? table[2] : dummy;
                    model = new IndexColorModel(8, len, red, green, blue);
                }
            } else if ((pixelType == 3 || pixelType == 2) && (table = (Object)r.get16BitLookupTable()) != null && ((byte[][])table).length > 0 && table[0] != null) {
                model = new Index16ColorModel(16, table[0].length, (short[][])table, r.isLittleEndian());
            }
        }
        if (model != null) {
            WritableRaster raster = Raster.createWritableRaster(b.getSampleModel(), b.getRaster().getDataBuffer(), null);
            b = new BufferedImage(model, raster, false, null);
        }
        return b;
    }

    public static Object getPixels(BufferedImage image) {
        return AWTImageTools.getPixels(image, 0, 0, image.getWidth(), image.getHeight());
    }

    public static Object getPixels(BufferedImage image, int x, int y, int w, int h2) {
        WritableRaster raster = image.getRaster();
        return AWTImageTools.getPixels(raster, x, y, w, h2);
    }

    public static Object getPixels(WritableRaster raster) {
        return AWTImageTools.getPixels(raster, 0, 0, raster.getWidth(), raster.getHeight());
    }

    public static Object getPixels(WritableRaster raster, int x, int y, int w, int h2) {
        int tt = raster.getTransferType();
        if (tt == 0) {
            return AWTImageTools.getBytes(raster, x, y, w, h2);
        }
        if (tt == 1 || tt == 2) {
            return AWTImageTools.getShorts(raster, x, y, w, h2);
        }
        if (tt == 3) {
            return AWTImageTools.getInts(raster, x, y, w, h2);
        }
        if (tt == 4) {
            return AWTImageTools.getFloats(raster, x, y, w, h2);
        }
        if (tt == 5) {
            return AWTImageTools.getDoubles(raster, x, y, w, h2);
        }
        return null;
    }

    public static byte[][] getBytes(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getBytes(r);
    }

    public static byte[][] getBytes(WritableRaster r) {
        return AWTImageTools.getBytes(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static byte[][] getBytes(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 0, DataBufferByte.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferByte)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        byte[][] samples = new byte[c][w * h2];
        int[] buf = new int[w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (byte)buf[j];
            }
        }
        return samples;
    }

    public static short[][] getShorts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getShorts(r);
    }

    public static short[][] getShorts(WritableRaster r) {
        return AWTImageTools.getShorts(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static short[][] getShorts(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 1, DataBufferUShort.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferUShort)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        short[][] samples = new short[c][w * h2];
        int[] buf = new int[w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, buf);
            for (int j = 0; j < buf.length; ++j) {
                samples[i][j] = (short)buf[j];
            }
        }
        return samples;
    }

    public static int[][] getInts(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getInts(r);
    }

    public static int[][] getInts(WritableRaster r) {
        return AWTImageTools.getInts(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static int[][] getInts(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 3, DataBufferInt.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferInt)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        int[][] samples = new int[c][w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, samples[i]);
        }
        return samples;
    }

    public static float[][] getFloats(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getFloats(r);
    }

    public static float[][] getFloats(WritableRaster r) {
        return AWTImageTools.getFloats(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static float[][] getFloats(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 4, DataBufferFloat.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferFloat)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        float[][] samples = new float[c][w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, samples[i]);
        }
        return samples;
    }

    public static double[][] getDoubles(BufferedImage image) {
        WritableRaster r = image.getRaster();
        return AWTImageTools.getDoubles(r);
    }

    public static double[][] getDoubles(WritableRaster r) {
        return AWTImageTools.getDoubles(r, 0, 0, r.getWidth(), r.getHeight());
    }

    public static double[][] getDoubles(WritableRaster r, int x, int y, int w, int h2) {
        if (AWTImageTools.canUseBankDataDirectly(r, 5, DataBufferDouble.class) && x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return ((DataBufferDouble)r.getDataBuffer()).getBankData();
        }
        int c = r.getNumBands();
        double[][] samples = new double[c][w * h2];
        for (int i = 0; i < c; ++i) {
            r.getSamples(x, y, w, h2, i, samples[i]);
        }
        return samples;
    }

    private static boolean canUseBankDataDirectly(WritableRaster r, int transferType, Class<? extends DataBuffer> dataBufferClass) {
        int i;
        int tt = r.getTransferType();
        if (tt != transferType) {
            return false;
        }
        DataBuffer buffer = r.getDataBuffer();
        if (!dataBufferClass.isInstance(buffer)) {
            return false;
        }
        SampleModel model = r.getSampleModel();
        if (!(model instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel csm = (ComponentSampleModel)model;
        int pixelStride = csm.getPixelStride();
        if (pixelStride != 1) {
            return false;
        }
        int w = r.getWidth();
        int scanlineStride = csm.getScanlineStride();
        if (scanlineStride != w) {
            return false;
        }
        int c = r.getNumBands();
        int[] bandOffsets = csm.getBandOffsets();
        if (bandOffsets.length != c) {
            return false;
        }
        for (i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == 0) continue;
            return false;
        }
        for (i = 0; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] == i) continue;
            return false;
        }
        return true;
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little) {
        return AWTImageTools.getPixelBytes(img, little, 0, 0, img.getWidth(), img.getHeight());
    }

    public static byte[][] getPixelBytes(WritableRaster r, boolean little) {
        return AWTImageTools.getPixelBytes(r, little, 0, 0, r.getWidth(), r.getHeight());
    }

    public static byte[][] getPixelBytes(BufferedImage img, boolean little, int x, int y, int w, int h2) {
        byte[][] pixelBytes;
        block14: {
            Object pixels;
            block17: {
                block16: {
                    int imageType;
                    block15: {
                        block13: {
                            pixels = AWTImageTools.getPixels(img, x, y, w, h2);
                            imageType = img.getType();
                            pixelBytes = null;
                            if (!(pixels instanceof byte[][])) break block13;
                            pixelBytes = (byte[][])pixels;
                            break block14;
                        }
                        if (!(pixels instanceof short[][])) break block15;
                        short[][] s2 = (short[][])pixels;
                        pixelBytes = new byte[s2.length][s2[0].length * 2];
                        for (int i = 0; i < pixelBytes.length; ++i) {
                            for (int j = 0; j < s2[0].length; ++j) {
                                DataTools.unpackBytes(s2[i][j], pixelBytes[i], j * 2, 2, little);
                            }
                        }
                        break block14;
                    }
                    if (!(pixels instanceof int[][])) break block16;
                    int[][] in = (int[][])pixels;
                    if (imageType == 1 || imageType == 4 || imageType == 2) {
                        pixelBytes = new byte[in.length][in[0].length];
                        for (int c = 0; c < in.length; ++c) {
                            for (int i = 0; i < in[0].length; ++i) {
                                if (imageType != 4) {
                                    pixelBytes[c][i] = (byte)(in[c][i] & 0xFF);
                                    continue;
                                }
                                pixelBytes[in.length - c - 1][i] = (byte)(in[c][i] & 0xFF);
                            }
                        }
                    } else {
                        pixelBytes = new byte[in.length][in[0].length * 4];
                        for (int i = 0; i < pixelBytes.length; ++i) {
                            for (int j = 0; j < in[0].length; ++j) {
                                DataTools.unpackBytes(in[i][j], pixelBytes[i], j * 4, 4, little);
                            }
                        }
                    }
                    break block14;
                }
                if (!(pixels instanceof float[][])) break block17;
                float[][] in = (float[][])pixels;
                pixelBytes = new byte[in.length][in[0].length * 4];
                for (int i = 0; i < pixelBytes.length; ++i) {
                    for (int j = 0; j < in[0].length; ++j) {
                        int v = Float.floatToIntBits(in[i][j]);
                        DataTools.unpackBytes(v, pixelBytes[i], j * 4, 4, little);
                    }
                }
                break block14;
            }
            if (!(pixels instanceof double[][])) break block14;
            double[][] in = (double[][])pixels;
            pixelBytes = new byte[in.length][in[0].length * 8];
            for (int i = 0; i < pixelBytes.length; ++i) {
                for (int j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    DataTools.unpackBytes(v, pixelBytes[i], j * 8, 8, little);
                }
            }
        }
        return pixelBytes;
    }

    public static byte[][] getPixelBytes(WritableRaster r, boolean little, int x, int y, int w, int h2) {
        Object in;
        int j;
        int i;
        Object pixels = AWTImageTools.getPixels(r);
        byte[][] pixelBytes = null;
        int bpp = 0;
        if (pixels instanceof byte[][]) {
            pixelBytes = (byte[][])pixels;
            bpp = 1;
        } else if (pixels instanceof short[][]) {
            bpp = 2;
            short[][] s2 = (short[][])pixels;
            pixelBytes = new byte[s2.length][s2[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < s2[0].length; ++j) {
                    DataTools.unpackBytes(s2[i][j], pixelBytes[i], j * bpp, bpp, little);
                }
            }
        } else if (pixels instanceof int[][]) {
            bpp = 4;
            in = (int[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    DataTools.unpackBytes(in[i][j], pixelBytes[i], j * bpp, bpp, little);
                }
            }
        } else if (pixels instanceof float[][]) {
            bpp = 4;
            in = (float[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    int v = Float.floatToIntBits(in[i][j]);
                    DataTools.unpackBytes(v, pixelBytes[i], j * bpp, bpp, little);
                }
            }
        } else if (pixels instanceof double[][]) {
            bpp = 8;
            in = (double[][])pixels;
            pixelBytes = new byte[((int[][])in).length][in[0].length * bpp];
            for (i = 0; i < pixelBytes.length; ++i) {
                for (j = 0; j < in[0].length; ++j) {
                    long v = Double.doubleToLongBits(in[i][j]);
                    DataTools.unpackBytes(v, pixelBytes[i], j * bpp, bpp, little);
                }
            }
        }
        if (x == 0 && y == 0 && w == r.getWidth() && h2 == r.getHeight()) {
            return pixelBytes;
        }
        byte[][] croppedBytes = new byte[pixelBytes.length][w * h2 * bpp];
        for (int c = 0; c < croppedBytes.length; ++c) {
            for (int row = 0; row < h2; ++row) {
                int src = (row + y) * r.getWidth() * bpp + x * bpp;
                int dest = row * w * bpp;
                System.arraycopy(pixelBytes[c], src, croppedBytes[c], dest, w * bpp);
            }
        }
        return croppedBytes;
    }

    public static int getPixelType(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        if (raster == null) {
            return -1;
        }
        DataBuffer buffer = raster.getDataBuffer();
        if (buffer == null) {
            return -1;
        }
        if (buffer instanceof SignedByteBuffer) {
            return 0;
        }
        if (buffer instanceof SignedShortBuffer) {
            return 2;
        }
        if (buffer instanceof UnsignedIntBuffer) {
            return 5;
        }
        int type = buffer.getDataType();
        int imageType = image.getType();
        switch (type) {
            case 0: {
                return 1;
            }
            case 5: {
                return 7;
            }
            case 4: {
                return 6;
            }
            case 3: {
                if (imageType == 1 || imageType == 4 || imageType == 2) {
                    return 1;
                }
                if (buffer instanceof UnsignedIntBuffer) {
                    return 5;
                }
                return 4;
            }
            case 2: {
                return 2;
            }
            case 1: {
                if (imageType == 9 || imageType == 8) {
                    return 1;
                }
                return 3;
            }
        }
        return -1;
    }

    public static BufferedImage convertRenderedImage(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys2 = img.getPropertyNames();
        if (keys2 != null) {
            for (int i = 0; i < keys2.length; ++i) {
                properties.put(keys2[i], img.getProperty(keys2[i]));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }

    public static byte[] getBytes(BufferedImage img, boolean separated) {
        byte[][] p = AWTImageTools.getBytes(img);
        if (separated || p.length == 1) {
            return p[0];
        }
        byte[] rtn = new byte[p.length * p[0].length];
        for (int i = 0; i < p.length; ++i) {
            System.arraycopy(p[i], 0, rtn, i * p[0].length, p[i].length);
        }
        return rtn;
    }

    public static BufferedImage makeUnsigned(BufferedImage img) {
        if (img == null) {
            return null;
        }
        int pixelType = AWTImageTools.getPixelType(img);
        boolean signed = FormatTools.isSigned(pixelType);
        boolean fp = FormatTools.isFloatingPoint(pixelType);
        if (!signed || fp) {
            return img;
        }
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        byte[][] pix = AWTImageTools.getPixelBytes(img, false);
        return AWTImageTools.makeImage(pix, img.getWidth(), img.getHeight(), bpp, fp, false, false);
    }

    public static BufferedImage getSubimage(BufferedImage image, boolean littleEndian, int x, int y, int w, int h2) {
        int pixelType = AWTImageTools.getPixelType(image);
        byte[][] pix = AWTImageTools.getPixelBytes(image, littleEndian, x, y, w, h2);
        return AWTImageTools.makeImage(pix, w, h2, FormatTools.getBytesPerPixel(pixelType), FormatTools.isFloatingPoint(pixelType), littleEndian, FormatTools.isSigned(pixelType));
    }

    public static BufferedImage[] splitChannels(BufferedImage image) {
        BufferedImage[] results;
        block7: {
            Object o;
            int c;
            int h2;
            int w;
            block10: {
                block9: {
                    boolean signed;
                    block8: {
                        block6: {
                            w = image.getWidth();
                            h2 = image.getHeight();
                            c = image.getRaster().getNumBands();
                            if (c == 1) {
                                return new BufferedImage[]{image};
                            }
                            results = new BufferedImage[c];
                            o = AWTImageTools.getPixels(image);
                            int pixelType = AWTImageTools.getPixelType(image);
                            signed = FormatTools.isSigned(pixelType);
                            if (!(o instanceof byte[][])) break block6;
                            byte[][] pix = (byte[][])o;
                            for (int i = 0; i < c; ++i) {
                                results[i] = AWTImageTools.makeImage(pix[i], w, h2, signed);
                            }
                            break block7;
                        }
                        if (!(o instanceof short[][])) break block8;
                        short[][] pix = (short[][])o;
                        for (int i = 0; i < c; ++i) {
                            results[i] = AWTImageTools.makeImage(pix[i], w, h2, signed);
                        }
                        break block7;
                    }
                    if (!(o instanceof int[][])) break block9;
                    int[][] pix = (int[][])o;
                    for (int i = 0; i < c; ++i) {
                        results[i] = AWTImageTools.makeImage(pix[i], w, h2, signed);
                    }
                    break block7;
                }
                if (!(o instanceof float[][])) break block10;
                float[][] pix = (float[][])o;
                for (int i = 0; i < c; ++i) {
                    results[i] = AWTImageTools.makeImage(pix[i], w, h2);
                }
                break block7;
            }
            if (!(o instanceof double[][])) break block7;
            double[][] pix = (double[][])o;
            for (int i = 0; i < c; ++i) {
                results[i] = AWTImageTools.makeImage(pix[i], w, h2);
            }
        }
        return results;
    }

    public static BufferedImage mergeChannels(BufferedImage[] images) {
        if (images == null || images.length == 0) {
            return null;
        }
        Object[] list = new Object[images.length];
        int c = 0;
        int type = 0;
        for (int i = 0; i < images.length; ++i) {
            Object o = AWTImageTools.getPixels(images[i]);
            if (o instanceof byte[][]) {
                if (i == 0) {
                    type = 0;
                } else if (type != 0) {
                    return null;
                }
                c += ((byte[][])o).length;
            } else if (o instanceof short[][]) {
                if (i == 0) {
                    type = 1;
                } else if (type != 1) {
                    return null;
                }
                c += ((short[][])o).length;
            } else if (o instanceof int[][]) {
                if (i == 0) {
                    type = 3;
                } else if (type != 3) {
                    return null;
                }
                c += ((int[][])o).length;
            } else if (o instanceof float[][]) {
                if (i == 0) {
                    type = 4;
                } else if (type != 4) {
                    return null;
                }
                c += ((float[][])o).length;
            } else if (o instanceof double[][]) {
                if (i == 0) {
                    type = 5;
                } else if (type != 5) {
                    return null;
                }
                c += ((double[][])o).length;
            }
            if (c > 4) {
                return null;
            }
            list[i] = o;
        }
        if (c < 1 || c > 4) {
            return null;
        }
        int w = images[0].getWidth();
        int h2 = images[0].getHeight();
        int pixelType = AWTImageTools.getPixelType(images[0]);
        boolean signed = FormatTools.isSigned(pixelType);
        if (type == 0) {
            byte[][] pix = new byte[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                byte[][] b = (byte[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new byte[w * h2];
            }
            return AWTImageTools.makeImage(pix, w, h2, signed);
        }
        if (type == 1 || type == 2) {
            short[][] pix = new short[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                short[][] b = (short[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new short[w * h2];
            }
            return AWTImageTools.makeImage(pix, w, h2, signed);
        }
        if (type == 3) {
            int[][] pix = new int[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                int[][] b = (int[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new int[w * h2];
            }
            return AWTImageTools.makeImage(pix, w, h2, signed);
        }
        if (type == 4) {
            float[][] pix = new float[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                float[][] b = (float[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new float[w * h2];
            }
            return AWTImageTools.makeImage(pix, w, h2);
        }
        if (type == 5) {
            double[][] pix = new double[c][];
            int ndx = 0;
            for (int i = 0; i < list.length; ++i) {
                double[][] b = (double[][])list[i];
                for (int j = 0; j < b.length; ++j) {
                    pix[ndx++] = b[j];
                }
            }
            while (ndx < pix.length) {
                pix[ndx++] = new double[w * h2];
            }
            return AWTImageTools.makeImage(pix, w, h2);
        }
        return null;
    }

    public static BufferedImage padImage(BufferedImage img, int width, int height) {
        boolean needsPadding;
        if (img == null) {
            byte[][] data = new byte[1][width * height];
            return AWTImageTools.makeImage(data, width, height, false);
        }
        boolean bl = needsPadding = img.getWidth() != width || img.getHeight() != height;
        if (needsPadding) {
            Object pixels = AWTImageTools.getPixels(img);
            int pixelType = AWTImageTools.getPixelType(img);
            boolean signed = FormatTools.isSigned(pixelType);
            if (pixels instanceof byte[][]) {
                byte[][] b = (byte[][])pixels;
                byte[][] newBytes = new byte[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newBytes[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newBytes, width, height, signed);
            }
            if (pixels instanceof short[][]) {
                short[][] b = (short[][])pixels;
                short[][] newShorts = new short[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newShorts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newShorts, width, height, signed);
            }
            if (pixels instanceof int[][]) {
                int[][] b = (int[][])pixels;
                int[][] newInts = new int[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newInts[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newInts, width, height, signed);
            }
            if (pixels instanceof float[][]) {
                float[][] b = (float[][])pixels;
                float[][] newFloats = new float[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newFloats[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newFloats, width, height);
            }
            if (pixels instanceof double[][]) {
                double[][] b = (double[][])pixels;
                double[][] newDoubles = new double[b.length][width * height];
                for (int i = 0; i < b.length; ++i) {
                    newDoubles[i] = ImageTools.padImage(b[i], false, 1, img.getWidth(), width, height);
                }
                return AWTImageTools.makeImage(newDoubles, width, height);
            }
            return null;
        }
        return img;
    }

    public static BufferedImage autoscale(BufferedImage img) {
        byte[][] pixels = AWTImageTools.getPixelBytes(img, true);
        double min2 = Double.MAX_VALUE;
        double max = 0.0;
        int bits = pixels[0].length / (img.getWidth() * img.getHeight()) * 8;
        for (int i = 0; i < pixels.length; ++i) {
            Double[] mm4 = ImageTools.scanData(pixels[0], bits, true);
            double tmin = mm4[0];
            double tmax = mm4[1];
            if (tmin < min2) {
                min2 = tmin;
            }
            if (!(tmax > max)) continue;
            max = tmax;
        }
        return AWTImageTools.autoscale(img, (int)min2, (int)max);
    }

    public static BufferedImage autoscale(BufferedImage img, int min2, int max) {
        Object pixels = AWTImageTools.getPixels(img);
        int pixelType = AWTImageTools.getPixelType(img);
        boolean signed = FormatTools.isSigned(pixelType);
        if (pixels instanceof byte[][]) {
            return img;
        }
        if (pixels instanceof short[][]) {
            short[][] shorts = (short[][])pixels;
            byte[][] out = new byte[shorts.length][shorts[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (shorts[i][j] < 0) {
                        short[] sArray = shorts[i];
                        int n = j;
                        sArray[n] = (short)(sArray[n] + Short.MAX_VALUE);
                    }
                    int diff = max - min2;
                    float dist = (float)(shorts[i][j] - min2) / (float)diff;
                    out[i][j] = shorts[i][j] >= max ? -1 : (shorts[i][j] <= min2 ? 0 : (int)((int)(dist * 256.0f)));
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight(), signed);
        }
        if (pixels instanceof int[][]) {
            int[][] ints = (int[][])pixels;
            byte[][] out = new byte[ints.length][ints[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (ints[i][j] >= max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (ints[i][j] <= min2) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min2;
                    float dist = (float)(ints[i][j] - min2) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight(), signed);
        }
        if (pixels instanceof float[][]) {
            float[][] floats = (float[][])pixels;
            byte[][] out = new byte[floats.length][floats[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (floats[i][j] >= (float)max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (floats[i][j] <= (float)min2) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min2;
                    float dist = (floats[i][j] - (float)min2) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight(), signed);
        }
        if (pixels instanceof double[][]) {
            double[][] doubles = (double[][])pixels;
            byte[][] out = new byte[doubles.length][doubles[0].length];
            for (int i = 0; i < out.length; ++i) {
                for (int j = 0; j < out[i].length; ++j) {
                    if (doubles[i][j] >= (double)max) {
                        out[i][j] = -1;
                        continue;
                    }
                    if (doubles[i][j] <= (double)min2) {
                        out[i][j] = 0;
                        continue;
                    }
                    int diff = max - min2;
                    float dist = (float)(doubles[i][j] - (double)min2) / (float)diff;
                    out[i][j] = (byte)(dist * 256.0f);
                }
            }
            return AWTImageTools.makeImage(out, img.getWidth(), img.getHeight(), signed);
        }
        return img;
    }

    public static BufferedImage copyScaled(BufferedImage source2, BufferedImage target, Object hint) {
        if (hint == null) {
            hint = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        Graphics2D g2 = target.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        double scalex = (double)target.getWidth() / (double)source2.getWidth();
        double scaley = (double)target.getHeight() / (double)source2.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scalex, scaley);
        g2.drawRenderedImage(source2, xform);
        g2.dispose();
        return target;
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = AWTImageTools.getDefaultConfiguration();
        }
        int trans = image.getColorModel().getTransparency();
        return AWTImageTools.copyScaled(image, gc.createCompatibleImage(width, height, trans), hint);
    }

    public static BufferedImage scale2D(BufferedImage image, int width, int height, Object hint, ColorModel cm) {
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
        return AWTImageTools.copyScaled(image, new BufferedImage(cm, raster, isRasterPremultiplied, null), hint);
    }

    public static Image scaleAWT(BufferedImage source2, int width, int height, int hint) {
        return source2.getScaledInstance(width, height, hint);
    }

    public static BufferedImage scale(BufferedImage source2, int width, int height, boolean pad) {
        int w = source2.getWidth();
        int h2 = source2.getHeight();
        if (w == width && h2 == height) {
            return source2;
        }
        int finalWidth = width;
        int finalHeight = height;
        if (pad) {
            double r = (double)w / (double)h2;
            double ratio = (double)width / (double)height;
            if (r > ratio) {
                height = h2 * width / w;
            } else {
                width = w * height / h2;
            }
        }
        int pixelType = AWTImageTools.getPixelType(source2);
        BufferedImage result = null;
        ColorModel sourceModel = source2.getColorModel();
        if (sourceModel instanceof Index16ColorModel || sourceModel instanceof IndexColorModel || sourceModel instanceof SignedColorModel || FormatTools.isFloatingPoint(pixelType)) {
            DataBuffer buffer = source2.getData().getDataBuffer();
            WritableRaster raster = Raster.createWritableRaster(source2.getSampleModel(), buffer, null);
            ColorModel model = AWTImageTools.makeColorModel(1, buffer.getDataType());
            if (sourceModel instanceof SignedColorModel) {
                model = sourceModel;
            }
            source2 = new BufferedImage(model, raster, false, null);
            Image scaled = AWTImageTools.scaleAWT(source2, width, height, 16);
            result = AWTImageTools.makeBuffered(scaled, sourceModel);
            raster = Raster.createWritableRaster(result.getSampleModel(), result.getData().getDataBuffer(), null);
            result = new BufferedImage(sourceModel, raster, false, null);
        } else {
            if (FormatTools.isSigned(pixelType)) {
                source2 = AWTImageTools.makeUnsigned(source2);
                sourceModel = null;
            }
            Image scaled = AWTImageTools.scaleAWT(source2, width, height, 16);
            result = AWTImageTools.makeBuffered(scaled, sourceModel);
        }
        return AWTImageTools.padImage(result, finalWidth, finalHeight);
    }

    public static BufferedImage makeBuffered(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        AWTImageTools.loadImage(image);
        BufferedImage img = new BufferedImage(image.getWidth(OBS), image.getHeight(OBS), 1);
        Graphics g2 = img.getGraphics();
        g2.drawImage(image, 0, 0, OBS);
        g2.dispose();
        return img;
    }

    public static BufferedImage makeBuffered(Image image, ColorModel cm) {
        BufferedImage bi;
        if (cm == null) {
            return AWTImageTools.makeBuffered(image);
        }
        if (image instanceof BufferedImage && cm.equals((bi = (BufferedImage)image).getColorModel())) {
            return bi;
        }
        AWTImageTools.loadImage(image);
        int w = image.getWidth(OBS);
        int h2 = image.getHeight(OBS);
        boolean alphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = cm.createCompatibleWritableRaster(w, h2);
        BufferedImage result = new BufferedImage(cm, raster, alphaPremultiplied, null);
        Graphics2D g2 = result.createGraphics();
        g2.drawImage(image, 0, 0, OBS);
        g2.dispose();
        return result;
    }

    public static boolean loadImage(Image image) {
        if (image instanceof BufferedImage) {
            return true;
        }
        MediaTracker tracker = new MediaTracker(OBS);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException exc) {
            return false;
        }
        return 8 == tracker.statusID(0, false);
    }

    public static Dimension getSize(Image image) {
        if (image == null) {
            return new Dimension(0, 0);
        }
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            return new Dimension(bi.getWidth(), bi.getHeight());
        }
        AWTImageTools.loadImage(image);
        return new Dimension(image.getWidth(OBS), image.getHeight(OBS));
    }

    public static BufferedImage makeCompatible(BufferedImage image, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = AWTImageTools.getDefaultConfiguration();
        }
        int w = image.getWidth();
        int h2 = image.getHeight();
        int trans = image.getColorModel().getTransparency();
        BufferedImage result = gc.createCompatibleImage(w, h2, trans);
        Graphics2D g2 = result.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return result;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public static ColorSpace makeColorSpace(int c) {
        int type;
        switch (c) {
            case 1: {
                type = 1003;
                break;
            }
            case 2: {
                type = -1;
                break;
            }
            case 3: {
                type = 1000;
                break;
            }
            case 4: {
                type = 1000;
                break;
            }
            default: {
                return null;
            }
        }
        return TwoChannelColorSpace.getInstance(type);
    }

    public static ColorModel makeColorModel(int c, int dataType) {
        ColorSpace cs = AWTImageTools.makeColorSpace(c);
        return cs == null ? null : new ComponentColorModel(cs, c == 4, false, 3, dataType);
    }

    public static BufferedImage indexedToRGB(BufferedImage img, boolean le) {
        byte[][] indices = AWTImageTools.getPixelBytes(img, le);
        if (indices.length > 1) {
            return img;
        }
        int pixelType = AWTImageTools.getPixelType(img);
        boolean signed = FormatTools.isSigned(pixelType);
        if (pixelType == 1) {
            IndexColorModel model = (IndexColorModel)img.getColorModel();
            byte[][] b = new byte[3][indices[0].length];
            for (int i = 0; i < indices[0].length; ++i) {
                b[0][i] = (byte)(model.getRed(indices[0][i] & 0xFF) & 0xFF);
                b[1][i] = (byte)(model.getGreen(indices[0][i] & 0xFF) & 0xFF);
                b[2][i] = (byte)(model.getBlue(indices[0][i] & 0xFF) & 0xFF);
            }
            return AWTImageTools.makeImage(b, img.getWidth(), img.getHeight(), signed);
        }
        if (pixelType == 3) {
            Index16ColorModel model = (Index16ColorModel)img.getColorModel();
            short[][] s2 = new short[3][indices[0].length / 2];
            for (int i = 0; i < s2[0].length; ++i) {
                int ndx = DataTools.bytesToInt(indices[0], i * 2, 2, le) & 0xFFFF;
                s2[0][i] = (short)(model.getRed(ndx) & 0xFFFF);
                s2[1][i] = (short)(model.getRed(ndx) & 0xFFFF);
                s2[2][i] = (short)(model.getRed(ndx) & 0xFFFF);
            }
            return AWTImageTools.makeImage(s2, img.getWidth(), img.getHeight(), signed);
        }
        return null;
    }

    public static byte[][] get8BitLookupTable(ColorModel model) {
        if (!(model instanceof IndexColorModel)) {
            return null;
        }
        IndexColorModel m4 = (IndexColorModel)model;
        byte[][] lut = new byte[3][m4.getMapSize()];
        m4.getReds(lut[0]);
        m4.getGreens(lut[1]);
        m4.getBlues(lut[2]);
        return lut;
    }

    public static short[][] getLookupTable(ColorModel model) {
        if (!(model instanceof Index16ColorModel)) {
            return null;
        }
        Index16ColorModel m4 = (Index16ColorModel)model;
        short[][] lut = new short[][]{m4.getReds(), m4.getGreens(), m4.getBlues()};
        return lut;
    }
}

