/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import loci.formats.cache.ByteArraySource;
import loci.formats.cache.Cache;
import loci.formats.cache.CacheEvent;
import loci.formats.cache.CacheException;
import loci.formats.cache.CacheListener;
import loci.formats.cache.CrosshairStrategy;
import loci.formats.cache.ICacheSource;
import loci.formats.cache.ICacheStrategy;
import loci.formats.cache.RectangleStrategy;
import loci.formats.gui.BufferedImageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheComponent
extends JPanel
implements ActionListener,
CacheListener,
ChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheComponent.class);
    protected static final String[] SOURCES = new String[]{"Byte arrays", "BufferedImages"};
    protected static final Class[] SOURCE_VALUES = new Class[]{ByteArraySource.class, BufferedImageSource.class};
    protected static final Class[] SOURCE_PARAMS = new Class[]{String.class};
    protected static final String[] STRATEGIES = new String[]{"Crosshair", "Rectangle"};
    protected static final Class[] STRATEGY_VALUES = new Class[]{CrosshairStrategy.class, RectangleStrategy.class};
    protected static final Class[] STRATEGY_PARAMS = new Class[]{int[].class};
    protected static final String[] PRIORITIES = new String[]{"Maximum", "High", "Normal", "Low", "Minimum"};
    protected static final int[] PRIORITY_VALUES = new int[]{10, 5, 0, -5, -10};
    protected static final String[] ORDERS = new String[]{"Centered", "Forward", "Backward"};
    protected static final int[] ORDER_VALUES = new int[]{0, 1, -1};
    private Cache cache;
    private JComboBox sourceChooser;
    private JComboBox strategyChooser;
    private JSpinner[] range;
    private JComboBox[] priority;
    private JComboBox[] order;
    private String id;
    private int[] lengths;

    public CacheComponent(Cache cache, String[] axisLabels) {
        this(cache, axisLabels, null);
    }

    public CacheComponent(Cache cache, String[] axisLabels, String id) {
        this.cache = cache;
        this.id = id;
        this.lengths = cache.getStrategy().getLengths();
        this.setLayout(new BoxLayout(this, 1));
        CellConstraints cc = new CellConstraints();
        JPanel top = new JPanel();
        FormLayout layout = new FormLayout("pref,3dlu,pref:grow", id == null ? "pref:grow" : "pref:grow,3dlu,pref:grow");
        top.setLayout(layout);
        int col = 1;
        int row = 1;
        if (id != null) {
            JLabel label = new JLabel("Objects to cache: ");
            this.sourceChooser = new JComboBox<String>(SOURCES);
            this.sourceChooser.setSelectedIndex(this.sourceIndex(cache.getSource()));
            this.sourceChooser.setActionCommand("source");
            this.sourceChooser.addActionListener(this);
            col = 1;
            top.add((Component)label, cc.xy(col, row));
            top.add((Component)this.sourceChooser, cc.xy(col += 2, row));
            row += 2;
        }
        ICacheStrategy strategy = cache.getStrategy();
        JLabel label = new JLabel("Caching strategy: ");
        this.strategyChooser = new JComboBox<String>(STRATEGIES);
        this.strategyChooser.setSelectedIndex(this.strategyIndex(strategy));
        this.strategyChooser.setActionCommand("strategy");
        this.strategyChooser.addActionListener(this);
        col = 1;
        top.add((Component)label, cc.xy(col, row));
        top.add((Component)this.strategyChooser, cc.xy(col += 2, row));
        row += 2;
        JPanel bottom = new JPanel();
        StringBuilder rows = new StringBuilder();
        rows.append("pref:grow");
        for (int i = 0; i < axisLabels.length; ++i) {
            rows.append(",3dlu,pref:grow");
        }
        layout = new FormLayout("pref:grow,3dlu,pref:grow,3dlu,pref:grow,3dlu,pref:grow", rows.toString());
        bottom.setLayout(layout);
        row = 1;
        col = 1;
        bottom.add((Component)new JLabel("Axis"), cc.xy(col, row));
        bottom.add((Component)new JLabel("Range"), cc.xy(col += 2, row));
        bottom.add((Component)new JLabel("Priority"), cc.xy(col += 2, row));
        bottom.add((Component)new JLabel("Order"), cc.xy(col += 2, row));
        row += 2;
        this.range = new JSpinner[this.lengths.length];
        this.priority = new JComboBox[this.lengths.length];
        this.order = new JComboBox[this.lengths.length];
        int[] rng = strategy.getRange();
        int[] prio = strategy.getPriorities();
        int[] ord = strategy.getOrder();
        for (int i = 0; i < axisLabels.length; ++i) {
            JLabel l = new JLabel(axisLabels[i]);
            this.range[i] = new JSpinner(new SpinnerNumberModel(rng[i], 0, this.lengths[i], 1));
            this.priority[i] = new JComboBox<String>(PRIORITIES);
            this.priority[i].setSelectedIndex(this.priorityIndex(prio[i]));
            this.order[i] = new JComboBox<String>(ORDERS);
            this.order[i].setSelectedIndex(this.orderIndex(ord[i]));
            col = 1;
            bottom.add((Component)l, cc.xy(col, row));
            bottom.add((Component)this.range[i], cc.xy(col += 2, row));
            bottom.add((Component)this.priority[i], cc.xy(col += 2, row));
            bottom.add((Component)this.order[i], cc.xy(col += 2, row));
            row += 2;
            this.range[i].addChangeListener(this);
            this.priority[i].addActionListener(this);
            this.order[i].addActionListener(this);
        }
        this.add(top);
        this.add(Box.createVerticalStrut(9));
        this.add(bottom);
        cache.addCacheListener(this);
    }

    public Cache getCache() {
        return this.cache;
    }

    public void dispose() {
        this.cache.removeCacheListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("source".equals(cmd)) {
            this.updateSource();
        } else if ("strategy".equals(cmd)) {
            this.updateStrategy();
        } else {
            int i;
            Object src = e.getSource();
            for (i = 0; i < this.priority.length; ++i) {
                if (src != this.priority[i]) continue;
                this.updatePriority(i);
                return;
            }
            for (i = 0; i < this.order.length; ++i) {
                if (src != this.order[i]) continue;
                this.updateOrder(i);
                return;
            }
        }
    }

    @Override
    public void cacheUpdated(CacheEvent e) {
        int type = e.getType();
        ICacheStrategy strategy = this.cache.getStrategy();
        switch (type) {
            case 1: {
                this.sourceChooser.removeActionListener(this);
                this.sourceChooser.setSelectedIndex(this.sourceIndex(this.cache.getSource()));
                this.sourceChooser.addActionListener(this);
                break;
            }
            case 2: {
                this.strategyChooser.removeActionListener(this);
                this.strategyChooser.setSelectedIndex(this.strategyIndex(strategy));
                this.strategyChooser.addActionListener(this);
                break;
            }
            case 4: {
                int[] prio = strategy.getPriorities();
                for (int i = 0; i < prio.length; ++i) {
                    this.priority[i].removeActionListener(this);
                    this.priority[i].setSelectedIndex(this.priorityIndex(prio[i]));
                    this.priority[i].addActionListener(this);
                }
                break;
            }
            case 5: {
                int[] ord = strategy.getOrder();
                for (int i = 0; i < ord.length; ++i) {
                    this.order[i].removeActionListener(this);
                    this.order[i].setSelectedIndex(this.orderIndex(ord[i]));
                    this.order[i].addActionListener(this);
                }
                break;
            }
            case 6: {
                int[] rng = strategy.getRange();
                for (int i = 0; i < rng.length; ++i) {
                    this.range[i].removeChangeListener(this);
                    this.range[i].setValue(rng[i]);
                    this.range[i].addChangeListener(this);
                }
                break;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        for (int i = 0; i < this.range.length; ++i) {
            if (src != this.range[i]) continue;
            this.updateRange(i);
            return;
        }
    }

    private void updateSource() {
        try {
            ICacheSource source2 = this.sourceValue(this.sourceChooser.getSelectedIndex());
            if (source2 != null) {
                this.cache.setSource(source2);
            }
        }
        catch (CacheException exc) {
            LOGGER.info("", exc);
        }
    }

    private void updateStrategy() {
        try {
            ICacheStrategy strategy = this.strategyValue(this.strategyChooser.getSelectedIndex());
            if (strategy != null) {
                this.cache.setStrategy(strategy);
            }
        }
        catch (CacheException exc) {
            LOGGER.info("", exc);
        }
    }

    private void updateRange(int index) {
        ICacheStrategy strategy;
        int[] ranges;
        int rng = (Integer)this.range[index].getValue();
        if (rng != (ranges = (strategy = this.cache.getStrategy()).getRange())[index]) {
            strategy.setRange(rng, index);
        }
    }

    private void updatePriority(int index) {
        ICacheStrategy strategy;
        int[] priorities;
        int prio = this.priorityValue(this.priority[index].getSelectedIndex());
        if (prio != (priorities = (strategy = this.cache.getStrategy()).getPriorities())[index]) {
            strategy.setPriority(prio, index);
        }
    }

    private void updateOrder(int index) {
        ICacheStrategy strategy;
        int[] orders;
        int ord = this.orderValue(this.order[index].getSelectedIndex());
        if (ord != (orders = (strategy = this.cache.getStrategy()).getOrder())[index]) {
            strategy.setOrder(ord, index);
        }
    }

    private int sourceIndex(ICacheSource s2) {
        Class<?> c = s2.getClass();
        for (int i = 0; i < SOURCE_VALUES.length; ++i) {
            if (SOURCE_VALUES[i] != c) continue;
            return i;
        }
        return -1;
    }

    private ICacheSource sourceValue(int index) {
        Class c = SOURCE_VALUES[index];
        if (c == this.cache.getSource().getClass()) {
            return null;
        }
        try {
            Constructor con = c.getConstructor(SOURCE_PARAMS);
            return (ICacheSource)con.newInstance(this.id);
        }
        catch (NoSuchMethodException exc) {
            LOGGER.info("", exc);
        }
        catch (InstantiationException exc) {
            LOGGER.info("", exc);
        }
        catch (IllegalAccessException exc) {
            LOGGER.info("", exc);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.info("", exc);
        }
        catch (InvocationTargetException exc) {
            LOGGER.info("", exc);
        }
        return null;
    }

    private int strategyIndex(ICacheStrategy s2) {
        Class<?> c = s2.getClass();
        for (int i = 0; i < STRATEGY_VALUES.length; ++i) {
            if (STRATEGY_VALUES[i] != c) continue;
            return i;
        }
        return -1;
    }

    private ICacheStrategy strategyValue(int index) {
        Class c = STRATEGY_VALUES[index];
        if (c == this.cache.getStrategy().getClass()) {
            return null;
        }
        try {
            Constructor con = c.getConstructor(STRATEGY_PARAMS);
            return (ICacheStrategy)con.newInstance(new Object[]{this.lengths});
        }
        catch (NoSuchMethodException exc) {
            LOGGER.info("", exc);
        }
        catch (InstantiationException exc) {
            LOGGER.info("", exc);
        }
        catch (IllegalAccessException exc) {
            LOGGER.info("", exc);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.info("", exc);
        }
        catch (InvocationTargetException exc) {
            LOGGER.info("", exc);
        }
        return null;
    }

    private int priorityIndex(int prio) {
        for (int i = 0; i < PRIORITY_VALUES.length; ++i) {
            if (PRIORITY_VALUES[i] != prio) continue;
            return i;
        }
        return -1;
    }

    private int priorityValue(int index) {
        return PRIORITY_VALUES[index];
    }

    private int orderIndex(int ord) {
        for (int i = 0; i < ORDER_VALUES.length; ++i) {
            if (ORDER_VALUES[i] != ord) continue;
            return i;
        }
        return -1;
    }

    private int orderValue(int index) {
        return ORDER_VALUES[index];
    }
}

