/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class I2IReader
extends FormatReader {
    private static final int HEADER_SIZE = 1024;

    public I2IReader() {
        super("I2I", new String[]{"i2i"});
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, 1024, false)) {
            return false;
        }
        char pixelType = (char)stream.readByte();
        if (pixelType != 'I' && pixelType != 'R' && pixelType != 'C') {
            return false;
        }
        char check2 = (char)stream.readByte();
        if (check2 != ' ') {
            return false;
        }
        long pixelCount = this.getDimension(stream);
        pixelCount *= (long)this.getDimension(stream);
        return (pixelCount *= (long)this.getDimension(stream)) > 0L;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        long planeSize = FormatTools.getPlaneSize(this);
        long offset = 1024L + (long)no * planeSize;
        if (offset + planeSize <= this.in.length() && offset >= 0L) {
            this.in.seek(offset);
            this.readPlane(this.in, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        char pixelType = (char)this.in.readByte();
        switch (pixelType) {
            case 'I': {
                m4.pixelType = 2;
                break;
            }
            case 'R': {
                m4.pixelType = 6;
                break;
            }
            case 'C': {
                throw new FormatException("Complex pixel data not yet supported");
            }
            default: {
                throw new FormatException("Invalid pixel type: " + pixelType);
            }
        }
        if ((char)this.in.readByte() != ' ') {
            throw new FormatException("Expected space after pixel type character");
        }
        m4.sizeX = this.getDimension(this.in);
        m4.sizeY = this.getDimension(this.in);
        m4.sizeZ = this.getDimension(this.in);
        m4.littleEndian = (char)this.in.readByte() != 'B';
        this.in.order(this.isLittleEndian());
        short minPixelValue = this.in.readShort();
        short maxPixelValue = this.in.readShort();
        short xCoordinate = this.in.readShort();
        short yCoordinate = this.in.readShort();
        short n = this.in.readShort();
        this.in.skipBytes(33);
        for (int i = 0; i < 15; ++i) {
            String history = this.in.readString(64);
            this.addGlobalMetaList("Image history", history.trim());
        }
        this.addGlobalMeta("Minimum intensity value", minPixelValue);
        this.addGlobalMeta("Maximum intensity value", maxPixelValue);
        this.addGlobalMeta("Image position X", xCoordinate);
        this.addGlobalMeta("Image position Y", yCoordinate);
        if (n > 0) {
            m4.sizeZ /= n;
        }
        m4.sizeT = n;
        m4.imageCount = this.getSizeZ() * this.getSizeT();
        m4.sizeC = 1;
        m4.rgb = false;
        m4.dimensionOrder = "XYZTC";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private int getDimension(RandomAccessInputStream stream) throws IOException {
        String dim = stream.readString(6).trim();
        Integer dimension = DataTools.parseInteger(dim);
        return dimension == null ? 0 : dimension;
    }
}

