/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.SubResolutionFormatReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.NetCDFService;
import loci.formats.services.NetCDFServiceImpl;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Color;

public class ImarisHDFReader
extends SubResolutionFormatReader {
    public static final String HDF_MAGIC_STRING = "HDF";
    private static final String[] DELIMITERS = new String[]{" ", "-", "."};
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;
    private int seriesCount;
    private NetCDFService netcdf;
    private List<String> emWave;
    private List<String> exWave;
    private List<String> channelMin;
    private List<String> channelMax;
    private List<String> gain;
    private List<String> pinhole;
    private List<String> channelName;
    private List<String> microscopyMode;
    private List<double[]> colors;
    private int lastChannel = 0;
    private long maxBufferSize = 0x40000000L;
    private Object[] buffer = null;
    private int[] blockSizeZPerResolution;
    private int lastMinZ = 0;
    private int lastMaxZ = 0;
    private int lastRes = 0;
    private int lastT = 0;

    public ImarisHDFReader() {
        super("Bitplane Imaris 5.5 (HDF)", "ims");
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public int getOptimalTileWidth() {
        return ((CoreMetadata)this.core.get((int)this.series, (int)(this.core.size((int)this.series) - 1))).sizeX;
    }

    @Override
    public int getOptimalTileHeight() {
        return ((CoreMetadata)this.core.get((int)this.series, (int)(this.core.size((int)this.series) - 1))).sizeY;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readString(8).indexOf(HDF_MAGIC_STRING) >= 0;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 1 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= this.colors.size()) {
            return null;
        }
        double[] color = this.colors.get(this.lastChannel);
        byte[][] lut = new byte[3][256];
        for (int c = 0; c < lut.length; ++c) {
            double max = color[c] * 255.0;
            for (int p = 0; p < lut[c].length; ++p) {
                lut[c][p] = (byte)((double)p / 255.0 * max);
            }
        }
        return lut;
    }

    @Override
    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 3 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= this.colors.size() || this.colors.get(this.lastChannel) == null) {
            return null;
        }
        double[] color = this.colors.get(this.lastChannel);
        short[][] lut = new short[3][65536];
        for (int c = 0; c < lut.length; ++c) {
            double max = color[c] * 65535.0;
            for (int p = 0; p < lut[c].length; ++p) {
                lut[c][p] = (short)((double)p / 65535.0 * max);
            }
        }
        return lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.lastChannel = this.getZCTCoords(no)[1];
        Object image = this.getImageData(no, x, y, w, h2);
        boolean little = this.isLittleEndian();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        for (int row = 0; row < h2; ++row) {
            int i;
            int index;
            byte[] rowData;
            Object data;
            int rowlen = w * bpp;
            int base = row * rowlen;
            if (image instanceof byte[][]) {
                data = (byte[][])image;
                rowData = data[row + ((byte[][])data).length - h2];
                System.arraycopy(rowData, rowData.length - w, buf, base, w);
                continue;
            }
            if (image instanceof short[][]) {
                data = (short[][])image;
                rowData = data[row + ((byte[][])data).length - h2];
                index = rowData.length - w;
                for (i = 0; i < w; ++i) {
                    DataTools.unpackBytes(rowData[i + index], buf, base + 2 * i, 2, little);
                }
                continue;
            }
            if (image instanceof int[][]) {
                data = (int[][])image;
                rowData = data[row + ((byte[][])data).length - h2];
                index = rowData.length - w;
                for (i = 0; i < w; ++i) {
                    DataTools.unpackBytes(rowData[i + index], buf, base + i * 4, 4, little);
                }
                continue;
            }
            if (image instanceof float[][]) {
                data = (float[][])image;
                rowData = data[row + ((byte[][])data).length - h2];
                index = rowData.length - w;
                for (i = 0; i < w; ++i) {
                    int v = Float.floatToIntBits(rowData[i + index]);
                    DataTools.unpackBytes(v, buf, base + i * 4, 4, little);
                }
                continue;
            }
            if (!(image instanceof double[][])) continue;
            data = (double[][])image;
            rowData = data[row + ((byte[][])data).length - h2];
            index = rowData.length - w;
            for (i = 0; i < w; ++i) {
                long v = Double.doubleToLongBits(rowData[i + index]);
                DataTools.unpackBytes(v, buf, base + i * 8, 8, little);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.seriesCount = 0;
            this.pixelSizeZ = 0.0;
            this.pixelSizeY = 0.0;
            this.pixelSizeX = 0.0;
            this.maxZ = 0.0;
            this.maxY = 0.0;
            this.maxX = 0.0;
            this.minZ = 0.0;
            this.minY = 0.0;
            this.minX = 0.0;
            this.lastMaxZ = 0;
            this.lastMinZ = 0;
            this.lastT = 0;
            this.lastRes = 0;
            this.buffer = null;
            this.blockSizeZPerResolution = null;
            if (this.netcdf != null) {
                this.netcdf.close();
            }
            this.netcdf = null;
            this.channelMax = null;
            this.channelMin = null;
            this.exWave = null;
            this.emWave = null;
            this.microscopyMode = null;
            this.channelName = null;
            this.pinhole = null;
            this.gain = null;
            this.colors = null;
            this.lastChannel = 0;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        try {
            ServiceFactory factory2 = new ServiceFactory();
            this.netcdf = factory2.getInstance(NetCDFService.class);
            this.netcdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(NetCDFServiceImpl.NO_NETCDF_MSG, e);
        }
        this.pixelSizeZ = 1.0;
        this.pixelSizeY = 1.0;
        this.pixelSizeX = 1.0;
        this.emWave = new ArrayList<String>();
        this.exWave = new ArrayList<String>();
        this.channelMin = new ArrayList<String>();
        this.channelMax = new ArrayList<String>();
        this.gain = new ArrayList<String>();
        this.pinhole = new ArrayList<String>();
        this.channelName = new ArrayList<String>();
        this.microscopyMode = new ArrayList<String>();
        this.colors = new ArrayList<double[]>();
        this.seriesCount = 0;
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
        this.parseAttributes();
        int currentSeries = 0;
        if (this.seriesCount > 1) {
            for (int i = 1; i < this.seriesCount; ++i) {
                CoreMetadata ms = new CoreMetadata();
                String groupPath = "DataSet/ResolutionLevel_" + i + "/TimePoint_0/Channel_0";
                ms.sizeX = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeX"));
                ms.sizeY = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeY"));
                ms.sizeZ = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeZ"));
                ms.imageCount = ms.sizeZ * this.getSizeC() * this.getSizeT();
                ms.sizeC = this.getSizeC();
                ms.sizeT = this.getSizeT();
                ms.thumbnail = true;
                if (ms.sizeZ == ms0.sizeZ && ms.sizeC == ms0.sizeC && ms.sizeT == ms0.sizeT) {
                    this.core.add(currentSeries, ms);
                    continue;
                }
                this.core.add(ms);
                ++currentSeries;
            }
        }
        ms0.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        ms0.thumbnail = false;
        ms0.dimensionOrder = "XYZCT";
        this.blockSizeZPerResolution = new int[this.seriesCount];
        for (int res = 0; res < this.seriesCount; ++res) {
            String datasetPath = "DataSet/ResolutionLevel_" + res + "/TimePoint_0/Channel_0/Data";
            Hashtable<String, Object> table = this.netcdf.getVariableAttributes(datasetPath);
            String chunkSizesString = (String)table.get("_ChunkSizes");
            String[] sizes = chunkSizesString.split(" ");
            this.blockSizeZPerResolution[res] = Integer.parseInt(sizes[0]);
        }
        int type = -1;
        Object pix = this.getSampleData();
        if (pix instanceof byte[][]) {
            type = 1;
        } else if (pix instanceof short[][]) {
            type = 3;
        } else if (pix instanceof int[][]) {
            type = 5;
        } else if (pix instanceof float[][]) {
            type = 6;
        } else if (pix instanceof double[][]) {
            type = 7;
        } else {
            throw new FormatException("Unknown pixel type: " + pix);
        }
        for (int i = 0; i < this.core.size(); ++i) {
            for (int j = 0; j < this.core.size(i); ++j) {
                CoreMetadata ms = (CoreMetadata)this.core.get(i, j);
                ms.pixelType = type;
                ms.dimensionOrder = "XYZCT";
                ms.rgb = false;
                ms.thumbSizeX = 128;
                ms.thumbSizeY = 128;
                ms.orderCertain = true;
                ms.littleEndian = true;
                ms.interleaved = false;
                ms.indexed = this.colors.size() >= this.getSizeC();
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String imageName = new Location(this.getCurrentFile()).getName();
        for (int s2 = 0; s2 < this.getSeriesCount(); ++s2) {
            store.setImageName(imageName + " Resolution Level " + (s2 + 1), s2);
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        int cIndex = 0;
        for (int s3 = 0; s3 < this.getSeriesCount(); ++s3) {
            this.setSeries(s3);
            double px = this.pixelSizeX;
            double py = this.pixelSizeY;
            double pz = this.pixelSizeZ;
            if (px == 1.0) {
                px = (this.maxX - this.minX) / (double)this.getSizeX();
            }
            if (py == 1.0) {
                py = (this.maxY - this.minY) / (double)this.getSizeY();
            }
            if (pz == 1.0) {
                pz = (this.maxZ - this.minZ) / (double)this.getSizeZ();
            }
            Length sizeX = FormatTools.getPhysicalSizeX(px);
            Length sizeY = FormatTools.getPhysicalSizeY(py);
            Length sizeZ = FormatTools.getPhysicalSizeZ(pz);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, s3);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, s3);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, s3);
            }
            int i = 0;
            while (i < this.getSizeC()) {
                Float gainValue = null;
                Integer pinholeValue = null;
                Integer emWaveValue = null;
                if (cIndex < this.gain.size()) {
                    try {
                        gainValue = Float.valueOf(Float.parseFloat(this.gain.get(cIndex)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (cIndex < this.pinhole.size()) {
                    try {
                        pinholeValue = Integer.parseInt(this.pinhole.get(cIndex));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (cIndex < this.emWave.size()) {
                    try {
                        emWaveValue = Integer.parseInt(this.emWave.get(cIndex));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (cIndex < this.exWave.size()) {
                    try {
                        Integer exWaveValue = Integer.parseInt(this.exWave.get(cIndex));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Double minValue = null;
                Double maxValue = null;
                if (cIndex < this.channelMin.size()) {
                    try {
                        minValue = DataTools.parseDouble(this.channelMin.get(cIndex));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (cIndex < this.channelMax.size()) {
                    try {
                        maxValue = DataTools.parseDouble(this.channelMax.get(cIndex));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (i < this.colors.size() && this.colors.get(i) != null) {
                    double[] color = this.colors.get(i);
                    Color realColor = new Color((int)(color[0] * 255.0), (int)(color[1] * 255.0), (int)(color[2] * 255.0), 255);
                    store.setChannelColor(realColor, s3, i);
                }
                if (i < this.channelName.size()) {
                    store.setChannelName(this.channelName.get(i), s3, i);
                }
                ++i;
                ++cIndex;
            }
        }
        this.setSeries(0);
    }

    private Object getImageData(int no, int x, int y, int width, int height) throws FormatException {
        int[] zct = this.getZCTCoords(no);
        int resolutionIndex = this.getCoreIndex();
        Object image = null;
        if (height == 1) {
            ++height;
            if (y == this.getSizeY() - 1) {
                --y;
            }
        }
        if (width == 1) {
            ++width;
            if (x == this.getSizeX() - 1) {
                --x;
            }
        }
        if (x >= this.getSizeX() / 2 && y >= this.getSizeY() / 2) {
            width += x - this.getSizeX() / 2 + 1;
            x = this.getSizeX() / 2 - 1;
        }
        if (this.getSizeZ() > 1 && (long)(this.getSizeX() * this.getSizeY() * this.blockSizeZPerResolution[resolutionIndex] * this.getSizeC() * FormatTools.getBytesPerPixel(this.getPixelType())) < this.maxBufferSize) {
            Object slice;
            if (zct[0] < this.lastMinZ || zct[0] > this.lastMaxZ || zct[2] != this.lastT || resolutionIndex != this.lastRes || this.buffer == null) {
                this.buffer = new Object[this.getSizeC()];
                if (resolutionIndex != this.lastRes) {
                    this.lastRes = resolutionIndex;
                    this.lastT = zct[2];
                }
                if (zct[2] != this.lastT) {
                    this.lastT = zct[2];
                }
                int blockNumber = zct[0] / this.blockSizeZPerResolution[resolutionIndex];
                int[] dims = new int[]{this.blockSizeZPerResolution[resolutionIndex], this.getSizeY(), this.getSizeX()};
                int[] idcs = new int[]{blockNumber * this.blockSizeZPerResolution[resolutionIndex], 0, 0};
                try {
                    for (int ch = 0; ch < this.getSizeC(); ++ch) {
                        String path = "/DataSet/ResolutionLevel_" + resolutionIndex + "/TimePoint_" + zct[2] + "/Channel_" + ch + "/Data";
                        this.buffer[ch] = this.netcdf.getArray(path, idcs, dims);
                    }
                }
                catch (ServiceException e) {
                    throw new FormatException(e);
                }
                this.lastMinZ = blockNumber * this.blockSizeZPerResolution[resolutionIndex];
                this.lastMaxZ = this.lastMinZ + this.blockSizeZPerResolution[resolutionIndex] - 1;
            }
            if (this.buffer[zct[1]] instanceof byte[][][]) {
                byte[][][] byteBuffer = (byte[][][])this.buffer[zct[1]];
                slice = new byte[height][width];
                for (int i = y; i < y + height; ++i) {
                    for (int j = x; j < x + width; ++j) {
                        slice[i - y][j - x] = byteBuffer[zct[0] - this.lastMinZ][i][j];
                    }
                }
                image = slice;
            } else if (this.buffer[zct[1]] instanceof short[][][]) {
                short[][][] shortBuffer = (short[][][])this.buffer[zct[1]];
                slice = new short[height][width];
                for (int i = y; i < y + height; ++i) {
                    for (int j = x; j < x + width; ++j) {
                        slice[i - y][j - x] = shortBuffer[zct[0] - this.lastMinZ][i][j];
                    }
                }
                image = slice;
            } else if (this.buffer[zct[1]] instanceof int[][][]) {
                int[][][] intBuffer = (int[][][])this.buffer[zct[1]];
                slice = new int[height][width];
                for (int i = y; i < y + height; ++i) {
                    for (int j = x; j < x + width; ++j) {
                        slice[i - y][j - x] = intBuffer[zct[0] - this.lastMinZ][i][j];
                    }
                }
                image = slice;
            } else if (this.buffer[zct[1]] instanceof float[][][]) {
                float[][][] floatBuffer = (float[][][])this.buffer[zct[1]];
                slice = new float[height][width];
                for (int i = y; i < y + height; ++i) {
                    for (int j = x; j < x + width; ++j) {
                        slice[i - y][j - x] = (byte)floatBuffer[zct[0] - this.lastMinZ][i][j];
                    }
                }
                image = slice;
            }
        } else {
            int[] dimensions = new int[]{1, height, width};
            int[] indices = new int[]{zct[0], y, x};
            try {
                String path = "/DataSet/ResolutionLevel_" + resolutionIndex + "/TimePoint_" + zct[2] + "/Channel_" + zct[1] + "/Data";
                image = this.netcdf.getArray(path, indices, dimensions);
            }
            catch (ServiceException e) {
                throw new FormatException(e);
            }
        }
        return image;
    }

    private Object getSampleData() throws FormatException {
        int resolutionIndex = this.getCoreIndex();
        Object image = null;
        int[] dimensions = new int[]{1, 2, 2};
        int[] indices = new int[]{0, 0, 0};
        try {
            String path = "/DataSet/ResolutionLevel_" + resolutionIndex + "/TimePoint_0/Channel_0/Data";
            image = this.netcdf.getArray(path, indices, dimensions);
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        return image;
    }

    private void parseAttributes() {
        Vector<String> attributes = this.netcdf.getAttributeList();
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
        for (String attr : attributes) {
            int slash;
            int n;
            String name = attr.substring(attr.lastIndexOf("/") + 1);
            String value = this.netcdf.getAttributeValue(attr);
            if (value == null) continue;
            value = value.trim();
            if (name.equals("X") || attr.startsWith("DataSet/ResolutionLevel_0") && name.equals("ImageSizeX")) {
                try {
                    ms0.sizeX = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.trace("Failed to parse '" + name + "'", e);
                }
            } else if (name.equals("Y") || attr.startsWith("DataSet/ResolutionLevel_0") && name.equals("ImageSizeY")) {
                try {
                    ms0.sizeY = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.trace("Failed to parse '" + name + "'", e);
                }
            } else if (name.equals("Z") || attr.startsWith("DataSet/ResolutionLevel_0") && name.equals("ImageSizeZ")) {
                try {
                    ms0.sizeZ = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.trace("Failed to parse '" + name + "'", e);
                }
            } else if (name.equals("FileTimePoints")) {
                ms0.sizeT = Integer.parseInt(value);
            } else if (name.equals("NumberOfChannels") && this.getSizeC() == 0) {
                ms0.sizeC = Integer.parseInt(value);
            } else if (name.equals("RecordingEntrySampleSpacing")) {
                this.pixelSizeX = Double.parseDouble(value);
            } else if (name.equals("RecordingEntryLineSpacing")) {
                this.pixelSizeY = Double.parseDouble(value);
            } else if (name.equals("RecordingEntryPlaneSpacing")) {
                this.pixelSizeZ = Double.parseDouble(value);
            } else if (name.equals("ExtMax0")) {
                this.maxX = Double.parseDouble(value);
            } else if (name.equals("ExtMax1")) {
                this.maxY = Double.parseDouble(value);
            } else if (name.equals("ExtMax2")) {
                this.maxZ = Double.parseDouble(value);
            } else if (name.equals("ExtMin0")) {
                this.minX = Double.parseDouble(value);
            } else if (name.equals("ExtMin1")) {
                this.minY = Double.parseDouble(value);
            } else if (name.equals("ExtMin2")) {
                this.minZ = Double.parseDouble(value);
            }
            if (attr.startsWith("DataSet/ResolutionLevel_") && (n = Integer.parseInt(attr.substring(24, (slash = attr.indexOf("/", 24)) == -1 ? attr.length() : slash))) >= this.seriesCount) {
                this.seriesCount = n + 1;
            }
            if (attr.startsWith("DataSetInfo/Channel_")) {
                String originalValue = value;
                for (String d : DELIMITERS) {
                    if (value.indexOf(d) == -1) continue;
                    value = value.substring(value.indexOf(d) + 1);
                }
                int underscore = attr.indexOf(95) + 1;
                int cIndex = Integer.parseInt(attr.substring(underscore, attr.indexOf("/", underscore)));
                while (cIndex >= this.getSizeC()) {
                    ++ms0.sizeC;
                }
                if (name.equals("Gain")) {
                    this.addValue(this.gain, value, cIndex);
                } else if (name.equals("LSMEmissionWavelength")) {
                    this.addValue(this.emWave, value, cIndex);
                } else if (name.equals("LSMExcitationWavelength")) {
                    this.addValue(this.exWave, value, cIndex);
                } else if (name.equals("Max")) {
                    this.addValue(this.channelMax, value, cIndex);
                } else if (name.equals("Min")) {
                    this.addValue(this.channelMin, value, cIndex);
                } else if (name.equals("Pinhole")) {
                    this.addValue(this.pinhole, value, cIndex);
                } else if (name.equals("Name")) {
                    this.addValue(this.channelName, originalValue, cIndex);
                } else if (name.equals("MicroscopyMode")) {
                    this.addValue(this.microscopyMode, value, cIndex);
                } else if (name.equals("Color")) {
                    double[] color = new double[3];
                    String[] intensity = originalValue.split(" ");
                    for (int i = 0; i < intensity.length; ++i) {
                        color[i] = Double.parseDouble(intensity[i]);
                    }
                    this.addValue(this.colors, color, cIndex);
                }
            }
            if (value == null) continue;
            this.addGlobalMeta(name, value);
        }
    }

    private void addValue(List l, Object value, int index) {
        if (index < l.size()) {
            l.set(index, value);
        } else {
            while (index > l.size()) {
                l.add(null);
            }
            l.add(value);
        }
    }
}

