/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class LEOReader
extends BaseTiffReader {
    public static final int LEO_TAG = 34118;
    private static final String[] DATE_FORMATS = new String[]{"HH:mm dd-MMM-yyyy", "HH:mm:ss dd MMM yyyy"};
    private Length xSize;
    private String date;
    private String time;
    private Length workingDistance;

    public LEOReader() {
        super("LEO", new String[]{"sxm", "tif", "tiff"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setDoCaching(false);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(34118);
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        String tag = ((IFD)this.ifds.get(0)).getIFDTextValue(34118);
        String[] lines = tag.split("\n");
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int line = 36; line < lines.length; ++line) {
                String t2 = lines[line];
                if (!t2.startsWith("AP_") && !t2.startsWith("DP_") && !t2.startsWith("SV_")) continue;
                String separator = t2.equals("AP_TIME") || t2.equals("AP_DATE") ? "\\s+:" : "\\s+=\\s+";
                String value = this.parseKeyValue(lines[++line], separator);
                if (t2.equals("AP_TIME")) {
                    this.time = value;
                    continue;
                }
                if (t2.equals("AP_DATE")) {
                    this.date = value;
                    continue;
                }
                if (t2.equals("AP_IMAGE_PIXEL_SIZE")) {
                    this.xSize = FormatTools.parseLength(value);
                    continue;
                }
                if (!t2.equals("AP_WD")) continue;
                this.workingDistance = FormatTools.parseLength(value);
            }
            if (this.xSize == null) {
                this.xSize = FormatTools.getPhysicalSizeY(Double.parseDouble(lines[3]) * 1000000.0);
            }
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        String acquisitionDate = DateTools.formatDate(this.time + " " + this.date, DATE_FORMATS);
        if (acquisitionDate != null) {
            store.setImageAcquisitionDate(new Timestamp(acquisitionDate), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (this.xSize != null) {
                store.setPixelsPhysicalSizeX(this.xSize, 0);
                store.setPixelsPhysicalSizeY(this.xSize, 0);
            }
            String instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            store.setImageInstrumentRef(instrument, 0);
            store.setObjectiveID(MetadataTools.createLSID("Objective", 0, 0), 0, 0);
            if (this.workingDistance != null) {
                store.setObjectiveWorkingDistance(this.workingDistance, 0, 0);
            }
            store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
            store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
        }
    }

    private String parseKeyValue(String string, String separator) {
        String[] values2 = string.split(separator);
        if (values2.length == 2) {
            this.addGlobalMeta(values2[0], values2[1]);
            return values2[1];
        }
        return null;
    }
}

