/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.meta.MetadataStore;

public class NAFReader
extends FormatReader {
    private static final int LUT_SIZE = 263168;
    private long[] offsets;
    private boolean compressed;

    public NAFReader() {
        super("Hamamatsu Aquacosmos", "naf");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.compressed) {
            throw new UnsupportedCompressionException("Sorry, compressed data is not supported.");
        }
        this.in.seek(this.offsets[this.getSeries()] + (long)(no * FormatTools.getPlaneSize(this)));
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.compressed = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        String endian = this.in.readString(2);
        boolean little = endian.equals("II");
        this.in.order(little);
        this.in.seek(98L);
        int seriesCount = this.in.readInt();
        this.in.seek(192L);
        while (this.in.read() == 0) {
        }
        String description = this.in.readCString();
        this.addGlobalMeta("Description", description);
        while (this.in.readInt() == 0) {
        }
        long fp = this.in.getFilePointer();
        fp = fp % 2L == 0L ? (fp -= 4L) : --fp;
        this.offsets = new long[seriesCount];
        this.core.clear();
        for (int i = 0; i < seriesCount; ++i) {
            int numBits;
            CoreMetadata ms;
            block10: {
                this.in.seek(fp + (long)(i * 256));
                ms = new CoreMetadata();
                this.core.add(ms);
                ms.littleEndian = little;
                ms.sizeX = this.in.readInt();
                ms.sizeY = this.in.readInt();
                numBits = this.in.readInt();
                ms.sizeC = this.in.readInt();
                ms.sizeZ = this.in.readInt();
                ms.sizeT = this.in.readInt();
                ms.imageCount = ms.sizeZ * ms.sizeC * ms.sizeT;
                int nBytes = numBits / 8;
                ms.pixelType = FormatTools.pixelTypeFromBytes(nBytes, false, nBytes == 8);
                ms.dimensionOrder = "XYCZT";
                ms.rgb = false;
                this.in.skipBytes(4);
                long pointer = this.in.getFilePointer();
                String name = this.in.readCString();
                if (i == 0) {
                    this.in.skipBytes(92L - this.in.getFilePointer() + pointer);
                    while (true) {
                        int check2;
                        if ((long)(check2 = this.in.readInt()) > this.in.getFilePointer()) {
                            this.offsets[i] = (long)check2 + 263168L;
                            break block10;
                        }
                        this.in.skipBytes(92);
                    }
                }
                CoreMetadata mp = (CoreMetadata)this.core.get(i - 1);
                this.offsets[i] = this.offsets[i - 1] + (long)(mp.sizeX * mp.sizeY * mp.imageCount * FormatTools.getBytesPerPixel(mp.pixelType));
            }
            int n = i;
            this.offsets[n] = this.offsets[n] + 352L;
            this.in.seek(this.offsets[i]);
            while (this.in.getFilePointer() + 116L < this.in.length() && this.in.read() == 3 && this.in.read() == 37) {
                this.in.skipBytes(114);
                this.offsets[i] = this.in.getFilePointer();
            }
            this.in.seek(this.in.getFilePointer() - 1L);
            byte[] buf = new byte[0x300000];
            int n2 = this.in.read(buf, 0, 1);
            boolean found = false;
            while (!found && this.in.getFilePointer() < this.in.length()) {
                n2 += this.in.read(buf, 1, buf.length - 1);
                for (int q = 0; q < buf.length - 1; ++q) {
                    if ((buf[q] & 0xFF) != 192 || (buf[q + 1] & 0xFF) != 46) continue;
                    this.offsets[i] = this.in.getFilePointer() - (long)n2 + (long)q;
                    found = true;
                    break;
                }
                buf[0] = buf[buf.length - 1];
                n2 = 1;
            }
            if (found) {
                int n3 = i;
                this.offsets[n3] = this.offsets[n3] + 16063L;
            }
            if (i != this.offsets.length - 1 || this.compressed || i <= 0) continue;
            this.offsets[i] = (int)(this.in.length() - (long)(ms.sizeX * ms.sizeY * ms.imageCount * (numBits / 8)));
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

