/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.ZipHandle;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.ImageReader;

public class ZipReader
extends FormatReader {
    private transient ImageReader reader;
    private String entryName;
    private ArrayList<String> mappedFiles = new ArrayList();

    public ZipReader() {
        super("Zip", "zip");
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.reader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.reader.get16BitLookupTable();
    }

    @Override
    public void setGroupFiles(boolean groupFiles) {
        super.setGroupFiles(groupFiles);
        if (this.reader != null) {
            this.reader.setGroupFiles(groupFiles);
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        if (Location.getMappedFile(this.entryName) == null) {
            this.reader.close();
            this.findZipEntries();
        }
        this.reader.setId(this.entryName);
        return this.reader.openBytes(no, buf, x, y, w, h2);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.reader != null) {
            this.reader.close(fileOnly);
        }
        if (!fileOnly) {
            this.reader = null;
        }
        for (String name : this.mappedFiles) {
            IRandomAccess handle = Location.getMappedFile(name);
            Location.mapFile(name, null);
            if (handle == null) continue;
            handle.close();
        }
        this.mappedFiles.clear();
        this.entryName = null;
    }

    @Override
    public void reopenFile() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        } else {
            this.reader = new ImageReader();
        }
        this.findZipEntries();
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new ImageReader();
        this.reader.setMetadataOptions(this.getMetadataOptions());
        this.reader.setMetadataFiltered(this.isMetadataFiltered());
        this.reader.setOriginalMetadataPopulated(this.isOriginalMetadataPopulated());
        this.reader.setNormalized(this.isNormalized());
        this.reader.setMetadataStore(this.getMetadataStore());
        this.findZipEntries();
        if (this.entryName == null) {
            throw new FormatException("Zip file does not contain any valid files");
        }
        this.reader.setId(this.entryName);
        this.metadataStore = this.reader.getMetadataStore();
        this.core = new ArrayList<CoreMetadata>(this.reader.getCoreMetadataList());
        this.metadata = this.reader.getGlobalMetadata();
    }

    private void findZipEntries() throws IOException {
        int sep;
        String innerFile = this.currentId;
        if (ZipReader.checkSuffix(this.currentId, "zip")) {
            innerFile = this.currentId.substring(0, this.currentId.length() - 4);
        }
        if ((sep = innerFile.lastIndexOf(File.separator)) < 0) {
            sep = innerFile.lastIndexOf("/");
        }
        if (sep >= 0) {
            innerFile = innerFile.substring(sep + 1);
        }
        IRandomAccess rawHandle = Location.getHandle(this.currentId, false, false);
        try (RandomAccessInputStream in = new RandomAccessInputStream(rawHandle, this.currentId);){
            ZipInputStream zip2 = new ZipInputStream(in);
            ZipEntry ze = null;
            this.entryName = null;
            boolean matchFound = false;
            while ((ze = zip2.getNextEntry()) != null) {
                if (this.entryName == null) {
                    this.entryName = ze.getName();
                }
                if (!matchFound && ze.getName().startsWith(innerFile)) {
                    this.entryName = ze.getName();
                    matchFound = true;
                }
                if (Location.getMappedFile(ze.getName()) != null) {
                    Location.getMappedFile(ze.getName()).close();
                }
                ZipHandle handle = new ZipHandle(this.currentId, ze);
                Location.mapFile(ze.getName(), handle);
                this.mappedFiles.add(ze.getName());
            }
        }
    }
}

