/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import loci.common.DataTools;
import loci.formats.FormatTools;
import loci.formats.UpgradeChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandLineTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLineTools.class);
    public static final String VERSION = "-version";
    public static final String NO_UPGRADE_CHECK = "-no-upgrade";

    public static void printVersion() {
        System.out.println("Version: " + FormatTools.VERSION);
        System.out.println("Build date: " + FormatTools.DATE);
        System.out.println("VCS revision: " + FormatTools.VCS_REVISION);
    }

    public static void runUpgradeCheck(String[] args2) {
        if (DataTools.indexOf(args2, NO_UPGRADE_CHECK) != -1) {
            LOGGER.debug("Skipping upgrade check");
            return;
        }
        UpgradeChecker checker = new UpgradeChecker();
        boolean canUpgrade = checker.newVersionAvailable("Bio-Formats utilities");
        if (canUpgrade) {
            LOGGER.info("*** A new stable version is available. ***");
            LOGGER.info("*** Install the new version using:     ***");
            LOGGER.info("***   'upgradechecker -install'        ***");
        }
    }
}

