/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.BufferedImageWriter;
import loci.formats.meta.IMetadata;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.OMETiffWriter;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.EnumerationException;

public class MakeTestOmeTiff {
    public int sizeZsub = 1;
    public int sizeTsub = 1;
    public int sizeCsub = 1;
    public boolean isModulo = false;

    public void makeSamples() throws FormatException, IOException {
        this.makeOmeTiffExtensions("single-channel", "439", "167", "1", "1", "1", "XYZCT");
        this.makeOmeTiffExtensions("multi-channel", "439", "167", "1", "3", "1", "XYZCT");
        this.makeOmeTiffExtensions("z-series", "439", "167", "5", "1", "1", "XYZCT");
        this.makeOmeTiffExtensions("multi-channel-z-series", "439", "167", "5", "3", "1", "XYZCT");
        this.makeOmeTiffExtensions("time-series", "439", "167", "1", "1", "7", "XYZCT");
        this.makeOmeTiffExtensions("multi-channel-time-series", "439", "167", "1", "3", "7", "XYZCT");
        this.makeOmeTiffExtensions("4D-series", "439", "167", "5", "1", "7", "XYZCT");
        this.makeOmeTiffExtensions("multi-channel-4D-series", "439", "167", "5", "3", "7", "XYZCT");
        this.makeOmeTiffExtensions("modulo-6D-Z", "250", "200", "8", "3", "2", "XYZCT", "4", "1", "1");
        this.makeOmeTiffExtensions("modulo-6D-C", "250", "200", "4", "9", "2", "XYZCT", "1", "3", "1");
        this.makeOmeTiffExtensions("modulo-6D-T", "250", "200", "4", "3", "6", "XYZCT", "1", "1", "2");
        this.makeOmeTiffExtensions("modulo-7D-ZC", "250", "220", "8", "9", "2", "XYZCT", "4", "3", "1");
        this.makeOmeTiffExtensions("modulo-7D-CT", "250", "220", "4", "9", "6", "XYZCT", "1", "3", "2");
        this.makeOmeTiffExtensions("modulo-7D-ZT", "250", "220", "8", "3", "6", "XYZCT", "4", "1", "2");
        this.makeOmeTiffExtensions("modulo-8D", "200", "250", "8", "9", "6", "XYZCT", "4", "3", "2");
    }

    public int makeOmeTiff(String ... args2) throws FormatException, IOException {
        if (args2 == null || args2.length == 0) {
            this.makeSamples();
            return 0;
        }
        if (args2.length != 7 && args2.length != 10) {
            this.displayUsage();
            return 1;
        }
        if (args2.length == 10) {
            this.isModulo = true;
        }
        String name = args2[0];
        CoreMetadata info = new CoreMetadata();
        info.sizeX = Integer.parseInt(args2[1]);
        info.sizeY = Integer.parseInt(args2[2]);
        info.sizeZ = Integer.parseInt(args2[3]);
        info.sizeC = Integer.parseInt(args2[4]);
        info.sizeT = Integer.parseInt(args2[5]);
        info.imageCount = info.sizeZ * info.sizeC * info.sizeT;
        info.dimensionOrder = args2[6].toUpperCase();
        if (this.isModulo) {
            this.sizeZsub = Integer.parseInt(args2[7]);
            this.sizeCsub = Integer.parseInt(args2[8]);
            this.sizeTsub = Integer.parseInt(args2[9]);
        }
        this.makeOmeTiff(name, info);
        return 0;
    }

    public void makeOmeTiffExtensions(String ... args2) throws FormatException, IOException {
        String name = args2[0];
        args2[0] = name + ".ome.tif";
        this.makeOmeTiff(args2);
        args2[0] = name + ".ome.tiff";
        this.makeOmeTiff(args2);
        args2[0] = name + ".ome.tf2";
        this.makeOmeTiff(args2);
        args2[0] = name + ".ome.tf8";
        this.makeOmeTiff(args2);
        args2[0] = name + ".ome.btf";
        this.makeOmeTiff(args2);
    }

    public void makeOmeTiff(String name, CoreMetadata info) throws FormatException, IOException {
        String id = this.getId(name);
        try (OMETiffWriter out = this.createWriter(name, info, id);){
            this.writeData(name, info, id, out);
        }
    }

    public static void main(String[] args2) throws FormatException, IOException {
        int returnCode = new MakeTestOmeTiff().makeOmeTiff(args2);
        System.exit(returnCode);
    }

    private void displayUsage() {
        System.out.println("Usage: java loci.formats.tools.MakeTestOmeTiff name");
        System.out.println("           SizeX SizeY SizeZ SizeC SizeT DimOrder");
        System.out.println();
        System.out.println("  name: output filename");
        System.out.println("  SizeX: width of image planes");
        System.out.println("  SizeY: height of image planes");
        System.out.println("  SizeZ: number of focal planes");
        System.out.println("  SizeC: number of channels");
        System.out.println("  SizeT: number of time points");
        System.out.println("  DimOrder: planar ordering:");
        System.out.println("    XYZCT, XYZTC, XYCZT, XYCTZ, XYTZC, or XYTCZ");
        System.out.println();
        System.out.println("Example:");
        System.out.println("  java loci.formats.tools.MakeTestOmeTiff test \\");
        System.out.println("    517 239 5 3 4 XYCZT");
        System.out.println();
        System.out.println("Optional Usage: java loci.formats.tools.MakeTestOmeTiff name");
        System.out.println("           SizeX SizeY SizeZ SizeC SizeT DimOrder SubZ SubC SubT");
        System.out.println("This creates a 6D, 7D, or 8D file using the Modulo extension");
        System.out.println();
        System.out.println("  SubZ: splits of Z planes into extra dimension");
        System.out.println("  SubC: splits of channels into extra dimension");
        System.out.println("  SubT: splits of time points into extra dimension");
        System.out.println("A value of 1 means no split");
        System.out.println();
        System.out.println("Example:");
        System.out.println("  java loci.formats.tools.MakeTestOmeTiff test8D \\");
        System.out.println("    200 250 6 4 8 XYCZT 3 2 2");
    }

    private String getId(String name) {
        String id = name.toLowerCase().endsWith(".ome.tiff") || name.toLowerCase().endsWith(".ome.tif") || name.toLowerCase().endsWith(".ome.tf2") || name.toLowerCase().endsWith(".ome.tf8") || name.toLowerCase().endsWith(".ome.btf") ? name : name + ".ome.tiff";
        return id;
    }

    private OMETiffWriter createWriter(String name, CoreMetadata info, String id) throws FormatException, IOException {
        OMETiffWriter out = new OMETiffWriter();
        try {
            out.setMetadataRetrieve(this.createMetadata(name, info));
        }
        catch (DependencyException e) {
            throw new FormatException(e);
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        catch (EnumerationException e) {
            throw new FormatException(e);
        }
        this.ensureNonExisting(id);
        out.setId(id);
        return out;
    }

    private void writeData(String name, CoreMetadata info, String id, OMETiffWriter out) throws FormatException, IOException {
        System.out.print(id);
        for (int i = 0; i < info.imageCount; ++i) {
            BufferedImage plane = this.createPlane(name, info, i);
            out.saveBytes(i, BufferedImageWriter.toBytes(plane, out));
            System.out.print(".");
        }
        System.out.println();
        out.close();
    }

    private void ensureNonExisting(String id) {
        File idFile = new File(id);
        if (idFile.exists()) {
            idFile.delete();
        }
    }

    private IMetadata createMetadata(String name, CoreMetadata info) throws DependencyException, ServiceException, EnumerationException {
        ServiceFactory serviceFactory = new ServiceFactory();
        OMEXMLService omexmlService = serviceFactory.getInstance(OMEXMLService.class);
        OMEXMLMetadata meta = omexmlService.createOMEXMLMetadata();
        MetadataTools.populateMetadata(meta, 0, name, info);
        if (this.isModulo) {
            meta.setXMLAnnotationID("Annotation:Modulo:0", 0);
            meta.setXMLAnnotationNamespace("openmicroscopy.org/omero/dimension/modulo", 0);
            meta.setXMLAnnotationDescription("For a description of how 6D, 7D, and 8D data is stored using the Modulo extension see https://docs.openmicroscopy.org/latest/ome-model/developers/6d-7d-and-8d-storage.html", 0);
            StringBuilder moduloBlock = new StringBuilder();
            moduloBlock.append("<Modulo namespace=\"http://www.openmicroscopy.org/Schemas/Additions/2011-09\">");
            if (this.sizeZsub != 1) {
                moduloBlock.append("<ModuloAlongZ Type=\"other\" TypeDescription=\"Example Data Over Z-Plane\" Start=\"0\" Step=\"1\" End=\"");
                moduloBlock.append(this.sizeZsub);
                moduloBlock.append("\"/>");
            }
            if (this.sizeTsub != 1) {
                moduloBlock.append("<ModuloAlongT Type=\"other\" TypeDescription=\"Example Data Over Time \" Start=\"0\" Step=\"1\" End=\"");
                moduloBlock.append(this.sizeTsub);
                moduloBlock.append("\"/>");
            }
            if (this.sizeCsub != 1) {
                moduloBlock.append("<ModuloAlongC Type=\"other\" TypeDescription=\"Example Data Over Channel\" Start=\"0\" Step=\"1\" End=\"");
                moduloBlock.append(this.sizeCsub);
                moduloBlock.append("\"/>");
            }
            moduloBlock.append("</Modulo>");
            meta.setXMLAnnotationValue(moduloBlock.toString(), 0);
            meta.setImageAnnotationRef("Annotation:Modulo:0", 0, 0);
        }
        return meta;
    }

    private BufferedImage createPlane(String name, CoreMetadata info, int no) {
        int[] zct = FormatTools.getZCTCoords(info.dimensionOrder, info.sizeZ, info.sizeC, info.sizeT, info.imageCount, no);
        BufferedImage plane = new BufferedImage(info.sizeX, info.sizeY, 10);
        Graphics2D g2 = plane.createGraphics();
        boolean type = false;
        for (int y = 0; y < info.sizeY; ++y) {
            int v = this.gradient(0, y, info.sizeY);
            g2.setColor(new Color(v, v, v));
            g2.drawLine(0, y, info.sizeX, y);
        }
        ArrayList<TextLine> lines = new ArrayList<TextLine>();
        Font font = g2.getFont();
        lines.add(new TextLine(name, font.deriveFont(32.0f), 5, -5));
        lines.add(new TextLine(info.sizeX + " x " + info.sizeY, font.deriveFont(2, 16.0f), 20, 10));
        lines.add(new TextLine(info.dimensionOrder, font.deriveFont(2, 14.0f), 30, 5));
        int space = 5;
        if (info.sizeZ > 1) {
            lines.add(new TextLine("Focal plane = " + (zct[0] + 1) + "/" + info.sizeZ, font, 20, space));
            space = 2;
        }
        if (info.sizeC > 1) {
            lines.add(new TextLine("Channel = " + (zct[1] + 1) + "/" + info.sizeC, font, 20, space));
            space = 2;
        }
        if (info.sizeT > 1) {
            lines.add(new TextLine("Time point = " + (zct[2] + 1) + "/" + info.sizeT, font, 20, space));
            space = 2;
        }
        if (this.isModulo) {
            if (this.sizeZsub > 1) {
                lines.add(new TextLine("True-Z point = " + (zct[0] / this.sizeZsub + 1) + "/" + info.sizeZ / this.sizeZsub, font, 20, space));
                space = 2;
            }
            if (this.sizeZsub > 1) {
                lines.add(new TextLine("Sub-Z = " + (zct[0] % this.sizeZsub + 1) + "/" + this.sizeZsub, font, 20, space));
                space = 2;
            }
            if (this.sizeCsub > 1) {
                lines.add(new TextLine("True Channel = " + (zct[1] / this.sizeCsub + 1) + "/" + info.sizeC / this.sizeCsub, font, 20, space));
                space = 2;
            }
            if (this.sizeCsub > 1) {
                lines.add(new TextLine("Sub Channel = " + (zct[1] % this.sizeCsub + 1) + "/" + this.sizeCsub, font, 20, space));
                space = 2;
            }
            if (this.sizeTsub > 1) {
                lines.add(new TextLine("True-T point = " + (zct[2] / this.sizeTsub + 1) + "/" + info.sizeT / this.sizeTsub, font, 20, space));
                space = 2;
            }
            if (this.sizeTsub > 1) {
                lines.add(new TextLine("Sub-T = " + (zct[2] % this.sizeTsub + 1) + "/" + this.sizeTsub, font, 20, space));
                space = 2;
            }
        }
        g2.setColor(Color.white);
        int yoff = 0;
        for (int l = 0; l < lines.size(); ++l) {
            TextLine text = (TextLine)lines.get(l);
            g2.setFont(text.font);
            Rectangle2D r = g2.getFont().getStringBounds(text.line, g2.getFontRenderContext());
            yoff = (int)((double)yoff + (r.getHeight() + (double)text.ypad));
            g2.drawString(text.line, text.xoff, yoff);
        }
        g2.dispose();
        return plane;
    }

    private int gradient(int type, int num, int total) {
        int max = 96;
        int split = type / 2 + 1;
        boolean reverse = type % 2 == 0;
        int v = 96;
        int splitTotal = total / split;
        for (int i = 1; i <= split + 1; ++i) {
            if (num >= i * splitTotal) continue;
            if (i % 2 == 0) {
                v = 96 * (num % splitTotal) / splitTotal;
                break;
            }
            v = 96 * (splitTotal - num % splitTotal) / splitTotal;
            break;
        }
        if (reverse) {
            v = 96 - v;
        }
        return v;
    }

    private static class TextLine {
        final String line;
        final Font font;
        final int xoff;
        final int ypad;

        TextLine(String line, Font font, int xoff, int ypad) {
            this.line = line;
            this.font = font;
            this.xoff = xoff;
            this.ypad = ypad;
        }
    }
}

