/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;

public class PrintDomains {
    public static void main(String[] args2) {
        IFormatReader[] readers = new ImageReader().getReaders();
        TreeMultimap domains = TreeMultimap.create();
        for (IFormatReader reader : readers) {
            try {
                String[] readerDomains;
                for (String domain : readerDomains = reader.getPossibleDomains("")) {
                    domains.put(domain, reader.getFormat());
                }
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : domains.asMap().entrySet()) {
            System.out.println((String)entry.getKey() + ":");
            for (String readerFormat : (Collection)entry.getValue()) {
                System.out.println("  " + readerFormat);
            }
        }
    }
}

