/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintFormatTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintFormatTable.class);

    public static String getTextHeader() {
        return "";
    }

    public static String getTextFooter() {
        return "";
    }

    public static String getTextFormatLine(String name, boolean read, boolean write, boolean wmp, String ext) {
        StringBuffer s2 = new StringBuffer(name);
        if (read) {
            s2.append(": can read");
        }
        if (write) {
            s2.append(", can write");
        }
        if (wmp) {
            s2.append(", can write multiple");
        }
        s2.append(" (");
        s2.append(ext);
        s2.append(")");
        return s2.toString();
    }

    public static String getXmlHeader() {
        return "<response>\n";
    }

    public static String getXmlFooter() {
        return "</response>\n";
    }

    public static String getXmlFormatLine(String name, boolean read, boolean write, boolean wmp, String ext) {
        StringBuffer s2 = new StringBuffer("<format name='");
        s2.append(name);
        s2.append("'>\n");
        if (read) {
            s2.append("  <tag name='support' value='reading' />\n");
        }
        if (write) {
            s2.append("  <tag name='support' value='writing' />\n");
        }
        if (wmp) {
            s2.append("  <tag name='support' value='writing multiple pages' />\n");
        }
        s2.append("  <tag name='extensions' value='");
        s2.append(ext.replace(", ", "|"));
        s2.append("' />\n</format>\n");
        return s2.toString();
    }

    public static String getHtmlHeader() {
        return "<table><tr><th>Name</th><th>Reading</th><th>Writing</th><th>Extensions</th></tr>";
    }

    public static String getHtmlFooter() {
        return "</table>";
    }

    public static String getHtmlFormatLine(String name, boolean read, boolean write, String ext) {
        StringBuffer s2 = new StringBuffer("  <tr><td>");
        s2.append(name);
        s2.append("</td><td>");
        s2.append(read ? "yes" : "no");
        s2.append("</td><td>");
        s2.append(write ? "yes" : "no");
        s2.append("</td><td>");
        s2.append(ext);
        s2.append("</td></tr>");
        return s2.toString();
    }

    public static String getHeader(PrintStyles style) {
        if (style == PrintStyles.XML) {
            return PrintFormatTable.getXmlHeader();
        }
        if (style == PrintStyles.HTML) {
            return PrintFormatTable.getHtmlHeader();
        }
        if (style == PrintStyles.TXT) {
            return PrintFormatTable.getTextHeader();
        }
        return "";
    }

    public static String getFooter(PrintStyles style) {
        if (style == PrintStyles.XML) {
            return PrintFormatTable.getXmlFooter();
        }
        if (style == PrintStyles.HTML) {
            return PrintFormatTable.getHtmlFooter();
        }
        if (style == PrintStyles.TXT) {
            return PrintFormatTable.getTextFooter();
        }
        return "";
    }

    public static String getFormatLine(PrintStyles style, String name, boolean read, boolean write, boolean wmp, String ext) {
        if (style == PrintStyles.XML) {
            return PrintFormatTable.getXmlFormatLine(name, read, write, wmp, ext);
        }
        if (style == PrintStyles.HTML) {
            return PrintFormatTable.getHtmlFormatLine(name, read, write, ext);
        }
        if (style == PrintStyles.TXT) {
            return PrintFormatTable.getTextFormatLine(name, read, write, wmp, ext);
        }
        return "";
    }

    public static void printSupportedFormats(String[] args2) {
        PrintStyles printStyle = PrintStyles.TXT;
        boolean usage = false;
        if (args2 != null) {
            for (int i = 0; i < args2.length; ++i) {
                if (args2[i].equals("-help")) {
                    usage = true;
                    continue;
                }
                if (args2[i].equals("-xml")) {
                    printStyle = PrintStyles.XML;
                    continue;
                }
                if (args2[i].equals("-html")) {
                    printStyle = PrintStyles.HTML;
                    continue;
                }
                if (args2[i].equals("-txt")) {
                    printStyle = PrintStyles.TXT;
                    continue;
                }
                LOGGER.warn("unknown flag: {}; try -help for options", (Object)args2[i]);
            }
        }
        if (usage) {
            LOGGER.info("Usage: formatlist [-html] [-txt] [-xml]");
            LOGGER.info("  -html: show formats in an HTML table");
            LOGGER.info("   -txt: show formats in plaintext (default)");
            LOGGER.info("   -xml: show formats as XML data");
            return;
        }
        LOGGER.info(PrintFormatTable.getHeader(printStyle));
        ImageReader baseReader = new ImageReader();
        IFormatReader[] readers = baseReader.getReaders();
        ImageWriter baseWriter = new ImageWriter();
        IFormatWriter[] writers = baseWriter.getWriters();
        for (int i = 0; i < readers.length; ++i) {
            String readerFormatName = readers[i].getFormat();
            boolean read = true;
            boolean write = false;
            boolean wmp = false;
            IFormatWriter writer = null;
            for (int j = 0; j < writers.length; ++j) {
                if (!writers[j].getFormat().equals(readerFormatName)) continue;
                writer = writers[j];
            }
            if (writer != null) {
                write = true;
                if (writer.canDoStacks()) {
                    wmp = true;
                }
            }
            String[] extensions = readers[i].getSuffixes();
            StringBuilder ext = new StringBuilder();
            for (int j = 0; j < extensions.length; ++j) {
                ext.append(extensions[j]);
                if (j >= extensions.length - 1) continue;
                ext.append(", ");
            }
            LOGGER.info(PrintFormatTable.getFormatLine(printStyle, readerFormatName, read, write, wmp, ext.toString()));
        }
        LOGGER.info(PrintFormatTable.getFooter(printStyle));
    }

    public static void main(String[] args2) {
        PrintFormatTable.printSupportedFormats(args2);
    }

    public static enum PrintStyles {
        TXT,
        XML,
        HTML;

    }
}

