/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.config;

import ij.Prefs;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import loci.plugins.config.IFormatWidgets;

public class CellSensWidgets
implements IFormatWidgets,
ItemListener {
    private String[] labels;
    private Component[] widgets;

    public CellSensWidgets() {
        boolean failOnMissing = Prefs.get("bioformats.cellsens.fail_on_missing_ets", false);
        String failOnMissingLabel = "Fail";
        JCheckBox failOnMissingBox = new JCheckBox("Throw an exception if an expected .ets file is missing", failOnMissing);
        failOnMissingBox.addItemListener(this);
        this.labels = new String[]{failOnMissingLabel};
        this.widgets = new Component[]{failOnMissingBox};
    }

    @Override
    public String[] getLabels() {
        return this.labels;
    }

    @Override
    public Component[] getWidgets() {
        return this.widgets;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox box = (JCheckBox)e.getSource();
        if (box.equals(this.getWidgets()[0])) {
            Prefs.set("bioformats.cellsens.fail_on_missing_ets", box.isSelected());
        }
    }
}

