/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.config;

import ij.Prefs;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import loci.plugins.config.IFormatWidgets;

public class ZeissCZIWidgets
implements IFormatWidgets,
ItemListener {
    private String[] labels;
    private Component[] widgets;

    public ZeissCZIWidgets() {
        boolean attachmentImages = Prefs.get("bioformats.zeissczi.include.attachments", true);
        boolean autostitch = Prefs.get("bioformats.zeissczi.allow.autostitch", true);
        String attachmentLabel = "Attachment";
        String autostitchLabel = "Autostitch";
        JCheckBox attachmentBox = new JCheckBox("Include attachment images", attachmentImages);
        attachmentBox.addItemListener(this);
        JCheckBox autostitchBox = new JCheckBox("Automatically stitch tiled images", autostitch);
        autostitchBox.addItemListener(this);
        this.labels = new String[]{attachmentLabel, autostitchLabel};
        this.widgets = new Component[]{attachmentBox, autostitchBox};
    }

    @Override
    public String[] getLabels() {
        return this.labels;
    }

    @Override
    public Component[] getWidgets() {
        return this.widgets;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox box = (JCheckBox)e.getSource();
        if (box.equals(this.widgets[0])) {
            Prefs.set("bioformats.zeissczi.include.attachments", box.isSelected());
        } else if (box.equals(this.widgets[1])) {
            Prefs.set("bioformats.zeissczi.allow.autostitch", box.isSelected());
        }
    }
}

